if (!$.support.transition){
	$.fn.transition = $.fn.animate;
}

$(function () {
	var is_process = false;
	var $container = $('.container');
	
	$container.masonry({
		columnWidth: '.grid-sizer',
		itemSelector: '.item',
		transitionDuration: 0,
		gutter: 0
	});
	
	var buildLines = function (_flag) {
		if (is_process === true) { return false; }
		is_process = true;

		$container
			.masonry('remove', $container.find('.item'))
			.find('.item')
				.remove()
				.end()
			.masonry('layout');
		
		var output = "";
		for (var i = 0; i < 15; i++) {
			var ramdomHeight = Math.floor(Math.random() * (100 - 50) + 50);
			output += "<li class=\"item\"><div style=\"height:" + ramdomHeight + "px\"></div></li>";
		}

		$output = $(output);
		
		$container
			.masonry()
			.append($output)
			.masonry('appended', $output, true);

		if (_flag) {

			/* ---------------------------------
 			 *   with delayDo   */			
			$container.find('li').each(function () {
				var $target = $(this);
				$.delayDo('masonry_append', function () {
					$target
						.css({ y: 10 })
						.transition({ opacity: 0.5, y: 0 }, { duration: 300 });
				})
			});

			$.delayDo.resume({
				timerId: 'masonry_append',
				interval: 100,
				complete: function () {
					is_process = false;
				}
			});

		}
		else {

			/* ---------------------------------
 			 *   without delayDo   */
			$container.find('li').each(function () {
				var $target = $(this);
				$target
					.css({ y: 10 })
					.transition({ opacity: 0.5, y: 0 }, { duration: 300 });
			});
			is_process = false;

		}
	}
	
	$('#trigger1').click(function () {
		buildLines(true);
	});

	$('#trigger2').click(function () {
		buildLines(false);
	});

});
