<?php
/**
 * Plugin Name: PBF Sample
 * Plugin URI: https://wp-pagebuilderframework.com/
 * Description: Example Plugin to extend Page Builder Framework.
 * Version: 1.0
 * Author: MapSteps
 * Author URI: https://wp-pagebuilderframework.com/
 * Text Domain: pbf-sample
 *
 * @package PBF_Sample
 */

defined( 'ABSPATH' ) || die( "Can't access directly" );

// Textdomain.
function pbf_sample_textdomain() {
	load_plugin_textdomain( 'pbf-sample', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'pbf_sample_textdomain' );

/**
 * Enqueue scripts & styles.
 */
function pbf_sample_scripts_styles() {

	// Default styles.
	wp_enqueue_style( 'pbf-sample', plugin_dir_url( __FILE__ ) . 'css/default-styles.css', '', '1.0' );

}
add_action( 'wp_enqueue_scripts', 'pbf_sample_scripts_styles' );

// Required files.
require __DIR__ . '/inc/styles.php';
require __DIR__ . '/inc/customizer-settings.php';
require __DIR__ . '/inc/output.php';
