<?php
/**
 * Styles.
 *
 * @package PBF_Sample
 */

defined( 'ABSPATH' ) || die( "Can't access directly" );

/**
 * Let's override our defaults if custom styles are defined.
 */
function pbf_sample_customized_styles() {

	// Book Now Button.
	if ( get_theme_mod( 'book_now_background_color' ) ) {
		?>
		.pbf-sample-book-now-button {
			background-color: <?php echo esc_attr( get_theme_mod( 'book_now_background_color' ) ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'book_now_font_color' ) ) {
		?>
		.pbf-sample-book-now-button a {
			color: <?php echo esc_attr( get_theme_mod( 'book_now_font_color' ) ); ?>;
		}
		<?php
	}

	// Promotion Bar.
	if ( get_theme_mod( 'promo_bar_background_color' ) ) {
		?>
		.pbf-sample-promo-bar {
			background-color: <?php echo esc_attr( get_theme_mod( 'promo_bar_background_color' ) ); ?>;
		}
		.pbf-sample-promo-bar .pbf-sample-promo-bar-button {
			color: <?php echo esc_attr( get_theme_mod( 'promo_bar_background_color' ) ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'promo_bar_font_color' ) ) {
		?>
		.pbf-sample-promo-bar .pbf-sample-promo-bar-button {
			background: <?php echo esc_attr( get_theme_mod( 'promo_bar_font_color' ) ); ?>;
		}
		.pbf-sample-promo-bar .pbf-sample-promo-bar-text {
			color: <?php echo esc_attr( get_theme_mod( 'promo_bar_font_color' ) ); ?>;
		}
		<?php
	}

}
add_action( 'wpbf_after_customizer_css', 'pbf_sample_customized_styles' );
