<?php
/**
 * Output.
 *
 * @package PBF_Sample
 */

defined( 'ABSPATH' ) || die( "Can't access directly" );

/**
 * Book Now Button output.
 */
function pbf_sample_book_now_button() {

	if ( get_theme_mod( 'book_now_toggle' ) ) {

		$url = get_theme_mod( 'book_now_url' ) ? get_theme_mod( 'book_now_url' ) : '#';

		$button  = '<div class="pbf-sample-book-now-button">';
		$button .= '<a href="' . esc_url( $url ) . '">Contact us today!</a>';
		$button .= '</div>';

		echo $button;

	}

}
add_action( 'wp_footer', 'pbf_sample_book_now_button' );

/**
 * Promo Bar output.
 */
function pbf_sample_promo_bar() {

	if ( get_theme_mod( 'promo_bar_toggle' ) ) {

		$url         = get_theme_mod( 'promo_bar_url' ) ? get_theme_mod( 'promo_bar_url' ) : '#';
		$text        = get_theme_mod( 'promo_bar_text' ) ? get_theme_mod( 'promo_bar_text' ) : 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Nam, quis!';
		$button_text = get_theme_mod( 'promo_bar_button_text' ) ? get_theme_mod( 'promo_bar_button_text' ) : 'Click Here';

		$promo_bar  = '<div class="pbf-sample-promo-bar">';
		$promo_bar .= '<p class="pbf-sample-promo-bar-content">';
		$promo_bar .= '<span class="pbf-sample-promo-bar-text">' . esc_html( $text ) . '</span>';
		$promo_bar .= '<a class="pbf-sample-promo-bar-button" href="' . esc_url( $url ) . '">' . esc_html( $button_text ) . '</a>';
		$promo_bar .= '</p>';
		$promo_bar .= '</div>';

		echo $promo_bar;

	}

}
add_action( 'wpbf_before_header', 'pbf_sample_promo_bar' );
