<?php
/**
 * Customizer settings.
 *
 * @package PBF_Sample
 */

defined( 'ABSPATH' ) || die( "Can't access directly" );

/**
 * Add customizer settings.
 */
function pbf_sample_customizer_settings() {

	wpbf_customizer_panel()
		->id( 'pbf_sample_panel' )
		->title( __( 'PBF Sample Panel', 'page-builder-framework' ) )
		->priority( 1 )
		->add();

	wpbf_customizer_section()
		->id( 'book_now_section' )
		->title( __( 'Book Now Button', 'pbf-sample' ) )
		->priority( 10 )
		->addToPanel( 'pbf_sample_panel' );

	wpbf_customizer_section()
		->id( 'promo_bar_section' )
		->title( __( 'Promotion Bar', 'pbf-sample' ) )
		->priority( 11 )
		->addToPanel( 'pbf_sample_panel' );

	// Book now toggle.
	wpbf_customizer_field()
		->id( 'book_now_toggle' )
		->type( 'toggle' )
		->label( __( 'Activate', 'pbf-sample' ) )
		->defaultValue( false )
		->priority( 1 )
		->addToSection( 'book_now_section' );

	// Book now background color.
	wpbf_customizer_field()
		->id( 'book_now_background_color' )
		->type( 'color' )
		->label( __( 'Background Color', 'pbf-sample' ) )
		->defaultValue( '#78ead3' )
		->priority( 2 )
		->properties( [
			'mode' => 'alpha',
		] )
		->activeCallback( [
			array(
				'id'       => 'book_now_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'book_now_section' );

	// Book now font color.
	wpbf_customizer_field()
		->id( 'book_now_font_color' )
		->type( 'color' )
		->label( __( 'Font Color', 'pbf-sample' ) )
		->defaultValue( '#ffffff' )
		->priority( 3 )
		->properties( [
			'mode' => 'alpha',
		] )
		->activeCallback( [
			array(
				'id'       => 'book_now_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'book_now_section' );

	// Book now button URL.
	wpbf_customizer_field()
		->id( 'book_now_url' )
		->type( 'url' )
		->label( __( 'Link', 'pbf-sample' ) )
		->priority( 4 )
		->activeCallback( [
			array(
				'id'       => 'book_now_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'book_now_section' );

	// Promo bar toggle.
	wpbf_customizer_field()
		->id( 'promo_bar_toggle' )
		->type( 'toggle' )
		->label( __( 'Activate', 'pbf-sample' ) )
		->defaultValue( false )
		->priority( 1 )
		->addToSection( 'promo_bar_section' );

	// Promo bar background color.
	wpbf_customizer_field()
		->id( 'promo_bar_background_color' )
		->type( 'color' )
		->label( __( 'Background Color', 'pbf-sample' ) )
		->defaultValue( '#78ead3' )
		->priority( 2 )
		->properties( [
			'mode' => 'alpha',
		] )
		->activeCallback( [
			array(
				'id'       => 'promo_bar_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'promo_bar_section' );

	// Promo bar font color.
	wpbf_customizer_field()
		->id( 'promo_bar_font_color' )
		->type( 'color' )
		->label( __( 'Font Color', 'pbf-sample' ) )
		->defaultValue( '#ffffff' )
		->priority( 3 )
		->properties( [
			'mode' => 'alpha',
		] )
		->activeCallback( [
			array(
				'id'       => 'promo_bar_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'promo_bar_section' );

	// Promo bar text.
	wpbf_customizer_field()
		->id( 'promo_bar_text' )
		->type( 'text' )
		->label( __( 'Text', 'pbf-sample' ) )
		->priority( 4 )
		->activeCallback( [
			array(
				'id'       => 'promo_bar_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'promo_bar_section' );

	// Promo bar button text.
	wpbf_customizer_field()
		->id( 'promo_bar_button_text' )
		->type( 'text' )
		->label( __( 'Button Text', 'pbf-sample' ) )
		->priority( 5 )
		->activeCallback( [
			array(
				'id'       => 'promo_bar_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'promo_bar_section' );

	// Promo bar button URL.
	wpbf_customizer_field()
		->id( 'promo_bar_url' )
		->type( 'url' )
		->label( __( 'Link', 'pbf-sample' ) )
		->priority( 6 )
		->activeCallback( [
			array(
				'id'       => 'promo_bar_toggle',
				'operator' => '==',
				'value'    => true,
			),
		] )
		->addToSection( 'promo_bar_section' );

}
add_action( 'after_setup_theme', 'pbf_sample_customizer_settings' );
