<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class TB_Quotes_Module extends Themify_Builder_Component_Module {

    public static function get_module_name():string {
        add_filter( 'themify_builder_active_vars', [ __CLASS__, 'builder_active_enqueue' ] );
        return __( 'Quote', 'custom-quotes' );
    }

    public static function get_module_icon():string {
        return 'quote-right';
    }

    public static function get_js_css():array {
        return array(
            'css' => plugin_dir_url( dirname( __FILE__ ) ) . 'assets/style.css'
        );
    }

    public static function builder_active_enqueue( array $vars ):array {
        $url = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/active.js';
        $version = '1.0';
        $vars['addons'][ $url ] = $version;

        return $vars;
    }
}