
{*******************************************************}
{                                                       }
{       SecureAnyBox5 Delphi client examples            }
{                                                       }
{       Copyright (c) 2025-26 TDP                       }
{                                                       }
{****************************************************tk*}

program Sab5UserConfigExample;

{$APPTYPE CONSOLE}

{$R *.res}

{$DEFINE SSL_1_1_1}
{$DEFINE USE_SSL}

uses
  System.SysUtils, System.StrUtils, System.IOUtils, System.Classes,
{$IFDEF USE_SSL}
 {$IFDEF SSL_1_1_1}
  ssl_openssl11,
  ssl_openssl11_lib,
 {$ELSE}
  ...
 {$ENDIF}
{$ENDIF}
  System.NetEncoding,
  KShield.Classes,
  KShield.Utils,
{$IFDEF CPUX64}
  KShield.x64.Support,
{$ENDIF}
  SAB5.RESTsend,
  SAB5.NaCl,
  SAB5.Client,
  SAB5.DTO,
  SAB5.Types,
  SAB5.Utils;

function KShieldLogin(const AClient: TSab5Client; const AClientName, AClientVersion, AClientBuild, AComputerName: string; out
  LoggedUser: string; out loginStatus: TLoginStatus): Boolean;
var
{$IFDEF CPUX64}
  Status: TKShieldStatus;
{$ELSE}
  KShieldClient: TKShield;
{$ENDIF}
  Info: TKShieldCertInfo;
  LoginCertificate: TMemoryStream;
  EncodedCert: TStringStream;
  Enc: TBase64Encoding;
begin
  Result := False;
  Info.Cn := '';
  LoggedUser := '';

{$IFDEF CPUX64}
  LoginCertificate := TMemoryStream.Create;
{$ELSE}
  KShieldClient := TKShield.Create;
{$ENDIF}
  Enc := TBase64Encoding.Create(0);
  EncodedCert := TStringStream.Create;
  try
{$IFDEF CPUX64}
    if not GetKShieldLoginCertificate64(LoginCertificate, Info, Status) then
      Exit;

    if Status = ksAuthenticated then
    begin
{$ELSE}
    if KShieldClient.Initialized and (KShieldClient.Status = ksAuthenticated) then
    begin
      LoginCertificate := KShieldClient.LoginCertificate;
{$ENDIF}
      if Assigned(LoginCertificate) then
      begin
        Enc.Encode(LoginCertificate, EncodedCert);
        AClient.kshieldCertLogin(EncodedCert.DataString, loginStatus, AClientName, AClientVersion, AClientBuild, AComputerName);

        if AClient.LoggedIn then
        begin
{$IFDEF CPUX64}
          LoggedUser := string(Info.Cn);
{$ELSE}
          if KShieldClient.GetUserInfo(Info) then
            LoggedUser := string(Info.Cn);
{$ENDIF}
          Result := True;
        end;
      end;
    end;
  finally
{$IFDEF CPUX64}
    LoginCertificate.Free;
{$ELSE}
    KShieldClient.Free;
{$ENDIF}
    EncodedCert.Free;
    Enc.Free;
  end;
end;

procedure Example;
const
  DefaultURL = 'https://172.22.78.123:8843';
  DefaultUser = 'admin';
  ClientName = 'Stella';
  ClientVersion = '8.88';
  ClientBuild = '999';
var
  Client: TSab5Client;
  userConfig: TUserConfig;
  loginStatus: TLoginStatus;
  Logged: Boolean;
  LoggedUser: string;

  BaseURL: string;
  User, Pswd, Domain, SecondFactor: string;
  Status: TStatus;
{$IFDEF USE_SSL}
  ProgPath: string;
{$ENDIF}
begin
{$IFDEF USE_SSL}
  ProgPath := ExtractFilePath(ParamStr(0));
  if not TSab5Client.CheckSSL(ProgPath, True) then
  begin
    // libraries are also located in Delphi\bin\subversion folder
    writeln('Cannot load ssleay32.dll or libeay32.dll ssl libraries.');
    Exit;
  end;
{$ENDIF}

  Client := TSab5Client.Create;
  try
    try
      write('URL (', DefaultURL, '): ');
      readln(BaseURL);
      if BaseURL = '' then
        BaseURL := DefaultURL;
      Client.BaseURL := BaseURL;

      if not Client.getStatus(Status) then
      begin
        writeln('getStatus:');
        writeln(Format('SAB Error: %s', [Client.Error.Message]));
        writeln(Format('  Details: #%d %s', [Client.Error.ErrorCode, Client.Error.ErrorKey]));
        Exit;
      end;
      Client.ErrorMessages.Language := sablngEnglish;

      Logged := KShieldLogin(Client, ClientName, ClientVersion, ClientBuild, '', LoggedUser, loginStatus);
      if Logged then
      begin
        writeln;
        if LoggedUser <> '' then
          writeln('Logged via KShield as ', LoggedUser)
        else
          writeln('Logged via KShield');
        writeln;
      end else
      begin
        write('User (', DefaultUser, '): ');
        readln(User);
        if User = '' then
          User := DefaultUser;

        write('Domain: ');
        readln(Domain);

        writeln;
        writeln;
        write('Password: ');
        readln(Pswd);
        writeln;
      end;

      if Logged or Client.Login(System.StrUtils.IfThen(Domain <> '', Domain + '\' + User, User), Pswd, loginStatus, ClientName,
        ClientVersion, ClientBuild, SAB5.Utils.GetComputerName) then
      begin
        if loginStatus.SecondFactorRequired then
        begin
          write('Enter Second factor: ');
          readln(SecondFactor);
          writeln;

          if not Client.authenticate2F(SecondFactor) then
            Exit;
        end;

        if Client.getUserConfig(userConfig) then
        begin
          writeln;
          writeln('User configuration');
          writeln('  Language:           ', userConfig.Lang);
          writeln('  enterprise Edition: ', System.StrUtils.IfThen(userConfig.EnterpriseEdition, 'yes', 'no'));
        end else
          writeln(Format('Client Error: %s', [Client.Error.&Message]));

        Client.Logout;
      end else
      begin
        writeln(Format('Client Error: %s', [Client.Error.&Message]));
      end;
    except
      on E: Exception do
        writeln(E.Message, '  (', E.ClassName, ')');
    end;
  finally
    Client.Free;
  end;
end;

begin
  Example;
end.
