library diskdir;

{$IFDEF FPC}
  {$MODE Delphi}
  {$ASMMODE INTEL}
{$ENDIF}

uses
  SysUtils,Classes,Windows;

type
  char=ansichar;
  pchar=pansichar;

const       {Error codes returned to calling application}
  E_END_ARCHIVE=     10;       {No more files in archive}
  E_NO_MEMORY=       11;       {Not enough memory}
  E_BAD_DATA=        12;       {Data is bad}
  E_BAD_ARCHIVE=     13;       {CRC error in archive data}
  E_UNKNOWN_FORMAT=  14;       {Archive format unknown}
  E_EOPEN=           15;       {Cannot open existing file}
  E_ECREATE=         16;       {Cannot create file}
  E_ECLOSE=          17;       {Error closing file}
  E_EREAD=           18;       {Error reading from file}
  E_EWRITE=          19;       {Error writing to file}
  E_SMALL_BUF=       20;       {Buffer too small}
  E_EABORTED=        21;       {Function aborted by user}
  E_NO_FILES=        22;       {No files found}
  E_TOO_MANY_FILES=  23;       {Too many files to pack}
  E_NOT_SUPPORTED=   24;       {Function not supported}

  {Unpacking flags}
  PK_OM_LIST=           0;
  PK_OM_EXTRACT=        1;

  {Flags for ProcessFile}
  PK_SKIP=              0;     {Skip file (no unpacking)}
  PK_TEST=              1;     {Test file integrity}
  PK_EXTRACT=           2;     {Extract file to disk}

  {Flags passed through ChangeVolProc}
  PK_VOL_ASK=           0;     {Ask user for location of next volume}
  PK_VOL_NOTIFY=        1;     {Notify app that next volume will be unpacked}

  {Packing flags}

  {For PackFiles}
  PK_PACK_MOVE_FILES=   1;    {Delete original after packing}
  PK_PACK_SAVE_PATHS=   2;    {Save path names of files}

  {Returned by GetPackCaps}
  PK_CAPS_NEW=          1;    {Can create new archives}
  PK_CAPS_MODIFY=       2;    {Can modify exisiting archives}
  PK_CAPS_MULTIPLE=     4;    {Archive can contain multiple files}
  PK_CAPS_DELETE=       8;    {Can delete files}
  PK_CAPS_OPTIONS=     16;    {Supports the options dialogbox}

type
  pbyte=^byte;
  {Definition of callback functions called by the DLL}
  {Ask to swap disk for multi-volume archive}
  PChangeVolProc=^TChangeVolProc;
  TChangeVolProc=function(ArcName:pchar;Mode:longint):longint; stdcall;
  {Notify that data is processed - used for progress dialog}
  PProcessDataProc=^TProcessDataProc;
  TProcessDataProc=function(Addr:pbyte;Size:longint):longint; stdcall;

type
  THeaderData=packed record
    ArcName:array [0..259] of ansichar;
    FileName:array [0..259] of ansichar;
    Flags,
    PackSize,
    UnpSize,
    HostOS,
    FileCRC,
    FileTime,
    UnpVer,
    Method,
    FileAttr:longint;
    CmtBuf:pchar;
    CmtBufSize,
    CmtSize,
    CmtState:longint;
  end;

  THeaderDataEx=packed record
    ArcName:array [0..1023] of char;
    FileName:array [0..1023] of char;
    Flags,
    PackSize,
    PackSizeHigh,
    UnpSize,
    UnpSizeHigh,
    HostOS,
    FileCRC,
    FileTime,
    UnpVer,
    Method,
    FileAttr:longint;
    CmtBuf:pchar;
    CmtBufSize,
    CmtSize,
    CmtState:longint;
    Reserved:array[0..1023] of char;
  end;

  tOpenArchiveData=packed record
    ArcName:pchar;
    OpenMode,
    OpenResult:longint;
    CmtBuf:pchar;
    CmtBufSize,
    CmtSize,
    CmtState:longint;
  end;

const maxarchives=10;
type ArchiveRec=record
       ArchiveName:array[0..259] of char;
       SrcDir,LastCurDir:array[0..259] of char;
       CurrentFileName:array[0..259] of char;
       CurrentUnpSize:comp;
       CurrentFileTime:longint;
       ArchiveHandle:textfile;
       ArchiveMode:longint;
       ArchiveActive:boolean;
       ChangeVolProc:TChangeVolProc;
       ProcessDataProc:TProcessDataProc;
     end;

{Keep a list of currently open archives (up to a maximum of maxarchives)}
var ArchiveList:array[1..maxarchives] of ArchiveRec;

var _TokenSource: pchar;

FUNCTION StrTok(Source: pchar; Token: ANSICHAR): pchar;
  VAR P: pchar;
BEGIN
  IF Source <> Nil THEN _TokenSource := Source;
  IF _TokenSource = Nil THEN begin
    strTok:=nil;
    exit
  end;
  P := StrScan(_TokenSource, Token);
  StrTok := _TokenSource;
  IF P <> Nil THEN BEGIN
    P^ := #0;
    Inc(P);
  END;
  _TokenSource := P;
END;

function OpenArchive(var ArchiveData:tOpenArchiveData):thandle; stdcall;
var i:integer;
    archandle:integer;
    foundslot:boolean;
begin
  result:=0;
  foundslot:=false;
  for i:=1 to maxarchives do begin
    if not ArchiveList[i].ArchiveActive then begin
      foundslot:=true;
      archandle:=i;
      break;
    end;
  end;
  if not foundslot then begin
    ArchiveData.OpenResult:=E_NO_MEMORY;
    exit
  end;
  with ArchiveList[archandle] do begin
    LastCurDir[0]:=#0;
    strlcopy(ArchiveName,ArchiveData.arcName,sizeof(ArchiveName)-1);
    assignfile(ArchiveHandle,ArchiveName);
    filemode:=0;
    {$i-}
    reset(ArchiveHandle);
    {$i+}
    if ioresult<>0 then
      ArchiveData.OpenResult:=E_EOPEN
    else begin
      ArchiveActive:=true;
      SrcDir[0]:=#0;
      result:=archandle;
    end;
  end;
end;

function CloseArchive(hArcData:thandle):longint; stdcall;
begin
  with ArchiveList[hArcData] do begin
    if ArchiveActive then begin
      {$i-}
      Close(ArchiveHandle);
      {$i+}
      if ioresult<>0 then
        Result:=E_ECLOSE
      else
        Result:=0;
      ArchiveActive:=false;
    end;
  end;
end;

type
  TDateTime1 = packed record
    Year, Month, Day, Hour, Min, Sec: Word;
  end;

procedure PackTime(var T: TDateTime1; var P: Longint); assembler; {$ifdef win32} pascal;{$endif}
asm
{$ifdef win32}
        PUSH EDI
        PUSH ESI
        PUSH EBX
        MOV EDI,[P]
        MOV  ESI,[T]
{$else}
        PUSH RDI
        PUSH RSI
        PUSH RBX
        MOV RDI,P
        MOV  RSI,T
{$endif}
	CLD
	LODSW
	SUB	AX,1980
	MOV	CL,9
	SHL	AX,CL
	XCHG	AX,DX
	LODSW
	MOV	CL,5
	SHL	AX,CL
	ADD	DX,AX
	LODSW
	ADD	DX,AX
	LODSW
	MOV	CL,11
	SHL	AX,CL
	XCHG	AX,BX
	LODSW
	MOV	CL,5
	SHL	AX,CL
	ADD	BX,AX
	LODSW
	SHR	AX,1
	ADD	AX,BX
	STOSW
	XCHG	AX,DX
	STOSW
        {$ifdef win32}
        POP EBX
        POP ESI
        POP EDI
        {$else}
        POP RBX
        POP RSI
        POP RDI
        {$endif}
end;

procedure UnpackTime(P: Longint; var T: TDateTime1); assembler; pascal;
asm
{$ifdef win32}
  PUSH    EBX
  PUSH    EDI
  MOV     EDI,T
{$else}
  PUSH    RBX
  PUSH    RDI
  MOV     RDI,T
{$endif}
  MOV EBX,P
	CLD
	MOV	EAX,EBX
	MOV	CL,9+16
	SHR	EAX,CL
	ADD	AX,1980
	STOSW
	MOV	EAX,EBX
	MOV	CL,5+16
	SHR	EAX,CL
	AND	AX,15
	STOSW
	MOV	EAX,EBX
	MOV	CL,16
	SHR	EAX,CL
	AND	AX,31
	STOSW
	MOV	AX,BX
	MOV	CL,11
	SHR	AX,CL
	STOSW
	MOV	AX,BX
	MOV	CL,5
	SHR	AX,CL
	AND	AX,63
	STOSW
	MOV	AX,BX
	AND	AX,31
	SHL	AX,1
	STOSW
{$ifdef win32}
        POP    EDI
        POP    EBX
{$else}
        POP    RDI
        POP    RBX
{$endif}
end;

function ReadHeader(hArcData:thandle;var HeaderData:THeaderData):longint; stdcall;
var buf:array[0..1023] of char;
    buf1:array[0..259] of char;
    p,p1,psize,pdate,ptime:pchar;
    tdt:TDateTime1;
    code:integer;
begin
  if ArchiveList[hArcData].ArchiveActive then begin
    if not ArchiveList[hArcData].ArchiveActive then
      Result:=E_BAD_ARCHIVE
    else if eof(ArchiveList[hArcData].ArchiveHandle) then
      Result:=E_END_ARCHIVE
    else begin
      {$i-}
      readln(ArchiveList[hArcData].ArchiveHandle,buf);
      if ArchiveList[hArcData].SrcDir[0]=#0 then begin   {First line!}
        if strscan(buf,#9)=nil then begin
          strcopy(ArchiveList[hArcData].SrcDir,buf);
          readln(ArchiveList[hArcData].ArchiveHandle,buf);
        end;
      end;
      {$i+}
      if ioresult=0 then begin
        fillchar(HeaderData,sizeof(HeaderData)-16,#0);
        p:=strtok(buf,#9);
        psize:=strtok(nil,#9);
        pdate:=strtok(nil,#9);
        ptime:=strtok(nil,#9);
        if (buf[0]<>#0) and (buf[strlen(buf)-1]='\') then
          HeaderData.FileAttr:=fadirectory;
        if strscan(buf,'\')=nil then begin  {No directory -> assume last given dir!}
          strlcopy(buf1,ArchiveList[hArcData].LastCurDir,sizeof(HeaderData.FileName)-1);
        end else begin
          if HeaderData.FileAttr=fadirectory then
            strlcopy(ArchiveList[hArcData].LastCurDir,buf,sizeof(ArchiveList[hArcData].lastcurdir)-1);
          buf1[0]:=#0;
        end;
        strlcat(buf1,buf,sizeof(buf1)-1);
        p:=strscan(buf1,':');
        if p<>nil then inc(p,2)
                  else p:=buf1;
        strlcopy(HeaderData.FileName,p,sizeof(HeaderData.FileName));
        if ArchiveList[hArcData].SrcDir[0]=#0 then   {First line!}
          strlcopy(ArchiveList[hArcData].SrcDir,buf1,3);

        strlcopy(HeaderData.ArcName,ArchiveList[hArcData].ArchiveName,sizeof(HeaderData.ArcName)-1);

        if psize<>nil then begin
          val(psize,HeaderData.UnpSize,code);
          if code<>0 then HeaderData.UnpSize:=-1;
          HeaderData.PackSize:=HeaderData.UnpSize;
        end else
          HeaderData.UnpSize:=-1;
        HeaderData.FileTime:=-1;
        if pdate<>nil then begin {Year.month.day}
          fillchar(tdt,sizeof(tdt),#0);
          p1:=strtok(pdate,'.');
          val(p1,tdt.year,code);
          p1:=strtok(nil,'.');
          if (code=0) and (p1<>nil) then begin
            if tdt.year<1900 then if tdt.year<80 then inc(tdt.year,2000)
                                                 else inc(tdt.year,1900);
            val(p1,tdt.month,code);
            p1:=strtok(nil,'.');
            if (code=0) and (p1<>nil) then begin
              val(p1,tdt.day,code);
              if code=0 then begin
                if ptime<>nil then begin {hour:min:seconds}
                  p1:=strtok(ptime,':');
                  val(p1,tdt.hour,code);
                  p1:=strtok(nil,'.');
                  if (code=0) and (p1<>nil) then begin
                    val(p1,tdt.min,code);
                    p1:=strtok(nil,'.');
                    if (code=0) then
                      if (p1<>nil) then val(p1,tdt.sec,code);
                  end;
                end;
                packtime(tdt,HeaderData.FileTime);
              end;
            end;
          end;
        end;
        strlcopy(ArchiveList[hArcData].CurrentFileName,HeaderData.filename,sizeof(ArchiveList[hArcData].CurrentFileName)-1);
        ArchiveList[hArcData].CurrentFileTime:=HeaderData.FileTime;
        Result:=0;
      end else
        Result:=E_EREAD;
    end;
  end;
end;

function makecomp(lowlong,highlong:longint):comp;
type tcomprec=record
       case boolean of
         true:(l,h:longint);
         false:(cmp:comp);
       end;
var tcr:tcomprec;
begin
  tcr.l:=lowlong;
  tcr.h:=highlong;
  result:=tcr.cmp;
end;

type tcomprec=record
       case boolean of
         true:(l,h:longint);
         false:(cmp:comp);
       end;

function ReadHeaderEx(hArcData:thandle;var HeaderData:THeaderDataEx):longint; stdcall;
var buf:array[0..1023] of char;
    buf1:array[0..259] of char;
    p,p1,psize,pdate,ptime:pchar;
    tdt:TDateTime1;
    code:integer;
    UnpSizeComp:comp;
begin
  if ArchiveList[hArcData].ArchiveActive then begin
    if not ArchiveList[hArcData].ArchiveActive then
      Result:=E_BAD_ARCHIVE
    else if eof(ArchiveList[hArcData].ArchiveHandle) then
      Result:=E_END_ARCHIVE
    else begin
      {$i-}
      readln(ArchiveList[hArcData].ArchiveHandle,buf);
      if ArchiveList[hArcData].SrcDir[0]=#0 then begin   {First line!}
        if strscan(buf,#9)=nil then begin
          strcopy(ArchiveList[hArcData].SrcDir,buf);
          readln(ArchiveList[hArcData].ArchiveHandle,buf);
        end;
      end;
      {$i+}
      if ioresult=0 then begin
        fillchar(HeaderData,sizeof(HeaderData)-16,#0);
        p:=strtok(buf,#9);
        psize:=strtok(nil,#9);
        pdate:=strtok(nil,#9);
        ptime:=strtok(nil,#9);
        if (buf[0]<>#0) and (buf[strlen(buf)-1]='\') then
          HeaderData.FileAttr:=fadirectory;
        if strscan(buf,'\')=nil then begin  {No directory -> assume last given dir!}
          strlcopy(buf1,ArchiveList[hArcData].LastCurDir,sizeof(HeaderData.FileName)-1);
        end else begin
          if HeaderData.FileAttr=fadirectory then
            strlcopy(ArchiveList[hArcData].LastCurDir,buf,sizeof(ArchiveList[hArcData].lastcurdir)-1);
          buf1[0]:=#0;
        end;
        strlcat(buf1,buf,sizeof(buf1)-1);
        p:=strscan(buf1,':');
        if p<>nil then inc(p,2)
                  else p:=buf1;
        strlcopy(HeaderData.FileName,p,sizeof(HeaderData.FileName));
        if ArchiveList[hArcData].SrcDir[0]=#0 then   {First line!}
          strlcopy(ArchiveList[hArcData].SrcDir,buf1,3);

        strlcopy(HeaderData.ArcName,ArchiveList[hArcData].ArchiveName,sizeof(HeaderData.ArcName)-1);

        if psize<>nil then begin
          val(psize,UnpSizeComp,code);
          if code<>0 then begin
            HeaderData.UnpSize:=-1;
            HeaderData.UnpSizeHigh:=-1;
          end else begin
            HeaderData.UnpSize:=tcomprec(UnpSizeComp).l;
            HeaderData.UnpSizeHigh:=tcomprec(UnpSizeComp).h;
          end;
          HeaderData.PackSize:=HeaderData.UnpSize;
        end else begin
          HeaderData.UnpSize:=-1;
          HeaderData.UnpSizeHigh:=-1;
        end;
        HeaderData.PackSizeHigh:=HeaderData.UnpSizeHigh;
        HeaderData.FileTime:=-1;
        if pdate<>nil then begin {Year.month.day}
          fillchar(tdt,sizeof(tdt),#0);
          p1:=strtok(pdate,'.');
          val(p1,tdt.year,code);
          p1:=strtok(nil,'.');
          if (code=0) and (p1<>nil) then begin
            if tdt.year<1900 then if tdt.year<80 then inc(tdt.year,2000)
                                                 else inc(tdt.year,1900);
            val(p1,tdt.month,code);
            p1:=strtok(nil,'.');
            if (code=0) and (p1<>nil) then begin
              val(p1,tdt.day,code);
              if code=0 then begin
                if ptime<>nil then begin {hour:min:seconds}
                  p1:=strtok(ptime,':');
                  val(p1,tdt.hour,code);
                  p1:=strtok(nil,'.');
                  if (code=0) and (p1<>nil) then begin
                    val(p1,tdt.min,code);
                    p1:=strtok(nil,'.');
                    if (code=0) then
                      if (p1<>nil) then val(p1,tdt.sec,code);
                  end;
                end;
                packtime(tdt,HeaderData.FileTime);
              end;
            end;
          end;
        end;
        strlcopy(ArchiveList[hArcData].CurrentFileName,HeaderData.filename,sizeof(ArchiveList[hArcData].CurrentFileName)-1);
        ArchiveList[hArcData].CurrentFileTime:=HeaderData.FileTime;
        ArchiveList[hArcData].CurrentUnpSize:=makecomp(HeaderData.UnpSize,
          HeaderData.UnpSizeHigh);
        Result:=0;
      end else
        Result:=E_EREAD;
    end;
  end;
end;

function createvalidoutfile(var g:file;trgfile:pchar;isadir:boolean):integer;
var err:integer;
    buf,buf0:array[0..259] of char;
    p,p1:pchar;
begin
  {$i-}
  if not isadir then begin
    assign(g,trgfile);
    rewrite(g,1);
    err:=ioresult;
  end;
  strlcopy(buf,trgfile,sizeof(buf)-1);
  if (err=3) or isadir then begin  {path not found}
    p1:=strrscan(buf,'\');
    if p1<>nil then inc(p1);  {pointer to filename}
    p:=strscan(buf,'\');
    if p<>nil then p:=strscan(p+1,'\');
    while (p<>nil) and (p<p1) do begin
      p[0]:=#0;
      mkdir(strpas(buf));
      err:=ioresult;
      p[0]:='\';
      p:=strscan(p+1,'\');
    end;
    if isadir then begin
      result:=0;    {A directory -> ok}
      exit;
    end;
    rewrite(g,1);
    err:=ioresult;
  end;
  result:=err;
end;

function ProcessFile(hArcData:thandle;Operation:longint;DestPath,DestName:pchar):longint; stdcall;
var srcfile,trgfile:array[0..259] of char;
    f,g:file;
    buf:array[0..32767] of char;
    p:pchar;
    dataread,datawritten,err:integer;
    filetime:tfiletime;
    showprogress:boolean;
begin                   
  if (Operation=PK_EXTRACT) or (Operation=PK_TEST) then
  with ArchiveList[hArcData] do if ArchiveActive then begin
    strcopy(srcfile,srcdir);
    strlcat(srcfile,CurrentFilename,sizeof(srcfile)-1);
    filemode:=0;
    repeat
      assign(f,srcfile);
      {$i-}
      reset(f,1);
      {$i+}
      err:=ioresult;
      if err>0 then
        if (@ChangeVolProc=nil) or
          (ChangeVolProc(srcfile,0)=0) then err:=-1
        else begin           {Remeber path given by user!}
          p:=strpos(srcfile,CurrentFilename);
          if p<>nil then
            strlcopy(srcdir,srcfile,p-@srcfile);
        end;
    until err<=0;

    if err<>0 then begin result:=E_EOPEN; exit; end;

    showprogress:=(CurrentUnpSize>0) and (@ProcessDataProc<>nil);
    if destpath<>nil then begin
      strcopy(trgfile,destpath);
      if (trgfile[0]<>#0) and (trgfile[strlen(trgfile)-1]<>'\') then
        strcat(trgfile,'\');
    end else trgfile[0]:=#0;
    if (Operation=PK_EXTRACT) then begin
      if destname<>nil then
        strlcat(trgfile,destname,sizeof(trgfile)-1)
      else begin
        p:=strrscan(CurrentFileName,'\');
        if p<>nil then inc(p) else p:=CurrentFileName;
        strlcat(trgfile,CurrentFileName,sizeof(trgfile)-1);
      end;
      if createvalidoutfile(g,trgfile,false)<>0 then begin close(f); result:=E_ECREATE; exit; end;
    end;
    while true do begin
      {$i-}
      blockread(f,buf[0],sizeof(buf),dataread);
      if ioresult<>0 then begin
        if (Operation=PK_EXTRACT) then close(g);
        result:=E_EREAD;
        exit
      end else begin
        if (Operation=PK_EXTRACT) then begin
          blockwrite(g,buf[0],dataread,datawritten);
          if ioresult<>0 then begin
            close(g);
            result:=E_EWRITE;
            exit
          end
        end else
          datawritten:=dataread;
        if showprogress then begin
          if ProcessDataProc(@buf,datawritten)=0 then begin {Abort!}
            close(f);
            if (Operation=PK_EXTRACT) then close(g);
            result:=0;     {UnRAR.DLL returns no error when aborted!}
            exit;
          end;
        end;
      end;
      if dataread<sizeof(buf) then break;
      {$i+}
    end;
    close(f);
    if (Operation=PK_EXTRACT) then begin
      FileSetDate(tfilerec(g).handle,CurrentFileTime);
      close(g);
    end;
  end;
  Result:=0;
end;

var PackerChangeVolProc:TChangeVolProc;
    PackerProcessDataProc:TProcessDataProc;

function SetChangeVolProc(hArcData:THandle;ChangeVolProc1:TChangeVolProc):longint; stdcall;
begin
  if hArcData=-1 then
    PackerChangeVolProc:=ChangeVolProc1
  else
    ArchiveList[hArcData].ChangeVolProc:=ChangeVolProc1;
end;

function SetProcessDataProc(hArcData:THandle;ProcessDataProc1:TProcessDataProc):longint; stdcall;
begin
  if hArcData=-1 then
    PackerProcessDataProc:=ProcessDataProc1
  else
    ArchiveList[hArcData].ProcessDataProc:=ProcessDataProc1;
end;

function PackFiles(PackedFile,SubPath,SrcPath,AddList:pchar;Flags:integer):integer; stdcall;
var s:tsearchrec;
    PackedHandle:text;
    p,pEnd,pData:pchar;
    tdt:tdatetime1;
    buf:array[0..299] of char;
    RunOk:boolean;
begin
  if FileExists(PackedFile) then begin
    result:=E_NOT_SUPPORTED;
    exit
  end else begin
    assignfile(PackedHandle,PackedFile);
    filemode:=0;
    {$i-}
    rewrite(PackedHandle);
    {$i+}
    if ioresult<>0 then
      Result:=E_ECREATE
    else begin
      if SrcPath[0]<>#0 then            {Search result?}
        writeln(PackedHandle,SrcPath);
      p:=AddList;
      strcopy(buf,SrcPath);
      pEnd:=Strend(buf);
      RunOK:=true;
      while (p[0]<>#0) and RunOK do begin
        strlcat(buf,p,sizeof(buf)-1);
        if buf[strlen(buf)-1]='\' then
          buf[strlen(buf)-1]:=#0;
        if FindFirst(strpas(buf),faAnyFile,s)=0 then begin
          pData:=pEnd;
          if (s.attr and fadirectory<>0) then begin
            strlcat(buf,'\',sizeof(buf)-1);
            s.size:=0;
          end else if SrcPath[0]<>#0 then begin               {Store only file names!}
            pData:=strrscan(pEnd,'\');
            if pData<>nil then inc(pData)
                          else pData:=pEnd;
          end;
          Unpacktime(s.time,tdt);
          writeln(PackedHandle,strpas(pData)+#9+FloatToStrF(makecomp(s.size,s.finddata.nFileSizeHigh),ffFixed,18,0)+#9+
          inttostr(tdt.year)+'.'+inttostr(tdt.month)+'.'+inttostr(tdt.day)+#9+
          inttostr(tdt.hour)+':'+inttostr(tdt.min)+'.'+inttostr(tdt.sec));
          sysutils.FindClose(s);
          if @PackerProcessDataProc<>nil then
            if PackerProcessDataProc(pByte(pEnd),s.size)=0 then
              RunOK:=false;
        end;
        pEnd[0]:=#0;
        p:=strend(p)+1;
      end;
      CloseFile(PackedHandle);
    end;
  end;
  if RunOK then result:=0
           else result:=E_EABORTED;
end;

function DeleteFiles(PackedFile,DeleteList:pchar):integer; stdcall;
begin
  result:=E_NOT_SUPPORTED;
end;

function GetPackerCaps:integer; stdcall;
begin
  result:=PK_CAPS_NEW or PK_CAPS_MULTIPLE or PK_CAPS_OPTIONS;
end;

procedure ConfigurePacker(ParentHandle,DllInstance:thandle); stdcall;
begin
  MessageBox(ParentHandle,'Diskdir plugin, Copyright © 1999-2012 by Christian Ghisler',
    'About diskdir',mb_iconinformation);
end;

exports
  OpenArchive,
  CloseArchive,
  ReadHeader,
  ReadHeaderEx,
  ProcessFile,
  SetChangeVolProc,
  SetProcessDataProc,
  PackFiles,
  DeleteFiles,
  GetPackerCaps,
  ConfigurePacker;

begin
  FillChar(ArchiveList,sizeof(ArchiveList),#0);
end.

