// ebcdicview.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "ebcdicview.h"

HINSTANCE hinst;
HMODULE FLibHandle=0;
char inifilename[MAX_PATH]="lsplugin.ini";  // Unused in this plugin, may be used to save data

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			hinst=(HINSTANCE)hModule;
			break;
		case DLL_PROCESS_DETACH:
			if (FLibHandle)
				FreeLibrary(FLibHandle);
			FLibHandle=NULL;
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
    }
    return TRUE;
}

char* strlcpy(char* p,char*p2,int maxlen)
{
	if ((int)strlen(p2)>=maxlen) {
		strncpy(p,p2,maxlen);
		p[maxlen]=0;
	} else
		strcpy(p,p2);
	return p;
}

char* AppendCurrentLine(char* inbuf,int currentline,int numdigits)
{
	char out1[16];

	itoa(currentline,out1,10);
	int fill=numdigits-strlen(out1);
	for (int i=0;i<fill;i++)
		inbuf[i]='0';
	strcpy(inbuf+fill,out1);
	strcat(inbuf,": ");
	return inbuf+strlen(inbuf);
}

int lastloadtime=0;   // Workaround to RichEdit bug

int __stdcall ListNotificationReceived(HWND ListWin,int Message,WPARAM wParam,LPARAM lParam)
{
	switch (Message) {
	case WM_COMMAND:
		if (HIWORD(wParam)==EN_UPDATE && abs((int)GetCurrentTime()-lastloadtime)>1000) {
			int firstvisible=SendMessage(ListWin,EM_GETFIRSTVISIBLELINE,0,0);
			int linecount=SendMessage(ListWin,EM_GETLINECOUNT,0,0);
			if (linecount>0) {
				int percent=MulDiv(firstvisible,100,linecount);
				PostMessage(GetParent(ListWin),WM_COMMAND,MAKELONG(percent,itm_percent),(LPARAM)ListWin);
			}
			return 0;
		}
		break;
	case WM_NOTIFY:
		break;
	case WM_MEASUREITEM:
		break;
	case WM_DRAWITEM:
		break;
	}
	return 0;
}

int ebcdictable[]={0x20,0xA0,0xE2,0xE4,0xE0,0xE1,0xE3,0xE5,0xE7,0xF1,0xA2,0x2E,0x3C,
                   0x28,0x2B,0x7C,0x26,0xE9,0xEA,0xEB,0xE8,0xED,0xEE,0xEF,0xEC,0xDF,
				   0x21,0x24,0x2A,0x29,0x3B,0xAC,0x2D,0x2F,0xC2,0xC4,0xC0,0xC1,0xC3,
				   0xC5,0xC7,0xD1,0xA6,0x2C,0x25,0x5F,0x3E,0x3F,0xF8,0xC9,0xCA,0xCB,
				   0xC8,0xCD,0xCE,0xCF,0xCC,0x60,0x3A,0x23,0x40,0x27,0x3D,0x22,0xD8,
				   0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0xAB,0xBB,0xF0,0xFD,
				   0xFE,0xB1,0xB0,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0xAA,
				   0xBA,0xE6,0xB8,0xC6,0xA4,0xB5,0x7E,0x73,0x74,0x75,0x76,0x77,0x78,
				   0x79,0x7A,0xA1,0xBF,0xD0,0xDD,0xDE,0xAE,0x5E,0xA3,0xA5,0xB7,0xA9,
				   0xA7,0xB6,0xBC,0xBD,0xBE,0x5B,0x5D,0xAF,0xA8,0xB4,0xD7,0x7B,0x41,
				   0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0xAD,0xF4,0xF6,0xF2,0xF3,
				   0xF5,0x7D,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,0x52,0xB9,0xFB,
				   0xFC,0xF9,0xFA,0xFF,0x5C,0xF7,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
				   0x5A,0xB2,0xD4,0xD6,0xD2,0xD3,0xD5,0x30,0x31,0x32,0x33,0x34,0x35,
				   0x36,0x37,0x38,0x39,0xB3,0xDB,0xDC,0xD9,0xDA,0xFF};

BOOL ConvertEbcdicToAnsi(char* p,int w2)
{
	int i;
	for (i=0;i<w2;i++)
		if (((unsigned char)p[i])>=0x40)
			p[i]=(char)ebcdictable[(unsigned char)p[i]-0x40];
		else if (p[i]==0x25) p[i]=0x0A;   //Line Feed
		else if (p[i]<0x40)
			p[i]=' ';
	return true;
}

int LetterCountAnsi(char* p,int w2)
{
	int i,retval;
	retval=0;
	for (i=0;i<w2;i++)
		if ((p[i]>='A' && p[i]<='Z') ||
			(p[i]>='a' && p[i]<='z') ||
			(p[i]>='0' && p[i]<='9') ||
			(p[i]==0x20))
			retval++;
	return retval;
}

int LetterCountEbcdic(char* p,int w2)
{
	int i,retval;
	retval=0;
	for (i=0;i<w2;i++)
		if ((p[i]>=0x81 && p[i]<=0x89) ||
			(p[i]>=0xC1 && p[i]<=0xC9) ||
			(p[i]>=0x91 && p[i]<=0x99) ||
			(p[i]>=0xD1 && p[i]<=0xD9) ||
			(p[i]>=0xA2 && p[i]<=0xA9) ||
			(p[i]>=0xE2 && p[i]<=0xE9) ||
			(p[i]>=0xF0 && p[i]<=0xF9) ||
			(p[i]==0x40))
			retval++;
	return retval;
}

bool HasZeroes(char* p,int w2)
{
	int i;
	for (i=0;i<w2;i++)
		if (p[i]==0) return true;
	return false;
}

HWND __stdcall ListLoad(HWND ParentWin,char* FileToLoad,int ShowFlags)
{
	HWND hwnd;
	RECT r;
	DWORD w2,lhigh;
	int l,ltest;
	char *p;
	BOOL success=false;

	// Extension is supported -> load file
	HANDLE f=CreateFile(FileToLoad,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,
							FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	if (f==INVALID_HANDLE_VALUE)
		return NULL;

	l=GetFileSize(f,&lhigh);
	if (lhigh) {          // no files > 2GB!
		CloseHandle(f);
		return NULL;
	}
	if ((ShowFlags & lcp_forceshow)==0) {  // don't check extension in this case!
		if (l>32*1024)
			ltest=32*1024;
		else
			ltest=l;

		p=(char*)malloc(ltest+1);
		if (p) {
			ReadFile(f,p,ltest,&w2,NULL);
			if ((LetterCountAnsi(p,w2)>LetterCountEbcdic(p,w2)) || HasZeroes(p,w2)) {
				CloseHandle(f);
				return NULL;
			}
			SetFilePointer(f,0,NULL,FILE_BEGIN);
			free(p);
		}
	}

	if (!FLibHandle) {
		int OldError = SetErrorMode(SEM_NOOPENFILEERRORBOX);
		FLibHandle = LoadLibrary("Riched20.dll");
		if ((int)FLibHandle < HINSTANCE_ERROR) 
			FLibHandle = LoadLibrary("RICHED32.DLL");
		if ((int)FLibHandle < HINSTANCE_ERROR) 
			FLibHandle = NULL;
		SetErrorMode(OldError);
	}

	lastloadtime=GetCurrentTime();

	GetClientRect(ParentWin,&r);
	// Create window invisbile, only show when data fully loaded!
	hwnd=CreateWindow("RichEdit20A","",WS_CHILD | ES_MULTILINE | ES_READONLY |
		                        WS_VSCROLL | ES_NOHIDESEL,
		r.left,r.top,r.right-r.left,
		r.bottom-r.top,ParentWin,NULL,hinst,NULL);
	if (!hwnd)
		hwnd=CreateWindow("RichEdit","",WS_CHILD | ES_MULTILINE | ES_READONLY |
		                        WS_VSCROLL | ES_NOHIDESEL,
		r.left,r.top,r.right-r.left,
		r.bottom-r.top,ParentWin,NULL,hinst,NULL);
	if (hwnd) {
		SendMessage(hwnd, EM_SETMARGINS, EC_LEFTMARGIN, 8);
		SendMessage(hwnd, EM_SETEVENTMASK, 0, ENM_UPDATE); //ENM_SCROLL doesn't work for thumb movements!

		PostMessage(ParentWin,WM_COMMAND,MAKELONG(lcp_ansi,itm_fontstyle),(LPARAM)hwnd);

		SendMessage(hwnd,WM_SETFONT,(DWORD)GetStockObject(ANSI_FIXED_FONT),0);

		p=(char*)malloc(l+1);
		if (p) {
			ReadFile(f,p,l,&w2,NULL);
			if (w2<0) w2=0;
			if (w2>(DWORD)l) w2=l;
			p[w2]=0;
			if ((DWORD)l==w2) {     // Make sure the file doesn't contain any 0x00 char!
				if (ConvertEbcdicToAnsi(p,w2)) {
					SetWindowText(hwnd,p);
					PostMessage(ParentWin,WM_COMMAND,MAKELONG(0,itm_percent),(LPARAM)hwnd);
					success=true;
				}
			}
			free(p);
		}
		if (!success) {
			DestroyWindow(hwnd);
			hwnd=NULL;
		}
	}
	CloseHandle(f);
	lastloadtime=GetCurrentTime();
	if (hwnd)
		ShowWindow(hwnd,SW_SHOW);
	return hwnd;
}

int __stdcall ListSendCommand(HWND ListWin,int Command,int Parameter)
{
	switch (Command) {
	case lc_copy:
		SendMessage(ListWin,WM_COPY,0,0);
		return EBCDICVIEW_OK;
	case lc_newparams:
		PostMessage(GetParent(ListWin),WM_COMMAND,MAKELONG(0,itm_next),(LPARAM)ListWin);
		return EBCDICVIEW_ERROR;
	case lc_selectall:
		SendMessage(ListWin,EM_SETSEL,0,-1);
		return EBCDICVIEW_OK;
	case lc_setpercent:
		int firstvisible=SendMessage(ListWin,EM_GETFIRSTVISIBLELINE,0,0);
		int linecount=SendMessage(ListWin,EM_GETLINECOUNT,0,0);
		if (linecount>0) {
			int pos=MulDiv(Parameter,linecount,100);
			SendMessage(ListWin,EM_LINESCROLL,0,pos-firstvisible);
			firstvisible=SendMessage(ListWin,EM_GETFIRSTVISIBLELINE,0,0);
			// Place caret on first visible line!
			int firstchar=SendMessage(ListWin,EM_LINEINDEX,firstvisible,0);
			SendMessage(ListWin,EM_SETSEL,firstchar,firstchar);
			pos=MulDiv(firstvisible,100,linecount);
			// Update percentage display
			PostMessage(GetParent(ListWin),WM_COMMAND,MAKELONG(pos,itm_percent),(LPARAM)ListWin);
			return EBCDICVIEW_OK;
		}
		break;
	}
	return EBCDICVIEW_ERROR;
}

int _stdcall ListSearchText(HWND ListWin,char* SearchString,int SearchParameter)
{
	FINDTEXT find;
	int StartPos,Flags;

	if (SearchParameter & lcs_findfirst) {
		//Find first: Start at top visible line
		StartPos=SendMessage(ListWin,EM_LINEINDEX,SendMessage(ListWin,EM_GETFIRSTVISIBLELINE,0,0),0);
		SendMessage(ListWin,EM_SETSEL,StartPos,StartPos);
	} else {
		//Find next: Start at current selection+1
		SendMessage(ListWin,EM_GETSEL,(WPARAM)&StartPos,0);
		StartPos+=1;
	}

	find.chrg.cpMin=StartPos;
	find.chrg.cpMax=SendMessage(ListWin,WM_GETTEXTLENGTH,0,0);
	Flags=0;
	if (SearchParameter & lcs_wholewords)
		Flags |= FR_WHOLEWORD;
	if (SearchParameter & lcs_matchcase)
		Flags |= FR_MATCHCASE;
	if (!(SearchParameter & lcs_backwards))
		Flags |= FR_DOWN;
	find.lpstrText=SearchString;
	int index=SendMessage(ListWin, EM_FINDTEXT, Flags, (LPARAM)&find);
	if (index!=-1) {
	  int indexend=index+strlen(SearchString);
	  SendMessage(ListWin,EM_SETSEL,index,indexend);
	  int line=SendMessage(ListWin,EM_LINEFROMCHAR,index,0)-3;
	  if (line<0)
		  line=0;
      line-=SendMessage(ListWin,EM_GETFIRSTVISIBLELINE,0,0);
      SendMessage(ListWin,EM_LINESCROLL,0,line);
	  return EBCDICVIEW_OK;
	} else {
		SendMessage(ListWin,EM_SETSEL,-1,-1);  // Restart search at the beginning
	}
	return EBCDICVIEW_ERROR;
}

void __stdcall ListCloseWindow(HWND ListWin)
{
	DestroyWindow(ListWin);
	return;
}

int __stdcall ListPrint(HWND ListWin,char* FileToPrint,char* DefPrinter,int PrintFlags,RECT* Margins)
{
	PRINTDLG PrintDlgRec;
	memset(&PrintDlgRec,0,sizeof(PRINTDLG));
	PrintDlgRec.lStructSize=sizeof(PRINTDLG);

    PrintDlgRec.Flags= PD_ALLPAGES | PD_USEDEVMODECOPIESANDCOLLATE | PD_RETURNDC;
	PrintDlgRec.nFromPage   = 0xFFFF; 
	PrintDlgRec.nToPage     = 0xFFFF; 
    PrintDlgRec.nMinPage	= 1;
    PrintDlgRec.nMaxPage	= 0xFFFF;
    PrintDlgRec.nCopies		= 1;
    PrintDlgRec.hwndOwner	= ListWin;// MUST be Zero, otherwise crash!
	if (PrintDlg(&PrintDlgRec)) 
	{
		HDC hdc=PrintDlgRec.hDC;
		DOCINFO DocInfo;
		POINT offset,physsize,start,avail,printable;
		int LogX,LogY;
		RECT rcsaved;

		// Warning: PD_ALLPAGES is zero!
		BOOL PrintSel=(PrintDlgRec.Flags & PD_SELECTION);
		BOOL PrintPages=(PrintDlgRec.Flags & PD_PAGENUMS);
		int PageFrom=1;
		int PageTo=0x7FFF;
		if (PrintPages) {
			PageFrom=PrintDlgRec.nFromPage;
			PageTo=PrintDlgRec.nToPage;
			if (PageTo<=0) PageTo=0x7FFF;
		}


		memset(&DocInfo,0,sizeof(DOCINFO));
		DocInfo.cbSize=sizeof(DOCINFO);
		DocInfo.lpszDocName=FileToPrint;
		if (StartDoc(hdc,&DocInfo)) {
			SetMapMode(hdc,MM_LOMETRIC);
			offset.x=GetDeviceCaps(hdc,PHYSICALOFFSETX);
			offset.y=GetDeviceCaps(hdc,PHYSICALOFFSETY);
			DPtoLP(hdc,&offset,1);
			physsize.x=GetDeviceCaps(hdc,PHYSICALWIDTH);
			physsize.y=GetDeviceCaps(hdc,PHYSICALHEIGHT);
			DPtoLP(hdc,&physsize,1);

			start.x=Margins->left-offset.x;
			start.y=-Margins->top-offset.y;
			if (start.x<0)
				start.x=0;
			if (start.y>0)
				start.y=0;
			avail.x=GetDeviceCaps(hdc,HORZRES);
			avail.y=GetDeviceCaps(hdc,VERTRES);
			DPtoLP(hdc,&avail,1);

			printable.x=min(physsize.x-(Margins->right+Margins->left),avail.x-start.x);
			printable.y=max(physsize.y+(Margins->top+Margins->bottom),avail.y-start.y);
  			
			LogX=GetDeviceCaps(hdc, LOGPIXELSX);
			LogY=GetDeviceCaps(hdc, LOGPIXELSY);

			SendMessage(ListWin, EM_FORMATRANGE, 0, 0);

			FORMATRANGE Range;
			memset(&Range,0,sizeof(FORMATRANGE));
			Range.hdc=hdc;
			Range.hdcTarget=hdc;
			LPtoDP(hdc,&start,1);
			LPtoDP(hdc,&printable,1);
			Range.rc.left = start.x * 1440 / LogX;
			Range.rc.top = start.y * 1440 / LogY;
			Range.rc.right = (start.x+printable.x) * 1440 / LogX;
			Range.rc.bottom = (start.y+printable.y) * 1440 / LogY;
			SetMapMode(hdc,MM_TEXT);

			BOOL PrintAborted=false;
			Range.rcPage = Range.rc;
			rcsaved = Range.rc;
			int CurrentPage = 1;
			int LastChar = 0;
			int LastChar2= 0;
			int MaxLen = SendMessage(ListWin,WM_GETTEXTLENGTH,0,0);
			Range.chrg.cpMax = -1;
			if (PrintPages) {
				do {
			        Range.chrg.cpMin = LastChar;
					if (CurrentPage<PageFrom) {
						LastChar = SendMessage(ListWin, EM_FORMATRANGE, 0, (LPARAM)&Range);
					} else {
						//waitform.ProgressLabel.Caption:=spage+inttostr(CurrentPage);
						//application.processmessages;
						LastChar = SendMessage(ListWin, EM_FORMATRANGE, 1, (LPARAM)&Range);
					}
					// Warning: At end of document, LastChar may be<MaxLen!!!
					if (LastChar!=-1 && LastChar < MaxLen) {
						Range.rc=rcsaved;                // Check whether another page comes
						Range.rcPage = Range.rc;
						Range.chrg.cpMin = LastChar;
						LastChar2= SendMessage(ListWin, EM_FORMATRANGE, 0, (LPARAM)&Range);
						if (LastChar<LastChar2 && LastChar < MaxLen && LastChar != -1 &&
						  CurrentPage>=PageFrom && CurrentPage<PageTo) {
							EndPage(hdc);
						}
					}

					CurrentPage++;
					Range.rc=rcsaved;
					Range.rcPage = Range.rc;
				} while (LastChar < MaxLen && LastChar != -1 && LastChar<LastChar2 &&
					     (PrintPages && CurrentPage<=PageTo) && !PrintAborted);
			} else {
				if (PrintSel) {
					SendMessage(ListWin,EM_GETSEL,(WPARAM)&LastChar,(LPARAM)&MaxLen);
					Range.chrg.cpMax = MaxLen;
				}
				do {
					Range.chrg.cpMin = LastChar;
					//waitform.ProgressLabel.Caption:=spage+inttostr(CurrentPage);
					//waitform.ProgressLabel.update;
					//application.processmessages;
					LastChar = SendMessage(ListWin, EM_FORMATRANGE, 1, (LPARAM)&Range);

					// Warning: At end of document, LastChar may be<MaxLen!!!
					if (LastChar!=-1 && LastChar < MaxLen) {
						Range.rc=rcsaved;                // Check whether another page comes
						Range.rcPage = Range.rc;
						Range.chrg.cpMin = LastChar;
						LastChar2= SendMessage(ListWin, EM_FORMATRANGE, 0, (LPARAM)&Range);
						if (LastChar<LastChar2 && LastChar < MaxLen && LastChar != -1) {
							EndPage(hdc);
						}
					}
					CurrentPage++;
					Range.rc=rcsaved;
					Range.rcPage = Range.rc;
				} while (LastChar<LastChar2 && LastChar < MaxLen && LastChar != -1 && !PrintAborted);
			}
			if (PrintAborted)
				AbortDoc(hdc);
			else
				EndDoc(hdc);
		} //StartDoc
  
		SendMessage(ListWin, EM_FORMATRANGE, 0, 0);
		DeleteDC(PrintDlgRec.hDC);
	}
	if (PrintDlgRec.hDevNames)
		GlobalFree(PrintDlgRec.hDevNames);
	return 0;
}

void __stdcall ListSetDefaultParams(ListDefaultParamStruct* dps)
{
	strlcpy(inifilename,dps->DefaultIniName,MAX_PATH-1);
}
