// wpdplug.cpp : Definiert den Einstiegspunkt fr die DLL-Anwendung.
//

#include <PortableDeviceApi.h>
#include <PortableDevice.h>
#include <stdio.h>
#include <wchar.h>
#include <Dbt.h>
#include <wmsdkidl.h>
#include <GdiPlus.h>
#include "wpdplug.h"
#include "cunicode.h"
#include "fsplugin.h"
#include "utils.h"
#include "connectionsettings.h"

#define DefPluginTitle "MediaAudio2"

WCHAR DefaultIniNameW[MAX_PATH];
HINSTANCE hInst;
tProgressProc ProgressProc;
tLogProc LogProc;
tRequestProc RequestProc;
tProgressProcW ProgressProcW;
tLogProcW LogProcW;
tRequestProcW RequestProcW;
int PluginNumber;
BOOL connected=false;
BOOL DeviceEventReceived=false;   // if true, we need to re-scan all devices
BOOL ThisLocalTime=false;

#define NUM_OBJECTS_TO_REQUEST 128

BOOL LoadAllDevices();
void FreeAllDevices();

ULONG_PTR GdiPlusToken=0;

BOOL GdiPlusInitialize()
{
	if (GdiPlusToken)
		return true;

	Gdiplus::GdiplusStartupInput Gsi;
	memset(&Gsi,0,sizeof(Gsi));
	Gsi.GdiplusVersion=1;
	if (Gdiplus::GdiplusStartup(&GdiPlusToken,&Gsi,NULL)!=0)
        GdiPlusToken=0;
	return (GdiPlusToken!=0);
}

void ShutdownGdiPlus()   // do NOT call this from DLL_PROCESS_DETACH!
{
	if (GdiPlusToken) {
		Gdiplus::GdiplusShutdown(GdiPlusToken);
		GdiPlusToken=0;
	}
}

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		hInst=(HINSTANCE)hModule;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}

char* strlcpy(char* p,char*p2,int maxlen)
{
	if ((int)strlen(p2)>=maxlen) {
		strncpy_s(p,maxlen,p2,maxlen);
		p[maxlen]=0;
	} else
		strcpy_s(p,maxlen,p2);
	return p;
}

char* strlcat(char* p,char*p2,int maxlen)
{
	int restlen=maxlen-(int)strlen(p);
	if (restlen>0)
		strlcpy(p+strlen(p),p2,restlen);
	return p;
}

typedef struct {
	WCHAR Path[wdirtypemax];
	WCHAR LastFoundName[wdirtypemax];
	IEnumPortableDeviceObjectIDs* pEnumObjectIDs;
	IPortableDeviceKeyCollection* pPropertiesToRead;
	IPortableDeviceProperties* pProperties;
	DWORD pPnpDeviceLastRead;
	LPWSTR szObjectIDArray[NUM_OBJECTS_TO_REQUEST];
	DWORD szObjectIDsFetched;
	DWORD szObjectIDLastRead;
} tLastFindStuct,*pLastFindStuct;

BOOL initialized=FALSE;
BOOL firstinitialized=FALSE;
IPortableDeviceManager* pDevMgr=NULL;
PWSTR* StoredPnpDeviceIDs=NULL;   // keep them globally!
PWSTR* StoredPnPFriendlyNames=NULL;
IPortableDevice** StoredDevices=NULL;
DWORD StoredNumIds=0;

HANDLE hDevNotify=NULL;
HWND hWndNotify=NULL;

BOOL InitFunctionsIfNeeded(BOOL trueconnect)
{
	HRESULT hr;
	BOOL result=false;

	if (!firstinitialized) {
		CoInitialize(NULL);
		firstinitialized=true;
	}
	if (!initialized) {
		initialized=true;
		hr = CoCreateInstance(CLSID_PortableDeviceManager, NULL, CLSCTX_INPROC_SERVER,
			IID_IPortableDeviceManager, (VOID**) &pDevMgr);
		if SUCCEEDED(hr) {
			result=true;
		} else {
			MessageBox(GetActiveWindow(),"This plugin needs Windows Media Player 10 or newer!","Wpdplug",MB_ICONSTOP);
			result=false;
		}
	} else
		result=true;
	if (result && pDevMgr && StoredNumIds==0) {
		return LoadAllDevices();
	} else
		return true;
}

// From: http://blogs.msdn.com/b/wpdblog/archive/2007/03/17/how-to-receive-wpd-device-arrival-events.aspx
#define WPD_DEVINTERFACE L"{6ac27878-a6fa-4155-ba85-f98f491d4f33}"
#define szWindowClass "PnpNotificationListener"
GUID guidDevInterface=GUID_NULL;

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{  
	switch (uMsg) {
		case WM_CREATE:
		{
			DEV_BROADCAST_DEVICEINTERFACE db = {0};
			db.dbcc_size = sizeof(db);
			db.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
			CLSIDFromString(WPD_DEVINTERFACE, &guidDevInterface);
			db.dbcc_classguid  = guidDevInterface;
			hDevNotify = RegisterDeviceNotificationW(hWnd, &db, DEVICE_NOTIFY_WINDOW_HANDLE);
			return 1;
		}
		case WM_DEVICECHANGE:
			switch(wParam)
			{
				case DBT_DEVICEARRIVAL:
				case DBT_DEVICEREMOVECOMPLETE:
				{
					PDEV_BROADCAST_HDR pdbh = (PDEV_BROADCAST_HDR)lParam;
					if (pdbh != NULL && pdbh->dbch_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
					{
						PDEV_BROADCAST_DEVICEINTERFACE pdbi = (PDEV_BROADCAST_DEVICEINTERFACE)lParam;
						if (IsEqualGUID(pdbi->dbcc_classguid, guidDevInterface)) 
						{
							DeviceEventReceived=true;
						}
					}
				 }
                 break;         
			} // switch (wParam)
			return 0;
		default:
			return DefWindowProc(hWnd, uMsg, wParam, lParam);
	} // switch (uMsg)
}

ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASS wc;
	memset(&wc,0,sizeof(wc));
	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc	= (WNDPROC)WndProc;
	wc.hInstance		= hInstance;
	wc.lpszClassName	= szWindowClass;
	return RegisterClass(&wc);
}

BOOL RegisterForEventNotifications(void)
{
	if (!hWndNotify) {
		HINSTANCE hInstance=GetModuleHandle(NULL);
		MyRegisterClass(hInstance);
		hWndNotify=CreateWindow(szWindowClass, szWindowClass, WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);
	}
	return hWndNotify!=NULL;
}

void UnregisterNotification(void) {
	if (hDevNotify) {
		UnregisterDeviceNotification(hDevNotify);
		hDevNotify=NULL;
	}
	if (hWndNotify) {
		DestroyWindow(hWndNotify);
		hWndNotify=NULL;
	}
}

#define CACHESIZE 32
LPWSTR CachedDirs[CACHESIZE]={0};
DWORD CachedDirLens[CACHESIZE]={0};
LPWSTR CachedObjectIds[CACHESIZE]={0};
DWORD CachedLastUsedTimes[CACHESIZE]={0};

void ClearCache() {
	for (int i=0;i<CACHESIZE;i++) {
		if (CachedDirs[i]!=NULL)
			CoTaskMemFree(CachedDirs[i]);
		if (CachedObjectIds[i]!=NULL)
			CoTaskMemFree(CachedObjectIds[i]);
	}
	memset(&CachedDirs,0,sizeof(CachedDirs));
	memset(&CachedDirLens,0,sizeof(CachedDirLens));
	memset(&CachedObjectIds,0,sizeof(CachedObjectIds));
	memset(&CachedLastUsedTimes,0,sizeof(CachedLastUsedTimes));
}

void RemoveNameFromCache(LPWSTR pdir) {
	WCHAR fulldir[1024];
	wcslcpy(fulldir,pdir,1022);
	wcslcatbackslash(fulldir,1023);
	DWORD len=(DWORD)wcslen(fulldir);
	if (len<=1)
		return;
	// look whether the dir or any subdir in it is already in the cache
	for (int i=0;i<CACHESIZE;i++) {
		if (CachedDirLens[i]>=len && wcsncmp(fulldir,CachedDirs[i],len)==0) {
			CoTaskMemFree(CachedDirs[i]);
			CachedDirs[i]=NULL;
			CoTaskMemFree(CachedObjectIds[i]);
			CachedObjectIds[i]=NULL;
			CachedDirLens[i]=0;
			CachedLastUsedTimes[i]=0;
		}
	}

}

void RemoveFullPathFromCache(LPWSTR pdir) {
	if (wcslen(pdir)<2)
		return;
	LPWSTR pdirstart=wcschr(pdir+1,'\\');
	if (pdirstart)
		RemoveNameFromCache(pdirstart+1);
}

void AddNameToCache(LPWSTR pdir,LPWSTR pObjectId,DWORD time) {
	WCHAR fulldir[1024];
	wcslcpy(fulldir,pdir,1022);
	wcslcatbackslash(fulldir,1023);
	DWORD len=(DWORD)wcslen(fulldir);
	if (len<=1)
		return;
	// first, look whether the dir is already in the cache
	for (int i=0;i<CACHESIZE;i++) {
		if (CachedDirLens[i]==len && wcscmp(fulldir,CachedDirs[i])==0)
			return;
	}
	// second, look for a free space
	int lastmatch=-1;
	for (int i=0;i<CACHESIZE;i++) {
		if (CachedDirs[i]==0) {
			lastmatch=i;
			break;
		}
	}
	// third, look for the one with the oldest timestamp
	if (lastmatch<0) {
		DWORD oldesttime=0xFFFFFFFF;
		for (int i=0;i<CACHESIZE;i++) {
			if (CachedLastUsedTimes[i]<oldesttime) {
				oldesttime=CachedLastUsedTimes[i];
				lastmatch=i;
			}
		}
		if (lastmatch>=0) {
			CoTaskMemFree(CachedDirs[lastmatch]);
			CoTaskMemFree(CachedObjectIds[lastmatch]);
		}
	}
	CachedDirs[lastmatch]=wstrnew(fulldir);
	CachedDirLens[lastmatch]=len;
	CachedObjectIds[lastmatch]=wstrnew(pObjectId);
	CachedLastUsedTimes[lastmatch]=time;
}

BOOL FindNameInCache(LPWSTR pdir,LPWSTR* returnedObjectId,LPWSTR* pdirsubstart) {
	WCHAR fulldir[1024];
	wcslcpy(fulldir,pdir,1022);
	wcslcatbackslash(fulldir,1023);
	DWORD maxmatchlen=0;
	int lastmatch=-1;
	// find longest match!
	for (int i=0;i<CACHESIZE;i++) {
		if (CachedDirs[i]) {
			if (CachedDirLens[i]>maxmatchlen) {
				if (wcsncmp(CachedDirs[i],fulldir,CachedDirLens[i])==0) {
					lastmatch=i;
					maxmatchlen=CachedDirLens[i];
				}
			}
		}
	}
	if (lastmatch>=0) {
		// copy remaining name back
		if (wcslen(pdir)>maxmatchlen)
			*pdirsubstart=pdir+maxmatchlen;
		else
			*pdirsubstart=pdir+wcslen(pdir);  // full match
		*returnedObjectId=CachedObjectIds[lastmatch];
		return true;
	}
	return false;
}

HRESULT GetFolderIDFromPathName(LPWSTR pPath,IEnumPortableDeviceObjectIDs** pEnumObjectIDsRetVal,
	IPortableDeviceProperties** pPropertiesRetVal,IPortableDeviceContent** pDeviceContent,LPWSTR* pStorageIDRetVal)
{
	if (StoredPnPFriendlyNames==NULL || StoredPnpDeviceIDs==NULL)
		return E_FAIL;
	// wsSearch has form \Devicename\path1\path2
	// First, get Device

	IPortableDevice* pDevice=NULL;
	IPortableDeviceContent* pContent=NULL;
	IEnumPortableDeviceObjectIDs* pEnumObjectIDs=NULL;
	IPortableDeviceProperties* pProperties=NULL;
	IPortableDeviceKeyCollection* pPropertiesToRead=NULL;
	WCHAR *pname,*pnext,*pdirstart,*pdirsubstart;
	HRESULT hr;
	WCHAR wcSearch[1024];

	wcslcpy(wcSearch,pPath+1,1023);
	pdirstart=wcschr(wcSearch,'\\');
	if (pdirstart) {
		pdirstart[0]=0;
		pdirstart++;
	}
	if (wcSearch[0]==0)
		return E_FAIL;
	// Find the right device, p points to it!

	WCHAR* DeviceID=NULL;
	DWORD DeviceIndex=0;
	for (DeviceIndex=0;DeviceIndex<StoredNumIds;DeviceIndex++) {
		if (wcscmp((const wchar_t *)StoredPnPFriendlyNames[DeviceIndex],wcSearch)==0) {
			DeviceID=StoredPnpDeviceIDs[DeviceIndex];
			pDevice=StoredDevices[DeviceIndex];
			break;
		}
	}
	if (DeviceID==NULL) {
		LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,"Device not found!");
		return E_FAIL;
	}
	if (pDevice==NULL) {
		IPortableDeviceValues* spClientInfo=NULL;
		hr = CoCreateInstance(CLSID_PortableDeviceValues, NULL, CLSCTX_INPROC_SERVER, IID_IPortableDeviceValues, (VOID**)&spClientInfo);
		if (SUCCEEDED(hr))
			hr = spClientInfo->SetUnsignedIntegerValue(WPD_CLIENT_REVISION, 0);
		if (SUCCEEDED(hr))
			hr = spClientInfo->SetUnsignedIntegerValue(WPD_CLIENT_MAJOR_VERSION, 1);
		if (SUCCEEDED(hr))
			hr = spClientInfo->SetUnsignedIntegerValue(WPD_CLIENT_MINOR_VERSION, 0);
		if (SUCCEEDED(hr))
			hr = spClientInfo->SetStringValue(WPD_CLIENT_NAME, L"Enumerator");       
		if (FAILED(hr)) {
			if (spClientInfo)
				spClientInfo->Release();
			return hr;
		}
		hr = CoCreateInstance(CLSID_PortableDevice, NULL, CLSCTX_INPROC_SERVER, IID_IPortableDevice, (VOID**) &pDevice);
		if (!SUCCEEDED(hr)) {
			spClientInfo->Release();
			return hr;
		}
		hr = pDevice->Open(DeviceID, spClientInfo);
		spClientInfo->Release();
		spClientInfo=NULL;
		if (SUCCEEDED(hr))
			StoredDevices[DeviceIndex]=pDevice;
	} else
		hr=S_OK;
	if (SUCCEEDED(hr)) {
		hr = pDevice->Content(&pContent);
		if (FAILED(hr)) {
			LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,"No content on Device!");
			return hr;
		} 
	}
	PWSTR returnedObjectId=NULL;
	pdirsubstart=pdirstart;
	if (!FindNameInCache(pdirstart,&returnedObjectId,&pdirsubstart))
		returnedObjectId=WPD_DEVICE_OBJECT_ID;

	if (pdirsubstart[0]==NULL) { // device root
		if (pEnumObjectIDsRetVal) {
			hr = pContent->EnumObjects(0,               // Flags are unused
                     returnedObjectId,     // Starting from the passed in object
                     NULL,            // Filter is unused
                     &pEnumObjectIDs);
			*pEnumObjectIDsRetVal=pEnumObjectIDs;
		} else 
			hr=S_OK;
		if (pPropertiesRetVal)
			pContent->Properties(pPropertiesRetVal);
		if (pDeviceContent)
			*pDeviceContent=pContent;
		else
			pContent->Release();
		if (pStorageIDRetVal)
			*pStorageIDRetVal=wstrnew(returnedObjectId);
		return hr;
	}

	// ShowSupportedFormats(pIDevice);
	if (SUCCEEDED(hr))
		hr = pContent->Properties(&pProperties);
	if (SUCCEEDED(hr))
		hr = CoCreateInstance(CLSID_PortableDeviceKeyCollection,
                      NULL,
                      CLSCTX_INPROC_SERVER,
					  IID_IPortableDeviceKeyCollection,
                      (VOID**) &pPropertiesToRead);
	if (SUCCEEDED(hr)) {
		pPropertiesToRead->Add(WPD_OBJECT_NAME);
		pPropertiesToRead->Add(WPD_OBJECT_ORIGINAL_FILE_NAME);
	}
	LPWSTR LastParentName=wstrnew(WPD_DEVICE_OBJECT_ID);
	if (SUCCEEDED(hr))
		hr = pContent->EnumObjects(0,               // Flags are unused
                                  returnedObjectId,     // Starting from the passed in object
                                  NULL,            // Filter is unused
                                  &pEnumObjectIDs);
	if (FAILED(hr)) {
		if (pPropertiesToRead)
			pPropertiesToRead->Release();
		if (pProperties)
			pProperties->Release();
		if (pEnumObjectIDs)
			pEnumObjectIDs->Release();
		if (pContent)
			pContent->Release();
		return hr;
	}
	pname=pdirsubstart;
	pnext=wcschr(pname,'\\');
	if (pnext)
		pnext[0]=0;

	DWORD cFetched=0;
	DWORD time=GetTickCount();
	while (SUCCEEDED(hr)) {
		PWSTR szObjectIDArray[NUM_OBJECTS_TO_REQUEST];
		hr = pEnumObjectIDs->Next(NUM_OBJECTS_TO_REQUEST,   // Number of objects to request on each NEXT call
			                          szObjectIDArray,          // Array of PWSTR array which will be populated on each NEXT call
				                      &cFetched);               // Number of objects written to the PWSTR array
		DWORD i=0;
		if (cFetched==0)
			hr=E_FAIL;
		while (SUCCEEDED(hr) && i<cFetched) {
			IPortableDeviceValues* pObjectProperties=NULL;
			HRESULT hr2=pProperties->GetValues(szObjectIDArray[i],
                                pPropertiesToRead,   // The properties we want to read
                                &pObjectProperties); // Driver supplied property values for the specified object
			if (SUCCEEDED(hr2)) {
				PWSTR pEnumName=NULL;
				pObjectProperties->GetStringValue(WPD_OBJECT_ORIGINAL_FILE_NAME,&pEnumName);
				if (pEnumName==NULL || pEnumName[0]==0)
					pObjectProperties->GetStringValue(WPD_OBJECT_NAME,&pEnumName);
				PWSTR pNameAlloc=pEnumName;
				if (wcscmp(pEnumName,L"\\")==0)
					pEnumName=L"_";

				if (wcscmp(pEnumName,pname)==0) {  //found!!
					AddNameToCache(pdirstart,szObjectIDArray[i],time);
					CoTaskMemFree(pNameAlloc);
					pEnumObjectIDs->Release();
					pEnumObjectIDs=NULL;

					CoTaskMemFree(LastParentName);
					LastParentName=wstrnew(szObjectIDArray[i]);
					for (i=0;i<cFetched;i++)
						CoTaskMemFree(szObjectIDArray[i]);
					cFetched=0;

					pname=pnext;
					if (pname) {
						pname[0]='\\';
						pname++;
						pnext=wcschr(pname,'\\');
						if (pnext)
							pnext[0]=0;
						if (pname[0]==0)
							pname=NULL;
					}
					if (pname || pEnumObjectIDsRetVal) {
						hr = pContent->EnumObjects(0,               // Flags are unused
									  LastParentName,               // Subitem
									  NULL,                         // Filter is unused
									  &pEnumObjectIDs);
						if (!SUCCEEDED(hr))    // a file?
							pEnumObjectIDs=NULL;
					}
					if (!pname) {   //we are done!
						if (pEnumObjectIDsRetVal)
							*pEnumObjectIDsRetVal=pEnumObjectIDs;
						if (pPropertiesRetVal)
							*pPropertiesRetVal=pProperties;
						else
							pObjectProperties->Release();
						if (pDeviceContent)
							*pDeviceContent=pContent;
						else
							pContent->Release();
						if (pStorageIDRetVal)
							*pStorageIDRetVal=LastParentName;
						else
							CoTaskMemFree(LastParentName);
						pPropertiesToRead->Release();
						return S_OK;
					}
				} else {
					CoTaskMemFree(pNameAlloc);
					pObjectProperties->Release();
				}
			}
			i++;
		}
		for (i=0;i<cFetched;i++)
			CoTaskMemFree(szObjectIDArray[i]);
	}
	if (pPropertiesToRead)
		pPropertiesToRead->Release();
	if (pProperties)
		pProperties->Release();
	if (pEnumObjectIDs)
		pEnumObjectIDs->Release();
	if (pContent)
		pContent->Release();
	if (LastParentName)
		CoTaskMemFree(LastParentName);
	return E_FAIL;
}

BOOL LoadAllDevices()
{
	RegisterForEventNotifications();
	StoredNumIds=0;
	HRESULT hr = pDevMgr->GetDevices(NULL,&StoredNumIds);
	if (FAILED(hr))
		return false;
	if (StoredNumIds) {
		StoredPnpDeviceIDs = (PWSTR*)malloc(StoredNumIds*sizeof(LPWSTR));
		StoredPnPFriendlyNames = (PWSTR*)malloc(StoredNumIds*sizeof(LPWSTR));
		int sz=StoredNumIds*sizeof(IPortableDevice);
		StoredDevices = (IPortableDevice**)malloc(sz);
		memset(StoredDevices,0,sz);
		hr = pDevMgr->GetDevices(StoredPnpDeviceIDs, &StoredNumIds);
		if (FAILED(hr))
			return false;
		LogProc(PluginNumber,MSGTYPE_CONNECT,"CONNECT \\");
		connected=true;

		for (DWORD i=0;i<StoredNumIds;i++) {
			DWORD friendlyNameLength=0;
			hr=pDevMgr->GetDeviceFriendlyName(StoredPnpDeviceIDs[i], NULL, &friendlyNameLength); 
			if (SUCCEEDED(hr) && friendlyNameLength>0 && friendlyNameLength<64) {
				StoredPnPFriendlyNames[i] = (PWSTR)CoTaskMemRealloc(NULL,friendlyNameLength*sizeof(WCHAR));
				hr=pDevMgr->GetDeviceFriendlyName(StoredPnpDeviceIDs[i], StoredPnPFriendlyNames[i], &friendlyNameLength); 
				if (FAILED(hr)) {
					CoTaskMemFree(StoredPnPFriendlyNames[i]);
					StoredPnPFriendlyNames[i]=NULL;
				} else {
					wcutlastbackslash(StoredPnPFriendlyNames[i]);
					DWORD len=(DWORD)wcslen(StoredPnPFriendlyNames[i]);
					for (DWORD j=0;j<len;j++) {
						WCHAR ch=StoredPnPFriendlyNames[i][j];
						if (ch=='\\' || ch=='/' || ch=='*' || ch=='?')
							ch='_';
					}
				}
			} else
				hr=E_FAIL;
			if (FAILED(hr)) {
				StoredPnPFriendlyNames[i] = (PWSTR)CoTaskMemRealloc(NULL,16*sizeof(WCHAR));
				if (wcsstr(StoredPnpDeviceIDs[i],L"usb"))
					swprintf(StoredPnPFriendlyNames[i],16,L"USB%d",i+1);
				else
					swprintf(StoredPnPFriendlyNames[i],16,L"Device%d",i+1);
			}
		}
	}
	return true;
}

/*
void logValue(PWSTR name,PWSTR text,HRESULT hr,PROPVARIANT* pr) {
	WCHAR buf[256];
	__try {
		if (!SUCCEEDED(hr)) {
			wsprintfW(buf,L"%s %s: Error=%d",name,text,hr);
		} else if (pr->vt==VT_ERROR) {
			wsprintfW(buf,L"%s %s: vt=VT_ERROR",name,text);
		} else if (pr->vt==VT_DATE) {
			SYSTEMTIME systime;
			hr=VariantTimeToSystemTime(pr->date,&systime);
			if (SUCCEEDED(hr))
				wsprintfW(buf,L"%s %s: VT_DATE=%d-%02d-%02d",name,text,systime.wYear,systime.wMonth,systime.wDay);
			else
				wsprintfW(buf,L"%s %s: VT_DATE invalid time: %d",name,text,hr);
		} else if (pr->vt==VT_FILETIME) {
			SYSTEMTIME systime;
			if (FileTimeToSystemTime(&pr->filetime,&systime))
				wsprintfW(buf,L"%s %s: VT_FILETIME=%d-%02d-%02d",name,text,systime.wYear,systime.wMonth,systime.wDay);
			else
				wsprintfW(buf,L"%s %s: VT_FILETIME invalid value",name,text);
		} else {
			wsprintfW(buf,L"%s %s: vt=%d, hr=%d",name,text,pr->vt,hr);
		}
		LogProcW(PluginNumber,MSGTYPE_DETAILS,buf);
	} __except (true) {
		LogProcW(PluginNumber,MSGTYPE_DETAILS,L"Exception in logValue");
	}
}

WCHAR lastbuf[2048]={0};
*/

#define COUNTOF(x) sizeof(x)/sizeof(x[0])

/*
DEFINE_GUID( WPD_PROPERTIES_MTP_VENDOR_EXTENDED_OBJECT_PROPS , 0x4d545058, 0x4fce, 0x4578, 0x95, 0xc8, 0x86, 0x98, 0xa9, 0xbc, 0xf, 0x49 );

WCHAR retbuf[128];

WCHAR* getNameFromPropertyKey(PROPERTYKEY* propkey,BOOL* unknownField) {
	WCHAR* p=NULL;
	__try {
		*unknownField=false;
		if (IsEqualGUID(propkey->fmtid,WPD_OBJECT_PROPERTIES_V1)) {
			switch(propkey->pid) {
				case 2:p=L"ID ";break;
				case 3:p=L"PARENT_ID ";break;
				case 4:p=L"NAME ";break;
				case 5:p=L"PERSISTENT_UNIQUE_ID ";break;
				case 6:p=L"FORMAT ";break;
				case 7:p=L"CONTENT_TYPE ";break;
				case 9:p=L"ISHIDDEN ";break;
				case 10:p=L"ISSYSTEM ";break;
				case 11:p=L"SIZE ";break;
				case 12:p=L"ORIGINAL_FILE_NAME ";break;
				case 13:p=L"NON_CONSUMABLE ";break;
				case 14:p=L"REFERENCES ";break;
				case 15:p=L"KEYWORDS ";break;
				case 16:p=L"SYNC_ID ";break;
				case 17:p=L"IS_DRM_PROTECTED ";break;
				case 18:p=L"DATE_CREATED ";*unknownField=true;break;
				case 19:p=L"DATE_MODIFIED ";*unknownField=true;break;
				case 20:p=L"DATE_AUTHORED ";*unknownField=true;break;
				case 21:p=L"BACK_REFERENCES ";break;
				case 23:p=L"CONTAINER_FUNCTIONAL_OBJECT_ID ";break;
				case 24:p=L"GENERATE_THUMBNAIL_FROM_RESOURCE ";break;
				case 25:p=L"HINT_LOCATION_DISPLAY_NAME ";break;
				case 26:p=L"CAN_DELETE ";break;
			}
		} else if (IsEqualGUID(propkey->fmtid,WPD_CONTACT_OBJECT_PROPERTIES_V1)) {
			switch(propkey->pid) {
				case 2:p=L"DISPLAY_NAME ";break;
			}
		} else if (IsEqualGUID(propkey->fmtid,WPD_FUNCTIONAL_OBJECT_PROPERTIES_V1)) {
			switch(propkey->pid) {
				case 2:p=L"FUNCTIONAL_OBJECT_CATEGORY ";break;
			}
		} else if (IsEqualGUID(propkey->fmtid,WPD_STORAGE_OBJECT_PROPERTIES_V1)) {
			switch(propkey->pid) {
				case 2:p=L"STORAGE_TYPE ";break;
				case 3:p=L"STORAGE_FILE_SYSTEM_TYPE ";break;
				case 4:p=L"STORAGE_CAPACITY ";break;
				case 5:p=L"STORAGE_FREE_SPACE_IN_BYTES ";break;
				case 6:p=L"STORAGE_FREE_SPACE_IN_OBJECTS ";break;
				case 7:p=L"STORAGE_DESCRIPTION ";break;
				case 8:p=L"STORAGE_SERIAL_NUMBER ";break;
				case 9:p=L"STORAGE_MAX_OBJECT_SIZE ";break;
				case 10:p=L"STORAGE_CAPACITY_IN_OBJECTS ";break;
				case 11:p=L"STORAGE_ACCESS_CAPABILITY ";break;
			}
		} else if (IsEqualGUID(propkey->fmtid,WPD_PROPERTIES_MTP_VENDOR_EXTENDED_OBJECT_PROPS)) {
			*unknownField=true;
			wsprintfW(retbuf,L"Vendor key %d ",propkey->pid);
			p=retbuf;
		}
		if (p==NULL) {
			*unknownField=true;
			retbuf[0]=0;
			StringFromGUID2(propkey->fmtid,retbuf,COUNTOF(retbuf)-1);
			if (retbuf[0]) {
				size_t L=wcslen(retbuf);
				_itow_s(propkey->pid,retbuf+L+1,COUNTOF(retbuf)-L-1,10);
				retbuf[L]=':';
				wcslcat(retbuf,L" ",COUNTOF(retbuf)-1);
			}
		}
		return p;
	} __except (true) {
		return L"Exception in getNameFromPropertyKey!";
	}
}
*/

void PopulateFindDataW(PWSTR szObject,pLastFindStuct lf,WIN32_FIND_DATAW *FindData,BOOL LocalTime)
{
	__try {
		memset(FindData,0,sizeof(WIN32_FIND_DATA));
		wcslcpy(FindData->cFileName,szObject,MAX_PATH-2);
		FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
		FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
		FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
		FindData->nFileSizeHigh=0;
		FindData->nFileSizeLow=0;

/*		IPortableDeviceKeyCollection *pkeys=NULL;
		__int64 getvalueflag=0;
		DWORD count=0;
		BOOL fieldTypesChanged=FALSE;

		if (SUCCEEDED(lf->pProperties->GetSupportedProperties(szObject,&pkeys))) {
			if (pkeys!=NULL && SUCCEEDED(pkeys->GetCount(&count))) {
				WCHAR buf[2048];
				wcslcpy(buf,L"Supported:",COUNTOF(buf)-1);
				for (DWORD i=0;i<count;i++) {
					PROPERTYKEY propkey;
					if (SUCCEEDED(pkeys->GetAt(i,&propkey))) {
						BOOL unknownField=FALSE;
						WCHAR* p=getNameFromPropertyKey(&propkey,&unknownField);
						if (p!=NULL) {
							if (unknownField)
								getvalueflag|=(1LL<<i);
							wcslcat(buf,p,COUNTOF(buf)-1);
						}
					}
				}
				if (wcscmp(buf,lastbuf)) {
					fieldTypesChanged=true;
					LogProcW(PluginNumber,MSGTYPE_DETAILS,buf);
					wcslcpy(lastbuf,buf,COUNTOF(lastbuf)-1);
				}
			}
		} else
			LogProcW(PluginNumber,MSGTYPE_DETAILS,L"GetSupportedProperties failed.");
*/
		if (lf->pPropertiesToRead && lf->pProperties) {
			IPortableDeviceValues* pObjectProperties=NULL;
			HRESULT hr2=lf->pProperties->GetValues(szObject,
							lf->pPropertiesToRead, //pkeys   // The properties we want to read
							&pObjectProperties); // Driver supplied property values for the specified object
			if (SUCCEEDED(hr2)) {
				PWSTR pName=NULL;
				pObjectProperties->GetStringValue(WPD_OBJECT_ORIGINAL_FILE_NAME,&pName);
				if (pName==NULL || pName[0]==0)
					pObjectProperties->GetStringValue(WPD_OBJECT_NAME,&pName);
				if (pName==NULL || pName[0]==0 || wcscmp(pName,L"\\")==0)
					wcslcpy(FindData->cFileName,L"_",MAX_PATH-2);
				else
					wcslcpy(FindData->cFileName,pName,MAX_PATH-2);
				CoTaskMemFree(pName);

				pName=NULL;
				hr2=pObjectProperties->GetStringValue(WPD_OBJECT_CONTENT_TYPE,&pName);
				if (pName!=NULL && _wcsicmp(pName,L"{27E2E392-A111-48E0-AB0C-E17705A05F85}")!=0 && //folder
					_wcsicmp(pName,L"{99ED0160-17FF-4C44-9D98-1D7A6F941921}")!=0) {  // functional object
					FindData->dwFileAttributes=0;
					ULONGLONG sz=0;
					hr2=pObjectProperties->GetUnsignedLargeIntegerValue(WPD_OBJECT_SIZE,&sz);
					if (SUCCEEDED(hr2)) {
						FindData->nFileSizeHigh=(DWORD)(sz>>32);
						FindData->nFileSizeLow=(DWORD)(sz);
					}
				}
				if (pName!=NULL)
					CoTaskMemFree(pName);

				PROPVARIANT pr;
				/*if (fieldTypesChanged) {
					WCHAR buf[2048];
					buf[0]=0;
					wcslcat(buf,L"Field types:",COUNTOF(buf)-10);
					for (DWORD i=0;i<count;i++) {
						if (getvalueflag & (1LL<<i)) {
							PROPERTYKEY propkey;
							if (SUCCEEDED(pkeys->GetAt(i,&propkey))) {
								BOOL unknownField=FALSE;
								WCHAR* p=getNameFromPropertyKey(&propkey,&unknownField);
								pr.vt=VT_ERROR;
								hr2=pObjectProperties->GetValue(propkey,&pr);
								wcslcat(buf,p,COUNTOF(buf)-10);
								if (SUCCEEDED(hr2)) {
									wcslcat(buf,L"=",COUNTOF(buf)-10);
									_itow_s(pr.vt,buf+wcslen(buf),COUNTOF(buf)-wcslen(buf)-1,10);
									wcslcat(buf,L" ",COUNTOF(buf)-10);
								}
							}
						}
					}
					LogProcW(PluginNumber,MSGTYPE_DETAILS,buf);
				}
				hr2=pObjectProperties->GetValue(WPD_OBJECT_DATE_MODIFIED,&pr);
				logValue(FindData->cFileName,L"MODIFIED",hr2,&pr);
				hr2=pObjectProperties->GetValue(WPD_OBJECT_DATE_CREATED,&pr);
				logValue(FindData->cFileName,L"CREATED",hr2,&pr);
				*/
				hr2=pObjectProperties->GetValue(WPD_OBJECT_DATE_MODIFIED,&pr);
				if (!SUCCEEDED(hr2) || pr.vt==VT_ERROR || pr.date==29221)
					hr2=pObjectProperties->GetValue(WPD_OBJECT_DATE_CREATED,&pr);
				if (SUCCEEDED(hr2)) {
					SYSTEMTIME systime,systime2;
					if (pr.vt==VT_DATE) {
						VariantTimeToSystemTime(pr.date,&systime);
						if (!(systime.wYear==1980 && systime.wDay==1 && systime.wMonth==1 && systime.wMinute==0 && systime.wSecond==0) &&
							!(systime.wYear==1979 && systime.wDay==31 && systime.wMonth==12 && systime.wMinute==0 && systime.wSecond==0)) {
							if (LocalTime==2) {
								TzSpecificLocalTimeToSystemTime(NULL,&systime,&systime2);
								SystemTimeToFileTime(&systime2,&FindData->ftLastWriteTime);
							} else if (LocalTime==1) {
								FILETIME ftime;
								if (!SystemTimeToFileTime(&systime,&ftime)) {
									ftime.dwHighDateTime=0;
									ftime.dwLowDateTime=0;
								}
								LocalFileTimeToFileTime(&ftime,&FindData->ftLastWriteTime);
							} else {
								SystemTimeToFileTime(&systime,&FindData->ftLastWriteTime);
							}
						}
					} else if (pr.vt==VT_FILETIME) {
						FindData->ftLastWriteTime=pr.filetime;
					}
				}
				pObjectProperties->Release();
			}
		}
	} __except (true) {
		LogProcW(PluginNumber,MSGTYPE_DETAILS,L"Exception in PopulateFindDataW");
	}
}

HANDLE __stdcall FsFindFirst(char* Path,WIN32_FIND_DATA *FindData)
{
	SetLastError(ERROR_FILE_NOT_FOUND);
	return INVALID_HANDLE_VALUE;
}

HANDLE __stdcall FsFindFirstW(WCHAR* Path,WIN32_FIND_DATAW *FindData)
{
	pLastFindStuct lf;
	WCHAR wcSearch[wdirtypemax];
	
	memset(FindData,0,sizeof(WIN32_FIND_DATAW));
	wcslcpy(wcSearch,Path,wdirtypemax-1);           // incl. Backslash!
	wcslcatbackslash(wcSearch,wdirtypemax-1);
	
	if (Path[0]=='\\') {
		if (DeviceEventReceived || Path[1]==0) {  // reload all devices in plugin root, or when receiving insert/remove notification
			DeviceEventReceived=false;
			FreeAllDevices();
			ClearCache();
		}

		if (!InitFunctionsIfNeeded(TRUE)) {
			SetLastError(ERROR_FILE_NOT_FOUND);
			return INVALID_HANDLE_VALUE;
		}
		if (StoredNumIds==0) {
			SetLastError(ERROR_NO_MORE_FILES);
			return INVALID_HANDLE_VALUE;
		}

		if (Path[1]==0) {  // Enum just the devices 
			DWORD numids=0;
			HRESULT hr=0;
			PWSTR* pPnpDeviceIDs;
			numids=StoredNumIds;
			pPnpDeviceIDs=StoredPnpDeviceIDs;
			if (numids>0) {
				wcslcpy(FindData->cFileName,StoredPnPFriendlyNames[0],MAX_PATH-2);
				FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
				FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
				FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
				FindData->nFileSizeHigh=0;
				FindData->nFileSizeLow=0;
				lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
				memset(lf,0,sizeof(tLastFindStuct));
				wcslcpy(lf->Path,wcSearch,wdirtypemax-1);
				lf->pPnpDeviceLastRead=0;
				lf->pEnumObjectIDs=NULL;
				lf->pProperties=NULL;
				return (HANDLE)lf;
			}
		} else {
			IEnumPortableDeviceObjectIDs* pEnumObjectIDs;
			IPortableDeviceProperties* pProperties;
			HRESULT hr = GetFolderIDFromPathName(wcSearch,&pEnumObjectIDs,&pProperties,NULL,NULL);
			if (!SUCCEEDED(hr)) {
				SetLastError(ERROR_FILE_NOT_FOUND);
				return INVALID_HANDLE_VALUE;
			}
			lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
			memset(lf,0,sizeof(tLastFindStuct));
			wcslcpy(lf->Path,wcSearch,wdirtypemax-1);
			lf->szObjectIDsFetched=0;
			lf->szObjectIDLastRead=0;
			hr = pEnumObjectIDs->Next(NUM_OBJECTS_TO_REQUEST,lf->szObjectIDArray,&lf->szObjectIDsFetched);
			if (!SUCCEEDED(hr) || lf->szObjectIDsFetched==0) {
				free(lf);
				pEnumObjectIDs->Release();
				pProperties->Release();
				SetLastError(ERROR_NO_MORE_FILES);
				LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,"Directory is empty!");
				return INVALID_HANDLE_VALUE;
			}

			WCHAR buf1[wdirtypemax];
			wcslcpy(buf1,L"GET DIR ",wdirtypemax-1);
			wcslcat(buf1,Path,wdirtypemax-1);
			LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);

			lf->pEnumObjectIDs=pEnumObjectIDs;
			lf->pProperties=pProperties;

			hr = CoCreateInstance(CLSID_PortableDeviceKeyCollection,NULL,
                      CLSCTX_INPROC_SERVER,
					  IID_IPortableDeviceKeyCollection,
                      (VOID**) &lf->pPropertiesToRead);
			if (SUCCEEDED(hr)) {
				IPortableDeviceValues* pObjectProperties=NULL;
				lf->pPropertiesToRead->Add(WPD_OBJECT_NAME);
				lf->pPropertiesToRead->Add(WPD_OBJECT_ORIGINAL_FILE_NAME);
				lf->pPropertiesToRead->Add(WPD_OBJECT_SIZE);
				lf->pPropertiesToRead->Add(WPD_OBJECT_DATE_MODIFIED);
				lf->pPropertiesToRead->Add(WPD_OBJECT_DATE_CREATED);  // for devices like some cameras which don't have the modified date
				lf->pPropertiesToRead->Add(WPD_OBJECT_CONTENT_TYPE);
				//lf->pPropertiesToRead->Add(WPD_OBJECT_FORMAT);
			} else
				lf->pPropertiesToRead=NULL;

			ThisLocalTime=UseLocalTime(Path);
			PopulateFindDataW(lf->szObjectIDArray[0],lf,FindData,ThisLocalTime);
			return (HANDLE)lf;
		}
	}
	SetLastError(ERROR_PATH_NOT_FOUND);
	return INVALID_HANDLE_VALUE;
}

BOOL __stdcall FsFindNext(HANDLE Hdl,WIN32_FIND_DATA *FindData)
{
	return false;
}

BOOL __stdcall FsFindNextW(HANDLE Hdl,WIN32_FIND_DATAW *FindData)
{
	HRESULT hr;
	pLastFindStuct lf;

	if (Hdl==(HANDLE)1)
		return false;

	lf=(pLastFindStuct)Hdl;
	if (lf->pEnumObjectIDs==NULL && StoredPnpDeviceIDs) {
		if (lf->pPnpDeviceLastRead+1<StoredNumIds) {
			lf->pPnpDeviceLastRead++;
			wcslcpy(FindData->cFileName,StoredPnPFriendlyNames[lf->pPnpDeviceLastRead],MAX_PATH-2);
			FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
			FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
			FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
			FindData->nFileSizeHigh=0;
			FindData->nFileSizeLow=0;
			return true;
		}
	} else if (lf->pEnumObjectIDs) {
		if (lf->szObjectIDLastRead+1<lf->szObjectIDsFetched) {
			lf->szObjectIDLastRead++;
			hr=S_OK;
		} else {
			for (DWORD i=0;i<lf->szObjectIDsFetched;i++) {
				CoTaskMemFree(lf->szObjectIDArray[i]);
				lf->szObjectIDArray[i]=NULL;
			}
			lf->szObjectIDsFetched=0;
			lf->szObjectIDLastRead=0;
			hr = lf->pEnumObjectIDs->Next(NUM_OBJECTS_TO_REQUEST,lf->szObjectIDArray,&lf->szObjectIDsFetched);
			if (!SUCCEEDED(hr) || lf->szObjectIDsFetched==0) {
				SetLastError(ERROR_NO_MORE_FILES);
				for (DWORD i=0;i<lf->szObjectIDsFetched;i++) {
					CoTaskMemFree(lf->szObjectIDArray[i]);
					lf->szObjectIDArray[i]=NULL;
				}
				lf->szObjectIDsFetched=0;
				lf->pEnumObjectIDs->Release();
				lf->pEnumObjectIDs=NULL;
				lf->pProperties->Release();
				lf->pProperties=NULL;
				return false;
			}
		}
		PopulateFindDataW(lf->szObjectIDArray[lf->szObjectIDLastRead],lf,FindData,ThisLocalTime);
		return true;
	}
	return false;
}

int __stdcall FsFindClose(HANDLE Hdl)
{
	if (Hdl==(HANDLE)1)
		return 0;
	pLastFindStuct lf;
	lf=(pLastFindStuct)Hdl;
	if (lf->pEnumObjectIDs) {
		lf->pEnumObjectIDs->Release();
		lf->pEnumObjectIDs=NULL;
	}
	if (lf->pProperties) {
		lf->pProperties->Release();
		lf->pProperties=NULL;
	}
	for (DWORD i=0;i<lf->szObjectIDsFetched;i++) {
		if (lf->szObjectIDArray[i])
			CoTaskMemFree(lf->szObjectIDArray[i]);
		lf->szObjectIDArray[i]=NULL;
	}
	lf->szObjectIDsFetched=0;
	free(lf);
	return 0;
}

int __stdcall FsInit(int PluginNr,tProgressProc pProgressProc,tLogProc pLogProc,tRequestProc pRequestProc)
{
	PluginNumber=PluginNr;
	ProgressProc=pProgressProc;
    LogProc=pLogProc;
    RequestProc=pRequestProc;
	return 0;
}

int __stdcall FsInitW(int PluginNr,tProgressProcW pProgressProcW,tLogProcW pLogProcW,tRequestProcW pRequestProcW)
{
	PluginNumber=PluginNr;
	ProgressProcW=pProgressProcW;
    LogProcW=pLogProcW;
    RequestProcW=pRequestProcW;
	return 0;
}

void FreeAllDevices()
{
	for (DWORD i=0;i<StoredNumIds;i++) {
		CoTaskMemFree(StoredPnpDeviceIDs[i]);
		CoTaskMemFree(StoredPnPFriendlyNames[i]);
		if (StoredDevices[i])
			StoredDevices[i]->Release();
	}
	if (StoredPnpDeviceIDs)
		free(StoredPnpDeviceIDs);
	if (StoredPnPFriendlyNames)
		free(StoredPnPFriendlyNames);
	if (StoredDevices)
		free(StoredDevices);
	StoredPnpDeviceIDs=NULL;
	StoredPnPFriendlyNames=NULL;
	StoredDevices=NULL;
	StoredNumIds=0;
	if (pDevMgr)
		pDevMgr->Release();    // we must release this too, otherwise new devices are not seen!
	pDevMgr=NULL;
	connected=false;
	initialized=false;
}

HRESULT DisConnectIfNeeded()
{
	if (initialized) {
		if (connected)
			FreeAllDevices();
		UnregisterNotification();
		return S_OK;
	} else
		return E_FAIL;
}

BOOL __stdcall FsDisconnect(char* DisconnectRoot)
{
	DisConnectIfNeeded();
	char buf1[MAX_PATH];
	strlcpy(buf1,"DISCONNECT ",MAX_PATH);
	strlcat(buf1,DisconnectRoot,MAX_PATH-1);
	LogProc(PluginNumber,MSGTYPE_DISCONNECT,buf1);
	return TRUE;
}

BOOL __stdcall FsMkDir(char* Path)
{
	WCHAR PathW[wdirtypemax];
	return FsMkDirW(awfilenamecopy(PathW,Path));
}

#define ArraySize 128

// Returns 0 if not exists, 1 for files, 2 for folders
int NameExistsInEnum(IEnumPortableDeviceObjectIDs* pEnumObjectIDs,PWSTR pSearchName,IPortableDeviceProperties *pProperties,
	LPWSTR *pReturnedObjectId)
{
	int match=0;
	IPortableDeviceKeyCollection* pPropertiesToRead=NULL;
	HRESULT hr = CoCreateInstance(CLSID_PortableDeviceKeyCollection,
                      NULL,
                      CLSCTX_INPROC_SERVER,
					  IID_IPortableDeviceKeyCollection,
                      (VOID**) &pPropertiesToRead);
	if (SUCCEEDED(hr)) {
		pPropertiesToRead->Add(WPD_OBJECT_NAME);
		pPropertiesToRead->Add(WPD_OBJECT_ORIGINAL_FILE_NAME);
	} else
		return 0;

	DWORD  cFetched;
	do {
		cFetched = 0;
		PWSTR  szObjectIDArray[ArraySize] = {0};
		hr = pEnumObjectIDs->Next(ArraySize,szObjectIDArray,&cFetched);
		if (SUCCEEDED(hr)) {
			for (DWORD i=0;i<cFetched;i++) {
				IPortableDeviceValues* pObjectProperties=NULL;
				HRESULT hr2=pProperties->GetValues(szObjectIDArray[i],
						pPropertiesToRead,   // The properties we want to read
						&pObjectProperties); // Driver supplied property values for the specified object
				if (SUCCEEDED(hr2)) {
					PWSTR pName=NULL;
					pObjectProperties->GetStringValue(WPD_OBJECT_ORIGINAL_FILE_NAME,&pName);
					if (pName==NULL || pName[0]==0)
						pObjectProperties->GetStringValue(WPD_OBJECT_NAME,&pName);
					if (wcscmp(pName,pSearchName)==0)
						match=1;
					pObjectProperties->Release();
					if (match) {
						// check whether it's a folder!
						pPropertiesToRead->Add(WPD_OBJECT_CONTENT_TYPE);
						hr2=pProperties->GetValues(szObjectIDArray[i],
							pPropertiesToRead,   // The properties we want to read
							&pObjectProperties); // Driver supplied property values for the specified object
						CoTaskMemFree(pName);
						pName=NULL;
						hr2=pObjectProperties->GetStringValue(WPD_OBJECT_CONTENT_TYPE,&pName);
						if (pName!=NULL && _wcsicmp(pName,L"{27E2E392-A111-48E0-AB0C-E17705A05F85}")==0)
							match=2;
						if (pName!=NULL)
							CoTaskMemFree(pName);
						if (pReturnedObjectId) {
							*pReturnedObjectId=szObjectIDArray[i];
							szObjectIDArray[i]=NULL;  // do not delete it!
						}
						break;
					} else
						CoTaskMemFree(pName);
				}
			}
			for (DWORD i=0;i<cFetched;i++)
				if (szObjectIDArray[i])
					CoTaskMemFree(szObjectIDArray[i]);
			if (match)
				break;
		} else
			break;
	} while (cFetched==ArraySize);
	pPropertiesToRead->Release();
	return match;
}

BOOL __stdcall FsMkDirW(WCHAR* Path)
{
	if (Path[0]!='\\')
		return false;
	BOOL result=false;

	InitFunctionsIfNeeded(TRUE);

	WCHAR wcSearch[wdirtypemax],*p;
	wcslcpy(wcSearch,Path,wdirtypemax-1);
	p=wcsrchr(wcSearch,'\\');
	if (p) {
		p[0]=0;
		p++;
		IEnumPortableDeviceObjectIDs* pEnumObjectIDs=NULL;
		IPortableDeviceProperties* pProperties=NULL;
		IPortableDeviceContent* pDeviceContent=NULL;
		LPWSTR pStorageID=NULL;
		HRESULT hr = GetFolderIDFromPathName(wcSearch,&pEnumObjectIDs,&pProperties,&pDeviceContent,&pStorageID);
		if (SUCCEEDED(hr)) {
			// Make sure that there isn't already a file with that name!
			int i=NameExistsInEnum(pEnumObjectIDs,p,pProperties,NULL);
			if (i!=0) {
				if (i==2)  // a folder?
					result=true;
				else
					result=false;
			} else {
				IPortableDeviceValues* pValues;
				hr = CoCreateInstance(CLSID_PortableDeviceValues,NULL,
					CLSCTX_INPROC_SERVER,IID_IPortableDeviceValues,(VOID**) &pValues);
				if (SUCCEEDED(hr)) {
					pValues->SetGuidValue(WPD_OBJECT_CONTENT_TYPE,WPD_CONTENT_TYPE_FOLDER);
					pValues->SetStringValue(WPD_OBJECT_PARENT_ID,pStorageID);
					pValues->SetStringValue(WPD_OBJECT_ORIGINAL_FILE_NAME,p);
					pValues->SetStringValue(WPD_OBJECT_NAME,p);

					LPWSTR NewObject=NULL;
					hr = pDeviceContent->CreateObjectWithPropertiesOnly( pValues,&NewObject);
					if SUCCEEDED(hr)
					{
						result=true;
						WCHAR buf1[wdirtypemax];
						wcslcpy(buf1,L"MKDIR ",wdirtypemax-1);
						wcslcat(buf1,Path,wdirtypemax-1);
						LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
					}
					if (NewObject)
						CoTaskMemFree(NewObject);
					pValues->Release();
				}
			}
			if (pStorageID)
				CoTaskMemFree(pStorageID);
			if (pDeviceContent)
				pDeviceContent->Release();
			if (pEnumObjectIDs)
				pEnumObjectIDs->Release();
			if (pProperties)
				pProperties->Release();
		}
	}
	return result;
}

BOOL __stdcall FsDeleteFile(char* RemoteName)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsDeleteFileW(awfilenamecopy(RemoteNameW,RemoteName));
}

BOOL __stdcall FsDeleteFileW(WCHAR* RemoteName)
{
	if (RemoteName[0]!='\\')
		return false;

	InitFunctionsIfNeeded(TRUE);

	WCHAR wcSearch[wdirtypemax];
	wcslcpy(wcSearch,RemoteName,wdirtypemax-1);
	int l=(int)wcslen(wcSearch)-1;
	if (wcSearch[l]=='\\')
		wcSearch[l]=0;
	BOOL result=false;
	LPWSTR p=wcsrchr(wcSearch,'\\');
	if (p) {
		p[0]=0;
		p++;
		IEnumPortableDeviceObjectIDs* pEnumObjectIDs=NULL;
		IPortableDeviceProperties* pProperties=NULL;
		IPortableDeviceContent* pDeviceContent=NULL;
		LPWSTR pStorageID=NULL;
		LPWSTR pItemStorageID=NULL;
		HRESULT hr = GetFolderIDFromPathName(wcSearch,&pEnumObjectIDs,&pProperties,&pDeviceContent,&pStorageID);
		if (SUCCEEDED(hr)) {
			// Find the file/folder with this name!
			int i=NameExistsInEnum(pEnumObjectIDs,p,pProperties,&pItemStorageID);
			if (i!=0 && pItemStorageID) {
				IPortableDevicePropVariantCollection* pCollection;
				hr = CoCreateInstance(CLSID_PortableDevicePropVariantCollection,NULL,
					CLSCTX_INPROC_SERVER,IID_IPortableDevicePropVariantCollection,(VOID**) &pCollection);
				if (SUCCEEDED(hr)) {
					PROPVARIANT pv = {0};
					PropVariantInit(&pv);
					pv.vt      = VT_LPWSTR;
					int len=(int)wcslen(pItemStorageID)+1;
					pv.pwszVal=(LPWSTR)CoTaskMemRealloc(NULL,len*sizeof(WCHAR));
					wcscpy_s((LPWSTR)pv.pwszVal,len,pItemStorageID);
					pCollection->Add(&pv);
					hr = pDeviceContent->Delete(PORTABLE_DEVICE_DELETE_NO_RECURSION,pCollection,NULL);
					if (SUCCEEDED(hr)) {
						if (hr!=S_FALSE) {
							RemoveFullPathFromCache(RemoteName);
							result=true;
						}
					}
					PropVariantClear(&pv);
					pCollection->Release();
				}
			}
		}
		if (pItemStorageID)
			CoTaskMemFree(pItemStorageID);
		if (pStorageID)
			CoTaskMemFree(pStorageID);
		if (pDeviceContent)
			pDeviceContent->Release();
		if (pEnumObjectIDs)
			pEnumObjectIDs->Release();
		if (pProperties)
			pProperties->Release();
	}
	return result;
}

BOOL __stdcall FsRemoveDir(char* RemoteName)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsRemoveDirW(awfilenamecopy(RemoteNameW,RemoteName));
}

BOOL __stdcall FsRemoveDirW(WCHAR* RemoteName)
{
	if (RemoteName[0]!='\\')
		return false;
	return FsDeleteFileW(RemoteName);
}

int __stdcall FsRenMovFile(char* OldName,char* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	WCHAR NewNameW[wdirtypemax],OldNameW[wdirtypemax];
	return FsRenMovFileW(awfilenamecopy(OldNameW,OldName),awfilenamecopy(NewNameW,NewName),Move,OverWrite,ri);
}

int __stdcall FsRenMovFileW(WCHAR* OldName,WCHAR* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	if (OldName[0]!='\\'  || NewName[0]!='\\')
		return FS_FILE_NOTFOUND;

	int err=ProgressProcT(PluginNumber,OldName,NewName,0);
	if (err)
		return FS_FILE_USERABORT;

	if (!InitFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	WCHAR buf1[wdirtypemax];
	if (Move) 
		wcscpy_s(buf1,6,L"MOVE ");
	else
		wcscpy_s(buf1,6,L"COPY ");

	WCHAR WOldName[wdirtypemax],*p,*p2;
	WCHAR WNewName[wdirtypemax];
	wcslcpy(WOldName,OldName,wdirtypemax-1);
	wcslcpy(WNewName,NewName,wdirtypemax-1);
	p=wcsrchr(WOldName,'\\');
	p2=wcsrchr(WNewName,'\\');
	int result=FS_FILE_NOTFOUND;
	if (p && p2) {
		IEnumPortableDeviceObjectIDs* pEnumObjectIDs=NULL;
		IEnumPortableDeviceObjectIDs* pEnumObjectIDs2=NULL;
		IPortableDeviceProperties* pProperties=NULL;
		IPortableDeviceProperties* pProperties2=NULL;
		IPortableDeviceContent* pDeviceContent=NULL;
		IPortableDeviceContent* pDeviceContent2=NULL;
		LPWSTR pStorageID=NULL;
		LPWSTR pStorageID2=NULL;
		LPWSTR pItemStorageID=NULL;

		p[0]=0;
		p++;
		p2[0]=0;
		p2++;
		// the interface supports rename in place, and copy/move WITHOUT renaming. Determine which to do first!
		BOOL samedir=wcscmp(WOldName,WNewName)==0;
		BOOL samename=wcscmp(p,p2)==0;
		if (samedir && samename)
			result=FS_FILE_OK;
		else if (!samedir && !samename)
			result=FS_FILE_NOTSUPPORTED;
		else if (!samename) {    // rename in same dir!
			result=FS_FILE_NOTSUPPORTED;
			HRESULT hr = GetFolderIDFromPathName(WOldName,&pEnumObjectIDs,&pProperties,&pDeviceContent,&pStorageID);
			if (SUCCEEDED(hr)) {
				int i=NameExistsInEnum(pEnumObjectIDs,p,pProperties,&pItemStorageID);
				int i2=NameExistsInEnum(pEnumObjectIDs,p,pProperties,NULL);
				if (i2) {
					if (i2==2)
						result=FS_FILE_WRITEERROR;  // cannot overwrite folder with file!
					else if (OverWrite) {
						if (!FsDeleteFileW(NewName)) {
							result=FS_FILE_WRITEERROR;
							i=0;
						}
					} else {
						i=0;
						result=FS_FILE_EXISTS;
					}
				}
				if (i!=0 && pItemStorageID) {
					IPortableDeviceValues* pObjectProperties=NULL;
					IPortableDeviceValues* pResultProperties=NULL;
					hr = CoCreateInstance(CLSID_PortableDeviceValues,
                              NULL,
                              CLSCTX_INPROC_SERVER,
							  IID_IPortableDeviceValues,
                              (VOID**)&pObjectProperties);
					if (SUCCEEDED(hr)) {
						hr = pObjectProperties->SetStringValue(WPD_OBJECT_ORIGINAL_FILE_NAME, p2);
						hr = pObjectProperties->SetStringValue(WPD_OBJECT_NAME, p2);
					}
					if (SUCCEEDED(hr)) {
						hr=pProperties->SetValues(pItemStorageID,pObjectProperties,&pResultProperties);
						if (FAILED(hr)) {
							hr = pObjectProperties->Clear();
							if (SUCCEEDED(hr))
								hr = pObjectProperties->SetStringValue(WPD_OBJECT_NAME, p2);
							if (SUCCEEDED(hr))
								hr=pProperties->SetValues(pItemStorageID,pObjectProperties,NULL);
						}
					}
					if (SUCCEEDED(hr)) {
						if (hr!=S_FALSE) {
							RemoveFullPathFromCache(OldName);
							RemoveFullPathFromCache(NewName);
							result=FS_FILE_OK;
						}
					} else if (hr=0x80070490)
						result=FS_FILE_NOTSUPPORTED;
					if (pObjectProperties)
						pObjectProperties->Release();
					if (pResultProperties)
						pResultProperties->Release();
				}
			}
		} else {  // !samedir
			HRESULT hr = GetFolderIDFromPathName(WOldName,&pEnumObjectIDs,&pProperties,&pDeviceContent,&pStorageID);
			if (SUCCEEDED(hr)) {
				hr = GetFolderIDFromPathName(WNewName,&pEnumObjectIDs2,&pProperties2,&pDeviceContent2,&pStorageID2);
				if (FAILED(hr))
					result=FS_FILE_WRITEERROR;
			} else
				result=FS_FILE_READERROR;
			if (SUCCEEDED(hr)) {
				// Find the file/folder with this name!
				int i=NameExistsInEnum(pEnumObjectIDs,p,pProperties,&pItemStorageID);
				int i2=NameExistsInEnum(pEnumObjectIDs2,p,pProperties2,NULL);
				if (i2) {
					if (i2==2)
						result=FS_FILE_WRITEERROR;  // cannot overwrite folder with file!
					else if (OverWrite) {
						if (!FsDeleteFileW(NewName)) {
							result=FS_FILE_WRITEERROR;
							i=0;
						}
					} else {
						i=0;
						result=FS_FILE_EXISTS;
					}
				}
				if (i!=0 && pItemStorageID) {
					IPortableDevicePropVariantCollection* pCollection=NULL;
					hr = CoCreateInstance(CLSID_PortableDevicePropVariantCollection,NULL,
						CLSCTX_INPROC_SERVER,IID_IPortableDevicePropVariantCollection,(VOID**) &pCollection);
					if (SUCCEEDED(hr)) {
						PROPVARIANT pv = {0};
						PropVariantInit(&pv);
						pv.vt      = VT_LPWSTR;
						pv.pwszVal=wstrnew(pItemStorageID);
						pCollection->Add(&pv);
						result=FS_FILE_WRITEERROR;
						if (Move)
							hr = pDeviceContent->Move(pCollection,pStorageID2,NULL);
						else
							hr = pDeviceContent->Copy(pCollection,pStorageID2,NULL);
						if (SUCCEEDED(hr)) {
							if (hr!=S_FALSE) {
								RemoveFullPathFromCache(OldName);
								RemoveFullPathFromCache(NewName);
								result=FS_FILE_OK;
							}
						} else if (hr=0x80070490)
							result=FS_FILE_NOTSUPPORTED;
						PropVariantClear(&pv);
					}
					if (pCollection)
						pCollection->Release();
				}
			}
		}
		if (pItemStorageID)
			CoTaskMemFree(pItemStorageID);
		if (pStorageID)
			CoTaskMemFree(pStorageID);
		if (pStorageID2)
			CoTaskMemFree(pStorageID2);
		if (pDeviceContent)
			pDeviceContent->Release();
		if (pDeviceContent2)
			pDeviceContent2->Release();
		if (pEnumObjectIDs)
			pEnumObjectIDs->Release();
		if (pEnumObjectIDs2)
			pEnumObjectIDs2->Release();
		if (pProperties)
			pProperties->Release();
		if (pProperties2)
			pProperties2->Release();
	}
	if (result==FS_FILE_OK) {
		result=ProgressProcT(PluginNumber,OldName,NewName,100);
		if (result)
			return FS_FILE_USERABORT;
	}
	if (result==FS_FILE_OK) {
		wcslcat(buf1,OldName,wdirtypemax-1);
		wcslcat(buf1,L"->",wdirtypemax-1);
		wcslcat(buf1,NewName,wdirtypemax-1);
		LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
	}
	return result;
}

int __stdcall FsGetFile(char* RemoteName,char* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
	WCHAR RemoteNameW[wdirtypemax],LocalNameW[wdirtypemax],OldLocalNameW[wdirtypemax];
	int ret=FsGetFileW(awfilenamecopy(RemoteNameW,RemoteName),awfilenamecopy(LocalNameW,LocalName),CopyFlags,ri);
	// A conversion may cause a name change
	if (ret==0 && wcscmp(LocalNameW,OldLocalNameW)!=0) {
		wafilenamecopy(LocalName,LocalNameW);
	}
	return ret;
}

int __stdcall FsGetFileW(WCHAR* RemoteName,WCHAR* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
    int err;
	BOOL OverWrite,Resume,Move;

	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;
	
	if (RemoteName[0]!='\\')
		return FS_FILE_NOTFOUND;
	if (Resume)
		return FS_FILE_NOTSUPPORTED;

	if (!OverWrite) {
		WIN32_FIND_DATAW fd;
		HANDLE hd;
		hd=FindFirstFileT(LocalName,&fd);
		if (hd!=INVALID_HANDLE_VALUE) {
			FindClose(hd);
			return FS_FILE_EXISTS;
		}
	}

	err=ProgressProcT(PluginNumber,RemoteName,LocalName,0);
	if (err)
		return FS_FILE_USERABORT;

	if (!InitFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	WCHAR WLocalName[wdirtypemax];
	WCHAR WRemoteName[wdirtypemax];
	wcslcpy(WLocalName,LocalName,wdirtypemax-1);
	wcslcpy(WRemoteName,RemoteName,wdirtypemax-1);
	LPWSTR pItemStorageID=NULL;
	IPortableDeviceContent* pDeviceContent=NULL;
	HRESULT hr = GetFolderIDFromPathName(WRemoteName,NULL,NULL,&pDeviceContent,&pItemStorageID);
	ULONGLONG totalsize=0;
	ULONGLONG totalcopied=0;
	if (ri) {
		totalsize=ri->SizeHigh;
		totalsize=(totalsize<<32) + ri->SizeLow;
	}
	int result=FS_FILE_READERROR;
	if (SUCCEEDED(hr)) {
		IPortableDeviceResources *pResources=NULL;
		IStream *pStream=NULL;
		hr=pDeviceContent->Transfer(&pResources);
		DWORD OptimalBufferSize=32768;
		if (SUCCEEDED(hr))
			hr= pResources->GetStream(pItemStorageID,
				WPD_RESOURCE_DEFAULT,
				STGM_READ,
				&OptimalBufferSize,
				&pStream);
		if SUCCEEDED(hr) {
			//loop
			char* buf=(char*)malloc(OptimalBufferSize);
			if (buf) {
				DWORD BytesRead,BytesWritten;
				HANDLE f=CreateFileT(LocalName,GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,0,NULL);
				if (f!=INVALID_HANDLE_VALUE) {
					if (OptimalBufferSize<1024)
						OptimalBufferSize=1024;
					DWORD lasttime=GetTickCount();
					DWORD thistime;
					while (1) {
						hr=pStream->Read(buf,OptimalBufferSize,&BytesRead);
						if (SUCCEEDED(hr) && BytesRead>0) {
							if (!WriteFile(f,buf,BytesRead,&BytesWritten,NULL)) {
								result=FS_FILE_WRITEERROR;
								break;
							}
							totalcopied+=BytesWritten;
							thistime=GetTickCount();
							if (totalsize && abs((int)thistime-(int)lasttime)>100) {
								int percent=(int)((totalcopied*100)/totalsize);
								lasttime=thistime;
								err=ProgressProcT(PluginNumber,NULL,NULL,percent);
								if (err) {
									result=FS_FILE_USERABORT;
									break;
								}
							}
						} else {
							if (BytesRead==0)
								result=FS_FILE_OK;
							break;
						}
					}
					if (ri && result==FS_FILE_OK)  
						if (!(ri->LastWriteTime.dwHighDateTime==0xFFFFFFFF && ri->LastWriteTime.dwLowDateTime==0xFFFFFFFF) &&
							!(ri->LastWriteTime.dwHighDateTime==0xFFFFFFFF && ri->LastWriteTime.dwLowDateTime==0xFFFFFFFE) &&
							!(ri->LastWriteTime.dwHighDateTime>=27846442 && ri->LastWriteTime.dwHighDateTime<=27846660) && //1.1.1980, different time zones
							!(ri->LastWriteTime.dwHighDateTime==0 && ri->LastWriteTime.dwLowDateTime==0))  // only if valid!
								SetFileTime(f,NULL,NULL,&ri->LastWriteTime);
					CloseHandle(f);
				} else
					result=FS_FILE_WRITEERROR;
				free(buf);
			}
		}
		if (pStream)
			pStream->Release();
		if (pResources)
			pResources->Release();
	}
	return result;
}

int __stdcall FsPutFile(char* LocalName,char* RemoteName,int CopyFlags)
{
	WCHAR RemoteNameW[wdirtypemax],LocalNameW[wdirtypemax],OldRemoteNameW[wdirtypemax];
	int ret=FsPutFileW(awfilenamecopy(LocalNameW,LocalName),awfilenamecopy(RemoteNameW,RemoteName),CopyFlags);
	// A conversion may cause a name change
	if (ret==0 && wcscmp(RemoteNameW,OldRemoteNameW)!=0) {
		wafilenamecopy(RemoteName,RemoteNameW);
	}
	return ret;
}

typedef struct _ExtensionMap
{
    LPCWSTR wszExtension;
    const GUID* formatCode;
	const GUID* contentCode;
} ExtensionMap;

static const ExtensionMap rgExtensionMap[] =
{
    { L"aiff",  &WPD_OBJECT_FORMAT_AIFF, &WPD_CONTENT_TYPE_AUDIO },
    { L"wav",   &WPD_OBJECT_FORMAT_WAVE, &WPD_CONTENT_TYPE_AUDIO  },
    { L"mp2",   &WPD_OBJECT_FORMAT_MP2, &WPD_CONTENT_TYPE_AUDIO  },
    { L"mp3",   &WPD_OBJECT_FORMAT_MP3, &WPD_CONTENT_TYPE_AUDIO  },
	{ L"wma",   &WPD_OBJECT_FORMAT_WMA, &WPD_CONTENT_TYPE_AUDIO },
	{ L"au",   &WPD_OBJECT_FORMAT_AUDIBLE, &WPD_CONTENT_TYPE_AUDIO  },
	{ L"aac",   &WPD_OBJECT_FORMAT_AAC, &WPD_CONTENT_TYPE_AUDIO  },
    { L"m4a",   &WPD_OBJECT_FORMAT_AAC, &WPD_CONTENT_TYPE_AUDIO },
	{ L"ogg",   &WPD_OBJECT_FORMAT_OGG, &WPD_CONTENT_TYPE_AUDIO},
	{ L"flac",   &WPD_OBJECT_FORMAT_FLAC, &WPD_CONTENT_TYPE_AUDIO},
	{ L"mp4",   &WPD_OBJECT_FORMAT_MP4, &WPD_CONTENT_TYPE_VIDEO },
    { L"avi",   &WPD_OBJECT_FORMAT_AVI, &WPD_CONTENT_TYPE_VIDEO },
    { L"mpeg",  &WPD_OBJECT_FORMAT_MPEG, &WPD_CONTENT_TYPE_VIDEO },
    { L"mpg",   &WPD_OBJECT_FORMAT_MPEG, &WPD_CONTENT_TYPE_VIDEO },
	{ L"3gp",   &WPD_OBJECT_FORMAT_3GP, &WPD_CONTENT_TYPE_VIDEO },
    { L"asf",   &WPD_OBJECT_FORMAT_ASF, &WPD_CONTENT_TYPE_VIDEO },
    { L"wmv",   &WPD_OBJECT_FORMAT_WMV, &WPD_CONTENT_TYPE_VIDEO },  
    { L"dvr-ms",&WPD_OBJECT_FORMAT_ASF, &WPD_CONTENT_TYPE_VIDEO },
    { L"jpg",   &WPD_OBJECT_FORMAT_JFIF, &WPD_CONTENT_TYPE_IMAGE },
    { L"jpe",   &WPD_OBJECT_FORMAT_JFIF, &WPD_CONTENT_TYPE_IMAGE },
    { L"jpeg",  &WPD_OBJECT_FORMAT_JFIF, &WPD_CONTENT_TYPE_IMAGE },
    { L"pcd",   &WPD_OBJECT_FORMAT_PCD, &WPD_CONTENT_TYPE_IMAGE },
    { L"bmp",  &WPD_OBJECT_FORMAT_BMP, &WPD_CONTENT_TYPE_IMAGE },
	{ L"pict",  &WPD_OBJECT_FORMAT_PICT, &WPD_CONTENT_TYPE_IMAGE },
	{ L"gif",  	&WPD_OBJECT_FORMAT_GIF, &WPD_CONTENT_TYPE_IMAGE },
	{ L"png",  	&WPD_OBJECT_FORMAT_PNG, &WPD_CONTENT_TYPE_IMAGE },
    { L"tif",  	&WPD_OBJECT_FORMAT_TIFF, &WPD_CONTENT_TYPE_IMAGE },
	{ L"tiff",  	&WPD_OBJECT_FORMAT_TIFF, &WPD_CONTENT_TYPE_IMAGE },
	{ L"mpl",   &WPD_OBJECT_FORMAT_MPLPLAYLIST, &WPD_CONTENT_TYPE_PLAYLIST},
	{ L"asx",   &WPD_OBJECT_FORMAT_ASXPLAYLIST, &WPD_CONTENT_TYPE_PLAYLIST},
	{ L"pls",   &WPD_OBJECT_FORMAT_PLSPLAYLIST, &WPD_CONTENT_TYPE_PLAYLIST},
	{ L"m3u",   &WPD_OBJECT_FORMAT_M3UPLAYLIST, &WPD_CONTENT_TYPE_PLAYLIST},
	{ L"doc",   &WPD_OBJECT_FORMAT_MICROSOFT_WORD, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"docx",   &WPD_OBJECT_FORMAT_MICROSOFT_WORD, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"xls",   &WPD_OBJECT_FORMAT_MICROSOFT_EXCEL, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"xlm",   &WPD_OBJECT_FORMAT_MICROSOFT_EXCEL, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"xlsx",   &WPD_OBJECT_FORMAT_MICROSOFT_EXCEL, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"ppt",   &WPD_OBJECT_FORMAT_MICROSOFT_POWERPOINT, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"pptx",   &WPD_OBJECT_FORMAT_MICROSOFT_POWERPOINT, &WPD_CONTENT_TYPE_DOCUMENT},
	{ L"txt",   &WPD_OBJECT_FORMAT_UNSPECIFIED,&WPD_CONTENT_TYPE_DOCUMENT},
	{ L"rtf",   &WPD_OBJECT_FORMAT_UNSPECIFIED,&WPD_CONTENT_TYPE_DOCUMENT}
};

void GetFormatCodeFromFile(WCHAR* pszFile,const GUID** pFormat,const GUID** pContent)
{
    CONST GUID* dwFormatCode = &WPD_OBJECT_FORMAT_UNSPECIFIED;
	CONST GUID* dwContentCode = &WPD_CONTENT_TYPE_GENERIC_FILE;
	WCHAR* p=wcsrchr(pszFile,'\\');
	if (!p)
		p=pszFile;
    WCHAR* pszExtension = wcsrchr(p,'.');
    if (pszExtension)
    {
        if (L'.' == pszExtension[0])
        {
            pszExtension++;
        }
        for (int i = 0; i < ARRAYSIZE(rgExtensionMap); i++)
        {
            //the length of comparison is bounded by strings represented by rgExtensionMap[i].wszExtension             
            if (0 == _wcsicmp(pszExtension, rgExtensionMap[i].wszExtension))
            {
                dwFormatCode = rgExtensionMap[i].formatCode;
				dwContentCode = rgExtensionMap[i].contentCode;
                break;
            }
        }
    }
    *pFormat=dwFormatCode;
	*pContent=dwContentCode;
}

int __stdcall FsPutFileW(WCHAR* LocalName,WCHAR* RemoteName,int CopyFlags)
{
	WCHAR* unknown=L"unknown";
	int err;
	BOOL OverWrite,Resume,Move;
	int retval=FS_FILE_WRITEERROR;

	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;
	
	if (RemoteName[0]!='\\')
		return FS_FILE_NOTFOUND;

	err=ProgressProcT(PluginNumber,LocalName,RemoteName,0);
	if (err)
		return FS_FILE_USERABORT;
	
	if (!InitFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	WCHAR WLocalName[wdirtypemax],*p;
	WCHAR WRemoteName[wdirtypemax];
	wcslcpy(WLocalName,LocalName,wdirtypemax);
	wcslcpy(WRemoteName,RemoteName,wdirtypemax);
	p=wcsrchr(WRemoteName,'\\');
	int result=FS_FILE_READERROR;
	ULONGLONG totalsize=0;
	ULONGLONG totalcopied=0;
	if (p) {
		p[0]=0;
		p++;
		IEnumPortableDeviceObjectIDs* pEnumObjectIDs=NULL;
		IPortableDeviceProperties* pProperties=NULL;
		IPortableDeviceContent* pDeviceContent=NULL;
		LPWSTR pStorageID=NULL;
		LPWSTR pItemStorageID=NULL;
		HRESULT hr = GetFolderIDFromPathName(WRemoteName,&pEnumObjectIDs,&pProperties,&pDeviceContent,&pStorageID);
		if (SUCCEEDED(hr)) {
			// Make sure that there isn't already a file with that name!
			int i=NameExistsInEnum(pEnumObjectIDs,p,pProperties,&pItemStorageID);
			if (i==2)  // a folder?
				result=FS_FILE_WRITEERROR;
			else if (i==1 && !OverWrite)
					result=FS_FILE_EXISTS;
			else {
				if (i==1) {    // file exists -> delete it!
					IPortableDevicePropVariantCollection* pCollection;
					hr = CoCreateInstance(CLSID_PortableDevicePropVariantCollection,NULL,
						CLSCTX_INPROC_SERVER,IID_IPortableDevicePropVariantCollection,(VOID**) &pCollection);
					if (SUCCEEDED(hr)) {
						PROPVARIANT pv = {0};
						PropVariantInit(&pv);
						pv.vt      = VT_LPWSTR;
						pv.pwszVal=wstrnew(pItemStorageID);
						pCollection->Add(&pv);
						hr = pDeviceContent->Delete(PORTABLE_DEVICE_DELETE_NO_RECURSION,pCollection,NULL);
						pCollection->Release();
						if (hr == S_FALSE)
							hr=E_FAIL;
					}
				} else
					hr=S_OK;
				if (SUCCEEDED(hr)) {
					IPortableDeviceValues* pValues;
					hr = CoCreateInstance(CLSID_PortableDeviceValues,NULL,
						CLSCTX_INPROC_SERVER,IID_IPortableDeviceValues,(VOID**) &pValues);
					if (SUCCEEDED(hr)) {
						HANDLE f=CreateFileT(LocalName,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
						if (f!=INVALID_HANDLE_VALUE) {
							DWORD SizeHigh;
							totalsize=GetFileSize(f,&SizeHigh);
							totalsize=totalsize | (((ULONGLONG)SizeHigh)<<32);
							IStream* pStream=NULL;
							CONST GUID* pFormat=NULL;
							CONST GUID* pContent=NULL;
							WM_PICTURE* pPreviewImage=NULL;
							GetFormatCodeFromFile(RemoteName,&pFormat,&pContent);
							if (pFormat)
								pValues->SetGuidValue(WPD_OBJECT_FORMAT,*pFormat);
							if (pContent)
								pValues->SetGuidValue(WPD_OBJECT_CONTENT_TYPE,*pContent);
							pValues->SetStringValue(WPD_OBJECT_PARENT_ID,pStorageID);
							pValues->SetStringValue(WPD_OBJECT_ORIGINAL_FILE_NAME,p);
							// pValues->SetStringValue(WPD_OBJECT_NAME,p);   // set it to title instead for music!
							// set size
							PROPVARIANT pv1 = {0};
							PropVariantInit(&pv1);
							pv1.vt = VT_UI8;
							pv1.uhVal.QuadPart=totalsize;
							pValues->SetValue(WPD_OBJECT_SIZE,&pv1);
							
							// set date
							FILETIME filetime;
							SYSTEMTIME systime;
							PROPVARIANT pv = {0};
							PropVariantInit(&pv);
							pv.vt = VT_DATE;
							GetFileTime(f,NULL,NULL,&filetime);
							int LocalTime=UseLocalTime(RemoteName);
							if (LocalTime==2) {
								SYSTEMTIME systime1;
								FileTimeToSystemTime(&filetime,&systime1);
								TzSpecificLocalTimeToSystemTime(NULL,&systime1,&systime);
							} else if (LocalTime==1) {
								FILETIME ftime;
								FileTimeToLocalFileTime(&filetime,&ftime);
								FileTimeToSystemTime(&ftime,&systime);
							} else {
								FileTimeToSystemTime(&filetime,&systime);
							}

							SystemTimeToVariantTime(&systime,&pv.date);
							pValues->SetValue(WPD_OBJECT_DATE_MODIFIED,&pv);
							if (!OverWrite)
								pValues->SetValue(WPD_OBJECT_DATE_CREATED,&pv);
							pValues->SetValue(WPD_MEDIA_LAST_ACCESSED_TIME,&pv);
							pValues->SetValue(WPD_OBJECT_DATE_AUTHORED,&pv);
							
							hr = GetMetaDataFromWMFSDK(WLocalName, pValues,pContent,&pPreviewImage);
							if (!SUCCEEDED(hr)) {
								pValues->SetStringValue(WPD_OBJECT_NAME,p);
								if (pFormat!=&WPD_OBJECT_FORMAT_UNSPECIFIED) {
									WCHAR *p1,*p2,*p3;
									WCHAR *pTitle=NULL;
									WCHAR *pAuthor=NULL;
									p1=wcsrchr(p,'\\');
									if (p1) p1++; else p1=p;
									p3=wcsrchr(p1,'.');   // remove extension
									if (p3)
										p3[0]=0;
									p2=wcsstr(p,L" - ");
									if (p2) {
										p2[0]=0;
										pTitle=wstrnew(p2+3);
										pAuthor=wstrnew(p1);
										p2[0]=' ';
									} else {   // just the title
										pTitle=wstrnew(p1);
										pAuthor=wstrnew(L"unknown");
									}
									pValues->SetStringValue(WPD_MEDIA_TITLE,pTitle);
									pValues->SetStringValue(WPD_MEDIA_ARTIST,pAuthor);
									CoTaskMemFree(pTitle);
									CoTaskMemFree(pAuthor);
									// use current date as album title!
									WCHAR buf[16];
									SYSTEMTIME systime;
									GetLocalTime(&systime);
									swprintf(buf,15,L"%04u%02u%02u",systime.wYear,systime.wMonth,systime.wDay);
									pValues->SetStringValue(WPD_MUSIC_ALBUM,buf);
									if (p3)
										p3[0]='.';  // restore extension
								}
							}

							// Now copy the actual data
							DWORD OptimalBufferSize=32768;
							hr = pDeviceContent->CreateObjectWithPropertiesAndData(pValues,&pStream,&OptimalBufferSize,NULL);
							if SUCCEEDED(hr) {
								RemoveFullPathFromCache(RemoteName);
								if (OptimalBufferSize<1024)
									OptimalBufferSize=1024;
								char* buf=(char*)malloc(OptimalBufferSize);
								if (buf) {
									DWORD BytesRead,BytesWritten;
									DWORD lasttime=GetTickCount();
									DWORD thistime;
									while (1) {
										if (ReadFile(f,buf,OptimalBufferSize,&BytesRead,NULL) && BytesRead>0) {
											hr=pStream->Write(buf,BytesRead,&BytesWritten);
											if (!SUCCEEDED(hr) || BytesWritten==0) {
												result=FS_FILE_WRITEERROR;
												break;
											}
											totalcopied+=BytesWritten;
											thistime=GetTickCount();
											if (totalsize && abs((int)thistime-(int)lasttime)>100) {
												int percent=(int)((totalcopied*100)/totalsize);
												lasttime=thistime;
												err=ProgressProcT(PluginNumber,NULL,NULL,percent);
												if (err) {
													result=FS_FILE_USERABORT;
													break;
												}
											}
										} else {
											if (BytesRead==0)
												result=FS_FILE_OK;
											break;
										}
									}
									free(buf);
								}
								pStream->Commit(STGC_DEFAULT);
								IPortableDeviceDataStream* pResultingStream=NULL;
								IPortableDeviceValues* spResInfo=NULL;
								LPWSTR NewId=NULL;
								DWORD cnt=0;
								UINT PreviewImageWidth=0;
								UINT PreviewImageHeight=0;
								IPortableDeviceKeyCollection* pKeys=NULL;
								IPortableDeviceResources* pResources=NULL;
								if (!pPreviewImage || !GdiPlusInitialize())
									pStream->Release();
								else {
									HRESULT hr2=S_OK;
									CONST GUID* imgtype=NULL;
									if (_wcsicmp(pPreviewImage->pwszMIMEType,L"image/jpeg")==0) {
										imgtype=&WPD_OBJECT_FORMAT_JFIF;										
									} else if (_wcsicmp(pPreviewImage->pwszMIMEType,L"image/png")==0) {
										imgtype=&WPD_OBJECT_FORMAT_PNG;
									} else if (_wcsicmp(pPreviewImage->pwszMIMEType,L"image/gif")==0) {
										imgtype=&WPD_OBJECT_FORMAT_GIF;
									} else if (_wcsicmp(pPreviewImage->pwszMIMEType,L"image/bmp")==0) {
										imgtype=&WPD_OBJECT_FORMAT_BMP;
									} else
										hr2=E_FAIL;

									int err=0;
									if (SUCCEEDED(hr2))
										HRESULT hr2=pStream->QueryInterface(IID_IPortableDeviceDataStream,(void**)&pResultingStream);
									else
										err=1;
									pStream->Release();
									if (SUCCEEDED(hr2)) {
										hr2=pResultingStream->GetObjectID(&NewId);
										pResultingStream->Release();
										pResultingStream=NULL;
									} else if (err==0)
										err=2;
									if (SUCCEEDED(hr2)) {
										hr2=pDeviceContent->Transfer(&pResources);
									} else if (err==0)
										err=3;
									if (SUCCEEDED(hr2)) {
										hr2=pResources->GetSupportedResources(NewId,&pKeys);
									} else if (err==0)
										err=4;
									if (SUCCEEDED(hr2)) {
										hr2=pKeys->GetCount(&cnt);
									} else if (err==0)
										err=5;
									BOOL preview=false;
									char supportedformats[128];
									supportedformats[0]=0;
									if (SUCCEEDED(hr2) && cnt>0) {
										for (DWORD dw=0;dw<cnt;dw++) {
											PROPERTYKEY pKey;
											hr2=pKeys->GetAt(dw,&pKey);
											if (SUCCEEDED(hr2)) {
												if (IsEqualPropertyKey(WPD_RESOURCE_ALBUM_ART,pKey)) {
													preview=true;
													break;
												} else if (IsEqualPropertyKey(WPD_RESOURCE_DEFAULT,pKey)) {
													strcat_s(supportedformats,128,"data ");
												} else if (IsEqualPropertyKey(WPD_RESOURCE_THUMBNAIL,pKey)) {
													strcat_s(supportedformats,128,"thumb ");
												} else if (IsEqualPropertyKey(WPD_RESOURCE_ICON,pKey)) {
													strcat_s(supportedformats,128,"icon ");
												} else if (IsEqualPropertyKey(WPD_RESOURCE_BRANDING_ART,pKey)) {
													strcat_s(supportedformats,128,"logo ");
												} else if (IsEqualPropertyKey(WPD_RESOURCE_GENERIC,pKey)) {
													strcat_s(supportedformats,128,"generic ");
												}
											}
										}
									}											

									if (preview) {
										HANDLE DataHandle=GlobalAlloc(GMEM_MOVEABLE,pPreviewImage->dwDataLen);
										if (DataHandle) {
											IStream* fDataStream;
											char* p=(char*)GlobalLock(DataHandle);
											memcpy(p,pPreviewImage->pbData,pPreviewImage->dwDataLen);
											GlobalUnlock(DataHandle);
											if (SUCCEEDED(CreateStreamOnHGlobal(DataHandle,true,&fDataStream))) {  // now fStream = data
												Gdiplus::GpImage* GdiplusImage;
												int err=Gdiplus::DllExports::GdipLoadImageFromStream(fDataStream,&GdiplusImage);
												if (err==0) {
													if (Gdiplus::DllExports::GdipGetImageWidth(GdiplusImage,&PreviewImageWidth)!=0)
														PreviewImageWidth=0;
													if (Gdiplus::DllExports::GdipGetImageHeight(GdiplusImage,&PreviewImageHeight)!=0)
														PreviewImageHeight=0;
													 Gdiplus::DllExports::GdipDisposeImage(GdiplusImage);
												}
											}
											fDataStream->Release();
											GlobalFree(DataHandle);
										}
									} else if (err==0)
										err=6;

									if (PreviewImageWidth>0 && PreviewImageHeight>0)
										hr2=CoCreateInstance(CLSID_PortableDeviceValues, NULL, CLSCTX_INPROC_SERVER, IID_IPortableDeviceValues, (VOID**)&spResInfo);
									else {
										hr2=E_FAIL;
										if (err==0)
											err=7;
									}
									if (SUCCEEDED(hr2))
										hr2 = spResInfo->SetStringValue(WPD_OBJECT_ID, NewId);
									 else if (err==0)
										err=8;
									if (SUCCEEDED(hr2))
										hr2 = spResInfo->SetKeyValue(WPD_RESOURCE_ATTRIBUTE_RESOURCE_KEY,WPD_RESOURCE_ALBUM_ART);
									else if (err==0)
										err=9;
									if (SUCCEEDED(hr2))
										hr2 = spResInfo->SetSignedLargeIntegerValue(WPD_RESOURCE_ATTRIBUTE_TOTAL_SIZE,pPreviewImage->dwDataLen);
									else if (err==0)
										err=10;
									if (SUCCEEDED(hr2))
										hr2 = spResInfo->SetGuidValue(WPD_RESOURCE_ATTRIBUTE_FORMAT,*imgtype);
									else if (err==0)
										err=11;
									if (SUCCEEDED(hr2))
										hr2 = spResInfo->SetSignedLargeIntegerValue(WPD_MEDIA_WIDTH,PreviewImageWidth);
									else if (err==0)
										err=12;
									if (SUCCEEDED(hr2))
										hr2 = spResInfo->SetSignedLargeIntegerValue(WPD_MEDIA_HEIGHT,PreviewImageHeight);
									else if (err==0)
										err=13;
									if (SUCCEEDED(hr2))
										hr2=pResources->CreateResource(spResInfo,&pStream,&OptimalBufferSize,NULL);
									else if (err==0)
										err=14;
									if (SUCCEEDED(hr2)) {
										DWORD BytesWritten;
										hr2=pStream->Write(pPreviewImage->pbData,pPreviewImage->dwDataLen,&BytesWritten);
										if (!SUCCEEDED(hr2))
											err=16;
										HRESULT hr3=pStream->Commit(STGC_DEFAULT);
										if (!SUCCEEDED(hr2) && err==0) {
											hr2=hr3;
											err=17;
										}
										pStream->Release();
										pStream=NULL;
									} else if (err==0)
										err=15;
									if (err) {
										char errbuf[256];
										if (err==1)
											LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,"Unknown album art, skipped.");
										else if (err==6) {
											strcpy_s(errbuf,sizeof(errbuf),"Album art skipped (not supported by this device). Supported streams: ");
											strcat_s(errbuf,sizeof(errbuf),supportedformats);
											LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,errbuf);
										} else if (err==7)
											LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,"GDI+: Could not load image to determine the size.");
										else {
											sprintf_s(errbuf,sizeof(errbuf),"Error copying album image in function %d: %x",err,hr2);
											LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,errbuf);
										}
									}
								}
								if (spResInfo)
									spResInfo->Release();
								if (pKeys)
									pKeys->Release();
								if (pResources)
									pResources->Release();

/* Doesn't work, returns access denied
								// set date again after copying!
								IEnumPortableDeviceObjectIDs* pEnumObjectIDs2=NULL;
								IPortableDeviceProperties* pProperties2=NULL;
								LPWSTR pItemStorageID2=NULL;
								HRESULT hr = GetFolderIDFromPathName(WRemoteName,&pEnumObjectIDs2,&pProperties2,NULL,NULL);
								if (SUCCEEDED(hr)) {
									// Find the file/folder with this name!
									int i=NameExistsInEnum(pEnumObjectIDs2,p,pProperties2,&pItemStorageID2);
									if (i>=0 && pItemStorageID2) {
										PROPVARIANT pv = {0};
										PropVariantInit(&pv);
										pv.vt = VT_DATE;
										SystemTimeToVariantTime(&systime,&pv.date);
										pValues->SetValue(WPD_OBJECT_DATE_MODIFIED,&pv);
										pValues->SetValue(WPD_OBJECT_DATE_CREATED,&pv);
										IPortableDeviceValues* pValues2=NULL;
										hr=pProperties2->SetValues(pItemStorageID2,pValues,&pValues2);
										HRESULT res2=0;
										if (!SUCCEEDED(hr))
											MessageBeep(0);
										else {
											pValues2->GetErrorValue(WPD_OBJECT_DATE_MODIFIED,&res2);
											pValues2->GetErrorValue(WPD_OBJECT_DATE_CREATED,&res2);
										}
										PropVariantClear(&pv);
										CoTaskMemFree(pItemStorageID2);
									}
									if (pEnumObjectIDs2)
										pEnumObjectIDs2->Release();
									if (pProperties2)
										pProperties2->Release();
								}
*/
							} else
								result=FS_FILE_WRITEERROR;
							CloseHandle(f);
							PropVariantClear(&pv);
							if (pPreviewImage)
								free(pPreviewImage);
							pPreviewImage=NULL;
						}
						pValues->Release();
					}
				}
			}
			if (pStorageID)
				CoTaskMemFree(pStorageID);
			if (pDeviceContent)
				pDeviceContent->Release();
			if (pEnumObjectIDs)
				pEnumObjectIDs->Release();
			if (pProperties)
				pProperties->Release();
		}
	}
	return result;
}

int __stdcall FsExecuteFile(HWND MainWin,char* RemoteName,char* Verb)
{
	WCHAR RemoteNameW[wdirtypemax],VerbW[wdirtypemax];
	return FsExecuteFileW(MainWin,awfilenamecopy(RemoteNameW,RemoteName),awfilenamecopy(VerbW,Verb));
}

int __stdcall FsExecuteFileW(HWND MainWin,WCHAR* RemoteName,WCHAR* Verb)
{
	char VerbA[wdirtypemax],RemoteNameA[wdirtypemax];
	if (RemoteName[0]!='\\')
		return FS_EXEC_ERROR;
	
	if (_wcsicmp(Verb,L"open")==0) {
		return FS_EXEC_YOURSELF;
	} else if (_wcsicmp(Verb,L"properties")==0) {
		// is it a device? If yes, the form is /devicename or /devicename/
		WCHAR* p=wcschr(RemoteName+1,'\\');
		if (p==NULL || p[1]==0) {
			ChangeConnectionSettingsW(hInst,MainWin,RemoteName);
			return FS_EXEC_OK;
		}
		return FS_EXEC_YOURSELF;
	} else if (_wcsnicmp(Verb,L"quote ",6)==0) {
		MessageBox(MainWin,wafilenamecopy(VerbA,Verb),"Quote verb not supported!",MB_ICONEXCLAMATION);
		return FS_EXEC_ERROR;
	} else if (_wcsnicmp(Verb,L"chmod ",6)==0) {
		MessageBox(MainWin,wafilenamecopy(RemoteNameA,Verb),"Chmod verb not supported!",MB_ICONEXCLAMATION);
		return FS_EXEC_ERROR;
	} else
		return FS_EXEC_ERROR;
}

void __stdcall FsGetDefRootName(char* DefRootName,int maxlen)
{
	strlcpy(DefRootName,DefPluginTitle,maxlen-1);
}

// Currently these are only used to unload GDI+

int __stdcall FsContentGetSupportedField(int FieldIndex,char* FieldName,char* Units,int maxlen)
{
	return ft_nomorefields;
}

int __stdcall FsContentGetValue(TCHAR* FileName,int FieldIndex,int UnitIndex,void* FieldValue,int maxlen,int flags)
{
	return ft_nosuchfield;
}

void __stdcall FsContentPluginUnloading(void)
{
	ShutdownGdiPlus();
}

void __stdcall FsSetDefaultParams(FsDefaultParamStruct* dps)
{
	awlcopy(DefaultIniNameW,dps->DefaultIniName,sizeof(DefaultIniNameW)/2-1);
}