// wincefs.cpp : Defines the entry point for the DLL application.
//

#include <windows.h>
#include <stdlib.h>
#include <shellapi.h>
#include <wchar.h>
#include "MSWMDM.h"   // Include headers for Windows Media Device Manager.
#include "MSWMDM_i.c" // Include IIDs for Windows Media Device Manager.
#include "key.c"    // This key is the authentication key.
#include "fsplugin.h"
#include "Sac.h"      // Include authentication headers.
#include "Scclient.h" // Include authentication client headers.
#include "utils.h"
#include "cunicode.h"

#define DefPluginTitle "MediaAudio"

tProgressProc ProgressProc;
tLogProc LogProc;
tRequestProc RequestProc;
tProgressProcW ProgressProcW;
tLogProcW LogProcW;
tRequestProcW RequestProcW;
int PluginNumber;

char* strlcpy(char* p,char*p2,int maxlen)
{
	if ((int)strlen(p2)>=maxlen) {
		strncpy(p,p2,maxlen);
		p[maxlen]=0;
	} else
		strcpy(p,p2);
	return p;
}

char* strlcat(char* p,char*p2,int maxlen)
{
	int restlen=maxlen-(int)strlen(p);
	if (restlen>0)
		strlcpy(p+strlen(p),p2,restlen);
	return p;
}

char* strlcatbackslash(char* thedir,int maxlen)
{
	if (thedir[0] && strlen(thedir)<(DWORD)maxlen)
		if (thedir[strlen(thedir)-1]!='\\')
			strlcat(thedir,"\\",maxlen);
	return thedir;
}

WCHAR* wcslcatbackslash(WCHAR* thedir,int maxlen)
{
	if (thedir[0] && wcslen(thedir)<(DWORD)maxlen)
		if (thedir[wcslen(thedir)-1]!='\\')
			wcscat(thedir,L"\\");
	return thedir;
}

typedef struct _ExtensionMap
{
    LPCWSTR wszExtension;
    WMDM_FORMATCODE formatCode;
} ExtensionMap;

static const ExtensionMap rgExtensionMap[] =
{
    { L"aiff",  WMDM_FORMATCODE_AIFF },
    { L"wav",   WMDM_FORMATCODE_WAVE },
    { L"mp2",   WMDM_FORMATCODE_MP3 },
    { L"mp3",   WMDM_FORMATCODE_MP3 },
    { L"avi",   WMDM_FORMATCODE_AVI },
    { L"mpeg",  WMDM_FORMATCODE_MPEG },
    { L"mpg",   WMDM_FORMATCODE_MPEG },
    { L"asf",   WMDM_FORMATCODE_ASF },
    { L"wmv",   WMDM_FORMATCODE_WMV },  
    { L"dvr-ms",WMDM_FORMATCODE_ASF },
    { L"jpg",   WMDM_FORMATCODE_IMAGE_EXIF },
    { L"jpe",   WMDM_FORMATCODE_IMAGE_EXIF },
    { L"jpeg",  WMDM_FORMATCODE_IMAGE_EXIF },
    { L"bmp",  WMDM_FORMATCODE_IMAGE_BMP },
	{ L"gif",  	WMDM_FORMATCODE_IMAGE_GIF },
	{ L"png",  	WMDM_FORMATCODE_IMAGE_PNG },
    { L"wma",   WMDM_FORMATCODE_WMA },
	{ L"mpl",   WMDM_FORMATCODE_MPLPLAYLIST},
	{ L"asx",   WMDM_FORMATCODE_ASXPLAYLIST},
	{ L"pls",   WMDM_FORMATCODE_PLSPLAYLIST},
	{ L"m3u",   WMDM_FORMATCODE_M3UPLAYLIST},
	{ L"ogg",   WMDM_FORMATCODE_UNDEFINEDAUDIO}
};

///////////////////////////////////////////////////////////////////////////
// Progress callback object
//

class MyWMDMProgress: public IWMDMProgress
{
protected: 
	UINT m_uiRefCount;
public: 
	// Contstructor and Destructor
	MyWMDMProgress();
	~MyWMDMProgress();

	// IUnknown Interface members
	STDMETHODIMP QueryInterface(REFIID, LPVOID*);
	STDMETHODIMP_(ULONG) AddRef(void);
	STDMETHODIMP_(ULONG) Release(void);

	STDMETHODIMP_(HRESULT) Begin(DWORD dwEstimatedTicks);
	STDMETHODIMP_(HRESULT) Progress(DWORD  dwTranspiredTicks);
	STDMETHODIMP_(HRESULT) End(void);
	void SetCopyNames(WCHAR* pOldName,WCHAR* pNewName);
private:
	DWORD dwTotalTicks;
	WCHAR OldName[wdirtypemax];
	WCHAR NewName[wdirtypemax];
};

MyWMDMProgress::MyWMDMProgress(void)
{
	m_uiRefCount = 1;
}

MyWMDMProgress::~MyWMDMProgress(void)
{
}

STDMETHODIMP MyWMDMProgress::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}
	//IDropTarget
	else if(IsEqualIID(riid, IID_IWMDMProgress))
	{
		*ppReturn = (IDropSource*)this;
	}
	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}
	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) MyWMDMProgress::AddRef(VOID)
{
	return ++m_uiRefCount;
}

STDMETHODIMP_(DWORD) MyWMDMProgress::Release(VOID)
{
	if(--m_uiRefCount == 0)
	{
		delete this;
		return 0;     // Object may be gone!
	}
	return m_uiRefCount;
}

STDMETHODIMP_(HRESULT) MyWMDMProgress::Begin(DWORD dwEstimatedTicks)
{
	dwTotalTicks=dwEstimatedTicks;
	return S_OK;
}

STDMETHODIMP_(HRESULT) MyWMDMProgress::End(void)
{
	return S_OK;
}

STDMETHODIMP_(HRESULT) MyWMDMProgress::Progress(DWORD  dwTranspiredTicks)
{
	if (dwTotalTicks>0) {
		int percent;
		if (dwTotalTicks>100000)    // avoid overflow
			percent=dwTranspiredTicks/(dwTotalTicks/100);
		else
			percent=100*dwTranspiredTicks/dwTotalTicks;
		if (percent>100)
			percent=100;
		int err=ProgressProcT(PluginNumber,OldName,NewName,percent);
		if (err)
			return WMDM_E_USER_CANCELLED;
	}
	return S_OK;
}

void MyWMDMProgress::SetCopyNames(WCHAR* pOldName,WCHAR* pNewName)
{
	wcslcpy(OldName,pOldName,wdirtypemax-1);
	wcslcpy(NewName,pNewName,wdirtypemax-1);
}

BOOL initialized=FALSE;
BOOL firstinitialized=FALSE;
IWMDeviceManager2* pIdvMgr=NULL;

BOOL InitFunctionsIfNeeded(BOOL trueconnect)
{
	HRESULT hr;
	IComponentAuthenticate* pICompAuth;
	CSecureChannelClient SAC;
	DWORD dwNumProtCount;
	DWORD* pdwProt;  // This will always be SAC_PROTOCOL_V1.

	if (!firstinitialized) {
		CoInitialize(NULL);
		firstinitialized=true;
	}

	if(initialized)
		return TRUE;

	hr = CoCreateInstance(CLSID_MediaDevMgr, NULL, CLSCTX_ALL,
				   IID_IComponentAuthenticate, (void **)&pICompAuth);

	// After getting IComponentAuthenticate, the authentication progression follows.
	if SUCCEEDED(hr)
	{
		hr = SAC.SetCertificate(SAC_CERT_V1, (BYTE*) abCert, sizeof(abCert), (BYTE*) abPVK, sizeof(abPVK));
		if SUCCEEDED(hr)
			{
			  // Set interface for Secure Authenticated Channel
			  // operations. The return value of this function is void.

			  SAC.SetInterface(pICompAuth);
			  hr = pICompAuth->SACGetProtocols(&pdwProt, &dwNumProtCount);
			  if SUCCEEDED(hr)
				  hr = SAC.Authenticate(*pdwProt); //SAC_PROTOCOL_V1
			  if (!SUCCEEDED(hr))
				  pdwProt=NULL;
			}
		if(pdwProt)
		  CoTaskMemFree(pdwProt);
		// After authentication has succeeded, call QueryInterface to 
		// get IID_IWMDeviceManager.
		hr = pICompAuth->QueryInterface(IID_IWMDeviceManager2, (void**)&pIdvMgr);
		if SUCCEEDED(hr)
		{
			pIdvMgr->AddRef();
			initialized=TRUE;
			return TRUE;
		}
	}
	return FALSE;
}

void FreeFunctions()
{
	if (initialized) {
		pIdvMgr->Release();
		pIdvMgr=NULL;
		initialized=false;
	}
}

BOOL connected=false;
IWMDMEnumDevice* pIEnumDev=NULL;

HRESULT ConnectIfNeeded(IWMDMEnumDevice** ppIEnumDev)
{
	if (!connected) {
		HRESULT hr;
		hr=pIdvMgr->EnumDevices2(&pIEnumDev);
		if (SUCCEEDED(hr)) {
			LogProc(PluginNumber,MSGTYPE_CONNECT,"CONNECT \\");
			connected=true;
			pIEnumDev->AddRef();
			*ppIEnumDev=pIEnumDev;
			return S_OK;
		} else
			return E_FAIL;
	} else {
		pIEnumDev->AddRef();
		pIEnumDev->Reset();
		*ppIEnumDev=pIEnumDev;
		return S_OK;
	}
}

//#define ReleaseInterfaceWarn(a) {if (a->Release()) { char buf[20]; _itoa(__LINE__,buf,10); MessageBox(0,"Interface not released",buf,MB_ICONSTOP);} a=NULL;}
#define ReleaseInterfaceWarn(a) {a->Release(); a=NULL;}

HRESULT DisConnectIfNeeded()
{
	if (connected) {
		connected=FALSE;
		if (0==pIEnumDev->Release())
/*			MessageBoxA(GetActiveWindow(),"Disconnected!","Test",0);
		else
			MessageBoxA(GetActiveWindow(),"Not fully released!","Test",0);*/
		pIEnumDev=NULL;
		return S_OK;
	} else
		return E_FAIL;
}

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	if (ul_reason_for_call==DLL_PROCESS_DETACH)
		FreeFunctions();
    return TRUE;
}

int __stdcall FsInit(int PluginNr,tProgressProc pProgressProc,tLogProc pLogProc,tRequestProc pRequestProc)
{
	PluginNumber=PluginNr;
	ProgressProc=pProgressProc;
    LogProc=pLogProc;
    RequestProc=pRequestProc;
	return 0;
}

int __stdcall FsInitW(int PluginNr,tProgressProcW pProgressProcW,tLogProcW pLogProcW,tRequestProcW pRequestProcW)
{
	PluginNumber=PluginNr;
	ProgressProcW=pProgressProcW;
    LogProcW=pLogProcW;
    RequestProcW=pRequestProcW;
	return 0;
}

typedef struct {
	WCHAR Path[wdirtypemax];
	WCHAR LastFoundName[wdirtypemax];
	IWMDMEnumDevice* pIEnumDev;
    IWMDMEnumStorage* pIEnumStorageFile;
} tLastFindStuct,*pLastFindStuct;

BOOL __stdcall FsDisconnect(char* DisconnectRoot)
{
	DisConnectIfNeeded();
	FreeFunctions();
	char buf1[MAX_PATH];
	strlcpy(buf1,"DISCONNECT ",MAX_PATH);
	strlcat(buf1,DisconnectRoot,MAX_PATH-1);
	LogProc(PluginNumber,MSGTYPE_DISCONNECT,buf1);
	return TRUE;
}

BOOL alreadylisted=false;

// Query a device for supported configurations for each media or format type. 
void ShowSupportedFormats(IWMDMDevice* pDevice1)
{
	IWMDMDevice3* pDevice3;
	if (alreadylisted)
		return;
	alreadylisted=true;
	HRESULT hr = pDevice1->QueryInterface(IID_IWMDMDevice3, (void**)&pDevice3);
	if SUCCEEDED(hr) {
		// Request the "formats supported" property to get a list of supported formats.
		PROPVARIANT pvFormatsSupported;
		PropVariantInit(&pvFormatsSupported);
		hr = pDevice3->GetProperty(g_wszWMDMFormatsSupported, &pvFormatsSupported);
		// Loop through the retrieved format list.
		// For each format, get a list of format configurations.
		SAFEARRAY* formatList = pvFormatsSupported.parray;
		WMDM_FORMATCODE formatCode = WMDM_FORMATCODE_NOTUSED;
		char buf1[MAX_PATH],buf2[32];
		int numfound=0;
		strlcpy(buf1,"Supported formats: ",MAX_PATH-1);
		for(LONG iCap = 0; iCap < formatList->rgsabound[0].cElements; iCap++)
		{ 
			// Get a format from the SAFEARRAY of retrieved formats.
			SafeArrayGetElement(formatList, &iCap, &formatCode);

			// Call a custom function to see the specifics of device support for 
			// each format.
			if (formatCode != WMDM_FORMATCODE_NOTUSED) {
				BOOL codefound=false;
				if (numfound)
					strlcat(buf1,", ",MAX_PATH-1);
				numfound++;
				for (int i = 0; i < ARRAYSIZE(rgExtensionMap); i++)
				{
					//the length of comparison is bounded by strings represented by rgExtensionMap[i].wszExtension             
					if (formatCode == rgExtensionMap[i].formatCode) {
						WideCharToMultiByte(CP_ACP,0,rgExtensionMap[i].wszExtension,-1,buf2,sizeof(buf2)-1,
							NULL,NULL);
						strlcat(buf1,buf2,MAX_PATH);
						codefound=true;
						break;
					}
				}
				if (!codefound) {
					itoa(formatCode,buf2,16);
					strlcat(buf1,"0x",MAX_PATH-1);
					strlcat(buf1,buf2,MAX_PATH-1);
				}
			}
		}
		// Clear out the memory we used.
		PropVariantClear(&pvFormatsSupported);
		pDevice3->Release();
		if (numfound)
			LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
	}
}

HRESULT GetEnumStorageFromPathName(WCHAR* wcSearch,IWMDMEnumStorage** pIEnumStorageFile,IWMDMStorage** pIStorageFile)
{
	// wsSearch has form \Devicename\path1\path2
	// First, get Device
	WCHAR* p;
	HRESULT hr;
	DWORD dwCount,ulNumFetched;
	p = wcstok(wcSearch,L"\\");
	if (!p)
		return E_FAIL;
	// Find the right device, p points to it!

	if (!InitFunctionsIfNeeded(TRUE)) {
		return E_FAIL;
	}
	WCHAR DeviceName[MAX_PATH];

	hr = pIdvMgr->GetDeviceCount(&dwCount);
	if (!SUCCEEDED(hr) || dwCount==0) {
		return E_FAIL;
	}
	
	IWMDMEnumDevice* pIEnumDev;
	IWMDMDevice* pIDevice;
	hr = ConnectIfNeeded(&pIEnumDev);
	if SUCCEEDED(hr)
	{
		while (1) {
			hr = pIEnumDev->Next(1,&pIDevice,&ulNumFetched); // Get device.
			// If no device is found, S_FALSE is returned, which is still
			// a success case.  Do not use the SUCCEEDED macro.
			if (S_OK == hr && ulNumFetched>0)
			{
				hr = pIDevice->GetName(DeviceName,MAX_PATH-1);
				if SUCCEEDED(hr)
				{
					if (wcscmp(DeviceName,p)==0)
						break;
				}
				pIDevice->Release();
				pIDevice=NULL;
			} else {
				pIDevice=NULL;
				break;
			}
		}
		pIEnumDev->Release();  // not 0, will be cached!
		pIEnumDev=NULL;
	}
	IWMDMStorage* pIStorage;
	IWMDMEnumStorage* pIEnumStorage;

	if (!pIDevice) {
		LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,"Device not found!");
		return E_FAIL;
	}
	ShowSupportedFormats(pIDevice);

	hr = pIDevice->EnumStorage(&pIEnumStorage);
	if (!SUCCEEDED(hr)) {
		pIDevice->Release();
		pIDevice=NULL;
		return E_FAIL;
	}
	p = wcstok(NULL,L"\\");
	if (!p) {    // we want to enumerate the root!
		if (pIEnumStorageFile && pIStorageFile==NULL) {
			*pIEnumStorageFile=pIEnumStorage;
			pIDevice->Release();
			pIDevice=NULL;
			return S_OK;
		} else {
			ReleaseInterfaceWarn(pIEnumStorage);
			pIDevice->Release();
			pIDevice=NULL;
			return E_FAIL;
		}
	}
	// now enumerate subfolders until we have reached the right one!
	WCHAR wsString[MAX_PATH];
	do {
		hr = pIEnumStorage->Next(1, &pIStorage, &ulNumFetched);
		if (hr==S_OK && ulNumFetched>0) {
			hr = pIStorage->GetName(wsString, MAX_PATH-1);
			if SUCCEEDED(hr) {
				if (wcscmp(wsString,L"\\")==0)
					wsString[0]='_';
				if (wcscmp(wsString,p)==0) {  //found!!
					pIEnumStorage->Release();
					pIEnumStorage=NULL;
					hr = pIStorage->EnumStorage(&pIEnumStorage);
					if (!SUCCEEDED(hr))    // a file?
						pIEnumStorage=NULL;
					p=wcstok(NULL,L"\\");
					if (!p) {   //we are done!
						if (pIEnumStorageFile) {
							//pIEnumStorage->AddRef();
							*pIEnumStorageFile=pIEnumStorage;
						} else if (pIEnumStorage)
							ReleaseInterfaceWarn(pIEnumStorage);
						pIEnumStorage=NULL;
						if (pIStorageFile) {
							//pIStorage->AddRef();
							*pIStorageFile=pIStorage;
						} else
							ReleaseInterfaceWarn(pIStorage);
						pIStorage=NULL;
						return S_OK;
					}
				}
			}
		}
	} while (hr==S_OK && ulNumFetched>0);
	pIDevice->Release();
	pIDevice=NULL;
	return E_FAIL;
}

BOOL NameExistsInEnum(IWMDMEnumStorage* pIEnumStorage,WCHAR* name,IWMDMStorage** ppIStorage)
{
	WCHAR wsString[MAX_PATH];
	IWMDMStorage* pIStorage;
	HRESULT hr;
	DWORD ulNumFetched;
	pIEnumStorage->Reset();
	do {
		hr = pIEnumStorage->Next(1, &pIStorage, &ulNumFetched);
		if (hr==S_OK && ulNumFetched>0) {
			hr = pIStorage->GetName(wsString, MAX_PATH-1);
			if SUCCEEDED(hr) {
				if (wcscmp(wsString,name)==0) {  //found!!
					if (ppIStorage) {
						*ppIStorage=pIStorage;
					} else
						ReleaseInterfaceWarn(pIStorage);
					return true;
				}
			}
			ReleaseInterfaceWarn(pIStorage);
		}
	} while (hr==S_OK && ulNumFetched>0);
	return false;
}

HANDLE __stdcall FsFindFirst(char* Path,WIN32_FIND_DATAA *FindData)
{
	WCHAR PathW[wdirtypemax];
	WIN32_FIND_DATAW FindDataW;
	HANDLE h=FsFindFirstW(awfilenamecopy(PathW,Path),&FindDataW);
	if (h!=INVALID_HANDLE_VALUE)
		copyfinddatawa(FindData,&FindDataW);
	return h;
}

HANDLE __stdcall FsFindFirstW(WCHAR* Path,WIN32_FIND_DATAW *FindData)
{
	pLastFindStuct lf;
	WCHAR wcSearch[wdirtypemax];
	DWORD hr,dwCount,ulNumFetched;
	
	memset(FindData,0,sizeof(WIN32_FIND_DATAW));
	wcslcpy(wcSearch,Path,wdirtypemax-1);           // incl. Backslash!
	wcslcatbackslash(wcSearch,wdirtypemax-1);
	wcslcat(wcSearch,L"*.*",wdirtypemax-1);
	
	if (Path[0]=='\\') {   
		if (!InitFunctionsIfNeeded(TRUE)) {
			return INVALID_HANDLE_VALUE;
		}

		if (Path[1]==0) {  // Enum just the devices 
			WCHAR DeviceName[MAX_PATH];
			hr = pIdvMgr->GetDeviceCount(&dwCount);
			if (!SUCCEEDED(hr) || dwCount==0) {
				SetLastError(ERROR_NO_MORE_FILES);
				return INVALID_HANDLE_VALUE;
			}
			IWMDMEnumDevice* pIEnumDev;
			IWMDMDevice* pIDevice;

			hr = ConnectIfNeeded(&pIEnumDev);
			if SUCCEEDED(hr)
			{
				hr = pIEnumDev->Next(1,&pIDevice,&ulNumFetched); // Get device.
				
				// If no device is found, S_FALSE is returned, which is still
				// a success case.  Do not use the SUCCEEDED macro.
				if (S_OK == hr)
				{
					// Get manufacturer.
					hr = pIDevice->GetName(DeviceName,MAX_PATH-1);
					pIDevice->Release();
					if SUCCEEDED(hr)
					{
						WCHAR buf1[wdirtypemax];
						wcslcpy(buf1,L"GET DIR ",wdirtypemax-1);
						wcslcat(buf1,wcSearch,wdirtypemax-1);
						LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);

						wcslcpy(FindData->cFileName,(LPCWSTR)&DeviceName,MAX_PATH-2);
						FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
						FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
						FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
						FindData->nFileSizeHigh=0;
						FindData->nFileSizeLow=0;
						lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
						wcslcpy(lf->Path,wcSearch,wdirtypemax-1);
						lf->pIEnumDev=pIEnumDev;
						lf->pIEnumStorageFile=NULL;
						return (HANDLE)lf;
					}
				}
				pIEnumDev->Release();   // not fully released (cached)
			}
		} else {
			IWMDMEnumStorage* pIEnumStorageFile;
			WCHAR* pWild;
			pWild=wcsrchr(wcSearch,L'\\');
			if (pWild)
				pWild[0]=0;
			hr=GetEnumStorageFromPathName(wcSearch,&pIEnumStorageFile,NULL);
			if (SUCCEEDED(hr)) {
				IWMDMStorage* pIStorageFile;
				// Loop to enumerate content storages (files).
				for( ; ; )
				{
					hr = pIEnumStorageFile->Next(1 , &pIStorageFile, &ulNumFetched);
					if (S_OK != hr) {
						SetLastError(ERROR_NO_MORE_FILES);
						ReleaseInterfaceWarn(pIEnumStorageFile);
						return INVALID_HANDLE_VALUE;
					}
					if SUCCEEDED(hr) {
						WCHAR wsString[MAX_PATH];
						hr = pIStorageFile->GetName(wsString, MAX_PATH-1);
						if SUCCEEDED(hr) {
							WCHAR buf1[wdirtypemax];
							wcslcpy(buf1,L"GET DIR ",wdirtypemax-1);
							wcslcat(buf1,wcSearch,wdirtypemax-1);
							LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);

							wcslcpy(FindData->cFileName,(LPCWSTR)&wsString,MAX_PATH-2);
							if (wcscmp(FindData->cFileName,L"\\")==0)
								FindData->cFileName[0]='_';
							DWORD dwAttribs;
							_WAVEFORMATEX Format;
							hr = pIStorageFile->GetAttributes(&dwAttribs, &Format);
							if SUCCEEDED(hr) {
								if (dwAttribs&WMDM_FILE_ATTR_FOLDER)
									FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
								else {
									FindData->dwFileAttributes=0;
									if (dwAttribs&WMDM_FILE_ATTR_HIDDEN)
										FindData->dwFileAttributes|=WMDM_FILE_ATTR_HIDDEN;
									if (dwAttribs&WMDM_FILE_ATTR_HIDDEN)
										FindData->dwFileAttributes|=WMDM_FILE_ATTR_SYSTEM;
									if (dwAttribs&WMDM_FILE_ATTR_READONLY)
										FindData->dwFileAttributes|=WMDM_FILE_ATTR_READONLY;
								}
							} else
								FindData->dwFileAttributes=0;
							WMDMDATETIME wdt;
							hr = pIStorageFile->GetDate(&wdt);
							if (SUCCEEDED(hr)) {
								SYSTEMTIME st;
								st.wDay=wdt.wDay;
								st.wMonth=wdt.wMonth;
								st.wYear=wdt.wYear;
								st.wMilliseconds=0;
								st.wHour=wdt.wHour;
								st.wMinute=wdt.wMinute;
								st.wSecond=wdt.wSecond;
								SystemTimeToFileTime(&st,&FindData->ftLastWriteTime);
							} else {
								FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
								FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
							}
							hr = pIStorageFile->GetSize(&FindData->nFileSizeLow,&FindData->nFileSizeHigh);
							if (!SUCCEEDED(hr)) {
								FindData->nFileSizeHigh=0;
								FindData->nFileSizeLow=0;
							}
							lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
							wcslcpy(lf->Path,wcSearch,wdirtypemax-1);
							pIEnumStorageFile->AddRef();
							lf->pIEnumStorageFile=pIEnumStorageFile;
							lf->pIEnumDev=NULL;
							return (HANDLE)lf;
						}
					}
				}
				ReleaseInterfaceWarn(pIEnumStorageFile);
			}
		}
	}
	SetLastError(ERROR_PATH_NOT_FOUND);
	return INVALID_HANDLE_VALUE;
}

BOOL __stdcall FsFindNext(HANDLE Hdl,WIN32_FIND_DATAA *FindData)
{
	WIN32_FIND_DATAW FindDataW;
	BOOL ret=FsFindNextW(Hdl,&FindDataW);
	if (ret)
		copyfinddatawa(FindData,&FindDataW);
	return ret;
}

BOOL __stdcall FsFindNextW(HANDLE Hdl,WIN32_FIND_DATAW *FindData)
{
	pLastFindStuct lf;

	if (Hdl==(HANDLE)1)
		return false;

	lf=(pLastFindStuct)Hdl;
	if (lf->pIEnumDev) {
		DWORD hr,ulNumFetched;
		WCHAR DeviceName[MAX_PATH];
		IWMDMDevice* pIDevice;
		hr=lf->pIEnumDev->Next(1,&pIDevice,&ulNumFetched); // Get device.
		if (S_OK == hr)
		{
			hr = pIDevice->GetName(DeviceName,MAX_PATH-1);
			ReleaseInterfaceWarn(pIDevice);
			if SUCCEEDED(hr)
			{
				memset(FindData,0,sizeof(WIN32_FIND_DATA));
				wcslcpy(FindData->cFileName,DeviceName,MAX_PATH-2);
				FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
				FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
				FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
				FindData->nFileSizeHigh=0;
				FindData->nFileSizeLow=0;
				return true;
			}
		}
	} else if (lf->pIEnumStorageFile) {
		DWORD hr,ulNumFetched;
		IWMDMStorage* pIStorageFile;
		hr = lf->pIEnumStorageFile->Next(1 , &pIStorageFile, &ulNumFetched);
		if (S_OK == hr) {
			WCHAR wsString[MAX_PATH];
			hr = pIStorageFile->GetName(wsString, MAX_PATH-1);
			if SUCCEEDED(hr) {
				wcslcpy(FindData->cFileName,(LPCWSTR)&wsString,MAX_PATH-2);
				DWORD dwAttribs;
				_WAVEFORMATEX Format;
				hr = pIStorageFile->GetAttributes(&dwAttribs, &Format);
				if SUCCEEDED(hr) {
					if (dwAttribs&WMDM_FILE_ATTR_FOLDER)
						FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
					else {
						FindData->dwFileAttributes=0;
						if (dwAttribs&WMDM_FILE_ATTR_HIDDEN)
							FindData->dwFileAttributes|=WMDM_FILE_ATTR_HIDDEN;
						if (dwAttribs&WMDM_FILE_ATTR_HIDDEN)
							FindData->dwFileAttributes|=WMDM_FILE_ATTR_SYSTEM;
						if (dwAttribs&WMDM_FILE_ATTR_READONLY)
							FindData->dwFileAttributes|=WMDM_FILE_ATTR_READONLY;
					}
				} else
					FindData->dwFileAttributes=0;
				WMDMDATETIME wdt;
				hr = pIStorageFile->GetDate(&wdt);
				if (SUCCEEDED(hr)) {
					SYSTEMTIME st;
					st.wDay=wdt.wDay;
					st.wMonth=wdt.wMonth;
					st.wYear=wdt.wYear;
					st.wMilliseconds=0;
					st.wHour=wdt.wHour;
					st.wMinute=wdt.wMinute;
					st.wSecond=wdt.wSecond;
					SystemTimeToFileTime(&st,&FindData->ftLastWriteTime);
				} else {
					FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
					FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
				}
				hr = pIStorageFile->GetSize(&FindData->nFileSizeLow,&FindData->nFileSizeHigh);
				if (!SUCCEEDED(hr)) {
					FindData->nFileSizeHigh=0;
					FindData->nFileSizeLow=0;
				}
				return true;
			}
			ReleaseInterfaceWarn(pIStorageFile);
		}
	}
	return false;
}

int __stdcall FsFindClose(HANDLE Hdl)
{
	if (Hdl==(HANDLE)1)
		return 0;
	pLastFindStuct lf;
	lf=(pLastFindStuct)Hdl;
	if (lf->pIEnumDev) {
		lf->pIEnumDev->Release();
		lf->pIEnumDev=NULL;
	} else if (lf->pIEnumStorageFile) {
		lf->pIEnumStorageFile->Release();
		lf->pIEnumStorageFile=NULL;
	}
	free(lf);
	return 0;
}

BOOL __stdcall FsMkDir(char* Path)
{
	WCHAR PathW[wdirtypemax];
	return FsMkDirW(awfilenamecopy(PathW,Path));
}

BOOL __stdcall FsMkDirW(WCHAR* Path)
{
	if (Path[0]!='\\')
		return false;

	InitFunctionsIfNeeded(TRUE);

	WCHAR wcSearch[wdirtypemax],*p;
	HRESULT hr;
	wcslcpy(wcSearch,Path,wdirtypemax-1);
	p=wcsrchr(wcSearch,'\\');
	if (p) {
		IWMDMStorage* pIStorageFile;
		IWMDMStorage* pIStorage2;
		IWMDMEnumStorage* pIEnumStorageFile;
		p[0]=0;
		p++;
		hr=GetEnumStorageFromPathName(wcSearch,&pIEnumStorageFile,&pIStorageFile);
		if (SUCCEEDED(hr)) {
			IWMDMStorageControl* pIWMDMStorageControl;
			// Make sure that there isn't already a file with that name!
			if (NameExistsInEnum(pIEnumStorageFile,p,&pIStorage2)) {
				DWORD dwAttribs;
				_WAVEFORMATEX Format;
				pIStorage2->GetAttributes(&dwAttribs,&Format);
				pIStorage2->Release();
				pIEnumStorageFile->Release();
				ReleaseInterfaceWarn(pIStorageFile);
				if (dwAttribs & WMDM_FILE_ATTR_FOLDER)
					return true;
				else
					return false;
			} else {
				pIEnumStorageFile->Release();
				hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
					(void**)&pIWMDMStorageControl);
				if SUCCEEDED(hr)
				{
					pIStorage2=NULL;
					hr = pIWMDMStorageControl->Insert(
							 WMDM_MODE_BLOCK | WMDM_CONTENT_FOLDER | WMDM_STORAGECONTROL_INSERTINTO, 
							 p, 
							 NULL, NULL, 
							 &pIStorage2);
					pIWMDMStorageControl->Release();
					if (SUCCEEDED(hr)) {
						WCHAR buf1[wdirtypemax];
						wcslcpy(buf1,L"MKDIR ",wdirtypemax-1);
						wcslcat(buf1,Path,wdirtypemax-1);
						LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
						ReleaseInterfaceWarn(pIStorage2);
					}
					ReleaseInterfaceWarn(pIStorageFile);
					return SUCCEEDED(hr);
				}
				ReleaseInterfaceWarn(pIStorageFile);
			}
		}
	}
	return false;
}

int __stdcall FsExecuteFile(HWND MainWin,char* RemoteName,char* Verb)
{
	WCHAR RemoteNameW[wdirtypemax],VerbW[wdirtypemax];
	return FsExecuteFileW(MainWin,awfilenamecopy(RemoteNameW,RemoteName),awfilenamecopy(VerbW,Verb));
}

int __stdcall FsExecuteFileW(HWND MainWin,WCHAR* RemoteName,WCHAR* Verb)
{
	char VerbA[wdirtypemax],RemoteNameA[wdirtypemax];
	if (RemoteName[0]!='\\')
		return FS_EXEC_ERROR;
	
	if (wcsicmp(Verb,L"open")==0) {
		return FS_EXEC_YOURSELF;
	} else if (wcsicmp(Verb,L"properties")==0) {
		return FS_EXEC_YOURSELF;
	} else if (wcsnicmp(Verb,L"quote ",6)==0) {
		MessageBox(MainWin,wafilenamecopy(VerbA,Verb),"Quote verb not supported!",MB_ICONEXCLAMATION);
		return FS_EXEC_ERROR;
	} else if (wcsnicmp(Verb,L"chmod ",6)==0) {
		MessageBox(MainWin,wafilenamecopy(RemoteNameA,Verb),"Chmod verb not supported!",MB_ICONEXCLAMATION);
		return FS_EXEC_ERROR;
	} else
		return FS_EXEC_ERROR;
}

int __stdcall FsRenMovFile(char* OldName,char* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	WCHAR NewNameW[wdirtypemax],OldNameW[wdirtypemax];
	return FsRenMovFileW(awfilenamecopy(OldNameW,OldName),awfilenamecopy(NewNameW,NewName),Move,OverWrite,ri);
}

int __stdcall FsRenMovFileW(WCHAR* OldName,WCHAR* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	if (OldName[0]!='\\'  || NewName[0]!='\\')
		return FS_FILE_NOTFOUND;

	int err=ProgressProcT(PluginNumber,OldName,NewName,0);
	if (err)
		return FS_FILE_USERABORT;

	if (!InitFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	WCHAR buf1[wdirtypemax];
	if (Move) 
		wcscpy(buf1,L"MOVE ");
	else
		wcscpy(buf1,L"COPY ");

	int retval=WMDM_E_INTERFACEDEAD;

	if (Move) {
		WCHAR WOldName[wdirtypemax],*p,*p2;
		WCHAR WNewName[wdirtypemax];
		HRESULT hr;
		wcslcpy(WOldName,OldName,wdirtypemax-1);
		wcslcpy(WNewName,NewName,wdirtypemax-1);
		p=wcsrchr(WOldName,'\\');
		p2=wcsrchr(WNewName,'\\');
		if (p && p2) {
			IWMDMStorage* pIStorageFile;
			IWMDMEnumStorage* pIEnumStorageFile;
			p[0]=0;
			p2[0]=0;
			if (wcscmp(WOldName,WNewName)==0) {  // rename in place
				IWMDMStorageControl* pIWMDMStorageControl;
				hr=GetEnumStorageFromPathName(WOldName,&pIEnumStorageFile,NULL);
				if (SUCCEEDED(hr)) {
					p[0]='\\';
					p2[0]='\\';
					p++;
					p2++;
					if (NameExistsInEnum(pIEnumStorageFile,p2,&pIStorageFile)) {   // New name exists?
						DWORD dwAttribs;
						_WAVEFORMATEX Format;
						pIStorageFile->GetAttributes(&dwAttribs,&Format);
						if (dwAttribs & WMDM_FILE_ATTR_FOLDER) {  // do not delete folders!
							pIEnumStorageFile->Release();
							ReleaseInterfaceWarn(pIStorageFile);
							return FS_FILE_WRITEERROR;
						}
						if (OverWrite) {
							// delete it!
							hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
								(void**)&pIWMDMStorageControl);
							if (SUCCEEDED(hr))
								hr = pIWMDMStorageControl->Delete(WMDM_MODE_BLOCK,NULL);
							pIWMDMStorageControl->Release();
							ReleaseInterfaceWarn(pIStorageFile);
							if (!SUCCEEDED(hr))
								return FS_FILE_WRITEERROR;
						} else {
							ReleaseInterfaceWarn(pIStorageFile);
							return FS_FILE_EXISTS;
						}
					}
					if (NameExistsInEnum(pIEnumStorageFile,p,&pIStorageFile)) {  // Source ->Rename
						hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
							(void**)&pIWMDMStorageControl);
						if SUCCEEDED(hr)
						{
							hr = pIWMDMStorageControl->Rename(WMDM_MODE_BLOCK,p2,NULL);
							pIWMDMStorageControl->Release();
							if (SUCCEEDED(hr))
								retval=FS_FILE_OK;
						} 
						ReleaseInterfaceWarn(pIStorageFile);
					}
				}
			} else if (wcscmp(p+1,p2+1)==0) {
				IWMDMStorage* pIStorageFileTarget;
				p[0]='\\';
				hr=GetEnumStorageFromPathName(WOldName,NULL,&pIStorageFile);
				if (SUCCEEDED(hr)) {
					hr=GetEnumStorageFromPathName(WNewName,NULL,&pIStorageFileTarget);  // just the path!
					if (SUCCEEDED(hr)) {
						IWMDMStorageControl* pIWMDMStorageControl;
						hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
							(void**)&pIWMDMStorageControl);
						if SUCCEEDED(hr)
						{
							hr = pIWMDMStorageControl->Move(WMDM_MODE_BLOCK | WMDM_STORAGECONTROL_INSERTINTO,
								pIStorageFileTarget,NULL);
							pIWMDMStorageControl->Release();
							if (SUCCEEDED(hr)) {
								retval=FS_FILE_OK;
							} else
								retval=hr;
						}
						ReleaseInterfaceWarn(pIStorageFileTarget);
					}
					ReleaseInterfaceWarn(pIStorageFile);
				}
			}
			if (retval==FS_FILE_OK) {
				WCHAR buf1[wdirtypemax];
				wcslcpy(buf1,L"RNFR ",wdirtypemax-1);
				wcslcat(buf1,OldName,wdirtypemax-1);
				LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
				wcslcpy(buf1,L"RNTO ",wdirtypemax-1);
				wcslcat(buf1,NewName,wdirtypemax-1);
				LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
				return retval;
			}
		}
	} else {
		return FS_FILE_NOTSUPPORTED;
	}

	if (retval!=FS_FILE_OK) {
		switch(retval) {
			case E_NOTIMPL:
				return FS_FILE_NOTSUPPORTED;
			case WMDM_E_INTERFACEDEAD:
				return FS_FILE_NOTFOUND;
//			case ERROR_FILE_EXISTS:
//				return FS_FILE_EXISTS;
			default:
				return FS_FILE_WRITEERROR;
		}
	}

	err=ProgressProcT(PluginNumber,OldName,NewName,100);
	if (err)
		return FS_FILE_USERABORT;
	else {
		wcslcat(buf1,OldName,wdirtypemax-1);
		wcslcat(buf1,L"->",wdirtypemax-1);
		wcslcat(buf1,NewName,wdirtypemax-1);
		LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
		return FS_FILE_OK;
	}
}

int __stdcall FsGetFile(char* RemoteName,char* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
	WCHAR RemoteNameW[wdirtypemax],LocalNameW[wdirtypemax],OldLocalNameW[wdirtypemax];
	int ret=FsGetFileW(awfilenamecopy(RemoteNameW,RemoteName),awfilenamecopy(LocalNameW,LocalName),CopyFlags,ri);
	// A conversion may cause a name change
	if (ret==0 && wcscmp(LocalNameW,OldLocalNameW)!=0) {
		wafilenamecopy(LocalName,LocalNameW);
	}
	return ret;
}

int __stdcall FsGetFileW(WCHAR* RemoteName,WCHAR* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
    int err;
	BOOL OverWrite,Resume,Move;

	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;

	if (RemoteName[0]!='\\')
		return FS_FILE_NOTFOUND;
	if (Resume)
		return FS_FILE_NOTSUPPORTED;

	if (!OverWrite) {
		WIN32_FIND_DATAW fd;
		HANDLE hd;
		hd=FindFirstFileT(LocalName,&fd);
		if (hd!=INVALID_HANDLE_VALUE) {
			FindClose(hd);
			return FS_FILE_EXISTS;
		}
	}

	err=ProgressProcT(PluginNumber,RemoteName,LocalName,0);
	if (err)
		return FS_FILE_USERABORT;

	if (!InitFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	WCHAR WLocalName[wdirtypemax];
	WCHAR WRemoteName[wdirtypemax];
	HRESULT hr;
	wcslcpy(WLocalName,LocalName,wdirtypemax-1);
	wcslcpy(WRemoteName,RemoteName,wdirtypemax-1);
	IWMDMStorage* pIStorageFile;
	hr=GetEnumStorageFromPathName(WRemoteName,NULL,&pIStorageFile);
	if (SUCCEEDED(hr)) {
		IWMDMStorageControl* pIWMDMStorageControl;
		hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
			(void**)&pIWMDMStorageControl);
		if SUCCEEDED(hr)
		{
			MyWMDMProgress* progr=new MyWMDMProgress;
			progr->SetCopyNames(RemoteName,LocalName);
			hr = pIWMDMStorageControl->Read(
						WMDM_CONTENT_FILE | WMDM_MODE_BLOCK, 
						WLocalName,
						progr, NULL);
			pIWMDMStorageControl->Release();
			progr->Release();
			if (SUCCEEDED(hr)) {
				WMDMDATETIME wdt;
				hr=pIStorageFile->GetDate(&wdt);
				if (SUCCEEDED(hr)) {
					SYSTEMTIME st;
					FILETIME ft;
					if (wdt.wDay!=0 && wdt.wMonth!=0 && wdt.wYear!=0) {
						st.wDay=wdt.wDay;
						st.wMonth=wdt.wMonth;
						st.wYear=wdt.wYear;
						st.wMilliseconds=0;
						st.wHour=wdt.wHour;
						st.wMinute=wdt.wMinute;
						st.wSecond=wdt.wSecond;
						SystemTimeToFileTime(&st,&ft);
						HANDLE f=CreateFileT(LocalName,GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
						if (f!=INVALID_HANDLE_VALUE) {
							SetFileTime(f,NULL,NULL,&ft);
							CloseHandle(f);
						}
					}
				}
				ReleaseInterfaceWarn(pIStorageFile);
				WCHAR buf1[wdirtypemax];
				wcslcpy(buf1,L"GET ",wdirtypemax-1);
				wcslcat(buf1,RemoteName,wdirtypemax-1);
				LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
				return S_OK;
			}
		}
		ReleaseInterfaceWarn(pIStorageFile);
	}
	return FS_FILE_READERROR;
}

DWORD GetFormatCodeFromFile(WCHAR* pszFile)
{
    DWORD dwFormatCode = WMDM_FORMATCODE_UNDEFINED;
	WCHAR* p=wcsrchr(pszFile,'\\');
	if (!p)
		p=pszFile;
    WCHAR* pszExtension = wcsrchr(p,'.');
    if (pszExtension)
    {
        if (L'.' == pszExtension[0])
        {
            pszExtension++;
        }
        for (int i = 0; i < ARRAYSIZE(rgExtensionMap); i++)
        {
            //the length of comparison is bounded by strings represented by rgExtensionMap[i].wszExtension             
            if (0 == _wcsicmp(pszExtension, rgExtensionMap[i].wszExtension))
            {
                dwFormatCode = rgExtensionMap[i].formatCode;
                break;
            }
        }
    }
    return(dwFormatCode);
}

int __stdcall FsPutFile(char* LocalName,char* RemoteName,int CopyFlags)
{
	WCHAR RemoteNameW[wdirtypemax],LocalNameW[wdirtypemax],OldRemoteNameW[wdirtypemax];
	int ret=FsPutFileW(awfilenamecopy(LocalNameW,LocalName),awfilenamecopy(RemoteNameW,RemoteName),CopyFlags);
	// A conversion may cause a name change
	if (ret==0 && wcscmp(RemoteNameW,OldRemoteNameW)!=0) {
		wafilenamecopy(RemoteName,RemoteNameW);
	}
	return ret;
}

int __stdcall FsPutFileW(WCHAR* LocalName,WCHAR* RemoteName,int CopyFlags)
{
	WCHAR* unknown=L"unknown";
	int err;
	BOOL OverWrite,Resume,Move;
	int retval=FS_FILE_WRITEERROR;

	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;
	
	if (RemoteName[0]!='\\')
		return FS_FILE_NOTFOUND;

	err=ProgressProcT(PluginNumber,LocalName,RemoteName,0);
	if (err)
		return FS_FILE_USERABORT;
	
	if (!InitFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	WCHAR WLocalName[wdirtypemax],*p,*p2;
	WCHAR WRemoteName[wdirtypemax];
	HRESULT hr,hr1,hr2;
	wcslcpy(WLocalName,LocalName,wdirtypemax);
	wcslcpy(WRemoteName,RemoteName,wdirtypemax);
	IWMDMStorage* pIStorageFile;
	IWMDMEnumStorage* pIEnumStorageFile;
	IWMDMStorage* pIStorage2;
	p=wcsrchr(WRemoteName,'\\');
	p2=wcsrchr(WLocalName,'\\');
	BOOL samefilename=(p && p2 && wcscmp(p,p2)==0);
	{  // no rename!
		p[0]=0;
		p++;
		hr=GetEnumStorageFromPathName(WRemoteName,&pIEnumStorageFile,&pIStorageFile);
		if (SUCCEEDED(hr)) {
			IWMDMStorageControl* pIWMDMStorageControl;
			IWMDMStorageControl3* pIWMDMStorageControl3;
			IWMDMMetaData* pIWMDMMetaData;
			IWMDMStorage3* pIWMDMStorage3;
			// Make sure that there isn't already a file with that name!
			if (NameExistsInEnum(pIEnumStorageFile,p,&pIStorage2)) {
				DWORD dwAttribs=0;
				_WAVEFORMATEX Format;
				pIStorage2->GetAttributes(&dwAttribs,&Format);
				if (dwAttribs & WMDM_FILE_ATTR_FOLDER) {  // do not delete folders!
					pIStorage2->Release();
					pIEnumStorageFile->Release();
					ReleaseInterfaceWarn(pIStorageFile);
					return FS_FILE_WRITEERROR;
				}
				if (OverWrite) {
					// delete it!
					hr = pIStorage2->QueryInterface(IID_IWMDMStorageControl, 
						(void**)&pIWMDMStorageControl);
					if (SUCCEEDED(hr))
						hr = pIWMDMStorageControl->Delete(WMDM_MODE_BLOCK,NULL);
					pIWMDMStorageControl->Release();
					ReleaseInterfaceWarn(pIStorage2);
					if (!SUCCEEDED(hr)) {
						ReleaseInterfaceWarn(pIEnumStorageFile);
						ReleaseInterfaceWarn(pIStorageFile);
						return FS_FILE_WRITEERROR;
					}
				} else {
					ReleaseInterfaceWarn(pIStorage2);
					ReleaseInterfaceWarn(pIEnumStorageFile);
					ReleaseInterfaceWarn(pIStorageFile);
					return FS_FILE_EXISTS;
				}
			}

			hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
				(void**)&pIWMDMStorageControl);
			if SUCCEEDED(hr)
			{
				MyWMDMProgress* progr=new MyWMDMProgress;
				progr->SetCopyNames(LocalName,RemoteName);
				// http://ureader.com/message/1341155.aspx
				//  I found a very IMPORTANT thing about IWMDMStorageControl->Insert,
				//  this method should be replaced with IWMDMStorageControl3->Insert3.
				//  
				//  The reason is : IWMDMStorageControl->Insert just support the portable
				//  devices which is compatible with WMP9, but not WMP10.
				//  The structure in WMP10 is totally changed, and we can not use 
				//  IWMDMStorageControl->Insert to insert WMA or MP3 files to make device
				//  accept it. Even the file was inserted, we will never see the file listed in 
				//  the file list of device.......
				hr1 = pIWMDMStorageControl->QueryInterface(IID_IWMDMStorageControl3,
					(void**)&pIWMDMStorageControl3);
				hr2 = pIStorageFile->QueryInterface(IID_IWMDMStorage3,
						(void**)&pIWMDMStorage3);
				if SUCCEEDED(hr2) {
					hr2 = pIWMDMStorage3->CreateEmptyMetadataObject(&pIWMDMMetaData);
					if (!SUCCEEDED(hr2))
						pIWMDMStorage3->Release();
					else {
						DWORD dw = GetFormatCodeFromFile(p);
						pIWMDMMetaData->AddItem(WMDM_TYPE_DWORD, g_wszWMDMFormatCode, (BYTE*)&dw, sizeof(dw));

						HANDLE f=CreateFileT(LocalName,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
						if (f!=INVALID_HANDLE_VALUE) {
							FILETIME ft;
							SYSTEMTIME st;
							WMDMDATETIME timestamp;
							GetFileTime(f,NULL,NULL,&ft);
							FileTimeToSystemTime(&ft,&st);
							CloseHandle(f);
							timestamp.wDay=st.wDay;
							timestamp.wMonth=st.wMonth;
							timestamp.wYear=st.wYear;
							timestamp.wHour=st.wHour;
							timestamp.wMinute=st.wMinute;
							timestamp.wSecond=st.wSecond;
							pIWMDMMetaData->AddItem(WMDM_TYPE_DATE, g_wszWMDMLastModifiedDate, (BYTE *)&timestamp, sizeof(timestamp));
							pIWMDMMetaData->AddItem(WMDM_TYPE_DATE, g_wszWMDMUserLastPlayTime, (BYTE *)&timestamp, sizeof(timestamp));
							pIWMDMMetaData->AddItem(WMDM_TYPE_DATE, g_wszWMDMAuthorDate, (BYTE *)&timestamp, sizeof(timestamp));
						}
						// Try to get meta data from ID3 tags. If it fails, set them by name
						hr = GetMetaDataFromWMFSDK(WLocalName, pIWMDMMetaData);
						if (!SUCCEEDED(hr) && dw!=WMDM_FORMATCODE_UNDEFINED) {
							WCHAR *p1,*p2,*p3;
							p1=wcsrchr(p,'\\');
							if (p1) p1++; else p1=p;
							p3=wcsrchr(p1,'.');   // remove extension
							if (p3)
								p3[0]=0;
							p2=wcsstr(p,L" - ");
							if (p2) {
								p2[0]=0;
								pIWMDMMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMTitle, (BYTE *)(p2+3),(wcslen(p2+3)+1)*2);
								pIWMDMMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMAuthor, (BYTE *)p1,(wcslen(p1)+1)*2);
								p2[0]=' ';
							} else {   // just the title
								pIWMDMMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMTitle, (BYTE *)p1, (wcslen(p1)+1)*2);
								pIWMDMMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMAuthor, (BYTE *)unknown,(wcslen(unknown)+1)*2);
							}
							// use current date as album title!
							WCHAR buf[16];
							SYSTEMTIME systime;
							GetLocalTime(&systime);
							swprintf(buf,15,L"%04u%02u%02u",systime.wYear,systime.wMonth,systime.wDay);

							pIWMDMMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMAlbumTitle, (BYTE *)buf,(wcslen(buf)+1)*2);
							if (p3)
								p3[0]='.';
						}
					}
				}
				pIStorage2=NULL;
				if (SUCCEEDED(hr1) && SUCCEEDED(hr2)) {
					hr = pIWMDMStorageControl3->Insert3(
						WMDM_CONTENT_FILE | WMDM_MODE_BLOCK,
						0,
						WLocalName,
						p,
						NULL,
						progr,
						pIWMDMMetaData,
						NULL,
						&pIStorage2);
				} else if (samefilename) {
					hr = pIWMDMStorageControl->Insert(
						WMDM_CONTENT_FILE | WMDM_MODE_BLOCK | WMDM_STORAGECONTROL_INSERTINTO, 
						WLocalName,
						NULL, progr, 
						&pIStorage2);
				} else
					hr=E_FAIL;     // pIWMDMStorageControl cannot rename
				if SUCCEEDED(hr1)
					pIWMDMStorageControl3->Release();
				if SUCCEEDED(hr2) {
					pIWMDMMetaData->Release();
					pIWMDMStorage3->Release();
				}
				ReleaseInterfaceWarn(progr);
				pIWMDMStorageControl->Release();
				if (SUCCEEDED(hr)) {
					WCHAR buf1[wdirtypemax];
					wcslcpy(buf1,L"PUT ",wdirtypemax-1);
					wcslcat(buf1,RemoteName,wdirtypemax-1);
					LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
					ReleaseInterfaceWarn(pIStorage2);
					retval=S_OK;
				}
			}
			ReleaseInterfaceWarn(pIEnumStorageFile);
			ReleaseInterfaceWarn(pIStorageFile);
		}
	}
	return retval;
}

BOOL __stdcall FsDeleteFile(char* RemoteName)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsDeleteFileW(awfilenamecopy(RemoteNameW,RemoteName));
}

BOOL __stdcall FsDeleteFileW(WCHAR* RemoteName)
{
	if (RemoteName[0]!='\\')
		return false;

	InitFunctionsIfNeeded(TRUE);

	WCHAR wcSearch[wdirtypemax];
	HRESULT hr;
	wcslcpy(wcSearch,RemoteName,wdirtypemax-1);
	int l=wcslen(wcSearch)-1;
	if (wcSearch[l]=='\\')
		wcSearch[l]=0;
	IWMDMStorage* pIStorageFile;
	hr=GetEnumStorageFromPathName(wcSearch,NULL,&pIStorageFile);
	if (SUCCEEDED(hr)) {
		IWMDMStorageControl* pIWMDMStorageControl;
		hr = pIStorageFile->QueryInterface(IID_IWMDMStorageControl, 
			(void**)&pIWMDMStorageControl);
		if SUCCEEDED(hr)
		{
			hr = pIWMDMStorageControl->Delete(WMDM_MODE_BLOCK,NULL);
			pIWMDMStorageControl->Release();
			ReleaseInterfaceWarn(pIStorageFile);
			if SUCCEEDED(hr) {
				WCHAR buf1[wdirtypemax];
				wcslcpy(buf1,L"DEL ",wdirtypemax-1);
				wcslcat(buf1,RemoteName,wdirtypemax-1);
				LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
			}
			return SUCCEEDED(hr);
		}
		ReleaseInterfaceWarn(pIStorageFile);
	}
	return false;
}

BOOL __stdcall FsRemoveDir(char* RemoteName)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsRemoveDirW(awfilenamecopy(RemoteNameW,RemoteName));
}

BOOL __stdcall FsRemoveDirW(WCHAR* RemoteName)
{
	if (RemoteName[0]!='\\')
		return false;
	return FsDeleteFileW(RemoteName);
}

void __stdcall FsGetDefRootName(char* DefRootName,int maxlen)
{
	strlcpy(DefRootName,DefPluginTitle,maxlen-1);
}

