//
// Helper functions to extract metadata from WMF SDK
// From Microsoft sample "wmdmapp"
// 
#include <windows.h>
#include <stdlib.h>
#include <shellapi.h>
#include <wchar.h>
#include "MSWMDM.h"   // Include headers for Windows Media Device Manager.
#include "wmsstd.h"
#include <wmsdk.h>
#include "fsplugin.h"

extern tLogProc LogProc;
extern int PluginNumber;


HRESULT GetPropertyFromWMFSDK(IWMHeaderInfo *pHeaderInfo, 
					    LPCWSTR pwszName,
					    BYTE **ppBuf,
					    WORD *pBufSize,
						WMT_ATTR_DATATYPE *proptype)
{
	HRESULT hr         = S_OK ;
	WORD    nstreamNum = 0 ;
	WORD    cbLength   = 0 ;
	BYTE* pValue       = NULL;
	WMT_ATTR_DATATYPE type ;

	hr = pHeaderInfo->GetAttributeByName( &nstreamNum,
					      pwszName,
					      &type,
					      NULL,
					      &cbLength );

	if ( FAILED( hr ) && hr != ASF_E_NOTFOUND )
	{
		*pBufSize = 0;
		return hr;
	}

	if ( cbLength == 0)
	{
	    *pBufSize = 0;
		return hr;
	}

	if (proptype)
		*proptype=type;

	if(WMT_TYPE_STRING == type || WMT_TYPE_BINARY == type)
	{
		*ppBuf = (BYTE *)new BYTE[cbLength];

		if ( NULL == *ppBuf )
	   	{
			return E_OUTOFMEMORY;
		}
	} else if (cbLength>*pBufSize)   // don't copy too much data if the preallocated buffer is smaller!
		cbLength=*pBufSize;

	nstreamNum = 0;
	hr = pHeaderInfo->GetAttributeByName( &nstreamNum,
					      pwszName,
					      &type,
					      *ppBuf,
					      &cbLength );

	if (FAILED(hr) && (WMT_TYPE_STRING == type || WMT_TYPE_BINARY == type))
	{
		*pBufSize = 0;
	    delete [] *ppBuf;
	}
	else
	{
	    *pBufSize = cbLength;
	}

	return hr;

}

#define	fFalse		0

#define	CORg(hResult)\
	do\
		{\
		hr = (hResult);\
        if (FAILED(hr))\
            {\
            goto Error;\
            }\
		}\
	while (fFalse)

HRESULT CopyStringProperty(IWMHeaderInfo* pHeaderInfo,IWMDMMetaData *pMetaData,
						  LPCWSTR g_wszWM,LPCWSTR g_wszWMDM)
{
	WCHAR *Name;
	WORD size=0;
	Name = NULL;
	HRESULT hr2 = GetPropertyFromWMFSDK( pHeaderInfo, g_wszWM,(BYTE **)&Name, &size,NULL);
	if(SUCCEEDED(hr2) )
	{
	    pMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDM, (BYTE *)Name, size) ;
	    SAFE_ARRAY_DELETE(Name);
	}
	return hr2;
}

WMDM_TAG_DATATYPE ConvertDataTypeName(WMT_ATTR_DATATYPE proptype)
{
	switch (proptype) {
		case WMT_TYPE_DWORD:return WMDM_TYPE_DWORD; break;
		case WMT_TYPE_STRING:return  WMDM_TYPE_STRING; break;
		case WMT_TYPE_BINARY:return  WMDM_TYPE_BINARY; break;
		case WMT_TYPE_BOOL:return WMDM_TYPE_BOOL; break;
		case WMT_TYPE_QWORD:return WMDM_TYPE_QWORD; break;
		case WMT_TYPE_WORD:return WMDM_TYPE_WORD; break;
		case WMT_TYPE_GUID:return WMDM_TYPE_GUID; break;
	}
	return WMDM_TYPE_DWORD;
}

HRESULT CopyProperty(IWMHeaderInfo* pHeaderInfo,IWMDMMetaData *pMetaData,
						  LPCWSTR g_wszWM,LPCWSTR g_wszWMDM)
{
	WCHAR *Name;
	DWORD dwData;
	WCHAR defbuf[4];   //8 bytes default buffer
	WORD size=8;
	WMT_ATTR_DATATYPE proptype;
	Name = defbuf;
	HRESULT hr2 = GetPropertyFromWMFSDK( pHeaderInfo, g_wszWM,(BYTE **)&Name, &size, &proptype);
	if(SUCCEEDED(hr2) )
	{
		if ((g_wszWM==g_wszWMTrackNumber || g_wszWM==g_wszWMTrack) && proptype==WMT_TYPE_STRING) {
			// detect strings in the form "11/12" !
			WCHAR* p=Name;
			while (p[0]>='0' && p[0]<='9')
				p++;
			if (p[0])
				p[0]=0;
			dwData=_wtoi(Name);     // convert it to a DWORD!
			SAFE_ARRAY_DELETE(Name);
			Name=(WCHAR*)&dwData;
			size=4;
			proptype=WMT_TYPE_DWORD;
		}
	    pMetaData->AddItem(ConvertDataTypeName(proptype), g_wszWMDM, (BYTE *)Name, size) ;
		if (proptype==WMDM_TYPE_STRING || proptype==WMDM_TYPE_BINARY)
			SAFE_ARRAY_DELETE(Name);
	}
	return hr2;
}

HRESULT GetMetaDataFromWMFSDK(LPWSTR pwszFileName, 
			      IWMDMMetaData *pMetaData
			      )
{
	WCHAR* unknown=L"unknown";
	WORD   size = 0;
	HRESULT hr = S_OK;
	HRESULT hr2 = S_OK;
	IWMMetadataEditor* pEditor      = NULL;
	IWMHeaderInfo*     pHeaderInfo  = NULL; 

	WCHAR *Name;
	BYTE *Data;
	
    DWORD dwBitrate = 0;
	QWORD qdwDuration = 0;
	BOOL fIsProtected = false;
	BOOL *pfIsProtected = &fIsProtected;
	DWORD dwTrack = 0;
	DWORD *pdwTrack = &dwTrack;
	DWORD *pdwBitrate = &dwBitrate;
	QWORD *pqdwDuration = &qdwDuration;
	
	CORg(WMCreateEditor( &pEditor ));

	CORg(pEditor->Open( pwszFileName ) );

	CORg(pEditor->QueryInterface( IID_IWMHeaderInfo, ( void ** ) &pHeaderInfo ) );

	// Return S_OK if just the title is there!
	hr = CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMTitle,g_wszWMDMTitle);

	hr2 = CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMAuthor,g_wszWMDMAuthor);
	if(!SUCCEEDED(hr2)) {
	    pMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMAuthor, (BYTE *)unknown,(wcslen(unknown)+1)*2);
	}

	if(!SUCCEEDED(CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMAlbumTitle,g_wszWMDMAlbumTitle)))
	{
		WCHAR buf[16];     // use the system time for the Album title
		SYSTEMTIME systime;
		GetLocalTime(&systime);
		swprintf(buf,15,L"%04u%02u%02u",systime.wYear,systime.wMonth,systime.wDay);
		pMetaData->AddItem(WMDM_TYPE_STRING, g_wszWMDMAlbumTitle, (BYTE *)buf,(wcslen(buf)+1)*2);
	}

	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMGenre,g_wszWMDMGenre);
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMYear,g_wszWMDMYear);
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMAlbumArtist,g_wszWMDMAlbumArtist);
	
	// Duration: Quad word!
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMDuration,g_wszWMDMDuration);
	// Protected flag (DWORD)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMProtected,g_wszWMDMIsProtected);
	// Bitrate (DWORD)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMBitrate,g_wszWMDMBitrate);
	// Rating (DWORD)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMRating,g_wszWMDMUserRating);
	// Track (DWORD)
	if (!SUCCEEDED(CopyProperty(pHeaderInfo,pMetaData,g_wszWMTrack,g_wszWMDMTrack)))
		CopyProperty(pHeaderInfo,pMetaData,g_wszWMTrackNumber,g_wszWMDMTrack);
	{
		char buf[200];
		WCHAR Data[4];
		WORD size=0;
		WCHAR *pData = Data;
		HRESULT hr2 = GetPropertyFromWMFSDK( pHeaderInfo, g_wszWMTrack, (BYTE **)&pData, &size,NULL);
		if(SUCCEEDED(hr2)) {
			wsprintf(buf,"WMTrack: %S",pData);
			LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf);
		}
		hr2 = GetPropertyFromWMFSDK( pHeaderInfo, g_wszWMTrackNumber, (BYTE **)&pData, &size,NULL);
		if(SUCCEEDED(hr2)) {
			wsprintf(buf,"WMTrackNumber: %S",pData);
			LogProc(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf);
		}
	}

	// Rating (type DWORD)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMRating,g_wszWMDMUserRating);
	// Video width (type DWORD)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMVideoWidth,g_wszWMDMWidth);
	// Video height (type DWORD )
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMVideoHeight,g_wszWMDMHeight);
	// Codec (type DWORD)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMCodec,g_wszAudioWAVECodec);
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMCodec,g_wszVideoFourCCCodec);

	// Composer (type string)
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMComposer,g_wszWMDMComposer);
	// Copyright (type string)
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMCopyright,g_wszWMDMProviderCopyright);
	// Description (type string)
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMDescription,g_wszWMDMDescription);
	// Parental rating (type STRING)
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMParentalRating,g_wszWMDMParentalRating);
	// Radio station name (type STRING)
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMRadioStationName,g_wszWMDMMediaStationName);
	// TV episode title (type STRING)
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMSubTitle,g_wszWMDMSubTitle);
	// Track mood (type STRING)
	CopyStringProperty(pHeaderInfo,pMetaData,g_wszWMMood,g_wszWMDMTrackMood);
	// Cover (type BINARY)
	//g_wszWMPicture ID3v2.2: PIC, ID3v2.3/v2.4: APIC
	//See: http://msdn2.microsoft.com/en-us/library/aa386866(VS.85).aspx
	CopyProperty(pHeaderInfo,pMetaData,g_wszWMPicture,g_wszWMDMAlbumCoverData);
	pEditor->Close();

Error:
	SAFE_RELEASE( pHeaderInfo ) ;
	SAFE_RELEASE( pEditor ) ;

	return hr;
}


