// wincefs.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "fsplugin.h"
#include "ceconvert.h"
#include "utils.h"
#include "cunicode.h"
#include "rapifuncimp.h"

#define DefPluginTitle "WinCE Device"

// set the following to 0 if the plugin should support on the fly conversion!
int defconversionsflag=-1;

tProgressProc ProgressProc;
tLogProc LogProc;
tRequestProc RequestProc;
tProgressProcW ProgressProcW;
tLogProcW LogProcW;
tRequestProcW RequestProcW;
int PluginNumber;
char defininame[MAX_PATH]={0};
HINSTANCE hinst=NULL;

// for block size smooth change
#define MIN_READ_BLOCK_SIZE 2048
#define MIN_WRITE_BLOCK_SIZE 2048
// End for block size smooth change

// These two are global across threads
// The size is set so a block takes about 1 second to finish
int LastDownloadBlockSize=MIN_READ_BLOCK_SIZE;
int LastUploadBlockSize=MIN_WRITE_BLOCK_SIZE;

BOOL ceinitialized=FALSE;
BOOL oleinitialized=FALSE;
int conversionsflag=defconversionsflag;      //0: ask, 1:do, -1 don't convert
BOOL wantconverrors=true;

BOOL InitCeFunctionsIfNeeded(BOOL trueconnect)
{
	if(ceinitialized)
		return TRUE;

	if (!LoadRapiDll())
		return false;
	RAPIINIT rpi;
	rpi.cbSize=sizeof(RAPIINIT);
	rpi.heRapiInit=NULL;
	rpi.hrRapiInit=0;
	if (SUCCEEDED(CeRapiInitEx(&rpi))) {
		if (WaitForSingleObject(rpi.heRapiInit,5000)!=WAIT_OBJECT_0) {
			CeRapiUninit();
			MessageBeep(MB_ICONSTOP);
			return FALSE;
		} else {
			if (!SUCCEEDED(rpi.hrRapiInit)) {
				CeRapiUninit();
				MessageBeep(MB_ICONSTOP);
				return FALSE;
			} else {
				ceinitialized=TRUE;
				char buf1[MAX_PATH];
				strcpy(buf1,"CONNECT \\");   //very important: Message MUST be
				if (trueconnect)             //CONNECT Full path!!!
					LogProc(PluginNumber,MSGTYPE_CONNECT,buf1);
				return TRUE;
			}
		}
	} else
		return FALSE;
}

void FreeCeFunctions()
{
	if (ceinitialized) {
		CeRapiUninit();
		ceinitialized=FALSE;
	}
}

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	if (ul_reason_for_call==DLL_PROCESS_ATTACH) {
		hinst=(HINSTANCE)hModule;
	} else if (ul_reason_for_call==DLL_PROCESS_DETACH) {
		FreeCeFunctions();
		if (oleinitialized)
			CoUninitialize();
	}
    return TRUE;
}

int __stdcall FsInit(int PluginNr,tProgressProc pProgressProc,tLogProc pLogProc,tRequestProc pRequestProc)
{
	PluginNumber=PluginNr;
	ProgressProc=pProgressProc;
    LogProc=pLogProc;
    RequestProc=pRequestProc;
	return 0;
}

int __stdcall FsInitW(int PluginNr,tProgressProcW pProgressProcW,tLogProcW pLogProcW,tRequestProcW pRequestProcW)
{
	PluginNumber=PluginNr;
	ProgressProcW=pProgressProcW;
    LogProcW=pLogProcW;
    RequestProcW=pRequestProcW;
	return 0;
}

typedef struct {
	WCHAR PathW[wdirtypemax];
	WCHAR LastFoundNameW[wdirtypemax];
    LPCE_FIND_DATA pFindDataArray;
	DWORD dwFoundCount;
	DWORD dwLastUsed;
} tLastFindStuct,*pLastFindStuct;

BOOL __stdcall FsDisconnect(char* DisconnectRoot)
{
	FreeCeFunctions();
	char buf1[MAX_PATH];
	strcpy(buf1,"DISCONNECT ");
	strlcat(buf1,DisconnectRoot,MAX_PATH-1);
	LogProc(PluginNumber,MSGTYPE_DISCONNECT,buf1);
	conversionsflag=defconversionsflag;
	wantconverrors=true;
	return TRUE;
}

HANDLE __stdcall FsFindFirstW(WCHAR* Path,WIN32_FIND_DATAW *FindDataW)
{
	WCHAR buf[wdirtypemax];
	pLastFindStuct lf;
	
	memset(FindDataW,0,sizeof(WIN32_FIND_DATAW));
	if (Path[0]=='\\') {
		if (!InitCeFunctionsIfNeeded(TRUE)) {
			return INVALID_HANDLE_VALUE;
		}

		wcslcpy(buf,Path,wdirtypemax-1);           // incl. Backslash!
		wcslcatbackslash(buf,wdirtypemax-1);
		wcslcat(buf,L"*.*",wdirtypemax-1);

		LPCE_FIND_DATA pFindDataArray;

		BOOL found;
		DWORD dwFoundCount;

		for (int i=0;i<2;i++) {
			__try {
				found=CeFindAllFiles(buf,FAF_ATTRIBUTES | FAF_LASTWRITE_TIME |
				  FAF_SIZE_HIGH | FAF_SIZE_LOW | FAF_NAME,
				  &dwFoundCount,&pFindDataArray);

			} 
			__except(TRUE) {
				found=false;
				break;
			}
			if (found)
				break;
			else if (i==0) {           // re-init just in case the connection was lost
				FreeCeFunctions();
				InitCeFunctionsIfNeeded(FALSE);
			}
		}
		if (found) {
			WCHAR buf1[wdirtypemax];
			wcscpy(buf1,L"GET DIR ");
			wcslcat(buf1,buf,wdirtypemax-1);
			LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);

			if (dwFoundCount==0) {
				CeRapiFreeBuffer(pFindDataArray);
				SetLastError(ERROR_NO_MORE_FILES);
				return INVALID_HANDLE_VALUE;
			}

			wcslcpy(FindDataW->cFileName,pFindDataArray[0].cFileName,wdirtypemax-1);
			FindDataW->dwFileAttributes=pFindDataArray[0].dwFileAttributes;
			FindDataW->ftLastWriteTime=pFindDataArray[0].ftLastWriteTime;
			FindDataW->nFileSizeHigh=pFindDataArray[0].nFileSizeHigh;
			FindDataW->nFileSizeLow=pFindDataArray[0].nFileSizeLow;

			lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
			wcscpy(lf->PathW,buf);
			lf->pFindDataArray=pFindDataArray;
			lf->dwFoundCount=dwFoundCount;
			lf->dwLastUsed=0;
			return (HANDLE)lf;
		}
	}
	SetLastError(ERROR_PATH_NOT_FOUND);
	return INVALID_HANDLE_VALUE;
}

HANDLE __stdcall FsFindFirst(char* Path,WIN32_FIND_DATA *FindData)
{
	WCHAR PathW[wdirtypemax];
	WIN32_FIND_DATAW FindDataW;
	HANDLE h=FsFindFirstW(awfilenamecopy(PathW,Path),&FindDataW);
	if (h!=INVALID_HANDLE_VALUE)
		copyfinddatawa(FindData,&FindDataW);
	return h;
}

BOOL __stdcall FsFindNextW(HANDLE Hdl,WIN32_FIND_DATAW *FindDataW)
{
	pLastFindStuct lf;

	if ((int)Hdl==1)
		return false;

	lf=(pLastFindStuct)Hdl;
	if (lf->pFindDataArray) {
		lf->dwLastUsed++;
		if (lf->dwLastUsed<lf->dwFoundCount) {
			DWORD dw=lf->dwLastUsed;
			
			memset(FindDataW,0,sizeof(WIN32_FIND_DATAW));
			wcslcpy(FindDataW->cFileName,lf->pFindDataArray[dw].cFileName,wdirtypemax-1);
			FindDataW->dwFileAttributes=lf->pFindDataArray[dw].dwFileAttributes; //| 0x80000000;
//			FindData->dwReserved0=0x7F;
			FindDataW->ftLastWriteTime=lf->pFindDataArray[dw].ftLastWriteTime;
			FindDataW->nFileSizeHigh=lf->pFindDataArray[dw].nFileSizeHigh;
			FindDataW->nFileSizeLow=lf->pFindDataArray[dw].nFileSizeLow;
			return true;
		}
	}
	return false;
}

BOOL __stdcall FsFindNext(HANDLE Hdl,WIN32_FIND_DATA *FindData)
{
	WIN32_FIND_DATAW FindDataW;
	BOOL ret=FsFindNextW(Hdl,&FindDataW);
	if (ret)
		copyfinddatawa(FindData,&FindDataW);
	return ret;
}

int __stdcall FsFindClose(HANDLE Hdl)
{
	if ((int)Hdl==1)
		return 0;
	pLastFindStuct lf;
	lf=(pLastFindStuct)Hdl;
	if (lf->pFindDataArray) {
		CeRapiFreeBuffer(lf->pFindDataArray);
		lf->pFindDataArray=NULL;
	}
	free(lf);
	return 0;
}

BOOL __stdcall FsMkDirW(WCHAR* Path)
{
	if (Path[0]!='\\')
		return false;

	InitCeFunctionsIfNeeded(TRUE);
	return CeCreateDirectory(Path,NULL);
}

BOOL __stdcall FsMkDir(char* Path)
{
	WCHAR PathW[wdirtypemax];
	if (Path[0]!='\\')
		return false;
	return FsMkDirW(awfilenamecopy(PathW,Path));
}

int __stdcall FsExecuteFile(HWND MainWin,char* RemoteName,char* Verb)
{
	if (RemoteName[0]!='\\')
		return FS_EXEC_ERROR;
	WCHAR RemoteNameW[wdirtypemax],VerbW[wdirtypemax];
	return FsExecuteFileW(MainWin,awfilenamecopy(RemoteNameW,RemoteName),awfilenamecopy(VerbW,Verb));
}

INT_PTR CALLBACK PropDlgProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
	RECT rt1,rt2;
	int w,h,DlgWidth,DlgHeight,NewPosX,NewPosY;

	switch (Message) {
		case WM_INITDIALOG: {
			switch (defconversionsflag) {
			case 0:
				CheckDlgButton(hWnd,IDC_CONVASK,BST_CHECKED);
				break;
			case 1:
				CheckDlgButton(hWnd,IDC_CONVYES,BST_CHECKED);
				break;
			case -1:
				CheckDlgButton(hWnd,IDC_CONVNO,BST_CHECKED);
				break;
			}
			// trying to center the About dialog
			if (GetWindowRect(hWnd, &rt1) && GetWindowRect(GetParent(hWnd), &rt2)) {
				w=rt2.right-rt2.left;
				h=rt2.bottom-rt2.top;
				DlgWidth   = rt1.right - rt1.left;
				DlgHeight   = rt1.bottom - rt1.top ;
				NewPosX      =rt2.left + (w - DlgWidth)/2;
				NewPosY      =rt2.top + (h - DlgHeight)/2;
				SetWindowPos(hWnd, 0, NewPosX, NewPosY,
					0, 0, SWP_NOZORDER | SWP_NOSIZE);
			}
			return 1;
			break;
		}
		case WM_COMMAND: {
			char abuf[32];
			switch(LOWORD(wParam)) {
				case IDOK:
					if (IsDlgButtonChecked(hWnd,IDC_CONVASK))
						defconversionsflag=0;
					else if (IsDlgButtonChecked(hWnd,IDC_CONVYES))
						defconversionsflag=1;
					else
						defconversionsflag=-1;
					conversionsflag=defconversionsflag;
					itoa(defconversionsflag,abuf,10);
					WritePrivateProfileString("CECMD","CEConvertFormat",abuf,defininame);
					EndDialog(hWnd, IDOK);
					return 1;
				case IDCANCEL:
					EndDialog(hWnd, IDCANCEL);
					return 1;
			}
		}
	}
	return 0;
}

int __stdcall FsExecuteFileW(HWND MainWin,WCHAR* RemoteName,WCHAR* Verb)
{
	char VerbA[wdirtypemax],RemoteNameA[wdirtypemax];
	WCHAR wbuf[wdirtypemax];

	if (RemoteName[0]!='\\')
		return FS_EXEC_ERROR;
	
	if (wcsicmp(Verb,L"open")==0) {
		WCHAR* p=wcsrchr(RemoteName,'.');
		if (p && wcsicmp(p,L".lnk")==0) { // A shortcut?
			InitCeFunctionsIfNeeded(TRUE);

			if (CeSHGetShortcutTarget(RemoteName,wbuf,wdirtypemax-1)) {
				WCHAR* wp=wbuf;
				if (wp[0]=='"') {    // Remove double quotes
					wp++;
					WCHAR *wpend=wp+wcslen(wp)-1;
					if (wpend[0]=='"')
						wpend[0]=0;
				}
				DWORD attr=CeGetFileAttributes(wp);
				if (attr!=0xFFFFFFFF && (attr & FILE_ATTRIBUTE_DIRECTORY)) {
					wcslcpy(RemoteName,wp,wdirtypemax-1);
					return FS_EXEC_SYMLINK;
				} else
					return FS_EXEC_ERROR;  // can't execute linked docs
			}
		}
		return FS_EXEC_YOURSELF;
	} else if (wcsicmp(Verb,L"properties")==0) {
		if (wcscmp(RemoteName,L"\\")==0) {
			DialogBox(hinst,MAKEINTRESOURCE(IDD_SETTINGS),MainWin,PropDlgProc);
			return FS_EXEC_OK;
		} else
			return FS_EXEC_YOURSELF;
	} else if (wcsnicmp(Verb,L"quote ",6)==0) {
		MessageBox(MainWin,wafilenamecopy(VerbA,Verb),"Quote verb not supported!",MB_ICONEXCLAMATION);
		return FS_EXEC_ERROR;
	} else if (wcsnicmp(Verb,L"chmod ",6)==0) {
		MessageBox(MainWin,wafilenamecopy(RemoteNameA,Verb),"Chmod verb not supported!",MB_ICONEXCLAMATION);
		return FS_EXEC_ERROR;
	} else
		return FS_EXEC_ERROR;
}

int __stdcall FsRenMovFileW(WCHAR* OldName,WCHAR* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	if (OldName[0]!='\\'  || NewName[0]!='\\')
		return FS_FILE_NOTFOUND;

	int err=ProgressProcT(PluginNumber,OldName,NewName,0);
	if (err)
		return FS_FILE_USERABORT;

	InitCeFunctionsIfNeeded(TRUE);

	WCHAR buf1[wdirtypemax];
	if (Move) 
		wcscpy(buf1,L"MOVE ");
	else
		wcscpy(buf1,L"COPY ");

	int retval=FS_FILE_NOTFOUND;

	if (Move) {
		if (OverWrite)
			CeDeleteFile(NewName);
		if (CeMoveFile(OldName,NewName))
			retval=FS_FILE_OK;
	} else {
		if (CeCopyFile(OldName,NewName,!OverWrite))
			retval=FS_FILE_OK;
	}

	if (retval!=FS_FILE_OK) {
		switch(CeGetLastError()) {
			case ERROR_FILE_NOT_FOUND:
			case ERROR_PATH_NOT_FOUND:
			case ERROR_ACCESS_DENIED:
				return FS_FILE_NOTFOUND;
			case ERROR_FILE_EXISTS:
				return FS_FILE_EXISTS;
			default:
				return FS_FILE_WRITEERROR;
		}
	}
	err=ProgressProcT(PluginNumber,OldName,NewName,100);
	if (err)
		return FS_FILE_USERABORT;
	else {
		wcslcat(buf1,OldName,wdirtypemax-1);
		wcslcat(buf1,L"->",wdirtypemax-1);
		wcslcat(buf1,NewName,wdirtypemax-1);
		LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);
		return FS_FILE_OK;
	}
}

int __stdcall FsRenMovFile(char* OldName,char* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	WCHAR NewNameW[wdirtypemax],OldNameW[wdirtypemax];
	return FsRenMovFileW(awfilenamecopy(OldNameW,OldName),awfilenamecopy(NewNameW,NewName),Move,OverWrite,ri);
}

#define partblocksz (1024*1024)

typedef struct {
	WCHAR* LocalName;
	WCHAR* RemoteName;
	int CopyFlags;
	int Percent;
	RemoteInfoStruct* ri;
	bool Aborted;
	bool Finished;
} threaddata,*threaddataptr;

DWORD CheckTimeAndBlockSize(int BlockSize, int time_d, bool WriteData)
{	
	if (time_d<=0)  // time too short to measure -> multiply by 10
		BlockSize= 10*BlockSize;
	else            // 500: Take an average of 0.5 seconds per block
		BlockSize = (int)((BlockSize*500.0)/time_d);		
	BlockSize+=1023;   // for rounding up to next multiple of 1024
	BlockSize=min(BlockSize, partblocksz);  // upper limit
	BlockSize=max(BlockSize, 2048);	          // lower limit
	// multiple of 1024
	BlockSize&=0xfffffC00;
	return BlockSize;
}

DWORD WINAPI DownloadThreadProc(LPVOID lpParameter)
{
	int err;
	BOOL OverWrite,Resume;
	threaddataptr tdp=(threaddataptr)lpParameter;

	OverWrite=tdp->CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=tdp->CopyFlags & FS_COPYFLAGS_RESUME;

	WCHAR wfullname[MAX_PATH];
	wcslcpy(wfullname,tdp->RemoteName,wdirtypemax-1);

	// Open remote file
	HANDLE remotefilehandle = CeCreateFile (wfullname,	
                      GENERIC_READ,           // Open for reading
                      FILE_SHARE_READ|FILE_SHARE_WRITE, // Do not share
                      NULL,                   // No security
                      OPEN_EXISTING,          // Existing file only
                      FILE_ATTRIBUTE_NORMAL,  // Normal file
                      NULL);

	if (remotefilehandle==INVALID_HANDLE_VALUE)
	{
		tdp->Finished = true;
		return FS_FILE_NOTFOUND;
	}

	HANDLE localfilehandle;
	if (Resume) {
		// Open local file
		localfilehandle = CreateFileT(tdp->LocalName,GENERIC_WRITE,0,NULL,
			OPEN_ALWAYS,
			FILE_ATTRIBUTE_NORMAL,NULL);
		if (localfilehandle==INVALID_HANDLE_VALUE) {
			err=GetLastError();
			CeCloseHandle(remotefilehandle);
			if (err=ERROR_FILE_EXISTS)
			{
				tdp->Finished = true;
				return FS_FILE_EXISTS;
			}
			else
			{
				tdp->Finished = true;
				return FS_FILE_WRITEERROR;
		}
		}
	} else {
		// Create local file
		localfilehandle = CreateFileT(tdp->LocalName,GENERIC_WRITE,0,NULL,
			OverWrite ? CREATE_ALWAYS : CREATE_NEW,
			FILE_ATTRIBUTE_NORMAL,NULL);
		if (localfilehandle==INVALID_HANDLE_VALUE) {
			err=GetLastError();
			CeCloseHandle(remotefilehandle);
			if (err=ERROR_FILE_EXISTS)
			{
				tdp->Finished = true;
				return FS_FILE_EXISTSRESUMEALLOWED;
			}
			else
			{
				tdp->Finished = true;
				return FS_FILE_WRITEERROR;
		}
	}
	}

	INT64 totalsize=tdp->ri->SizeHigh;
	totalsize=totalsize << 32 | tdp->ri->SizeLow;
	INT64 totalcopied=0;

	if (Resume) {
		DWORD seeklow;
		LONG seekhigh=0;
		seeklow=SetFilePointer(localfilehandle,0,&seekhigh,FILE_END);
		totalcopied=seekhigh;
		totalcopied=totalcopied << 32 | seeklow;
		seeklow=CeSetFilePointer(remotefilehandle,seeklow,&seekhigh,FILE_BEGIN);
		if (seeklow=0xFFFFFFFF && CeGetLastError()!=NO_ERROR) {
			// seek failed!
			CeCloseHandle(remotefilehandle);
			CloseHandle(localfilehandle);
			tdp->Finished = true;
			return FS_FILE_READERROR;
		}
	}

	DWORD cbread,cbwritten,readblocksz, compare_readblocksz;
	char *block = new char[partblocksz];
	int starttime;	

	readblocksz=LastDownloadBlockSize;   // Global across threads!

	err=0;
	do {
		compare_readblocksz=readblocksz;
		starttime=GetCurrentTime();
		if (!CeReadFile(remotefilehandle,block,readblocksz,&cbread,NULL)) {
			err=FS_FILE_READERROR;
			break;
		} 
		starttime=GetCurrentTime()-starttime;
		readblocksz=CheckTimeAndBlockSize(readblocksz, starttime, false);// Dunamic Block Size

		if (!WriteFile(localfilehandle,block,cbread,&cbwritten,NULL) || cbread!=cbwritten) {
			err=FS_FILE_WRITEERROR;
			break;
		} else {   // read+write succeeded!
			totalcopied+=cbread;
			if (totalsize)         // may be zero if file was erroneously reported as 0 bytes
				tdp->Percent=(int)min(100,totalcopied*100.0/totalsize);
			else
				tdp->Percent=0;
			if (tdp->Aborted) {
				CeCloseHandle(remotefilehandle);
				CloseHandle(localfilehandle);
				tdp->Finished = true;
				return FS_FILE_USERABORT;
			}
		}
	} while (cbread>=compare_readblocksz);
	if(block!=NULL) delete block;

	LastDownloadBlockSize=readblocksz;

	if (tdp->ri->LastWriteTime.dwHighDateTime || tdp->ri->LastWriteTime.dwLowDateTime)
		SetFileTime(localfilehandle,NULL,NULL,&tdp->ri->LastWriteTime);
	CeCloseHandle(remotefilehandle);
	CloseHandle(localfilehandle);
	tdp->Finished = true;
	return err;
}

int __stdcall FsGetFile(char* RemoteName,char* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
	WCHAR RemoteNameW[wdirtypemax],LocalNameW[wdirtypemax],OldLocalNameW[wdirtypemax];
	int ret=FsGetFileW(awfilenamecopy(RemoteNameW,RemoteName),awfilenamecopy(LocalNameW,LocalName),CopyFlags,ri);
	// A conversion may cause a name change
	if (ret==0 && wcscmp(LocalNameW,OldLocalNameW)!=0) {
		wafilenamecopy(LocalName,LocalNameW);
	}
	return ret;
}

int __stdcall FsGetFileW(WCHAR* RemoteName,WCHAR* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
    int err;
	BOOL OverWrite,Resume,Move;
	BOOL hasdataloss=false;

	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;

	if (RemoteName[0]!='\\')
		return FS_FILE_NOTFOUND;

	err=ProgressProcT(PluginNumber,RemoteName,LocalName,0);
	if (err)
		return FS_FILE_USERABORT;

	if (!InitCeFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	char RemoteNameA[wdirtypemax];
	char newext[MAX_PATH],clsidname[MAX_PATH],temppath[MAX_PATH],tempname[MAX_PATH];
	WCHAR newextw[MAX_PATH];
	WCHAR tempnamew[MAX_PATH];
	BOOL doconvert=false;
	threaddata td;

	td.CopyFlags=CopyFlags;
	td.LocalName=LocalName;
	td.RemoteName=RemoteName;
	td.Percent=0;
	td.ri=ri;
	td.Aborted=false;
	td.Finished = false;
	HANDLE hThread;
	DWORD pThreadId;

	int ConvPercentMax=100;
	wafilenamecopy(RemoteNameA,RemoteName);
	if (conversionsflag!=-1 && NeedsConversion(true,RemoteNameA,newext,clsidname)) {
		if (conversionsflag==0) {  // Ask user!
			doconvert=RequestProc(PluginNumber,RT_MsgOKCancel,"WinCE-Plugin",
				"Some files need to be converted from their pocket formats (e.g. .pwd->.doc).\nPress OK to convert or Cancel to send unconverted!\n\nNote: This selection will remain active until you disconnect.",NULL,0);
			if (doconvert)
				conversionsflag=1;
			else
				conversionsflag=-1;
		} else
			doconvert=true;
		if (doconvert) {
			WCHAR* p=wcsrchr(LocalName,'\\');
			if (p) {
				p=wcsrchr(p,'.');
				if (p) {
					p++;
					awfilenamecopy(newextw,newext);
					wcscpy(p,newextw);
				}
			}
			err=ProgressProcT(PluginNumber,RemoteName,LocalName,0);

			if (!OverWrite && fileexistsT(LocalName))
				return FS_FILE_EXISTS;

			GetTempPath(MAX_PATH-1,temppath);
  			GetTempFileName(temppath,"conv",0,tempname);
			DeleteFile(tempname);
			p=wcsrchr(RemoteName,'\\');
			if (p) {
				p=wcsrchr(p,'.');
				if (p) {
					wafilenamecopy(newext,p);
					strlcat(tempname,newext,MAX_PATH-1);  // must have OLD extension!!!
				}
			}
			awfilenamecopy(tempnamew,tempname);
			td.LocalName=tempnamew;
			ConvPercentMax=90;
		}
	}

	hThread=CreateThread(NULL, 
				0,
				(LPTHREAD_START_ROUTINE)&DownloadThreadProc,
				&td,
				0,
                &pThreadId);

	if (!hThread)
		return FS_FILE_READERROR;

	int oldpercent=0;
	err=WaitForSingleObject(hThread,500);
	
	while (err==WAIT_TIMEOUT) {
//		if (oldpercent!=td.Percent)
		{
			oldpercent=td.Percent;
			if (ProgressProcT(PluginNumber,RemoteName,LocalName,MulDiv(oldpercent,ConvPercentMax,100))) {
				td.Aborted=true;
			}
		}
		err=WaitForSingleObject(hThread,500);
	} 

	DWORD dwcode;
	if (!GetExitCodeThread(hThread,&dwcode))
		return FS_FILE_READERROR;

	CloseHandle(hThread);
	err=(int)dwcode;

	WCHAR buf1[wdirtypemax];
	wcscpy(buf1,L"GET ");
	wcslcat(buf1,RemoteName,wdirtypemax-1);
	wcslcat(buf1,L"->",wdirtypemax-1);
	wcslcat(buf1,LocalName,wdirtypemax-1);
	LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);

	if (!err) {
		if (doconvert) {
			char LocalNameA[wdirtypemax],tempname2[wdirtypemax];
			WCHAR LocalName2[wdirtypemax],tempname2W[wdirtypemax];
			if (!oleinitialized)
				CoInitialize(NULL);
			oleinitialized=true;
			int ConvPercentStart=90;   //conversion after download

			wafilenamecopy(LocalNameA,LocalName);
			awfilenamecopy(LocalName2,LocalNameA);
			if (wcscmp(LocalName2,LocalName)==0 || !usys()) {
				if (!DoConversion(0,true,tempname,LocalNameA,clsidname,&hasdataloss,&wantconverrors,ConvPercentStart)) {
					DeleteFile(tempname);
					return FS_FILE_WRITEERROR;
				}
			} else {
				GetTempPath(MAX_PATH-1,temppath);
  				GetTempFileName(temppath,"conv",0,tempname2);
				DeleteFile(tempname2);
				char* p=strrchr(LocalNameA,'\\');
				if (p) {
					p=strrchr(p,'.');
					if (p) {
						strlcat(tempname2,p,MAX_PATH-1);  // must have OLD extension!!!
					}
				}
				if (!DoConversion(0,true,tempname,tempname2,clsidname,&hasdataloss,&wantconverrors,ConvPercentStart)) {
					DeleteFile(tempname);
					return FS_FILE_WRITEERROR;
				}
				awfilenamecopy(tempname2W,tempname2);
				DeleteFileW(LocalName);
				MoveFileW(tempname2W,LocalName);
			}
			DeleteFile(tempname);
			if (err)
				return FS_FILE_USERABORT;
		}		
		
		ProgressProcT(PluginNumber,RemoteName,LocalName,ConvPercentMax);

		if (Move && (!hasdataloss || !doconvert)) {
			
			if (!CeDeleteFile(RemoteName))       // New! Plugin deletes on Move
				return FS_FILE_WRITEERROR;
		}

		return FS_FILE_OK;
	} else {
		return err;
	}
}

DWORD WINAPI UploadThreadProc(LPVOID lpParameter)
{
	int err;
	BOOL OverWrite,Resume;
	threaddataptr tdp=(threaddataptr)lpParameter;

	OverWrite=tdp->CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=tdp->CopyFlags & FS_COPYFLAGS_RESUME;

	WCHAR wfullname[wdirtypemax];
	wcslcpy(wfullname,tdp->RemoteName,wdirtypemax-1);

	// Open local file
	HANDLE localfilehandle = CreateFileT (tdp->LocalName,
                      GENERIC_READ,           // Open for reading
                      0,                      // Do not share
                      NULL,                   // No security
                      OPEN_EXISTING,          // Existing file only
                      FILE_ATTRIBUTE_NORMAL,  // Normal file
                      NULL);

	if (localfilehandle==INVALID_HANDLE_VALUE)
	{
		tdp->Finished = true;
		return FS_FILE_NOTFOUND;
	}
	
	HANDLE remotefilehandle;

	if (Resume) {
		// Open remote file
		remotefilehandle = CeCreateFile(wfullname,GENERIC_WRITE,0,NULL,
			OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);

		if (remotefilehandle==INVALID_HANDLE_VALUE) {
			CloseHandle(localfilehandle);
			tdp->Finished = true;
			return FS_FILE_WRITEERROR;
		}
	} else {
		// Create remote file
		remotefilehandle = CeCreateFile(wfullname,GENERIC_WRITE,0,NULL,
			OverWrite ? CREATE_ALWAYS : CREATE_NEW,
			FILE_ATTRIBUTE_NORMAL,NULL);

		if (remotefilehandle==INVALID_HANDLE_VALUE) {
			err=CeGetLastError();
			CloseHandle(localfilehandle);
			if (err==ERROR_FILE_EXISTS)
			{
				tdp->Finished = true;
				return  FS_FILE_EXISTSRESUMEALLOWED;
			}
			else
			{
				tdp->Finished = true;
				return FS_FILE_WRITEERROR;
		}
	}
	}

	DWORD totalsizehigh=0;
	DWORD totalsizelow=GetFileSize(localfilehandle,&totalsizehigh);
	INT64 totalsize=totalsizehigh;
	totalsize=totalsize << 32 | totalsizelow;
	INT64 totalcopied=0;

	if (Resume) {
		DWORD seeklow;
		LONG seekhigh=0;
		seeklow=CeSetFilePointer(remotefilehandle,0,&seekhigh,FILE_END);
		totalcopied=seekhigh;
		totalcopied=totalcopied << 32 | seeklow;
		seeklow=SetFilePointer(localfilehandle,seeklow,&seekhigh,FILE_BEGIN);
		if (seeklow=0xFFFFFFFF && GetLastError()!=NO_ERROR) {
			// seek failed!
			CeCloseHandle(remotefilehandle);
			CloseHandle(localfilehandle);
			tdp->Finished = true;
			return FS_FILE_READERROR;
		}
	}

	DWORD cbread,cbwritten,readblocksz, compare_readblocksz;
	char * block = new char[partblocksz];
	int starttime;
	readblocksz=LastUploadBlockSize;

	err=0;
	do {
		compare_readblocksz=readblocksz;
		starttime=GetCurrentTime();
		if (!ReadFile(localfilehandle,block,readblocksz,&cbread,NULL)) {
			err=FS_FILE_READERROR;
			break;

		} else if (!CeWriteFile(remotefilehandle,block,cbread,&cbwritten,NULL) || cbread!=cbwritten) {
			err=FS_FILE_WRITEERROR;
			break;
		} else {   // read+write succeeded!
			starttime=GetCurrentTime()-starttime;
			readblocksz=CheckTimeAndBlockSize(readblocksz, starttime, true);// Dunamic Block Size

			totalcopied+=cbread;
			if (totalsize)         // may be zero if file was erroneously reported as 0 bytes
				tdp->Percent=(int)min(100,totalcopied*100.0/totalsize);
			else
				tdp->Percent=0;
			if (tdp->Aborted) {
				CeCloseHandle(remotefilehandle);
				CloseHandle(localfilehandle);
				tdp->Finished = true;
				return FS_FILE_USERABORT;
			}
		}
	} while (cbread>=compare_readblocksz);
	if(block!=NULL) delete block;
	LastUploadBlockSize=readblocksz;

	FILETIME LastWriteTime;
	if (GetFileTime(localfilehandle,NULL,NULL,&LastWriteTime))
		CeSetFileTime(remotefilehandle,NULL,NULL,&LastWriteTime);
	CeCloseHandle(remotefilehandle);
	CloseHandle(localfilehandle);
	tdp->Finished = true;
	return err;
}

int __stdcall FsPutFile(char* LocalName,char* RemoteName,int CopyFlags)
{
	WCHAR RemoteNameW[wdirtypemax],LocalNameW[wdirtypemax],OldRemoteNameW[wdirtypemax];
	int ret=FsPutFileW(awfilenamecopy(LocalNameW,LocalName),awfilenamecopy(RemoteNameW,RemoteName),CopyFlags);
	// A conversion may cause a name change
	if (ret==0 && wcscmp(RemoteNameW,OldRemoteNameW)!=0) {
		wafilenamecopy(RemoteName,RemoteNameW);
	}
	return ret;
}

int __stdcall FsPutFileW(WCHAR* LocalName,WCHAR* RemoteName,int CopyFlags)
{
	int err;
	BOOL OverWrite,Resume,Move;
	BOOL hasdataloss=false;
	
	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;
	
	if (RemoteName[0]!='\\')
		return FS_FILE_NOTFOUND;

	err=ProgressProcT(PluginNumber,LocalName,RemoteName,0);
	if (err)
		return FS_FILE_USERABORT;
	
	if (!InitCeFunctionsIfNeeded(TRUE))
		return FS_FILE_READERROR;

	char newext[MAX_PATH],clsidname[MAX_PATH],temppath[MAX_PATH],tempname[MAX_PATH];
	char LocalNameA[wdirtypemax];
	WCHAR newextW[wdirtypemax];
	WCHAR tempnameW[wdirtypemax];
	BOOL doconvert=false;

	threaddata td;

	td.CopyFlags=CopyFlags;
	td.LocalName=LocalName;
	td.RemoteName=RemoteName;
	td.Percent=0;
	td.Aborted=false;
	td.Finished = false;
	int ConvPercentStart=0;
	int ConvPercentMax=100;
	
	wafilenamecopy(LocalNameA,LocalName);
	if (conversionsflag!=-1 && NeedsConversion(false,LocalNameA,newext,clsidname)) {
		if (conversionsflag==0) {  // Ask user!
			doconvert=RequestProc(PluginNumber,RT_MsgOKCancel,"WinCE-Plugin",
				"Some files need to be converted to their pocket formats (e.g. .doc->.pwd).\nPress OK to convert or Cancel to send unconverted!\n\nNote: This selection will remain active until you disconnect.",NULL,0);
			if (doconvert)
				conversionsflag=1;
			else
				conversionsflag=-1;
		} else
			doconvert=true;
		if (doconvert) {
			WCHAR LocalName2[wdirtypemax];
			awfilenamecopy(LocalName2,LocalNameA);
			GetTempPath(MAX_PATH-1,temppath);
  			GetTempFileName(temppath,"conv",0,tempname);
			DeleteFile(tempname);
			strlcat(tempname,".",MAX_PATH-1);
			strlcat(tempname,newext,MAX_PATH-1);
			if (!oleinitialized)
				CoInitialize(NULL);
			oleinitialized=true;
			ConvPercentStart=0;   //conversion before upload
			if (wcscmp(LocalName2,LocalName)==0 || !usys()) {
				if (!DoConversion(0,false,LocalNameA,tempname,clsidname,&hasdataloss,&wantconverrors,ConvPercentStart)) {
					DeleteFile(tempname);
					return FS_FILE_NOTFOUND;
				}
			} else {
				char tempname2[MAX_PATH],newext2[MAX_PATH];
				WCHAR tempname2W[MAX_PATH];
  				GetTempFileName(temppath,"conv",0,tempname2);
				DeleteFile(tempname2);
				WCHAR* p=wcsrchr(LocalName,'\\');
				if (p) {
					p=wcsrchr(p,'.');
					if (p) {
						wafilenamecopy(newext2,p);
						strlcat(tempname2,newext2,MAX_PATH-1);  // must have OLD extension!!!
					}
				}
				awfilenamecopy(tempname2W,tempname2);
				CopyFileW(LocalName,tempname2W,false);
				if (!DoConversion(0,false,tempname2,tempname,clsidname,&hasdataloss,&wantconverrors,ConvPercentStart)) {
					DeleteFile(tempname);
					return FS_FILE_NOTFOUND;
				}
			}
			WCHAR* p=wcsrchr(RemoteName,'\\');
			if (p) {
				p=wcsrchr(p,'.');
				if (p) {
					p++;
					awfilenamecopy(newextW,newext);
					wcscpy(p,newextW);
				}
			}
			ConvPercentStart=10;
			ConvPercentMax=90;

			err=ProgressProcT(PluginNumber,LocalName,RemoteName,ConvPercentStart);
			if (err) {
				DeleteFile(tempname);
				return FS_FILE_USERABORT;
			}
			awfilenamecopy(tempnameW,tempname);
			td.LocalName=tempnameW;
		}
	}
	HANDLE hThread;
	DWORD pThreadId;

	hThread=CreateThread(NULL, 
				0,
				(LPTHREAD_START_ROUTINE)&UploadThreadProc,
				&td,
				0,
                &pThreadId);

	if (!hThread)
		return FS_FILE_READERROR;

	int oldpercent=0;
	err=WaitForSingleObject(hThread,500);
	
	while (err==WAIT_TIMEOUT) {
//		if (oldpercent!=td.Percent) 
		{
			oldpercent=td.Percent;
			if (ProgressProcT(PluginNumber,LocalName,RemoteName,ConvPercentStart+MulDiv(oldpercent,ConvPercentMax,100))) {
				td.Aborted=true;
			}
		}
		err=WaitForSingleObject(hThread,500);
	} 
	if (doconvert) DeleteFile(tempname);

	DWORD dwcode;
	if (!GetExitCodeThread(hThread,&dwcode))
		return FS_FILE_READERROR;

	CloseHandle(hThread);
	err=(int)dwcode;

	WCHAR buf1[wdirtypemax];
	wcscpy(buf1,L"PUT ");
	if (err)
		wcscat(buf1,L"ERROR ");
	wcslcat(buf1,LocalName,wdirtypemax-1);
	wcslcat(buf1,L"->",wdirtypemax-1);
	wcslcat(buf1,RemoteName,wdirtypemax-1);
	LogProcT(PluginNumber,MSGTYPE_OPERATIONCOMPLETE,buf1);

	if (err==0) {
		ProgressProcT(PluginNumber,LocalName,RemoteName,100);
		if (Move && (!hasdataloss || !doconvert))
			if (!DeleteFileT(LocalName))
				return FS_FILE_WRITEERROR;
		return FS_FILE_OK;
	} else {
		return err;
	}
}

BOOL __stdcall FsDeleteFile(char* RemoteName)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsDeleteFileW(awfilenamecopy(RemoteNameW,RemoteName));
}

BOOL __stdcall FsDeleteFileW(WCHAR* RemoteName)
{
	if (RemoteName[0]!='\\')
		return false;

	InitCeFunctionsIfNeeded(TRUE);

	return CeDeleteFile(RemoteName);	
}

BOOL __stdcall FsRemoveDir(char* RemoteName)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsRemoveDirW(awfilenamecopy(RemoteNameW,RemoteName));
}

BOOL __stdcall FsRemoveDirW(WCHAR* RemoteName)
{
	if (RemoteName[0]!='\\')
		return false;

	InitCeFunctionsIfNeeded(TRUE);

	return CeRemoveDirectory(RemoteName);	
}

BOOL __stdcall FsSetAttr(char* RemoteName,int NewAttr)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsSetAttrW(awfilenamecopy(RemoteNameW,RemoteName),NewAttr);
}

BOOL __stdcall FsSetAttrW(WCHAR* RemoteName,int NewAttr)
{
	if (RemoteName[0]!='\\')
		return false;

	InitCeFunctionsIfNeeded(TRUE);

	if (NewAttr==0)
		NewAttr=FILE_ATTRIBUTE_NORMAL;
	return CeSetFileAttributes(RemoteName,NewAttr);	
}

BOOL __stdcall FsSetTime(char* RemoteName,FILETIME *CreationTime,
      FILETIME *LastAccessTime,FILETIME *LastWriteTime)
{
	WCHAR RemoteNameW[wdirtypemax];
	return FsSetTimeW(awfilenamecopy(RemoteNameW,RemoteName),CreationTime,
      LastAccessTime,LastWriteTime);
}

BOOL __stdcall FsSetTimeW(WCHAR* RemoteName,FILETIME *CreationTime,
      FILETIME *LastAccessTime,FILETIME *LastWriteTime)
{
	if (RemoteName[0]!='\\')
		return false;

	InitCeFunctionsIfNeeded(TRUE);

	HANDLE remotefilehandle = CeCreateFile (RemoteName,	
                      GENERIC_WRITE,          // Open for writing
                      0,                      // Do not share
                      NULL,                   // No security
                      OPEN_EXISTING,          // Existing file only
                      FILE_ATTRIBUTE_NORMAL,  // Normal file
                      NULL);

	if (remotefilehandle==INVALID_HANDLE_VALUE)
		return FALSE;

	BOOL retval=CeSetFileTime(remotefilehandle,CreationTime,LastAccessTime,LastWriteTime);
    CeCloseHandle(remotefilehandle);
	return retval;
}

void __stdcall FsGetDefRootName(char* DefRootName,int maxlen)
{
	strlcpy(DefRootName,DefPluginTitle,maxlen-1);
}

void __stdcall FsSetDefaultParams(FsDefaultParamStruct* dps)
{
	strlcpy(defininame,dps->DefaultIniName,MAX_PATH-1);
	defconversionsflag=GetPrivateProfileInt("CECMD","CEConvertFormat",-1,defininame);
}

int __stdcall FsGetBackgroundFlags(void)
{
	return BG_DOWNLOAD | BG_UPLOAD;
}
