#include <windows.h>
#include <StdAfx.h>
#include "utils.h"
#include <mbstring.h>
#include "cunicode.h"

char* strend(char* p)
{
	while (p[0]) p++;
	return p;
}

void strcatbackslash(char *st)
{
	char *p;
    if (st[0]) {
		p=AnsiPrev(st,strend(st));
		if (p[0]!='\\')
			strcat(p,"\\");
	}
}

LPTSTR strlcatbackslash(char* thedir,int maxlen)
{
	if (thedir[0] && strlen(thedir)<(DWORD)maxlen)
		if (thedir[strlen(thedir)-1]!='\\')
			strcat(thedir,"\\");
	return thedir;
}

WCHAR* wcslcatbackslash(WCHAR* thedir,int maxlen)
{
	if (thedir[0] && wcslen(thedir)<(DWORD)maxlen)
		if (thedir[wcslen(thedir)-1]!='\\')
			wcscat(thedir,L"\\");
	return thedir;
}

void cutlastbackslash(LPSTR filename)
{
	if (!filename[0]) return;
	if (filename[strlen(filename)-1]=='\\')
		filename[strlen(filename)-1]='\000';
}

BOOL ispointdir(LPSTR dirname)
{
	return strcmp(dirname,".")==0 || strcmp(dirname,"..")==0;
}

char* strlcpy(char* p,char*p2,int maxlen)
{
	if ((int)strlen(p2)>=maxlen) {
		strncpy(p,p2,maxlen);
		p[maxlen]=0;
	} else
		strcpy(p,p2);
	return p;
}

char* strlcat(char* p,char*p2,int maxlen)
{
	return strncat(p,p2,maxlen);
}

WCHAR* wcslcpy(WCHAR* p,WCHAR* p2,int maxlen)
{
	if ((int)wcslen(p2)>=maxlen) {
		wcsncpy(p,p2,maxlen);
		p[maxlen]=0;
	} else
		wcscpy(p,p2);
	return p;
}

int getfiletype(char* filename)
{
        HANDLE findhandle;
        WIN32_FIND_DATA s;

        findhandle=FindFirstFile(filename,&s);
        if (findhandle==INVALID_HANDLE_VALUE)
                return ft_notfound;
        else {
                FindClose(findhandle);

                return (s.dwFileAttributes & 0x010)==0 ? ft_file : ft_dir;
        }
}

BOOL fileexists(char* filename)
{
        return getfiletype(filename)==ft_file;
}

int getfiletypeT(WCHAR* filename)
{
        HANDLE findhandle;
        WIN32_FIND_DATAW s;

        findhandle=FindFirstFileT(filename,&s);
        if (findhandle==INVALID_HANDLE_VALUE)
                return ft_notfound;
        else {
                FindClose(findhandle);

                return (s.dwFileAttributes & 0x010)==0 ? ft_file : ft_dir;
        }
}

BOOL fileexistsT(WCHAR* filename)
{
        return getfiletypeT(filename)==ft_file;
}
