#include <stdafx.h>
#include "rapifunc.h"

CERAPIINITEX CeRapiInitEx;
CERAPUNINIT CeRapiUninit;
CEFINDFIRSTFILE CeFindfFirstFile;
CEFINDNEXTFILE CeFindNextFile;
CEFINDALLFILES CeFindAllFiles;
CEFINDCLOSE CeFindClose;
CEDELETEFILE CeDeleteFile;
CECREATEDIRECTORY CeCreateDirectory;
CEREMOVEDIRECTORY CeRemoveDirectory;
CECREATEFILE CeCreateFile;
CEWRITEFILE CeWriteFile;
CEREADFILE CeReadFile;
CECLOSEHANDLE CeCloseHandle;
CEGETFILESIZE CeGetFileSize;
CESETFILEPOINTER CeSetFilePointer;
CESETFILETIME CeSetFileTime;
CEGETLASTERROR CeGetLastError;
CERAPIGETERROR CeRapiGetError;
CEGETVERSIONEX CeGetVersionEx;
CEMOVEFILE CeMoveFile;
CECOPYFILE CeCopyFile;
CEGETDISKFREESPACEEX CeGetDiskFreeSpaceEx;
CERAPIFREEBUFFER CeRapiFreeBuffer;
CESHGETSHORTCUTTARGET CeSHGetShortcutTarget;
CESETFILEATTRIBUTES CeSetFileAttributes;
CEGETFILEATTRIBUTES CeGetFileAttributes;

HMODULE lib=NULL;
BOOL LoadTried=false;

FARPROC MyGetProcAddress(BOOL* ok,__in HMODULE hModule,__in LPCSTR lpProcName) {
	FARPROC ret=GetProcAddress (hModule, lpProcName);
	if (ret==NULL)
		*ok=false;
	return ret;
}

BOOL LoadRapiDll()
{
	if (!LoadTried) {
		lib=LoadLibrary("rapi.dll");
		if (lib==NULL) {
			MessageBox(GetActiveWindow(),"The library rapi.dll was not found!\n\nPlease install Windows Mobile Device Center 6.1 or newer!",
				"Error",MB_ICONSTOP);
			return false;
		}
	} else
		return lib!=NULL;
	BOOL ok=true;
	CeRapiInitEx=(CERAPIINITEX)MyGetProcAddress(&ok,lib,"CeRapiInitEx");
	CeRapiUninit=(CERAPUNINIT)MyGetProcAddress(&ok,lib,"CeRapiUninit");
	CeFindfFirstFile=(CEFINDFIRSTFILE)MyGetProcAddress(&ok,lib,"CeFindFirstFile");
	CeFindNextFile=(CEFINDNEXTFILE)MyGetProcAddress(&ok,lib,"CeFindNextFile");
	CeFindAllFiles=(CEFINDALLFILES)MyGetProcAddress(&ok,lib,"CeFindAllFiles");
	CeFindClose=(CEFINDCLOSE)MyGetProcAddress(&ok,lib,"CeFindClose");
	CeDeleteFile=(CEDELETEFILE)MyGetProcAddress(&ok,lib,"CeDeleteFile");
	CeCreateDirectory=(CECREATEDIRECTORY)MyGetProcAddress(&ok,lib,"CeCreateDirectory");
	CeRemoveDirectory=(CEREMOVEDIRECTORY)MyGetProcAddress(&ok,lib,"CeRemoveDirectory");
	CeCreateFile=(CECREATEFILE)MyGetProcAddress(&ok,lib,"CeCreateFile");
	CeWriteFile=(CEWRITEFILE)MyGetProcAddress(&ok,lib,"CeWriteFile");
	CeReadFile=(CEREADFILE)MyGetProcAddress(&ok,lib,"CeReadFile");
	CeCloseHandle=(CECLOSEHANDLE)MyGetProcAddress(&ok,lib,"CeCloseHandle");
	CeGetFileSize=(CEGETFILESIZE)MyGetProcAddress(&ok,lib,"CeGetFileSize");
	CeSetFilePointer=(CESETFILEPOINTER)MyGetProcAddress(&ok,lib,"CeSetFilePointer");
	CeSetFileTime=(CESETFILETIME)MyGetProcAddress(&ok,lib,"CeSetFileTime");
	CeGetLastError=(CEGETLASTERROR)MyGetProcAddress(&ok,lib,"CeGetLastError");
	CeRapiGetError=(CERAPIGETERROR)MyGetProcAddress(&ok,lib,"CeRapiGetError");
	CeGetVersionEx=(CEGETVERSIONEX)MyGetProcAddress(&ok,lib,"CeGetVersionEx");
	CeMoveFile=(CEMOVEFILE)MyGetProcAddress(&ok,lib,"CeMoveFile");
	CeCopyFile=(CECOPYFILE)MyGetProcAddress(&ok,lib,"CeCopyFile");
	CeGetDiskFreeSpaceEx=(CEGETDISKFREESPACEEX)MyGetProcAddress(&ok,lib,"CeGetDiskFreeSpaceEx");
	CeRapiFreeBuffer=(CERAPIFREEBUFFER)MyGetProcAddress(&ok,lib,"CeRapiFreeBuffer");
	CeSHGetShortcutTarget=(CESHGETSHORTCUTTARGET)MyGetProcAddress(&ok,lib,"CeSHGetShortcutTarget");
	CeSetFileAttributes=(CESETFILEATTRIBUTES)MyGetProcAddress(&ok,lib,"CeSetFileAttributes");
	CeGetFileAttributes=(CEGETFILEATTRIBUTES)MyGetProcAddress(&ok,lib,"CeGetFileAttributes");
	if (!ok) {
		FreeLibrary(lib);
		lib=NULL;
	}
	return ok;
}