// CeStream.h: interface for the CCeStream class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILESTREAM_H__D0C00276_C5CD_4795_A56E_53FE3C67F489__INCLUDED_)
#define AFX_FILESTREAM_H__D0C00276_C5CD_4795_A56E_53FE3C67F489__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CFileStream : public IStream  
{
protected:
    ULONG           m_uiRef;             // Object reference count
public:
	CFileStream(LPSTR fullname,BOOL fwriteallowed);
    virtual ~CFileStream();
    
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID FAR *);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
	// IStream methods
	STDMETHODIMP            Read( 
            /* [length_is][size_is][out] */ void __RPC_FAR *pv,
            /* [in] */ ULONG cb,
            /* [out] */ ULONG __RPC_FAR *pcbRead);

	STDMETHODIMP            Write( 
            /* [size_is][in] */ const void __RPC_FAR *pv,
            /* [in] */ ULONG cb,
            /* [out] */ ULONG __RPC_FAR *pcbWritten);

    STDMETHODIMP            Seek( 
            /* [in] */ LARGE_INTEGER dlibMove,
            /* [in] */ DWORD dwOrigin,
            /* [out] */ ULARGE_INTEGER __RPC_FAR *plibNewPosition);
        
    STDMETHODIMP            SetSize( 
            /* [in] */ ULARGE_INTEGER libNewSize);
        
    STDMETHODIMP            CopyTo( 
            /* [unique][in] */ IStream __RPC_FAR *pstm,
            /* [in] */ ULARGE_INTEGER cb,
            /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbRead,
            /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbWritten);
        
    STDMETHODIMP            Commit( 
            /* [in] */ DWORD grfCommitFlags);
        
    STDMETHODIMP            Revert( void);
        
    STDMETHODIMP            LockRegion( 
            /* [in] */ ULARGE_INTEGER libOffset,
            /* [in] */ ULARGE_INTEGER cb,
            /* [in] */ DWORD dwLockType);
        
    STDMETHODIMP            UnlockRegion( 
            /* [in] */ ULARGE_INTEGER libOffset,
            /* [in] */ ULARGE_INTEGER cb,
            /* [in] */ DWORD dwLockType);
        
    STDMETHODIMP            Stat( 
            /* [out] */ STATSTG __RPC_FAR *pstatstg,
            /* [in] */ DWORD grfStatFlag);
        
    STDMETHODIMP            Clone( 
            /* [out] */ IStream __RPC_FAR *__RPC_FAR *ppstm);
private:
	char			m_fullname[MAX_PATH];
	HANDLE			m_filehandle;
	BOOL			m_writemode;
	BOOL tryopenfile();
public:
	void closefile();
  };

#endif // !defined(AFX_FILESTREAM_H__D0C00276_C5CD_4795_A56E_53FE3C67F489__INCLUDED_)