// ceconvert.h : Header for ce convert functions
//

#include "resource.h"
#include "filestream.h"
#include "replfilt.h"

BOOL NeedsConversion(BOOL datafromdevice,const char* fromname,char* newext,char* clsidname);
BOOL DoConversion(HWND hWnd,BOOL datafromdevice,char* fromname,char* toname,char* clsidname,
				  BOOL* datalossreported,BOOL* wantconverrors,int ConvPercentStart);


class CCeFileFilterSite  : public ICeFileFilterSite
{
public:
	CCeFileFilterSite();
	~CCeFileFilterSite();

	//IUnknown methods
	STDMETHOD (QueryInterface)(REFIID, LPVOID*);
	STDMETHOD_ (DWORD, AddRef)();
	STDMETHOD_ (DWORD, Release)();

	//ICeFileFilterSite
    // *** ICeFileFilterSite methods ***
	STDMETHOD(OpenSourceFile) (int nHowToOpenFile,LPVOID *ppObj); 
	STDMETHOD(OpenDestinationFile) (int nHowToOpenFile,LPCTSTR pszFullpath,LPVOID *ppObj);
	STDMETHOD(CloseSourceFile) (LPUNKNOWN pObj);
	STDMETHOD(CloseDestinationFile) (BOOL bKeepFile,LPUNKNOWN pObj); 
	STDMETHOD(ReportProgress) (UINT nPercent);
	STDMETHOD(ReportLoss) (DWORD dw,LPCTSTR psz,va_list args);
protected:
	DWORD m_dwRefCount;
private:
	CFileStream *destfile;
	CFileStream *sourcefile;
public:
	ICeFileFilter* iceff;
	int ConvPercentStart;
	BOOL filter_hasdataloss;
	BOOL filter_wantconverterrordisplay;
	char m_sourcename[MAX_PATH];
	char m_targetname[MAX_PATH];
	// TODO : Add implementation specific functions to create the IDList
};
