// testceconvert.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "ceconvert.h"
#include "filestream.h"
#include "fsplugin.h"
#include "utils.h"

extern tProgressProc ProgressProc;
extern tRequestProc RequestProc;
extern int PluginNumber;

const GUID IID_ICeFileFilterOptions2 \
                = { 0x6c5c05e2, 0x97a2, 0x11cf, { 0x80, 0x11, 0x0, 0xa0, 0xc9, 0xa, 0x8f, 0x78} };

const GUID IID_ICeFileFilterSite2 \
				= {0x6c5c05e0, 0x97a2, 0x11cf, {0x80, 0x11, 0x0, 0xa0, 0xc9, 0xa, 0x8f, 0x78}};

const GUID IID_ICeFileFilter2 \
				= {0x6c5c05e1, 0x97a2, 0x11cf, {0x80, 0x11, 0x0, 0xa0, 0xc9, 0xa, 0x8f, 0x78}};


CCeFileFilterSite::CCeFileFilterSite(void)
{
	m_dwRefCount = 1;
	sourcefile=NULL;
	destfile=NULL;
}

CCeFileFilterSite::~CCeFileFilterSite()
{
	int ref;
	if (sourcefile) {
		do {
			ref=sourcefile->Release();
		} while (ref);
	}
	sourcefile=NULL;
	if (destfile) {
		do {
			ref=destfile->Release();
		} while (ref);
	}
	destfile=NULL;
}

///////////////////////////////////////////////////////////
// IUnknown implementation
//
STDMETHODIMP CCeFileFilterSite::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}
	//IEnumIDList
	else if(IsEqualIID(riid, IID_ICeFileFilterSite2))
	{
		*ppReturn = (ICeFileFilterSite*)this;
	}   
	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}
	return E_NOINTERFACE;
}                                             

STDMETHODIMP_(DWORD) CCeFileFilterSite::AddRef()
{
	return ++m_dwRefCount;
}

STDMETHODIMP_(DWORD) CCeFileFilterSite::Release()
{
	if(--m_dwRefCount == 0)
	{
		delete this;
		return 0;
	}
	return m_dwRefCount;
}

// *** ICeFileFilterSite methods ***
STDMETHODIMP_(HRESULT) CCeFileFilterSite::OpenSourceFile(int nHowToOpenFile,LPVOID *ppObj)
{
	if (nHowToOpenFile!=PF_OPENFLAT) {
		IStorage *stgOpen;
		WCHAR wname[MAX_PATH];
		MultiByteToWideChar(CP_ACP,0,m_sourcename,-1,wname,MAX_PATH);

		HRESULT ret=StgOpenStorage(wname,NULL,STGM_DIRECT | STGM_READ | STGM_SHARE_DENY_WRITE,NULL,0,&stgOpen);
		if (SUCCEEDED(ret))
			*ppObj=(LPVOID *)stgOpen;
		return ret;
	}
	sourcefile = new CFileStream(m_sourcename,FALSE);
	if (sourcefile) {
		*ppObj=(LPVOID *)sourcefile;
		return S_OK;
	} else
		return E_FAIL;
}

STDMETHODIMP_(HRESULT) CCeFileFilterSite::OpenDestinationFile(int nHowToOpenFile,LPCTSTR pszFullpath,LPVOID *ppObj)
{
	if (pszFullpath)
		strcpy(m_targetname,pszFullpath);

	if (nHowToOpenFile!=PF_OPENFLAT) {
		IStorage *stgOpen;
		WCHAR wname[MAX_PATH];
		MultiByteToWideChar(CP_ACP,0,m_targetname,-1,wname,MAX_PATH);

		HRESULT ret=StgCreateDocfile(wname,STGM_READWRITE | STGM_SHARE_EXCLUSIVE,0,&stgOpen);
		if (SUCCEEDED(ret))
			*ppObj=(LPVOID *)stgOpen;
		return ret;
	}
	
	destfile = new CFileStream(m_targetname,TRUE);
	if (destfile) {
		*ppObj=(LPVOID *)destfile;
		return S_OK;
	} else
		return E_FAIL;
}

STDMETHODIMP_(HRESULT) CCeFileFilterSite::CloseSourceFile(LPUNKNOWN pObj)
{
	((CFileStream*)pObj)->Release();
	sourcefile=NULL;
	return S_OK;
}

STDMETHODIMP_(HRESULT) CCeFileFilterSite::CloseDestinationFile(BOOL bKeepFile,LPUNKNOWN pObj)
{
	((CFileStream*)pObj)->Release();
	destfile=NULL;
	return S_OK;
}

STDMETHODIMP_(HRESULT) CCeFileFilterSite::ReportProgress(UINT nPercent)
{
	if (ProgressProc) {
		char tempname[MAX_PATH];
		strlcpy(tempname,m_sourcename,sizeof(tempname)-1);
		strlcat(tempname," (Convert)",sizeof(tempname)-1);
		ProgressProc(PluginNumber,tempname,m_targetname,nPercent/10+ConvPercentStart);
	}
	return S_OK;
}

char* questionstr="\n\n(Cancel=Don't show any conversion errors.)";

STDMETHODIMP_(HRESULT) CCeFileFilterSite::ReportLoss(DWORD dw,LPCTSTR psz,va_list args)
{
	DWORD cb;
	char* buffer;
	char* buffer2=NULL;

	if (filter_wantconverterrordisplay) {
		if (dw==0 && psz) {
			buffer2=(char*)malloc(strlen(psz)+strlen(questionstr)+1);
			strcpy(buffer2,psz);
		} else {
			if SUCCEEDED(iceff->FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_HMODULE | FORMAT_MESSAGE_ARGUMENT_ARRAY,
						dw,LOCALE_USER_DEFAULT,(LPTSTR)&buffer,0,&args,&cb)) {
				buffer2=(char*)malloc(strlen(buffer)+strlen(questionstr)+1);
				strcpy(buffer2,buffer);
				LocalFree((HLOCAL)buffer);
			}
		}
		if (buffer2) {
			strcat(buffer2,questionstr);
			filter_wantconverterrordisplay=(0!=RequestProc(PluginNumber,RT_MsgOKCancel,"Conversion error",
				buffer2,NULL,0));
			free(buffer2);
		}
	}
	filter_hasdataloss=true;
	return S_OK;
}

BOOL NeedsConversion(BOOL datafromdevice,const char* fromname,char* newext,char* clsidname)
{
	const char* p;
	char filterlocation[MAX_PATH],lastdevice[MAX_PATH];
	HKEY thekey;
	HRESULT hres;
	DWORD cb,regtype;

	clsidname[0]=0;
	newext[0]=0;
	p=strrchr(fromname,'\\');
	if (!p) return false;
	p=strrchr(p,'.');
	if (!p) return false;

	hres=RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Microsoft\\Windows CE Services",0,KEY_QUERY_VALUE,&thekey);
	if (hres==S_OK ){     // nicht SUCCEEDED!
		cb=MAX_PATH-1;
		hres=RegQueryValueEx(thekey,"Last Device", NULL, &regtype,(LPBYTE)lastdevice, &cb);
		RegCloseKey(thekey);
		if (SUCCEEDED(hres) && cb>0) {
			strcpy(filterlocation,"Software\\Microsoft\\Windows CE Services\\Partners\\");
			strcat(filterlocation,lastdevice);
			strcat(filterlocation,"\\Filters\\");
			strcat(filterlocation,p);
			hres=RegOpenKeyEx(HKEY_CURRENT_USER,filterlocation,0,KEY_QUERY_VALUE,&thekey);
		}
	}
	// If not found, look in "SOFTWARE\\Microsoft\\Windows CE Services\\Filters\\"
	if (FAILED(hres)) {
		strcpy(filterlocation,"SOFTWARE\\Microsoft\\Windows CE Services\\Filters\\");
		strcat(filterlocation,p);
		hres=RegOpenKeyEx(HKEY_LOCAL_MACHINE,filterlocation,0,KEY_QUERY_VALUE,&thekey);
	}
	if (SUCCEEDED(hres)){
		cb=MAX_PATH-1;
		regtype=REG_SZ;
		if (datafromdevice)
			RegQueryValueEx(thekey,"DefaultExport", NULL, &regtype,(LPBYTE)clsidname, &cb);
		else
			RegQueryValueEx(thekey,"DefaultImport", NULL, &regtype,(LPBYTE)clsidname, &cb);
		RegCloseKey(thekey);
	}
	if (clsidname[0]) {
		strcpy(filterlocation,"CLSID\\");
		strcat(filterlocation,clsidname);
		strcat(filterlocation,"\\PegasusFilter");
		if (RegOpenKeyEx(HKEY_CLASSES_ROOT,filterlocation,0,KEY_QUERY_VALUE,&thekey)==ERROR_SUCCESS) {
			cb=MAX_PATH-1;
			regtype=REG_SZ;
			RegQueryValueEx(thekey,"NewExtension", NULL, &regtype, (LPBYTE)newext, &cb);
			RegCloseKey(thekey);
		}
	}
	if (newext[0]) {
		return true;
	} else {
		return false;
	}
}

BOOL DoConversion(HWND hWnd,BOOL datafromdevice,char* fromname,char* toname,char* clsidname,
				  BOOL* datalossreported,BOOL* wantconverrors,int ConvPercentStart)
{
	char* p;
	WCHAR oleclsidname[MAX_PATH];
	CLSID clsid;
	HRESULT hres;
	ICeFileFilterOptions* iceop;
	ICeFileFilter* iceff;
	IUnknown* iunk;

	MultiByteToWideChar(CP_ACP,0,clsidname,-1,oleclsidname,sizeof(oleclsidname)/2);

	if (!SUCCEEDED(CLSIDFromString(oleclsidname,&clsid)))
		return false;

	// Now we have the CLSID and the new extension, do the conversion!

	hres = CoCreateInstance(clsid, NULL, CLSCTX_INPROC_SERVER,
                     IID_IUnknown//IID_ICeFileFilterOptions2
					 , (LPVOID*)&iunk);

	BOOL success=false;

	if (SUCCEEDED(hres)) {
		if (SUCCEEDED(iunk->QueryInterface(IID_ICeFileFilterOptions2,(LPVOID*)&iceop))) {
			CFF_CONVERTOPTIONS cff;
			cff.cbSize=sizeof(CFF_CONVERTOPTIONS);
			cff.bNoModalUI=FALSE;
			iceop->SetFilterOptions(&cff);
			iceop->Release();		
		}
		if (SUCCEEDED(iunk->QueryInterface(IID_ICeFileFilter2,(LPVOID*)&iceff))) {
			CFF_CONVERTINFO ci;
			CFF_SOURCEFILE sf;
			CFF_DESTINATIONFILE df;
			BOOL bCancel;
			long err;
			CCeFileFilterSite CeFileFilterSite;

			CeFileFilterSite.iceff=iceff;
			CeFileFilterSite.filter_hasdataloss=false;
			CeFileFilterSite.filter_wantconverterrordisplay=*wantconverrors;
			CeFileFilterSite.ConvPercentStart=ConvPercentStart;
			strcpy(CeFileFilterSite.m_sourcename,fromname);
			strcpy(CeFileFilterSite.m_targetname,toname);
			bCancel=false;
			ci.bImport=!datafromdevice;
			ci.hwndParent=hWnd;
			ci.bYesToAll=true;
			ci.pffs=&CeFileFilterSite;
			
			memset(&sf,0,sizeof(CFF_SOURCEFILE));
			strcpy(sf.szFullpath,fromname);
			strcpy(sf.szPath,fromname);
			p=strrchr(sf.szPath,'\\');
			if (p) {
				p[0]=0;
				p++;
				strcpy(sf.szFilename,p);
				p=strrchr(p,'.');
				if (p) {
					p++;
					strcpy(sf.szExtension,p);
				}
				WIN32_FIND_DATA fda;
				HANDLE hdl=FindFirstFile(fromname,&fda);
				if (hdl) {
					sf.cbSize=fda.nFileSizeLow;
					sf.ftCreated=fda.ftCreationTime;
					sf.ftModified=fda.ftLastWriteTime;
					FindClose(hdl);
				}
			}

			memset(&df,0,sizeof(CFF_DESTINATIONFILE));
			strcpy(df.szFullpath,toname);
			strcpy(df.szPath,toname);
			p=strrchr(df.szPath,'\\');
			if (p) {
				p[0]=0;
				p++;
				strcpy(df.szFilename,p);
				p=strrchr(p,'.');
				if (p) {
					p++;
					strcpy(df.szExtension,p);
				}
			}
			hres=iceff->NextConvertFile(0,&ci,&sf,&df,&bCancel,&err);
			success=SUCCEEDED(hres) || (hres==ERROR_NO_MORE_ITEMS);
			if (hres==E_FAIL) {
				char* buffer;
				char* varray[10];
				DWORD cb;
				memset(varray,0,sizeof(varray));
				varray[0]=fromname;
				varray[1]=toname;
				if SUCCEEDED(iceff->FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_HMODULE | FORMAT_MESSAGE_ARGUMENT_ARRAY,
					err,LOCALE_USER_DEFAULT,(LPTSTR)&buffer,0,(char**)&varray,&cb)) {
					RequestProc(PluginNumber,RT_MsgOK,"Conversion failure!",buffer,NULL,0);
					LocalFree((HLOCAL)buffer);
				}
			}
			*datalossreported=CeFileFilterSite.filter_hasdataloss;
			*wantconverrors=CeFileFilterSite.filter_wantconverterrordisplay;
			iceff->Release(); 
		}
		iunk->Release();
	}
	return success;		
}

