#include <windows.h>
#include "minidshow.h"
#pragma once

#define __IDxtCompositor_INTERFACE_DEFINED__
#define __IDxtAlphaSetter_INTERFACE_DEFINED__
#define __IDxtJpeg_INTERFACE_DEFINED__
#define __IDxtKey_INTERFACE_DEFINED__
//#include <qedit.h>

BOOL ScanQrCode(HINSTANCE hInstance, char* scanned,int maxlen);

class SimpleWebCam;
typedef void (*WebCamCallback)(char* data,int size, int width, int height, int bitspixel);

class CallbackHandler : public ISampleGrabberCB
{
public:
	CallbackHandler(SimpleWebCam* parent);
	~CallbackHandler();

	void SetCallback(WebCamCallback callback);

	virtual HRESULT __stdcall SampleCB(double time, IMediaSample* sample);
	virtual HRESULT __stdcall BufferCB(double time, BYTE* buffer, long len);
	virtual HRESULT __stdcall QueryInterface( REFIID iid, LPVOID *ppv );
	virtual ULONG	__stdcall AddRef();
	virtual ULONG	__stdcall Release();

private:
	WebCamCallback			callback;
	SimpleWebCam*			parent;
};

class SimpleWebCam
{
public:
	SimpleWebCam();
	~SimpleWebCam();
	
	int				GetIndex();
	int				GetWidth();
	int				GetHeight();
	const WCHAR*	GetName(int newindex);
	void			SetCallback(WebCamCallback callback);

	HRESULT			GetDeviceList();
	int				GetDeviceCount();
	HRESULT			OpenCamera(int newindex);
	void			CloseCamera();
	HRESULT			Start();
	HRESULT			Stop();
	bool			isRunning;

private:
	int				index;
	int				id;
	int				width;
	int				height;
	char			friendlyname[256];
	WCHAR			filtername[256];

	IFilterGraph2*			graph;
	ICaptureGraphBuilder2*	capture;
	IMediaControl*			control;

	IBaseFilter*	sourcefilter;
	IBaseFilter*	samplegrabberfilter;
	IBaseFilter*	nullrenderer;

	ISampleGrabber* samplegrabber;
	CallbackHandler *callbackhandler;
	WCHAR*			devicenames[8];
	IMoniker*		monikers[8];
	int				devicecount;
};
