#include <windows.h>
#include <shellapi.h>
#include <tchar.h>
#include <time.h>
#include "resource.h"
#include "webcamdlg.h" 
#include "utils.h"

// Global Variables:
HINSTANCE hInst;								// current instance
HWND maindlg;

extern TCHAR inifilename[MAX_PATH];

#ifdef WIN64
#define myint INT_PTR
#else
#define myint int
#endif

SimpleWebCam* cam=NULL;
POINT buffersize;
HWND combobox_handle;
int cbheight=0;
HDC backbuffer=0;
HBITMAP oldbitmap=0;
bool sizechanged=false;
bool stopped=false;
bool loadTried=false;
typedef bool (cdecl *DEF_DecodeQrCode)(char* buffer, int width, int height,char* resStr,int maxlen);
HANDLE hLib;
DEF_DecodeQrCode DecodeQrCode=NULL;
char ReceivedCode[256];

#ifndef countof
#define countof(array) (sizeof(array)/sizeof(array[0]))
#endif // countof

myint CALLBACK ScanDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

BOOL ScanQrCode(HINSTANCE hInstance, char* scanned,int maxlen)
{
	hInst=hInstance;
	ReceivedCode[0]=0;
	sizechanged=false;
	stopped=false;
	HWND parent=GetActiveWindow();
	DialogBox(hInst,(LPCTSTR)MAKEINTRESOURCE(IDD_QRCODE),parent,ScanDlgProc);
	if (cam!=NULL) {
		cam->CloseCamera();
		cam=NULL;
	}
	if (backbuffer!=0) {
		SelectObject(backbuffer,oldbitmap);
		DeleteDC(backbuffer);
		backbuffer=0;
	}

	cam=NULL;
	EnableWindow(parent,true);
	SetActiveWindow(parent);
	SetForegroundWindow(parent);
	if (ReceivedCode[0]!=0) {
		scanned[0]=0;
		strncat(scanned,ReceivedCode,maxlen);
		return TRUE;
	}
	return FALSE;
}

bool decodeQrCode(int bpp,char* data,int width,int height,char* resStr,int maxlen)
{
	if (DecodeQrCode==NULL && ! loadTried) {
		loadTried=true;
		TCHAR name[256];
		GetModuleFileName(hInst,name,countof(name)-1);
		TCHAR* p=_tcsrchr(name,'\\');
		if (p!=NULL)
			p[1]=0;
		else
			name[0]=0;
		_tcslcat(name,
#ifdef WIN64
			TEXT("qrcodelib64.dll"),
#else
			TEXT("qrcodelib.dll"),
#endif
			sizeof(name)-1);
		hLib=LoadLibrary(name);
		DecodeQrCode=(DEF_DecodeQrCode)GetProcAddress((HMODULE)hLib,"DecodeQrCode");
//		bool test=DecodeQrCode((char*)testbuffer, testwidth, testheight, name, sizeof(name)-1);
//		if (!test || strcmp(name,"Hello!")!=0)
//			DecodeQrCode=NULL;
	}
	if (DecodeQrCode==NULL)
		return false;
	// first, convert to greyscale
	if (bpp==24) {
		for (int y = 0; y < height; y++) {
			int offset = y * width;
			int end=offset+width;
			int offset2 = end*3-3;  // the code is upside down!
			for (; offset < end; offset++) {
				int r = (unsigned char)data[offset2];
				int g = (unsigned char)data[offset2+1];
				int b = (unsigned char)data[offset2+2];
				data[offset] = (byte) ((r + g + g + b) >> 2);
				offset2-=3;
			}
		}
	} else
		return false;
	bool ret=DecodeQrCode((char*)data, width, height, resStr, maxlen);
	if (!ret) {  // try again mirrored image!
		int halfwidth=width/2;
		for (int y = 0; y < height; y++) {
			int offset = y * width;
			int last=offset+width-1;
			int x2=0;
			for (; offset < last; offset++, last--) {
				char swap=data[offset];
				data[offset]=data[last];
				data[last]=swap;
			}
		}
		ret=DecodeQrCode((char*)data, width, height, resStr, maxlen);
	}
	return ret;
}

int lasttime=0;

void callback(char* data,int size, int width, int height, int bitspixel)
{
	if (backbuffer!=0 && !stopped) {
		BITMAPINFO bmi;
		memset(&bmi, 0, sizeof(BITMAPINFO));
		bmi.bmiHeader.biSize = sizeof(BITMAPINFO);
		bmi.bmiHeader.biWidth = width;
		bmi.bmiHeader.biHeight = height;
		bmi.bmiHeader.biPlanes = 1;
		bmi.bmiHeader.biBitCount = 24;
		bmi.bmiHeader.biCompression = BI_RGB;
		if (height==buffersize.y && width==buffersize.x)
			SetDIBitsToDevice(backbuffer,0,0,width,height, 0, 0, 0, (UINT)height, data, &bmi, DIB_RGB_COLORS);
		else {
			HDC tempbuffer = CreateCompatibleDC(backbuffer);
			HBITMAP	tempbitmap = CreateCompatibleBitmap(backbuffer, width, height);
			HBITMAP oldbitmap=(HBITMAP)SelectObject(tempbuffer,tempbitmap);
			SetDIBitsToDevice(tempbuffer,0,0,width,height, 0, 0, 0, (UINT)height, data, &bmi, DIB_RGB_COLORS);
			SetStretchBltMode(backbuffer,HALFTONE);
			SetBrushOrgEx(backbuffer,0,0,NULL);
			int drawx,drawy;
			drawx=buffersize.x;
			drawy=(buffersize.x*height)/width;
			if (drawy>buffersize.y) {
				drawx=(buffersize.y*width)/height;
				drawy=buffersize.y;
			}
			StretchBlt(backbuffer,(buffersize.x-drawx)/2,(buffersize.y-drawy)/2,
				drawx,drawy,tempbuffer,0,0,width,height,SRCCOPY);
			SelectObject(tempbuffer,oldbitmap);
			DeleteObject(tempbitmap);
			DeleteDC(tempbuffer);
		}
		RECT invalid = {0,cbheight,buffersize.x,buffersize.y+cbheight};
		InvalidateRect(maindlg, &invalid, false);

		int thistime=(int)GetCurrentTime();
		if (abs(lasttime-thistime)>100) {
			if (decodeQrCode(24,data,width,height,ReceivedCode, sizeof(ReceivedCode)-1)) {
				stopped=true;
				PostMessage(maindlg,WM_SYSCOMMAND,SC_CLOSE,0);
			} else
				ReceivedCode[0]=0;
			lasttime=(int)GetCurrentTime();
		}
	}
}

void InitCamera() 
{
	TCHAR defaultCamera[100];
	WCHAR defaultCameraW[100];
	GetPrivateProfileString(TEXT("_cam_settings"),TEXT("cam"),TEXT(""),defaultCamera,countof(defaultCamera),inifilename);
#ifdef UNICODE
	defaultCameraW[0]=0;
	wcsncat(defaultCameraW,defaultCamera,countof(defaultCameraW));
#else
	MultiByteToWideChar(CP_ACP,0,defaultCamera,-1,defaultCameraW,countof(defaultCameraW));
#endif
	cam=new SimpleWebCam();
	int defaultCameraIndex=0;
	int cnt=cam->GetDeviceCount();
	if (cnt>0) {
		WCHAR name[100];
		char str[100];
		int dupecounts[20];   // check for duplicate names!, append (2), (3) etc.
		memset(dupecounts,0,sizeof(dupecounts));
		for (int i=0;i<cnt;i++) {
			name[0]=0;
			wcsncat(name,cam->GetName(i),countof(name)-10);
			for (int j=0;j<i;j++) {
				if (wcscmp(name,cam->GetName(j))==0) {
					dupecounts[i]++;
					wcscat(name,L" (");
					_itow(dupecounts[i]+1,name+wcslen(name),10);
				 	wcscat(name,L")");
					break;
				}
			}
			if (defaultCameraW[0]!=0 && wcscmp(defaultCameraW,name)==0)
				defaultCameraIndex=i;
#ifdef UNICODE
			SendMessage(combobox_handle,CB_ADDSTRING,0,(LPARAM)name);
#else
			WideCharToMultiByte(CP_ACP,0,name,-1,str,sizeof(str)-1,NULL,NULL);
			SendMessage(combobox_handle,CB_ADDSTRING,0,(LPARAM)str);
#endif
		}
		if (SUCCEEDED(cam->OpenCamera(defaultCameraIndex))) {
			cam->SetCallback(callback);
			cam->Start();
			SendMessage(combobox_handle,CB_SETCURSEL,defaultCameraIndex,0);
		}
	}
}

myint CALLBACK ScanDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	int wmId, wmEvent, idx;
	PAINTSTRUCT ps;
	HDC hdc;
	RECT rt;
	maindlg=hWnd;

	switch (message) 
	{
		case WM_INITDIALOG:
			SetTimer(hWnd,1,500,NULL);
			combobox_handle = GetDlgItem(hWnd,IDC_COMBO1);
			return true;
		case WM_TIMER:
			KillTimer(hWnd,1);
			InitCamera();
			return true;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDC_COMBO1:
					if (wmEvent==CBN_SELCHANGE)	{
						idx=SendMessage(combobox_handle,CB_GETCURSEL,0,0);
						if (cam!=NULL && idx!=cam->GetIndex()) {
							TCHAR camname[100];
							SendMessage(combobox_handle,CB_GETLBTEXT,idx,(LPARAM)&camname);
							if (SUCCEEDED(cam->OpenCamera(idx))) {
								WritePrivateProfileString(TEXT("_cam_settings"),TEXT("cam"),camname,inifilename);
								cam->Start();
							}
						}
					}
					break;
				default:
				   return false;
			}
			return true;
		case WM_SIZE:
			sizechanged=true;
			GetClientRect(hWnd, &rt);
			MoveWindow(combobox_handle,0,0,rt.right,200,true);
			RECT cbrect;
			GetWindowRect(combobox_handle,&cbrect);
			cbheight=cbrect.bottom-cbrect.top;
			break;
		case WM_PAINT:
			// TODO: Add any drawing code here...
			GetClientRect(hWnd, &rt);
			hdc = BeginPaint(hWnd, &ps);
			if (backbuffer!=0)
				BitBlt(hdc, 0, cbheight, rt.right, rt.bottom-cbheight, backbuffer, 0, 0, SRCCOPY);
			if (backbuffer==0 || sizechanged) {
				sizechanged=false;
				bool needDelete=backbuffer!=0;
				if (backbuffer==0)
					backbuffer = CreateCompatibleDC(hdc);
				buffersize.x=rt.right;
				buffersize.y=rt.bottom-cbheight;
				HBITMAP backbitmap = CreateCompatibleBitmap(hdc,buffersize.x,buffersize.y);
				HBITMAP old=(HBITMAP)SelectObject(backbuffer,(HGDIOBJ)backbitmap);
				if (needDelete)
					DeleteObject(old);
				else
					oldbitmap=old;
			}				
			EndPaint(hWnd, &ps);
			return true;
		case WM_SYSCOMMAND:
			switch(LOWORD(wParam)) {
				case SC_CLOSE:
					EndDialog(hWnd, IDOK);
					return 1;
			}
			break;
	}
	return false;
}


