#include <windows.h>
#include <tchar.h>
#include <time.h>
#include "multiserver.h"
#include "utils.h"

// save servers in linked list

BOOL HasWebCams();

typedef struct {
	TCHAR displayname[260];
	SERVERID serverid;
	void* next;
	BOOL serverupdated;
} SERVERENTRY, *PSERVERENTRY;

PSERVERENTRY server_linked_list=NULL;

BOOL camerawasdisabled=false;

int LoadServersFromIni(TCHAR* inifilename,TCHAR* quickconnectname,TCHAR* qrcodename)
{
	// Retrieve server list
	if (qrcodename && !HasWebCams())
		qrcodename=NULL;

	int servercount=0;
	TCHAR serverlist[32768];
	PSERVERENTRY preventry=NULL;
	BOOL updating=server_linked_list!=NULL;
	if (updating) { // list exists -> update!
		PSERVERENTRY thisentry;
		thisentry=server_linked_list;
		while (thisentry) {
			thisentry->serverupdated=false;
			preventry=thisentry;
			thisentry=(PSERVERENTRY)(thisentry->next);
		}
	}		
	GetPrivateProfileString(NULL,NULL,TEXT(""),serverlist,countof(serverlist),inifilename);
	TCHAR *p=serverlist;
	while (p[0]) {
		// Each server MUST have the value "server"!!!
		TCHAR server[512];
		GetPrivateProfileString(p,TEXT("server"),TEXT(""),server,countof(server),inifilename);
		if (server[0]) {
			PSERVERENTRY newentry;
			servercount++;
			BOOL serverfound=false;
			if (updating) {  // look if entry already exists
				PSERVERENTRY thisentry=server_linked_list;
				while (thisentry) {
					if (_tcsicmp(thisentry->displayname,p)==0) {
						thisentry->serverupdated=true;
						serverfound=true;
						break;
					}
					thisentry=(PSERVERENTRY)(thisentry->next);
				}
			}
			if (!serverfound) {
				newentry=(PSERVERENTRY)malloc(sizeof(SERVERENTRY));
				if (newentry) {
					_tcslcpy(newentry->displayname,p,countof(newentry->displayname)-1);
					newentry->serverid=NULL;
					newentry->next=NULL;
					newentry->serverupdated=true;
				}
				if (preventry)
					preventry->next=newentry;
				else
					server_linked_list=newentry;
				preventry=newentry;
			}
		}
		p=p+_tcslen(p)+1;
	}
	// now delete all servers which aren't currently connected, and no longer in ini file
	if (updating) { // list exists -> update!
		PSERVERENTRY thisentry,preventry,nextentry;
		thisentry=server_linked_list;
		preventry=NULL;
		BOOL needrelink=false; // need to re-link linked list
		while (thisentry) {
			if (!thisentry->serverupdated && thisentry->serverid==NULL && (quickconnectname==NULL || _tcscmp(thisentry->displayname,quickconnectname)!=0)
				&& (qrcodename==NULL || _tcscmp(thisentry->displayname,qrcodename)!=0)) {
				if (preventry)
					preventry->next=NULL;
				nextentry=(PSERVERENTRY)(thisentry->next);
				free(thisentry);
				needrelink=true;
			} else {
				if (needrelink) {
					needrelink=false;
					if (preventry)
						preventry->next=thisentry;
					else
						server_linked_list=thisentry; // the first was deleted
				}
				preventry=thisentry;
				nextentry=(PSERVERENTRY)(thisentry->next);
			}
			thisentry=nextentry;
		}
	}
	// add "quick connect" entry as first list item
	if (!updating && quickconnectname) {
		PSERVERENTRY newentry=(PSERVERENTRY)malloc(sizeof(SERVERENTRY));
		if (newentry) {
			_tcscpy(newentry->displayname,quickconnectname);
			newentry->serverid=NULL;
			newentry->next=server_linked_list;
			newentry->serverupdated=true;
			server_linked_list=newentry;
		}
	}
	if ((!updating || camerawasdisabled) && qrcodename) {
		PSERVERENTRY newentry=(PSERVERENTRY)malloc(sizeof(SERVERENTRY));
		if (newentry) {
			_tcscpy(newentry->displayname,qrcodename);
			newentry->serverid=NULL;
			newentry->next=server_linked_list;
			newentry->serverupdated=true;
			server_linked_list=newentry;
		}
	}
	if (servercount==0 && qrcodename==NULL && quickconnectname==NULL)
		server_linked_list=NULL;
	camerawasdisabled=qrcodename==NULL;
	return servercount;
}

BOOL DeleteServerFromIni(TCHAR* servername,TCHAR* inifilename)
{
	return WritePrivateProfileString(servername,NULL,NULL,inifilename);
}

int CopyMoveServerInIni(TCHAR* oldservername,TCHAR* newservername,BOOL Move,BOOL OverWrite,TCHAR* inifilename)
{
	TCHAR captlist[1024];
	if (_tcsicmp(oldservername,newservername)==0)
		return 0;

	// now copy the options
	GetPrivateProfileString(oldservername,NULL,TEXT(""),captlist,countof(captlist)-1,inifilename);
	if (captlist[0]) {
		if (!OverWrite) {
			TCHAR testlist[100];
			// check whether server with new name already exists!
			testlist[0]=0;
			GetPrivateProfileString(newservername,NULL,TEXT(""),testlist,countof(testlist)-1,inifilename);
			if (testlist[0])
				return 1;
		}

		// Kill target section to delete fields not present in source section
		DeleteServerFromIni(newservername,inifilename);
		
		TCHAR* pcapt=captlist;
		while (pcapt[0]) {
			TCHAR valuebuf[1024];
			GetPrivateProfileString(oldservername,pcapt,TEXT(""),valuebuf,countof(valuebuf)-1,inifilename);
			WritePrivateProfileString(newservername,pcapt,valuebuf,inifilename);
			pcapt+=_tcslen(pcapt)+1;
		}
		if (Move)
			DeleteServerFromIni(oldservername,inifilename);
		return 0;
	}
	return 2;
}

void FreeServerList()
{
	if (server_linked_list) {
		PSERVERENTRY thisentry;
		thisentry=server_linked_list;
		while (thisentry) {
			PSERVERENTRY nextentry=(PSERVERENTRY)(thisentry->next);
			if (thisentry->serverid)
				free(thisentry->serverid);
			free(thisentry);
			thisentry=nextentry;
		}
	}
}

SERVERID GetServerIdFromName(TCHAR* displayname)
{
	if (server_linked_list) {
		PSERVERENTRY thisentry;
		thisentry=server_linked_list;
		while (thisentry) {
			if (_tcsicmp(thisentry->displayname,displayname)==0)
				return thisentry->serverid;
			thisentry=(PSERVERENTRY)(thisentry->next);
		}
	}
	return NULL;
}

BOOL SetServerIdForName(TCHAR* displayname,SERVERID newid)
{
	if (server_linked_list) {
		PSERVERENTRY thisentry;
		thisentry=server_linked_list;
		while (thisentry) {
			if (_tcsicmp(thisentry->displayname,displayname)==0) {
				if (thisentry->serverid)
					free(thisentry->serverid);
				thisentry->serverid=newid;
				return true;
			}
			thisentry=(PSERVERENTRY)(thisentry->next);
		}
	}
	return false;
}

void GetDisplayNameFromPath(TCHAR* Path,TCHAR* DisplayName,int maxlen)
{
	TCHAR* p=Path;
	while (p[0]=='\\' || p[0]=='/')
		p++;
	_tcslcpy(DisplayName,p,maxlen);
	p=DisplayName;
	while (p[0]!=0 && p[0]!='\\' && p[0]!='/')
		p++;
	p[0]=0;
}

SERVERHANDLE FindFirstServer(TCHAR* displayname,int maxlen)
{
	if (server_linked_list) {
		_tcslcpy(displayname,server_linked_list->displayname,maxlen);
		return server_linked_list;
	}
	return NULL;
}

SERVERHANDLE FindNextServer(SERVERHANDLE searchhandle,TCHAR* displayname,int maxlen)
{
	if (searchhandle) {
		PSERVERENTRY thisentry=(PSERVERENTRY)(searchhandle);
		thisentry=(PSERVERENTRY)thisentry->next;
		if (thisentry) {
			_tcslcpy(displayname,thisentry->displayname,maxlen);
			return thisentry;
		}
	}
	return NULL;
}
