// contents of fsplugin.h  version 1.1 (12.Nov.2002)

// ids for FsGetFile
#define FS_FILE_OK 0
#define FS_FILE_EXISTS 1
#define FS_FILE_NOTFOUND 2
#define FS_FILE_READERROR 3
#define FS_FILE_WRITEERROR 4
#define FS_FILE_USERABORT 5
#define FS_FILE_NOTSUPPORTED 6
#define FS_FILE_EXISTSRESUMEALLOWED 7

#define FS_EXEC_OK 0
#define FS_EXEC_ERROR 1
#define FS_EXEC_YOURSELF -1
#define FS_EXEC_SYMLINK -2

#define FS_COPYFLAGS_OVERWRITE 1
#define FS_COPYFLAGS_RESUME 2
#define FS_COPYFLAGS_MOVE 4
#define FS_COPYFLAGS_EXISTS_SAMECASE 8
#define FS_COPYFLAGS_EXISTS_DIFFERENTCASE 16
 
// flags for tRequestProc
#define RT_Other 0
#define RT_UserName 1
#define RT_Password 2
#define RT_Account 3
#define RT_UserNameFirewall 4
#define RT_PasswordFirewall 5
#define RT_TargetDir 6
#define RT_URL 7
#define RT_MsgOK 8
#define RT_MsgYesNo 9
#define RT_MsgOKCancel 10

// flags for tLogProc
#define MSGTYPE_CONNECT 1
#define MSGTYPE_DISCONNECT 2
#define MSGTYPE_DETAILS 3
#define MSGTYPE_TRANSFERCOMPLETE 4
#define MSGTYPE_CONNECTCOMPLETE 5
#define MSGTYPE_IMPORTANTERROR 6
#define MSGTYPE_OPERATIONCOMPLETE 7

// flags for FsStatusInfo
#define FS_STATUS_START 0
#define FS_STATUS_END 1

#define FS_STATUS_OP_LIST 1
#define FS_STATUS_OP_GET_SINGLE 2
#define FS_STATUS_OP_GET_MULTI 3
#define FS_STATUS_OP_PUT_SINGLE 4
#define FS_STATUS_OP_PUT_MULTI 5
#define FS_STATUS_OP_RENMOV_SINGLE 6
#define FS_STATUS_OP_RENMOV_MULTI 7
#define FS_STATUS_OP_DELETE 8
#define FS_STATUS_OP_ATTRIB 9
#define FS_STATUS_OP_MKDIR 10
#define FS_STATUS_OP_EXEC 11
#define FS_STATUS_OP_CALCSIZE 12
#define FS_STATUS_OP_SEARCH 13
#define FS_STATUS_OP_SEARCH_TEXT 14
#define FS_STATUS_OP_SYNC_SEARCH 15
#define FS_STATUS_OP_SYNC_GET 16
#define FS_STATUS_OP_SYNC_PUT 17
#define FS_STATUS_OP_SYNC_DELETE 18

#define FS_ICONFLAG_SMALL 1
#define FS_ICONFLAG_BACKGROUND 2

#define FS_ICON_USEDEFAULT 0
#define FS_ICON_EXTRACTED 1
#define FS_ICON_EXTRACTED_DESTROY 2
#define FS_ICON_DELAYED 3

#define FS_CRYPT_SAVE_PASSWORD 1
#define FS_CRYPT_LOAD_PASSWORD 2
#define FS_CRYPT_LOAD_PASSWORD_NO_UI 3 // Load password only if master password has already been entered!
#define FS_CRYPT_COPY_PASSWORD 4       // Copy encrypted password to new connection name
#define FS_CRYPT_MOVE_PASSWORD 5       // Move password when renaming a connection
#define FS_CRYPT_DELETE_PASSWORD 6     // Delete password


#define FS_CRYPTOPT_MASTERPASS_SET 1   // The user already has a master password defined

#define BG_DOWNLOAD 1                  // Plugin supports downloads in background
#define BG_UPLOAD 2                    // Plugin supports uploads in background
#define BG_ASK_USER 4                  // Plugin requires separate connection for background transfers -> ask 

typedef struct {
    DWORD SizeLow,SizeHigh;
    FILETIME LastWriteTime;
    int Attr;
} RemoteInfoStruct;

typedef struct {
	int size;
	DWORD PluginInterfaceVersionLow;
	DWORD PluginInterfaceVersionHi;
	char DefaultIniName[MAX_PATH];
} FsDefaultParamStruct;

// callback functions
typedef int (__stdcall *tProgressProc)(int PluginNr,TCHAR* SourceName,
             TCHAR* TargetName,int PercentDone);
typedef void (__stdcall *tLogProc)(int PluginNr,int MsgType,TCHAR* LogString);
typedef BOOL (__stdcall *tRequestProc)(int PluginNr,int RequestType,TCHAR* CustomTitle,
              TCHAR* CustomText,TCHAR* ReturnedText,int maxlen);
typedef int (__stdcall *tCryptProc)(int PluginNr,int CryptoNr,int Mode,
			  TCHAR* ConnectionName,TCHAR* Password,int maxlen);

// Function prototypes
int __stdcall FsInit(int PluginNr,tProgressProc pProgressProc,
                     tLogProc pLogProc,tRequestProc pRequestProc);
HANDLE __stdcall FsFindFirst(TCHAR* Path,WIN32_FIND_DATA *FindData);
BOOL __stdcall FsFindNext(HANDLE Hdl,WIN32_FIND_DATA *FindData);
int __stdcall FsFindClose(HANDLE Hdl);
BOOL __stdcall FsMkDir(TCHAR* Path);
int __stdcall FsExecuteFile(HWND MainWin,TCHAR* RemoteName,TCHAR* Verb);
int __stdcall FsRenMovFile(TCHAR* OldName,TCHAR* NewName,BOOL Move,
                           BOOL OverWrite,RemoteInfoStruct* ri);
int __stdcall FsGetFile(TCHAR* RemoteName,TCHAR* LocalName,int CopyFlags,
                        RemoteInfoStruct* ri);
int __stdcall FsPutFile(TCHAR* LocalName,TCHAR* RemoteName,int CopyFlags);
BOOL __stdcall FsDeleteFile(TCHAR* RemoteName);
BOOL __stdcall FsRemoveDir(TCHAR* RemoteName);
BOOL __stdcall FsDisconnect(TCHAR* DisconnectRoot);
BOOL __stdcall FsSetAttr(TCHAR* RemoteName,int NewAttr);
BOOL __stdcall FsSetTime(TCHAR* RemoteName,FILETIME *CreationTime,
      FILETIME *LastAccessTime,FILETIME *LastWriteTime);
void __stdcall FsStatusInfo(TCHAR* RemoteDir,int InfoStartEnd,int InfoOperation);
void __stdcall FsGetDefRootName(char* DefRootName,int maxlen);
int __stdcall FsExtractCustomIcon(TCHAR* RemoteName,int ExtractFlags,HICON* TheIcon);
void __stdcall FsSetDefaultParams(FsDefaultParamStruct* dps);

