// sertransplg.cpp : Defines the entry point for the DLL application.
//

#include <windows.h>
#include <tchar.h>
#include <time.h>
#include "fsplugin.h"
#include "utils.h"
#include "resource.h"
#include "webdav.h"
#include "davfunc.h"
#include "multiserver.h"

#ifdef UNICODE
#define UTCHAR unsigned short
#else
#define UTCHAR unsigned char
#endif

HINSTANCE hinst;
HWND hWndMain=NULL;

#define defininame TEXT("tcwebdav.ini")
TCHAR inifilename[MAX_PATH]=defininame;
TCHAR pluginname[]=TEXT("WebDAV");
char defrootname[]="WebDAV";

TCHAR s_f7newconnection[32];

BOOL disablereading=false;   // disable reading of subdirs to delete whole drives
BOOL freportconnect=true;    // report connect to caller only on first connect
BOOL ListLoaded=false;       // list of servers not yet loaded?

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
                )
{
	if (ul_reason_for_call==DLL_PROCESS_ATTACH) {
		hinst=(HINSTANCE)hModule;
		LoadString(hinst, IDS_F7NEW, s_f7newconnection, countof(s_f7newconnection));
	} else if (ul_reason_for_call==DLL_PROCESS_DETACH) {
		WebDavUnloadSslCertStore();
	}
	return TRUE;
}

int PluginNumber;
int CryptoNumber;
tProgressProc ProgressProc;
tLogProc LogProc;
tRequestProc RequestProc;
tCryptProc CryptProc;

DWORD lastpercenttime=0;
int lastpercent;
BOOL CryptCheckPass=false;   // check 'store password encrypted' by default

BOOL MessageLoop(void)
{
	BOOL aborted=false;
    if (ProgressProc && abs((int)GetCurrentTime()-(int)lastpercenttime)>250) {
        // important: also call AFTER soft_aborted is true!!!
        aborted=0!=ProgressProc(PluginNumber,NULL,NULL,lastpercent);
        // allow abort with Escape when there is no progress dialog!
        lastpercenttime=GetCurrentTime();
    }
    return aborted;
}

void ShowStatus(TCHAR* status)
{
    if (LogProc)
        LogProc(PluginNumber,MSGTYPE_DETAILS,status);
}

BOOL UpdatePercentBar(int percent)
{
    lastpercent=percent;  // used for MessageLoop below

    return MessageLoop();  // This actually sets the percent bar!
}

SERVERID GetServerIdAndRelativePathFromPath(TCHAR* Path,TCHAR* RelativePath,int maxlen)
{
	TCHAR DisplayName[3*MAX_PATH];
	GetDisplayNameFromPath(Path,DisplayName,countof(DisplayName)-1);
	SERVERID serverid=GetServerIdFromName(DisplayName);
	if (serverid) {
		WebDavGetRelativePath(serverid,RelativePath,maxlen);
		TCHAR* p=Path;
		while (p[0]=='\\' || p[0]=='/')  // skip initial slash
			p++;
		while (p[0]!=0 && p[0]!='\\' && p[0]!='/') // skip path
			p++;
		_tcslcat(RelativePath,p,maxlen);
		if (RelativePath[0]==0)
			_tcscpy(RelativePath,TEXT("\\"));
	} else if (maxlen)
		_tcscpy(RelativePath,TEXT("\\"));
	return serverid;
}

int __stdcall FsInit(int PluginNr,tProgressProc pProgressProc,tLogProc pLogProc,tRequestProc pRequestProc)
{
	ProgressProc=pProgressProc;
	LogProc=pLogProc;
	RequestProc=pRequestProc;
	PluginNumber=PluginNr;
	return 0;
}

void __stdcall FsSetCryptCallback(tCryptProc pCryptProc,int CryptoNr,int Flags)
{
	CryptProc=pCryptProc;
	CryptCheckPass=(Flags & FS_CRYPTOPT_MASTERPASS_SET)!=0;
	CryptoNumber=CryptoNr;
}

typedef struct {
   void* davdataptr;
   SERVERID serverid;
   SERVERHANDLE rootfindhandle;
   BOOL rootfindfirst;
} tLastFindStuct,*pLastFindStuct;

BOOL __stdcall FsDisconnect(TCHAR* DisconnectRoot)
{
	TCHAR DisplayName[3*MAX_PATH];
	GetDisplayNameFromPath(DisconnectRoot,DisplayName,countof(DisplayName)-1);
	SERVERID serverid=GetServerIdFromName(DisplayName);
	if (serverid) {
		TCHAR connbuf[MAX_PATH];
		_tcscpy(connbuf,TEXT("DISCONNECT \\"));
		_tcslcat(connbuf,DisplayName,countof(connbuf)-1);
		LogProc(PluginNumber,MSGTYPE_DISCONNECT,connbuf);
		WebDavCloseConnection(serverid);
		SetServerIdForName(DisplayName,NULL); // this frees it too!
	}
	return TRUE;
}

HANDLE __stdcall FsFindFirst(TCHAR* Path,WIN32_FIND_DATA *FindData)
{
	TCHAR remotedir[3*MAX_PATH],DisplayName[MAX_PATH];
	pLastFindStuct lf;

	void* davdataptr=NULL;
	BOOL wasconnected=true;

	if (_tcscmp(Path,TEXT("\\"))==0) {  // in the root!
		TCHAR s_helptext[256];
		LoadString(hinst, IDS_HELPTEXT, s_helptext, countof(s_helptext));
		LoadServersFromIni(inifilename,s_quickconnect,s_qrcode);
		ListLoaded=true;
		memset(FindData,0,sizeof(WIN32_FIND_DATA));

		_tcscpy(FindData->cFileName,s_f7newconnection);
		FindData->dwFileAttributes=0;
		FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
		FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
		FindData->nFileSizeLow=_tcslen(s_helptext);
		lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
		memset(lf,0,sizeof(tLastFindStuct));
		lf->rootfindfirst=true;
		return lf;
	} else {
		// load server list if user connects directly via URL
		if (!ListLoaded)
			LoadServersFromIni(inifilename,s_quickconnect,s_qrcode);
		ListLoaded=true;
		// only disable the reading within a server!
		if (disablereading) {
			SetLastError(ERROR_NO_MORE_FILES);
			return INVALID_HANDLE_VALUE;
		}

		GetDisplayNameFromPath(Path,DisplayName,countof(DisplayName)-1);
		SERVERID serverid=GetServerIdFromName(DisplayName);
		if (serverid==NULL) {
			wasconnected=false;
			serverid=WebDavConnectToServer(DisplayName,inifilename);
			if (serverid)
				SetServerIdForName(DisplayName,serverid);
			else {
				SetLastError(ERROR_PATH_NOT_FOUND);
				return INVALID_HANDLE_VALUE;
			}
		}
		// we are connected to server DisplayName now!

		if (ProgressProc(PluginNumber,Path,TEXT("temp"),0)) {
			SetLastError(ERROR_PATH_NOT_FOUND);
			return INVALID_HANDLE_VALUE;
		}

		memset(FindData,0,sizeof(WIN32_FIND_DATA));

		GetServerIdAndRelativePathFromPath(Path,remotedir,countof(remotedir)-1);

		// Retrieve the directory
		if (DAV_OK!=WebDavFindFirstFile(serverid,remotedir,&davdataptr)) {
			if (!wasconnected) {  // initial connect failed
				WebDavCloseConnection(serverid);
				SetServerIdForName(DisplayName,NULL); // this frees it too!
				freportconnect=false;
			}
			SetLastError(ERROR_PATH_NOT_FOUND);
			return INVALID_HANDLE_VALUE;
		}

		if (DAV_OK==WebDavFindNextFile(serverid,davdataptr,FindData,NULL)) {
			lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
			memset(lf,0,sizeof(tLastFindStuct));
			lf->davdataptr=davdataptr;
			lf->serverid=serverid;
			return (HANDLE)lf;
		} else {
			WebDavFindClose(serverid,davdataptr);
			SetLastError(ERROR_NO_MORE_FILES);
			return INVALID_HANDLE_VALUE;
		}
	}
	return INVALID_HANDLE_VALUE;
} 

BOOL __stdcall FsFindNext(HANDLE Hdl,WIN32_FIND_DATA *FindData)
{
	pLastFindStuct lf;

	if ((int)Hdl==1)
		return false;

	lf=(pLastFindStuct)Hdl;
	if (lf!=INVALID_HANDLE_VALUE) {
		if (lf->rootfindfirst) {
			SERVERHANDLE hdl=FindFirstServer(FindData->cFileName,countof(FindData->cFileName)-1);
			if (hdl) {
				lf->rootfindhandle=hdl;
				lf->rootfindfirst=false;
				FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
				FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
				FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
				FindData->nFileSizeLow=0;
				return true;
			} else
				return false;
		} else if (lf->rootfindhandle) {
			lf->rootfindhandle=FindNextServer(lf->rootfindhandle,FindData->cFileName,countof(FindData->cFileName)-1);
			return lf->rootfindhandle!=NULL;
		} else
			return WebDavFindNextFile(lf->serverid,lf->davdataptr,FindData,NULL)==DAV_OK;
	}
	return false;
}

int __stdcall FsFindClose(HANDLE Hdl)
{
   if (Hdl==INVALID_HANDLE_VALUE)
      return 0;
   pLastFindStuct lf;
   lf=(pLastFindStuct)Hdl;
   if (lf->davdataptr) {
	   WebDavFindClose(lf->serverid,lf->davdataptr);
	   lf->davdataptr=NULL;
   }
   free(lf);
   return 0;
}

BOOL __stdcall FsMkDir(TCHAR* Path)
{
	TCHAR* p=_tcschr(Path+1,'\\');
	if (p) {
		TCHAR remotedir[3*MAX_PATH];
		SERVERID serverid=GetServerIdAndRelativePathFromPath(Path,remotedir,countof(remotedir)-1);
		if (serverid)
			return WebDavCreateDirectory(serverid,remotedir)==DAV_OK;
		else
			return false;
	} else {  // new connection
		if (_tcscmp(Path+1,s_quickconnect)!=0 &&
			_tcscmp(Path+1,s_qrcode)!=0) {
			LoadServersFromIni(inifilename,s_quickconnect,s_qrcode);
			if (WebDavConfigureServer(Path+1,inifilename)) {
				LoadServersFromIni(inifilename,s_quickconnect,s_qrcode);
				return true;
			} else
				return false;
		} else
			return false;
	}
}

int __stdcall FsExecuteFile(HWND MainWin,TCHAR* RemoteName,TCHAR* Verb)
{
	if (_tcsicmp(Verb,TEXT("open"))==0) {
		return FS_EXEC_YOURSELF;
	} else if (_tcsicmp(Verb,TEXT("properties"))==0) {
		if (RemoteName[1] && _tcschr(RemoteName+1,'\\')==0 && _tcscmp(RemoteName+1,s_f7newconnection)!=0) {
			if (WebDavConfigureServer(RemoteName+1,inifilename)) {
				LoadServersFromIni(inifilename,s_quickconnect,s_qrcode);
			}
			return FS_EXEC_OK;
		} else {
			TCHAR remotedir[3*MAX_PATH],DisplayName[MAX_PATH];
			void* davdataptr=NULL;
			WIN32_FIND_DATA FindData;

			GetDisplayNameFromPath(RemoteName,DisplayName,countof(DisplayName)-1);
			SERVERID serverid=GetServerIdFromName(DisplayName);
			if (serverid==NULL)
				return FS_EXEC_ERROR;

			GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);

			// Retrieve the directory
			if (DAV_OK!=WebDavGetSingleFileProperties(serverid,remotedir,&davdataptr)) {
				return FS_EXEC_ERROR;
			}

			DAV_OPENDIR_DATA *oddatafound;
			if (DAV_OK==WebDavFindNextFile(serverid,davdataptr,&FindData,&oddatafound)) {
				// show dialog box
				ShowDavPropertiesDialog(&FindData,oddatafound);
				dav_closedir((DAV_OPENDIR_DATA*)davdataptr);
				free(davdataptr);
				return FS_EXEC_OK;
			} else {
				dav_closedir((DAV_OPENDIR_DATA*)davdataptr);
				free(davdataptr);
				return FS_EXEC_ERROR;
			}
		}
	} else
		return FS_EXEC_ERROR;
}

BOOL CopyMoveEncryptedPassword(TCHAR* OldName,TCHAR* NewName,BOOL Move)
{
	if (CryptProc)
		return CryptProc(PluginNumber,CryptoNumber,Move ? FS_CRYPT_MOVE_PASSWORD:FS_CRYPT_COPY_PASSWORD,
			OldName,NewName,0)==FS_FILE_OK;
	else
		return false;
}

int __stdcall FsRenMovFile(TCHAR* OldName,TCHAR* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
	lastpercent=0;
	TCHAR olddir[3*MAX_PATH],newdir[3*MAX_PATH];

	// Rename or copy a server?
	TCHAR* p1=_tcschr(OldName+1,'\\');
	TCHAR* p2=_tcschr(NewName+1,'\\');
	if (p1==NULL && p2==NULL) {
		switch (CopyMoveServerInIni(OldName+1,NewName+1,Move,OverWrite,inifilename)) {
			case 0:
				CopyMoveEncryptedPassword(OldName+1,NewName+1,Move);
				return FS_FILE_OK;
				break;
			case 1:
				return FS_FILE_EXISTS;
				break;
		}
		return FS_FILE_NOTFOUND;

	}

	SERVERID serverid1=GetServerIdAndRelativePathFromPath(OldName,olddir,countof(olddir)-1);
	SERVERID serverid2=GetServerIdAndRelativePathFromPath(NewName,newdir,countof(newdir)-1);

	// must be on same server!
	if (serverid1!=serverid2 || serverid1==NULL)
		return FS_FILE_NOTFOUND;
	BOOL isdir=false;
	if (ri)
		isdir=(ri->Attr & FILE_ATTRIBUTE_DIRECTORY)!=0;

	switch (WebDavRenameMoveFile(serverid1,olddir,newdir,Move,OverWrite,isdir)) {
	case DAV_OK:
		return FS_FILE_OK;
	case DAV_EXISTS:
		return FS_FILE_EXISTS;
	default:
		return FS_FILE_NOTFOUND;
	}
}

BOOL FileExists(TCHAR* LocalName)
{
	WIN32_FIND_DATA s;
	HANDLE findhandle;
	findhandle=FindFirstFile(LocalName,&s);
	if (findhandle==INVALID_HANDLE_VALUE)
		return false;
	else {
		FindClose(findhandle);
		return true;
	}
}

void RemoveInalidChars(TCHAR* p)
{
   while (p[0]) {
      if ((UTCHAR)(p[0])<32)
         p[0]=' ';
      else if (p[0]==':' || p[0]=='|' || p[0]=='*' || p[0]=='?' || p[0]=='\\' || p[0]=='/' || p[0]=='"')
         p[0]='_';
      p++;
   }
}

int __stdcall FsGetFile(TCHAR* RemoteName,TCHAR* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
	int err;
	BOOL OverWrite,Resume,Move;

	lastpercent=0;
	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;

	if (_tcslen(RemoteName)<3)
		return FS_FILE_NOTFOUND;

	if (_tcscmp(RemoteName+1,s_f7newconnection)==0) {
		HANDLE houtfile=CreateFile(LocalName,GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
			OverWrite ? CREATE_ALWAYS : CREATE_NEW,
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
		if (houtfile!=INVALID_HANDLE_VALUE) {
			DWORD written;
			char s_helptext[256];
			LoadStringA(hinst, IDS_HELPTEXT, s_helptext, countof(s_helptext));
			BOOL ret=WriteFile(houtfile,s_helptext,strlen(s_helptext),&written,NULL);
			CloseHandle(houtfile);
			if (ret)
				return FS_FILE_OK;
		} else
			if (OverWrite)
				return FS_FILE_EXISTS;
		return FS_FILE_WRITEERROR;
	}

	TCHAR* p=_tcsrchr(LocalName,'\\');
	if (p)
		RemoveInalidChars(p+1);  // Changes the name passed in!

	err=ProgressProc(PluginNumber,RemoteName,LocalName,0);
	if (err)
		return FS_FILE_USERABORT;
	if (OverWrite)
		DeleteFile(LocalName);
	else {
		if (!Resume && FileExists(LocalName))
			return FS_FILE_EXISTSRESUMEALLOWED;
	}

	_int64 filesize=(((_int64)ri->SizeHigh)<<32)+ri->SizeLow;

	TCHAR remotedir[3*MAX_PATH];
	
	SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);
	if (serverid==NULL)
		return FS_FILE_READERROR;

	switch (WebDavDownloadFile(serverid,remotedir,LocalName,true,filesize,&ri->LastWriteTime,Resume)) {
		case DAV_OK:return FS_FILE_OK;
		case DAV_EXISTS:return FS_FILE_EXISTS;
		case DAV_READFAILED:return FS_FILE_READERROR;
		case DAV_WRITEFAILED:return FS_FILE_WRITEERROR;
		case DAV_ABORT:return FS_FILE_USERABORT;
	}
	return FS_FILE_OK;
}


int __stdcall FsPutFile(TCHAR* LocalName,TCHAR* RemoteName,int CopyFlags)
{
	int err;
	DWORD resumeat;
	BOOL OverWrite,Resume,Move;

	lastpercent=0;
	OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
	Resume=CopyFlags & FS_COPYFLAGS_RESUME;
	Move=CopyFlags & FS_COPYFLAGS_MOVE;

	// WebDAV auto-overwrites files -> return error if file exists
	if ((CopyFlags & (FS_COPYFLAGS_EXISTS_SAMECASE | FS_COPYFLAGS_EXISTS_DIFFERENTCASE)) &&
		!(OverWrite | Resume))
		return FS_FILE_EXISTS;   // resume not supported by HTTP PUT!

	if (_tcslen(RemoteName)<3)
		return FS_FILE_WRITEERROR;

	err=ProgressProc(PluginNumber,LocalName,RemoteName,0);
	if (err)
		return FS_FILE_USERABORT;

	TCHAR remotedir[3*MAX_PATH];
	
	SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);
	if (serverid==NULL)
		return FS_FILE_READERROR;

	if (OverWrite && !Resume && WebDavDeleteBeforeUpload(serverid))  // needed for 1&1 webdav server!
		WebDavDeleteFile(serverid,remotedir,false);

	resumeat=0;
	if (Resume)
		return FS_FILE_NOTSUPPORTED;

	switch (WebDavUploadFile(serverid,LocalName,remotedir,resumeat)) {
		case DAV_OK:return FS_FILE_OK;
		case DAV_EXISTS:return FS_FILE_EXISTSRESUMEALLOWED;
		case DAV_READFAILED:return FS_FILE_READERROR;
		case DAV_WRITEFAILED:return FS_FILE_WRITEERROR;
		case DAV_ABORT:return FS_FILE_USERABORT;
	}
	return FS_FILE_NOTFOUND;
}

BOOL __stdcall FsDeleteFile(TCHAR* RemoteName)
{
	if (_tcslen(RemoteName)<3)
		return false;

	TCHAR remotedir[3*MAX_PATH];
	SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);
	if (serverid==NULL)
		return false;
	
	lastpercent=0;
	return WebDavDeleteFile(serverid,remotedir,false)==DAV_OK;
}

BOOL __stdcall FsRemoveDir(TCHAR* RemoteName)
{
	if (_tcslen(RemoteName)<1)
		return false;

	TCHAR* p=_tcschr(RemoteName+1,'\\');
	if (p) {
		TCHAR remotedir[3*MAX_PATH];
		SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);
		if (serverid==NULL)
			return FS_FILE_READERROR;
		lastpercent=0;

		if (WebDavDeleteFile(serverid,remotedir,true)==DAV_OK) {
			if (CryptProc)
				CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_DELETE_PASSWORD,
					RemoteName+1,NULL,0);
			return true;
		} else
			return false;
	} else {	// delete server
		return DeleteServerFromIni(RemoteName+1,inifilename);
	}
}

BOOL __stdcall FsSetAttr(TCHAR* RemoteName,int NewAttr)
{
	TCHAR remotedir[3*MAX_PATH];
	SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);
	if (serverid==NULL)
		return FS_FILE_READERROR;
	
	lastpercent=0;
	return WebDavSetAttr(serverid,remotedir,NewAttr)==DAV_OK;
}

BOOL __stdcall FsSetTime(TCHAR* RemoteName,FILETIME *CreationTime,
      FILETIME *LastAccessTime,FILETIME *LastWriteTime)
{
	TCHAR remotedir[3*MAX_PATH];
	SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteName,remotedir,countof(remotedir)-1);
	if (serverid==NULL)
		return FS_FILE_READERROR;

	lastpercent=0;
	return WebDavSetDateTime(serverid,remotedir,LastWriteTime)==DAV_OK;
}

void __stdcall FsStatusInfo(TCHAR* RemoteDir,int InfoStartEnd,int InfoOperation)
{
	if (_tcslen(RemoteDir)<2)
		if (InfoOperation==FS_STATUS_OP_DELETE || InfoOperation==FS_STATUS_OP_RENMOV_MULTI)
			if (InfoStartEnd==FS_STATUS_START)
				disablereading=true;
			else
				disablereading=false;

	TCHAR remotedir[3*MAX_PATH];
	SERVERID serverid=GetServerIdAndRelativePathFromPath(RemoteDir,remotedir,countof(remotedir)-1);
	if (serverid)
		WebDavStatusInfo(serverid,remotedir,InfoStartEnd,InfoOperation);
}

void __stdcall FsGetDefRootName(char* DefRootName,int maxlen)  // always Ansi!
{
	strlcpy(DefRootName,defrootname,maxlen);
}

// use default location, but our own ini file name!
void __stdcall FsSetDefaultParams(FsDefaultParamStruct* dps)
{
#ifdef UNICODE
	MultiByteToWideChar(CP_ACP,0,dps->DefaultIniName,-1,inifilename,countof(inifilename)-1);
#else
	strlcpy(inifilename,dps->DefaultIniName,MAX_PATH-1);
#endif
	TCHAR* p=_tcsrchr(inifilename,'\\');
	if (p)
		p[1]=0;
	else
		inifilename[0]=0;
	_tcslcat(inifilename,defininame,countof(inifilename)-1);
}

int __stdcall FsExtractCustomIcon(TCHAR* RemoteName,int ExtractFlags,HICON* TheIcon)
{
	TCHAR buf[256];
	buf[0]='\\';
	_tcslcpy(buf+1,s_qrcode,countof(buf)-2);
	_tcslcat(buf,TEXT("\\"),countof(buf)-1);
	if (RemoteName[0]=='\\' && _tcscmp(RemoteName,buf)==0) {
		int size;
		if (ExtractFlags & FS_ICONFLAG_SMALL)
			size=16;
		else
			size=32;
		*TheIcon=(HICON)LoadImage(hinst, MAKEINTRESOURCE(IDI_ICON2),
			IMAGE_ICON, size, size, LR_SHARED);			
		return FS_ICON_EXTRACTED;
	}
	return FS_ICON_USEDEFAULT;
}

int __stdcall FsGetBackgroundFlags(void)
{
	return BG_DOWNLOAD | BG_UPLOAD;
}

