#include "http.h"

#define DAV_OK 0
#define DAV_FAILED 1
#define DAV_EXISTS 2
#define DAV_READFAILED 3
#define DAV_WRITEFAILED 4
#define DAV_ABORT 5

typedef struct dav_opendir_data DAV_OPENDIR_DATA;

#define s_quickconnect TEXT("Quick connection")
#define s_qrcode TEXT("_QR-Code")

struct dav_opendir_data {
	const char *href;                // resource info
	DAV_PROP *prop;
	const TCHAR *filename;            // info extracted from href and prop
	const char *lockowner;            // for convenience
	int type;
	__int64 size;
	FILETIME cdate;
	FILETIME mdate;
	DAV_MULTISTATUS *multistatus;    // internal stuff
	DAV_RESPONSE *response_cursor;
	int directory_slash_count;
	int base_slash_count;
	const TCHAR *additional_prop;
	TCHAR namebuf[1024];
	TCHAR dirname[1024];
	int dirnamelen;
	BOOL bodyisutf8;         // xml body is in utf-8
	BOOL interpreturlasutf8; // tamino: send/receive urls as utf-8
};

void* WebDavConnectToServer(TCHAR* DisplayName,TCHAR* inifilename);
BOOL WebDavConfigureServer(TCHAR* DisplayName,TCHAR* inifilename);
int WebDavCloseConnection(void* serverid);
int WebDavFindFirstFile(void* serverid,TCHAR* remotedir,void** davdataptr);
BOOL WebDavFindNextFile(void* serverid,void* davdataptr,WIN32_FIND_DATA *FindData,DAV_OPENDIR_DATA **oddatafound);
int WebDavFindClose(void* serverid,void* davdataptr);
int WebDavGetSingleFileProperties(void* serverid,TCHAR* remotedir,void** davdataptr);
void ShowDavPropertiesDialog(WIN32_FIND_DATA* FindData,DAV_OPENDIR_DATA *oddatafound);
void dav_closedir(DAV_OPENDIR_DATA *oddata);
int WebDavCreateDirectory(void* serverid,TCHAR* Path);
int WebDavRenameMoveFile(void* serverid,TCHAR* OldName,TCHAR* NewName,BOOL Move, BOOL Overwrite, BOOL isdir);
int WebDavDownloadFile(void* serverid,TCHAR* RemoteName,TCHAR* LocalName,BOOL alwaysoverwrite,
					   _int64 filesize,FILETIME *ft,BOOL Resume);
void WebDavSetOverwriteFlag();
int WebDavUploadFile(void* serverid,TCHAR* LocalName,TCHAR* RemoteName,DWORD resumeat);
int WebDavDeleteFile(void* serverid,TCHAR* RemoteName,BOOL isdir);
int WebDavSetAttr(void* serverid,TCHAR* RemoteName,int NewAttr);
int WebDavSetDateTime(void* serverid,TCHAR* RemoteName,FILETIME *LastWriteTime);
void WebDavGetRelativePath(void* serverid,TCHAR* RelativePath,int maxlen);
BOOL WebDavDeleteBeforeUpload(void* serverid);
void WebDavUnloadSslCertStore();
void WebDavStatusInfo(void* serverid,TCHAR* remotedir,int InfoStartEnd,int InfoOperation);

