#define _WIN32_WINNT 0x400

#include <windows.h>
#include <WININET.h>
#include <string.h>
#include <time.h>
#include <tchar.h>
#include <wincrypt.h>
#include <winbase.h>
#include <map>
#include <string>
#include "strutl.h"
#include "webdav.h"
#include "davfunc.h"
#include "utils.h"
#include "resource.h"
#include "fsplugin.h"
#include "multiserver.h"
#include "cvtutf.h"
#include "webcamdlg.h"
#include "Base64Encoder.h"
#include "wlanfunctions.h"

#pragma comment (lib, "crypt32.lib")

#ifndef CERT_NAME_SIMPLE_DISPLAY_TYPE
#define CERT_NAME_SIMPLE_DISPLAY_TYPE   4
#endif

#ifndef CERT_NAME_ISSUER_FLAG
#define CERT_NAME_ISSUER_FLAG           0x1
#define CERT_NAME_DISABLE_IE4_UTF8_FLAG 0x00010000
#endif

#ifndef INTERNET_OPTION_CLIENT_CERT_CONTEXT
#define INTERNET_OPTION_CLIENT_CERT_CONTEXT      84
#endif

#ifdef UNICODE
#define _tcsprintf swprintf
#else
#define _tcsprintf sprintf
#endif

#define wdirtypemax 1024

int GetMimeTypeFromMap(char* ext,char* mime,int maxlen);
int getslashcount(TCHAR* p);

#ifdef UNICODE
WCHAR* wcslcpy(WCHAR *str1,const WCHAR *str2,int imaxlen)
{
	if ((int)wcslen(str2)>=imaxlen-1) {
		wcsncpy(str1,str2,imaxlen-1);
		str1[imaxlen-1]=0;
	} else
		wcscpy(str1,str2);
	return str1;
}

WCHAR* wcslcat(wchar_t *str1,const WCHAR *str2,int imaxlen)
{
	int l1=(int)wcslen(str1);
	if ((int)wcslen(str2)+l1>=imaxlen-1) {
		wcsncpy(str1+l1,str2,imaxlen-1-l1);
		str1[imaxlen-1]=0;
	} else
		wcscat(str1,str2);
	return str1;
}

BOOL MakeExtraLongNameW(WCHAR* outbuf,const WCHAR* inbuf,int maxlen)
{
	if (wcslen(inbuf)>259) {
		wcslcpy(outbuf,L"\\\\?\\",maxlen);
		wcslcat(outbuf,inbuf,maxlen);
	} else
		wcslcpy(outbuf,inbuf,maxlen);
	return (int)wcslen(inbuf)+4<=maxlen;
}

HANDLE CreateFileT(WCHAR* lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,
  LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,
  DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{
	WCHAR wbuf[wdirtypemax+4];
	if (MakeExtraLongNameW(wbuf,lpFileName,wdirtypemax+3))
		return CreateFileW(wbuf,dwDesiredAccess,dwShareMode,
			lpSecurityAttributes,dwCreationDisposition,
			dwFlagsAndAttributes,hTemplateFile);
	else
		return INVALID_HANDLE_VALUE;
}
#else
#define CreateFileT CreateFileA
#endif


// SR: 09.07.2005

// ****************************************************************************
// ******                       Definition zu countof                    ******
// ****************************************************************************
#ifndef countof
#define countof(array) (sizeof(array)/sizeof(array[0]))
#endif // countof

#include <tchar.h>
#define STRSAFE_NO_DEPRECATE

#define SSL_CLIENT_CERTIFICATE_STORE TEXT("MY")

void SetSSLCert(void* serverid, HINTERNET hRequest);

// SR: 09.07.2005


extern BOOL UpdatePercentBar(int percent);
extern void ShowStatus(TCHAR* status);
extern HINSTANCE hinst;
extern int PluginNumber;
extern tProgressProc ProgressProc;
extern tLogProc LogProc;
extern tRequestProc RequestProc;
extern tCryptProc CryptProc;

extern int CryptoNumber;
extern BOOL CryptCheckPass;

int numconnections=0;
BOOL serverfieldchangedbyuser=false;

// Note: Due to a bug in Windows 7 x64, this must be made global and must NOT be closed
// until the dll is unloaded! Why? It seems that once InternetSetOption(hRequest, INTERNET_OPTION_CLIENT_CERT_CONTEXT,
// has been called, Windows 7 x64 will try to access the same certificate on future
// connections. If the cert store is closed, the data is no longer available, resulting
// in a crash. 13.10.2010, Christian Ghisler
HCERTSTORE SslCertStore=NULL;

void WebDavUnloadSslCertStore()
{
	if (SslCertStore != NULL)
	{
		CertCloseStore(SslCertStore, CERT_CLOSE_STORE_FORCE_FLAG);
		SslCertStore = NULL;
	}
}

typedef std::map<int, HINTERNET> BackgroundConnectionMap;

typedef struct {
	TCHAR server[MAX_PATH];
	TCHAR user[MAX_PATH];
	TCHAR password[MAX_PATH];
	TCHAR rootdir[MAX_PATH];
	BOOL SslConnect;
	DWORD SslFlags;
	TCHAR SslCertIssuer[MAX_PATH];
	char SslCertSerial[MAX_PATH];   // always Ansi!
	HINTERNET InetHandle;
	HINTERNET ForegroundConnHandle;
	int ForegroundThreadId;
	BackgroundConnectionMap *bgConnMap;
	CRITICAL_SECTION connMapSection;
	int customport;
	BOOL interpreturlasutf8;
	BOOL dialogforconnection;
	BOOL use3stepuploadmethod;
	BOOL usemultistepuploadmethod;
	BOOL deletebeforeupload;
	BOOL detailedlog;
	BOOL apacheDirWithSlash;
	BOOL needDisconnectWlan;
	BOOL appendslash;
	DWORD TempPathUniqueValue;
	int baseslashcount;
	int proxynr;   //0=no proxy, >0 use entry  [proxy], [proxy2] etc.
	int proxytype;   //0=no, 1=default, 2=custom
	TCHAR proxyserver[MAX_PATH];
	TCHAR proxyuser[MAX_PATH];
	TCHAR proxypassword[MAX_PATH];
	BOOL RelativePathUrl;
	BOOL propPatchAllowed;
} tConnectSettings,*pConnectSettings;

//#define propfindxmlbody "\r\n<?xml version=\"1.0\" encoding=\"utf-8\" ?><A:propfind xmlns:A=\"DAV:\"><A:prop><A:getcontentlength/><A:getlastmodified/></A:prop></A:propfind>"
#define propfindxmlbody "\r\n<?xml version=\"1.0\" encoding=\"utf-8\" ?><A:propfind xmlns:A='DAV'><A:prop><A:getcontentlength/><A:getlastmodified/></A:prop></A:propfind>"
//#define datesetxmlbody "\r\n<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:srtns=\"http://www.southrivertech,com/\"><D:set><D:prop><srtns:srt_modifiedtime>2008-05-08T07:19:49Z</srtns:srt_modifiedtime></D:prop></D:set></D:propertyupdate>"

typedef struct {
	DWORD dwError;
	HINTERNET hCreatedRequest;
	HANDLE hHandleCreatedEvent;
	HANDLE hRequestCompleteEvent;
	int lastpercent;
} CONTEXTBUF;

int GetPercent(_int64 offset,_int64 filesize)
{
    if (!filesize)
        return 0;
    int percent=(int)(offset*100/filesize);
    if (percent<0) percent=0;
    if (percent>100) percent=100;
	return percent;
}

void ShowDetailedError(TCHAR* errorbegin,DWORD err)
{
	TCHAR errorbuf[3*MAX_PATH];
	memset(&errorbuf,0,sizeof(errorbuf));
	_tcscpy(errorbuf,errorbegin);
	TCHAR* p=errorbuf+_tcslen(errorbuf);
	DWORD len=countof(errorbuf)-(p-errorbuf)-1;
	DWORD err2;
	if (err==ERROR_INTERNET_EXTENDED_ERROR) {
		InternetGetLastResponseInfo(&err2,p,&len);
	} else if (err) {
		TCHAR* lpMsgBuf;
		lpMsgBuf=NULL;
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,err,0, // Default language
			(LPTSTR) &lpMsgBuf,0,NULL);
		if (lpMsgBuf && lpMsgBuf[0])
			_tcslcat(errorbuf,lpMsgBuf,countof(errorbuf)-1);
		else {
	 		if (err>=ERROR_INTERNET_OUT_OF_HANDLES  && err<=ERROR_INTERNET_INSERT_CDROM)
				LoadString(hinst,err,p,countof(errorbuf)-1-(p-errorbuf));
			else
				wsprintf(p,TEXT("Error %d, FormatMessage error %d"),err, GetLastError());
		}
		if (lpMsgBuf)
			LocalFree( lpMsgBuf );
	}
	ShowStatus(errorbuf);
}

BOOL GetFileVersionInfoValue(TCHAR* modulename,TCHAR* ProductName,int maxlen,int* highver,int* lowver)
{
	DWORD thehandle;
	int infosize=GetFileVersionInfoSize(modulename,&thehandle);
	if (infosize>0) {
		if (infosize<16384)
			infosize=16384;  // Workaround to problem with wrong buffer size
		LPVOID infobuf=(LPVOID)malloc(infosize);
		if (GetFileVersionInfo(modulename,thehandle,infosize,infobuf)) {
			unsigned int thesize;
			int* p;
			TCHAR* p2;
			TCHAR buf[8];
			if (VerQueryValue(infobuf,TEXT("\\StringFileInfo\\040904E4\\ProductName"),(void**)&p2,&thesize) ||
			    VerQueryValue(infobuf,TEXT("\\StringFileInfo\\000904B0\\ProductName"),(void**)&p2,&thesize)) {
				int i=0;
				int j=0;
				while (p2[i] && j<maxlen) {  // name without spaces!
					if (p2[i]!=' ') {
						ProductName[j]=p2[i];
						j++;
					}
					i++;
				}
				ProductName[j]=0; 
			} else
				_tcslcpy(ProductName,TEXT("unknown"),maxlen);
			buf[0]='\\';
			buf[1]=0;
			if (VerQueryValue(infobuf,buf,(void**)&p,&thesize)) {
				p=(int*)(((char*)p)+8);
				int verhigh1=*p;
				int verhigh2=verhigh1>>16;
				verhigh1=verhigh1 & 0xFFFF;
				*highver=verhigh2;
				*lowver=verhigh1;
				return true;
			}
		}
		free(infobuf);
	}
	return false;
}

typedef struct _OSVERSIONINFOEX2A {
    DWORD dwOSVersionInfoSize;
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    DWORD dwBuildNumber;
    DWORD dwPlatformId;
    CHAR  szCSDVersion[ 128 ];     // Maintenance string for PSS usage
    WORD   wServicePackMajor;
    WORD   wServicePackMinor;
    WORD   wSuiteMask;
    BYTE  wProductType;
    BYTE  wReserved;
} OSVERSIONINFOEX2A, *POSVERSIONINFOEX2A, *LPOSVERSIONINFOEX2A, RTL_OSVERSIONINFOEX2A, *PRTL_OSVERSIONINFOEX2A;

typedef struct _OSVERSIONINFOEX1A {
    DWORD dwOSVersionInfoSize;
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    DWORD dwBuildNumber;
    DWORD dwPlatformId;
    CHAR   szCSDVersion[ 128 ];     // Maintenance string for PSS usage
    WORD wServicePackMajor;
    WORD wServicePackMinor;
    WORD wReserved[2];
} OSVERSIONINFOEX1A, *POSVERSIONINFOEX1A, *LPOSVERSIONINFOEX1A;


typedef struct _OSVERSIONINFOEX2W {
    DWORD dwOSVersionInfoSize;
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    DWORD dwBuildNumber;
    DWORD dwPlatformId;
    WCHAR  szCSDVersion[ 128 ];     // Maintenance string for PSS usage
    WORD   wServicePackMajor;
    WORD   wServicePackMinor;
    WORD   wSuiteMask;
    BYTE  wProductType;
    BYTE  wReserved;
} OSVERSIONINFOEX2W, *POSVERSIONINFOEX2W, *LPOSVERSIONINFOEX2W, RTL_OSVERSIONINFOEX2W, *PRTL_OSVERSIONINFOEX2W;

typedef struct _OSVERSIONINFOEX1W {
    DWORD dwOSVersionInfoSize;
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    DWORD dwBuildNumber;
    DWORD dwPlatformId;
    WCHAR  szCSDVersion[ 128 ];     // Maintenance string for PSS usage
    WORD wServicePackMajor;
    WORD wServicePackMinor;
    WORD wReserved[2];
} OSVERSIONINFOEX1W, *POSVERSIONINFOEX1W, *LPOSVERSIONINFOEX1W;

#ifdef UNICODE
typedef OSVERSIONINFOEX1W OSVERSIONINFOEX1;
typedef POSVERSIONINFOEX1W POSVERSIONINFOEX1;
typedef LPOSVERSIONINFOEX1W LPOSVERSIONINFOEX1;
typedef OSVERSIONINFOEX2W OSVERSIONINFOEX2;
typedef POSVERSIONINFOEX2W POSVERSIONINFOEX2;
typedef LPOSVERSIONINFOEX2W LPOSVERSIONINFOEX2;
#else
typedef OSVERSIONINFOEX1A OSVERSIONINFOEX1;
typedef POSVERSIONINFOEX1A POSVERSIONINFOEX1;
typedef LPOSVERSIONINFOEX1A LPOSVERSIONINFOEX1;
typedef OSVERSIONINFOEX2A OSVERSIONINFOEX2;
typedef POSVERSIONINFOEX2A POSVERSIONINFOEX2;
typedef LPOSVERSIONINFOEX2A LPOSVERSIONINFOEX2;
#endif // UNICODE

#ifndef VER_NT_WORKSTATION
#define VER_NT_WORKSTATION              0x0000001
#endif

#define SM_SERVERR2 89

TCHAR BrowserName[256]={0};

TCHAR* GetBrowserName()
{
    //return TEXT("WinSCP/5.17 neon/0.30.2");
	//return TEXT("Microsoft-WebDAV-MiniRedir/6.3.9600");

	if (BrowserName[0]==0) { 
		TCHAR modulename[MAX_PATH];
		//ezdavplugin/2.0.1 TotalCommander/7.56a (Windows/7; en_EN)
		GetModuleFileName(hinst,modulename,countof(modulename)-1);
		int highver,lowver;
		if (GetFileVersionInfoValue(modulename,BrowserName,countof(BrowserName)-1,&highver,&lowver)) {
			_tcsprintf(BrowserName+_tcslen(BrowserName),TEXT("/%d.%d"),highver,lowver);
		} else
			_tcslcpy(BrowserName,TEXT("ezdavplugin/1.0"),countof(BrowserName)-1);
		_tcslcat(BrowserName,TEXT(" "),countof(BrowserName)-1);
		int L=_tcslen(BrowserName);
		GetModuleFileName(NULL,modulename,countof(modulename)-1);
		if (GetFileVersionInfoValue(modulename,BrowserName+L,countof(BrowserName)-L-1,&highver,&lowver)) {
			_tcsprintf(BrowserName+_tcslen(BrowserName),TEXT("/%d.%d"),highver,lowver);
		}
		// Send the following for Bitrix24:
		_tcslcat(BrowserName,TEXT(" Microsoft-WebDAV-MiniRedir/6.3.9600"),countof(BrowserName)-1);
		_tcslcat(BrowserName,TEXT(" (Windows"),countof(BrowserName)-1);
		OSVERSIONINFOEX2 osvi;
		memset(&osvi,0,sizeof(OSVERSIONINFOEX2));
		osvi.dwOSVersionInfoSize=sizeof(OSVERSIONINFOEX2);
		if (!GetVersionEx((LPOSVERSIONINFO)&osvi)) {
			osvi.dwOSVersionInfoSize=sizeof(OSVERSIONINFOEX1);
			GetVersionEx((LPOSVERSIONINFO)&osvi);
		}
		if (osvi.dwPlatformId==VER_PLATFORM_WIN32_NT) {
			if (osvi.dwMajorVersion>6) {
				_tcslcat(BrowserName,TEXT("/10"),countof(BrowserName)-1);
			} else if (osvi.dwMajorVersion>6) {
				_tcslcat(BrowserName,TEXT("/8"),countof(BrowserName)-1);
			} else if (osvi.dwMajorVersion==6) {
				if (osvi.dwMinorVersion==0) {
					if (osvi.wProductType==VER_NT_WORKSTATION)
						_tcslcat(BrowserName,TEXT("/Vista"),countof(BrowserName)-1);
					else
						_tcslcat(BrowserName,TEXT("/Server2008"),countof(BrowserName)-1);
				} else if (osvi.dwMinorVersion==1) {
					if (osvi.wProductType==VER_NT_WORKSTATION)
						_tcslcat(BrowserName,TEXT("/7"),countof(BrowserName)-1);
					else
						_tcslcat(BrowserName,TEXT("/Server2008R2"),countof(BrowserName)-1);
				} else
					_tcslcat(BrowserName,TEXT("/8"),countof(BrowserName)-1);
			} else {
				switch(osvi.dwMinorVersion) {
				case 2:
					if (GetSystemMetrics(SM_SERVERR2))
						_tcslcat(BrowserName,TEXT("/Server2003R2"),countof(BrowserName)-1);
					else if (osvi.wProductType==VER_NT_WORKSTATION)
						_tcslcat(BrowserName,TEXT("/XP"),countof(BrowserName)-1);
					else
						_tcslcat(BrowserName,TEXT("/Server2003"),countof(BrowserName)-1);
					break;
				case 1:
					_tcslcat(BrowserName,TEXT("/XP"),countof(BrowserName)-1);
					break;
				case 0:
					_tcslcat(BrowserName,TEXT("/2000"),countof(BrowserName)-1);
					break;
				}
			}
		}
		_tcslcat(BrowserName,TEXT("; en_EN)"),countof(BrowserName)-1);
	}
	return BrowserName;
}

void __stdcall DummyCallback(HINTERNET hInternet,DWORD dwContext,DWORD dwInternetStatus,LPVOID lpStatusInfo,DWORD dwStatusInfoLen);
void __stdcall InternetCallback(HINTERNET hInternet,DWORD dwContext,DWORD dwInternetStatus,LPVOID lpStatusInfo,DWORD dwStatusInfoLen);

int WebDavConnect(pConnectSettings ConnectSettings)
{
	WORD wVersionRequested;
	WSADATA wsaData;

	wVersionRequested = MAKEWORD( 1, 1 );

	if (numconnections==0)
		if (WSAStartup( wVersionRequested, &wsaData )==0)
			numconnections=1;
	if (numconnections) {
		if (!ConnectSettings->InetHandle) {
			TCHAR* pproxy=NULL;
			int opentype;
			switch (ConnectSettings->proxytype) {
			case 0:
				opentype=INTERNET_OPEN_TYPE_DIRECT;
				break;
			case 2:
				if (ConnectSettings->proxyserver[0]) {
					opentype=INTERNET_OPEN_TYPE_PROXY;
					pproxy=ConnectSettings->proxyserver;
				} else
					opentype=INTERNET_OPEN_TYPE_PRECONFIG;
				break;
			default:
				opentype=INTERNET_OPEN_TYPE_PRECONFIG;
			}

			ConnectSettings->InetHandle=InternetOpen(GetBrowserName(),opentype,pproxy,NULL,INTERNET_FLAG_ASYNC);
		}
		if (ConnectSettings->InetHandle) {
			InternetSetStatusCallback(ConnectSettings->InetHandle,(INTERNET_STATUS_CALLBACK)&DummyCallback);

			InternetSetOption(ConnectSettings->InetHandle, INTERNET_OPTION_PROXY_USERNAME,
				ConnectSettings->proxyuser, _tcslen(ConnectSettings->proxyuser)+1);

			//strPassword is the buffer that contains the proxy password.
			InternetSetOption(ConnectSettings->InetHandle, INTERNET_OPTION_PROXY_PASSWORD,
				ConnectSettings->proxypassword, _tcslen(ConnectSettings->proxypassword)+1);

			if (ConnectSettings->SslConnect)
			{
				ConnectSettings->ForegroundConnHandle=InternetConnect(ConnectSettings->InetHandle,ConnectSettings->server,ConnectSettings->customport,
					ConnectSettings->user,ConnectSettings->password,INTERNET_SERVICE_HTTP,INTERNET_FLAG_SECURE,0);
			}
			else if (ConnectSettings->customport)
				ConnectSettings->ForegroundConnHandle=InternetConnect(ConnectSettings->InetHandle,ConnectSettings->server,ConnectSettings->customport,
					ConnectSettings->user,ConnectSettings->password,INTERNET_SERVICE_HTTP,0,0);
			else
				ConnectSettings->ForegroundConnHandle=InternetConnect(ConnectSettings->InetHandle,ConnectSettings->server,INTERNET_DEFAULT_HTTP_PORT,
					ConnectSettings->user,ConnectSettings->password,INTERNET_SERVICE_HTTP,0,0);
			if (!ConnectSettings->ForegroundConnHandle) {
				ShowDetailedError(TEXT("InternetConnect failed: "),GetLastError());
				InternetCloseHandle(ConnectSettings->InetHandle);
				ConnectSettings->InetHandle=NULL;
				numconnections--;
			}				
		} else {
			ShowDetailedError(TEXT("Error: Could not get Internet handle: "),GetLastError());
			numconnections--;
		}
	}
	if (!ConnectSettings->ForegroundConnHandle) {
		if (numconnections==0) {
			WSACleanup();
		}
		return DAV_FAILED;
	} else
		return DAV_OK;
}

// SR: 10.07.2005
//char* defOK="<Choose new server type from list>";
//char* defBAD="Could not find file davplug.inc!";

void FillServerList(HWND hWnd)
{
	TCHAR listfilename[MAX_PATH];
	BOOL listread=false;
	DWORD size=0;
	char* serverlist=NULL;
	
	GetModuleFileName(hinst,listfilename,MAX_PATH-10);

	TCHAR* p=_tcsrchr(listfilename,'\\');
	if (!p) 
		p=listfilename;
	_tcscpy(p,TEXT("\\davplug.inc"));
	HANDLE tempfile=CreateFile(listfilename,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);

	if (tempfile!=INVALID_HANDLE_VALUE) {
		size=GetFileSize(tempfile,NULL);
		if (size) {
			DWORD bytesread=0;
			serverlist=(char*)malloc(size+1);
			if (serverlist)
				if (ReadFile(tempfile,serverlist,size,&bytesread,NULL) && bytesread>0) {
					serverlist[bytesread]=0;
					listread=true;
				}
		}
		CloseHandle(tempfile);
	}
	if (listread) 
	{
		// SR: 10.07.2005
		TCHAR szBuffer[256]; LoadString(hinst, IDS_SERVERLIST_DEFOK, szBuffer, countof(szBuffer));
		SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_ADDSTRING,0,(LPARAM)szBuffer);

		char* pitem=strtok(serverlist,"\r");
		while(pitem) {
			if (pitem[0]=='\n')
				pitem++;
			if (pitem[0]!='#') {  // a comment
				char* pitemend=strchr(pitem,',');
				if (pitemend) {
					pitemend[0]=0;
#ifdef UNICODE
					WCHAR wbuf[MAX_PATH];
					MultiByteToWideChar(CP_ACP,0,pitem,-1,wbuf,countof(wbuf)-1);
					SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_ADDSTRING,0,(LPARAM)&wbuf);
#else
					SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_ADDSTRING,0,(LPARAM)pitem);
#endif
					pitemend[0]=',';
				}
			}
			pitem=strtok(NULL,"\r");
		}
	} 
	else
	{
		// SR: 10.07.2005
		TCHAR szBuffer[256]; LoadString(hinst, IDS_SERVERLIST_DEFBAD, szBuffer, countof(szBuffer));
		SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_ADDSTRING,0,(LPARAM)szBuffer);
	}
	if (size)
		free(serverlist);
}

void FillClientCertList(HWND hWnd, pConnectSettings ConnectResults)
{
	if (ConnectResults->SslConnect)
		EnableWindow(GetDlgItem(hWnd,IDC_CBO_CC), TRUE);

	PCCERT_CONTEXT   pCertContext = NULL;
	TCHAR szNameString[MAX_PATH + 1] = TEXT("");
	BOOL bFoundCert = FALSE;
	
	SendDlgItemMessage(hWnd,IDC_CBO_CC,CB_ADDSTRING,0,(LPARAM) TEXT(""));

	if (!SslCertStore)
		SslCertStore = CertOpenSystemStore(NULL, SSL_CLIENT_CERTIFICATE_STORE);


	if (SslCertStore)
	{
		// CertGetNameString here leads to unresolved external symbol although the required h file and lib 
		// is included... Therefore use LoadLibrary/GetProcAddress
		HMODULE hCryptDll = LoadLibrary(TEXT("Crypt32.dll"));

		if (hCryptDll)
		{
			typedef DWORD (WINAPI* pfnCertGetNameString)(PCCERT_CONTEXT pCertContext, DWORD dwType, DWORD dwFlags,
						void *pvTypePara, TCHAR* pszNameString, DWORD cchNameString);
#ifdef UNICODE
			pfnCertGetNameString pfnCertGetNameStringProc = reinterpret_cast<pfnCertGetNameString>(GetProcAddress(hCryptDll, "CertGetNameStringW"));
#else
			pfnCertGetNameString pfnCertGetNameStringProc = reinterpret_cast<pfnCertGetNameString>(GetProcAddress(hCryptDll, "CertGetNameStringA"));
#endif
			if (pfnCertGetNameStringProc != NULL)
			{
				while ((pCertContext = CertEnumCertificatesInStore(SslCertStore, pCertContext)))
				{
					DWORD dwRet = pfnCertGetNameStringProc(pCertContext, CERT_NAME_SIMPLE_DISPLAY_TYPE,
										                   CERT_NAME_DISABLE_IE4_UTF8_FLAG,
										                   NULL, szNameString, MAX_PATH);
					
					if (dwRet)
					{
						int iIndex = SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_ADDSTRING, 0, (LPARAM) szNameString);

						PCERT_INFO pCertInfo = pCertContext->pCertInfo;

						if (pCertInfo != NULL)
						{
							// Get the serial number in order to search for the cert when connecting...
							CRYPT_INTEGER_BLOB clbSerial = pCertInfo->SerialNumber;

							unsigned int iOut = 0;
							unsigned char* szB64 = base64_encode((const char*) clbSerial.pbData, clbSerial.cbData, &iOut);

							if (szB64 != NULL)
							{
								if (iOut > 0)
								{
									CRYPT_INTEGER_BLOB* clbSerialB64 = new CRYPT_INTEGER_BLOB();
									clbSerialB64->pbData = szB64;
									clbSerialB64->cbData = iOut;

									if (iIndex > -1)
										SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_SETITEMDATA, (WPARAM) iIndex, (LPARAM) clbSerialB64);

									if (_tcsicmp(ConnectResults->SslCertIssuer, szNameString) == 0 && !bFoundCert)
									{
										if (strnicmp(ConnectResults->SslCertSerial, (const char*) szB64, iOut) == 0)
										{
											SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_SETCURSEL, (WPARAM) iIndex, (LPARAM) 0);
											bFoundCert = TRUE;
										}
									}
								}
								else
								{
									free(szB64);
									szB64 = NULL;
								}
							}
						}
					}
				}
			}

			FreeLibrary(hCryptDll);
		}
	}
}

char* _mytokensource;

char* mystrtok(char* pitem,char token)
{
	char* ret;
	if (pitem)
		ret=pitem;
	else
		ret=_mytokensource;

	if (ret) {
		_mytokensource=strchr(ret,token);
		if (_mytokensource) {
			_mytokensource[0]=0;
			_mytokensource++;
		}
	}
	return ret;
}

void LoadServerSettingsFromList(HWND hWnd,char* servertype,BOOL changeserverfield)
{
	TCHAR listfilename[MAX_PATH];
	BOOL listread=false;
	DWORD size=0;
	char* serverlist=NULL;
	
	GetModuleFileName(hinst,listfilename,MAX_PATH-10);

	TCHAR* p=_tcsrchr(listfilename,'\\');
	if (!p) 
		p=listfilename;
	_tcscpy(p,TEXT("\\davplug.inc"));
	HANDLE tempfile=CreateFile(listfilename,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);

	if (tempfile!=INVALID_HANDLE_VALUE) {
		size=GetFileSize(tempfile,NULL);
		if (size) {
			DWORD bytesread=0;
			serverlist=(char*)malloc(size+1);
			if (serverlist)
				if (ReadFile(tempfile,serverlist,size,&bytesread,NULL) && bytesread>0) {
					serverlist[bytesread]=0;
					listread=true;
				}
		}
		CloseHandle(tempfile);
	}
	if (listread) {
		char* pitem=strtok(serverlist,"\r");
		while(pitem) {
			if (pitem[0]=='\n')
				pitem++;
			if (pitem[0]!='#') {  // a comment
				char* pitemend=strchr(pitem,',');
				if (pitemend) {
					pitemend[0]=0;
					if (strcmp(pitem,servertype)==0) { //found!!!
						pitem=mystrtok(pitemend+1,',');
						if (pitem) {      // Server Adresse
							if (pitem[0] && changeserverfield) {
#ifdef UNICODE
								WCHAR wbuf[MAX_PATH];
								MultiByteToWideChar(CP_ACP,0,pitem,-1,wbuf,countof(wbuf)-1);
								SetDlgItemText(hWnd,IDC_CONNECTTO,wbuf);
#else
								SetDlgItemText(hWnd,IDC_CONNECTTO,pitem);
#endif
							}
							pitem=mystrtok(NULL,',');
						}
						if (pitem) {      // SSL
							if (pitem[0])
							{
								CheckDlgButton(hWnd,IDC_SECURE_SSL,pitem[0]=='1' ? BST_CHECKED : BST_UNCHECKED);
								EnableWindow(GetDlgItem(hWnd,IDC_CBO_CC), pitem[0]=='1');
							}
							else
								EnableWindow(GetDlgItem(hWnd,IDC_CBO_CC), FALSE);

							pitem=mystrtok(NULL,',');
						}
						if (pitem) {      // UTF8 Codierung
							if (pitem[0])
								CheckDlgButton(hWnd,IDC_UTF8_DIRS,pitem[0]=='1' ? BST_CHECKED : BST_UNCHECKED);
							pitem=mystrtok(NULL,',');
						}
						if (pitem) {      // 3Step
							if (pitem[0]) {
								if (pitem[0]=='2') {
									CheckDlgButton(hWnd,IDC_MULTISTEP,BST_UNCHECKED);
									EnableWindow(GetDlgItem(hWnd,IDC_3STEP_UPLOAD),false);
								} else {
									EnableWindow(GetDlgItem(hWnd,IDC_3STEP_UPLOAD),true);
									CheckDlgButton(hWnd,IDC_MULTISTEP,BST_CHECKED);
									CheckDlgButton(hWnd,IDC_3STEP_UPLOAD,pitem[0]=='1' ? BST_CHECKED : BST_UNCHECKED);
								}
							}
							pitem=mystrtok(NULL,',');
						}
						if (pitem) {      // Delete
							if (pitem[0])
								CheckDlgButton(hWnd,IDC_DELETE_BEFORE_UPLOAD,pitem[0]=='1' ? BST_CHECKED : BST_UNCHECKED);
							pitem=mystrtok(NULL,',');
						}
						if (pitem) {      // ApacheDirWithSlash
							if (pitem[0])
								CheckDlgButton(hWnd,IDC_APACHE_DIR_WITH_SLASH,pitem[0]=='1' ? BST_CHECKED : BST_UNCHECKED);
							pitem=mystrtok(NULL,',');
						}
						break;
					}
				}
			}
			pitem=strtok(NULL,"\r");
		}
	}
	if (size)
		free(serverlist);
}

void WebDavGetRelativePath(void* serverid,TCHAR* RelativePath,int maxlen)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	_tcslcpy(RelativePath,ConnectSettings->rootdir,maxlen);
}

pConnectSettings gConnectResults;
TCHAR* gDisplayName;
TCHAR* gIniFileName;

int g_focusset=0;

// SR: 09.07.2005


LPCTSTR g_pszKey = _T("unpzScGeCInX7XcRM2z+svTK+gegRLhz9KXVbYKJl5boSvVCcfym");

void EncryptString(LPCTSTR pszPlain, LPTSTR pszEncrypted, UINT cchEncrypted)
{
	int iPlainLength = _tcslen(pszPlain);
	int iKeyLength = _tcslen(g_pszKey);
	int iPos = _tcslen(pszPlain) % iKeyLength;

	pszEncrypted[0] = _TCHAR('\0');
	
	for (int iChar = 0; iChar < iPlainLength; iChar++)
	{
		_tcsprintf(pszEncrypted, TEXT("%s%03d"), pszEncrypted, pszPlain[iChar] ^ g_pszKey[(iChar + iPos) % iKeyLength]);
	}
}

void DecryptString(LPCTSTR pszEncrypted, LPTSTR pszPlain, UINT cchPlain)
{
	if (_tcscmp(pszEncrypted,TEXT("!"))==0) {   // signal password-protected password
		if (CryptProc)
			_tcscpy(pszPlain,TEXT("\001"));
		else
			pszPlain[0]=0;
		return;
	}
	int iKeyLength = _tcslen(g_pszKey);
	int iEncryptedLength = _tcslen(pszEncrypted);
	int iPos = (iEncryptedLength/3) % iKeyLength;
	int iChar;

	pszPlain[0] = _TCHAR('\0');

	for (iChar = 0; iChar < iEncryptedLength / 3 && iChar < (int) (cchPlain - 1); iChar++)
	{
		int iDigit = pszEncrypted[iChar * 3];
		if (iDigit < '0' || iDigit > '9')
		{
			pszPlain[0] = _TCHAR('\0');
			return;
		}

		int iNumber = (iDigit - '0') * 100;
		iDigit = pszEncrypted[iChar * 3 + 1];
		if (iDigit < '0' || iDigit > '9')
		{
			pszPlain[0] = _TCHAR('\0');
			return;
		}
		
		iNumber += (iDigit - '0') * 10;
		iDigit = pszEncrypted[iChar * 3 + 2];
		if (iDigit < '0' || iDigit > '9')
		{
			pszPlain[0] = _TCHAR('\0');
			return;
		}
		
		iNumber += iDigit - '0';
		pszPlain[iChar] = _TCHAR(iNumber ^ g_pszKey[(iChar + iPos) % iKeyLength]);
	}

	pszPlain[iChar] = _TCHAR('\0');
}

BOOL LoadProxySettingsFromNr(int proxynr,pConnectSettings ConnectResults)
{
	if (proxynr>0) {
		TCHAR proxyentry[64];
		if (proxynr>1)
			_tcsprintf(proxyentry,TEXT("proxy%d"),proxynr);
		else
			_tcscpy(proxyentry,TEXT("proxy"));
		int type=GetPrivateProfileInt(proxyentry,TEXT("proxytype"),-1,gIniFileName);
		if (type==-1)
			ConnectResults->proxytype=1;
		else
			ConnectResults->proxytype=type;
		GetPrivateProfileString(proxyentry,TEXT("proxyserver"),TEXT(""),ConnectResults->proxyserver,countof(ConnectResults->proxyuser)-1,gIniFileName);
		GetPrivateProfileString(proxyentry,TEXT("proxyuser"),TEXT(""),ConnectResults->proxyuser,countof(ConnectResults->proxyuser)-1,gIniFileName);
		TCHAR szPassword[MAX_PATH];
		if (GetPrivateProfileString(proxyentry,TEXT("proxypassword"),TEXT(""), szPassword, countof(szPassword), gIniFileName))
		{
			DecryptString(szPassword, ConnectResults->proxypassword,countof(ConnectResults->proxypassword));
		} else
			ConnectResults->proxypassword[0]=0;
		return (type!=-1 || proxynr==1);   //nr 1 is always valid
	} else {
		ConnectResults->proxytype=0;
		ConnectResults->proxyserver[0]=0;
		ConnectResults->proxyuser[0]=0;
		ConnectResults->proxypassword[0]=0;
		return false;
	}
}


BOOL LoadServerSettings(TCHAR* DisplayName,pConnectSettings ConnectResults)
{
	TCHAR szPassword[MAX_PATH];
	GetPrivateProfileString(DisplayName,TEXT("server"),TEXT(""),ConnectResults->server,countof(ConnectResults->server)-1,gIniFileName);
	if (ConnectResults->server[0]!=0) {
		TCHAR* p=ConnectResults->server+_tcslen(ConnectResults->server)-1;
		ConnectResults->appendslash=(p[0]=='/');  // trailing slash in config?
		if (_tcsnicmp(gConnectResults->server,TEXT("https://"),8)==0 ||
			_tcsnicmp(gConnectResults->server,TEXT("http://"),7)==0)
			ConnectResults->baseslashcount=getslashcount(ConnectResults->server+8);
		else
			ConnectResults->baseslashcount=getslashcount(ConnectResults->server);
	}

	GetPrivateProfileString(DisplayName,TEXT("user"),TEXT(""),ConnectResults->user,countof(ConnectResults->user)-1,gIniFileName);
	ConnectResults->SslConnect=GetPrivateProfileInt(gDisplayName,TEXT("ssl"),0,gIniFileName)!=0;
	if (!gConnectResults->SslConnect)
		if (_tcsnicmp(gConnectResults->server,TEXT("https://"),8)==0)
			gConnectResults->SslConnect=true;
	if (ConnectResults->SslConnect)
		ConnectResults->SslFlags=INTERNET_FLAG_SECURE | INTERNET_FLAG_RELOAD; // | INTERNET_FLAG_IGNORE_CERT_CN_INVALID;
	else
		ConnectResults->SslFlags=0;

	GetPrivateProfileString(DisplayName,TEXT("ssl_cert_issuer"),TEXT(""),ConnectResults->SslCertIssuer,countof(ConnectResults->SslCertIssuer)-1,gIniFileName);
#ifdef UNICODE	
	TCHAR wbuf[MAX_PATH];
	GetPrivateProfileString(DisplayName,TEXT("ssl_cert_serial"),TEXT(""),wbuf,countof(wbuf)-1,gIniFileName);
	WideCharToMultiByte(CP_ACP,0,wbuf,-1,ConnectResults->SslCertSerial,countof(ConnectResults->SslCertSerial)-1,NULL,NULL);
#else
	GetPrivateProfileString(DisplayName,"ssl_cert_serial","",ConnectResults->SslCertSerial,countof(ConnectResults->SslCertSerial)-1,gIniFileName);
#endif

	ConnectResults->interpreturlasutf8=GetPrivateProfileInt(gDisplayName,TEXT("utf8urls"),0,gIniFileName)!=0;
	ConnectResults->use3stepuploadmethod=GetPrivateProfileInt(gDisplayName,TEXT("3stepupload"),0,gIniFileName)!=0;
	ConnectResults->usemultistepuploadmethod=GetPrivateProfileInt(gDisplayName,TEXT("multistepupload"),1,gIniFileName)!=0;
	ConnectResults->deletebeforeupload=GetPrivateProfileInt(gDisplayName,TEXT("deletebeforeupload"),0,gIniFileName)!=0;
	ConnectResults->detailedlog=GetPrivateProfileInt(gDisplayName,TEXT("detailedlog"),0,gIniFileName)!=0;
	ConnectResults->apacheDirWithSlash=GetPrivateProfileInt(gDisplayName,TEXT("apacheDirWithSlash"),0,gIniFileName)!=0;
	ConnectResults->password[0]=0;
	if (GetPrivateProfileString(gDisplayName,TEXT("password"),TEXT(""), szPassword, countof(szPassword), gIniFileName))
	{
		DecryptString(szPassword, ConnectResults->password, countof(ConnectResults->password));
	}
	ConnectResults->proxynr=GetPrivateProfileInt(gDisplayName,TEXT("proxynr"),1,gIniFileName);  // default to old entry "proxy"!
	ConnectResults->propPatchAllowed=true;  // allow until first 501 error!

	LoadProxySettingsFromNr(ConnectResults->proxynr,ConnectResults);

	return ConnectResults->server[0]!=0;
}

int gProxyNr=0;

#ifdef WIN64
#define myint1 INT_PTR
#else
typedef int myint1;
#endif


myint1 CALLBACK ProxyDlgProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
	RECT rt1,rt2;
	int w,h,DlgWidth,DlgHeight,NewPosX,NewPosY;
	tConnectSettings ConnectData;

	switch (Message) {
	case WM_INITDIALOG: {
		LoadProxySettingsFromNr(gProxyNr,&ConnectData);
		
		switch (ConnectData.proxytype) {
		case 0:g_focusset=IDC_NOPROXY;break;
		case 2:g_focusset=IDC_OTHERPROXY;break;
		default:
			g_focusset=IDC_IEPROXY;
		}
		CheckRadioButton(hWnd,IDC_IEPROXY,IDC_OTHERPROXY,g_focusset);

		EnableWindow(GetDlgItem(hWnd,IDC_PROXYSERVER),ConnectData.proxytype==2);
		EnableWindow(GetDlgItem(hWnd,IDC_PROXYUSERNAME),ConnectData.proxytype!=0);
		EnableWindow(GetDlgItem(hWnd,IDC_PROXYPASSWORD),ConnectData.proxytype!=0);
		SetDlgItemText(hWnd,IDC_PROXYSERVER,ConnectData.proxyserver);
		SetDlgItemText(hWnd,IDC_PROXYUSERNAME,ConnectData.proxyuser);

		if (_tcscmp(ConnectData.proxypassword,TEXT("\001"))==0 && CryptProc) {
			TCHAR proxyentry[64];
			if (gProxyNr>1)
				_tcsprintf(proxyentry,TEXT("proxy%d"),gProxyNr);
			else
				_tcscpy(proxyentry,TEXT("proxy"));
			_tcscat(proxyentry,TEXT("$$pass"));

			if (CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_LOAD_PASSWORD_NO_UI,proxyentry,ConnectData.proxypassword,countof(ConnectData.proxypassword)-1)==FS_FILE_OK) {
				SetDlgItemText(hWnd,IDC_PROXYPASSWORD, ConnectData.proxypassword);
				CheckDlgButton(hWnd,IDC_CRYPTPASS,BST_CHECKED);
			} else {
				ShowWindow(GetDlgItem(hWnd,IDC_PROXYPASSWORD),SW_HIDE);
				ShowWindow(GetDlgItem(hWnd,IDC_CRYPTPASS),SW_HIDE);
				ShowWindow(GetDlgItem(hWnd,IDC_EDITPASS),SW_SHOW);
			}
		} else {
			SetDlgItemText(hWnd,IDC_PROXYPASSWORD, ConnectData.proxypassword);
			if (!CryptProc)
				EnableWindow(GetDlgItem(hWnd,IDC_CRYPTPASS),false);
			else if (ConnectData.proxypassword[0]==0 && CryptCheckPass)
				CheckDlgButton(hWnd,IDC_CRYPTPASS,BST_CHECKED);
		}

		// trying to center the dialog
		if (GetWindowRect(hWnd, &rt1) && GetWindowRect(GetParent(hWnd), &rt2)) {
			w=rt2.right-rt2.left;
			h=rt2.bottom-rt2.top;
			DlgWidth   = rt1.right - rt1.left;
			DlgHeight   = rt1.bottom - rt1.top ;
			NewPosX      =rt2.left + (w - DlgWidth)/2;
			NewPosY      =rt2.top + (h - DlgHeight)/2;
			SetWindowPos(hWnd, 0, NewPosX, NewPosY,
				0, 0, SWP_NOZORDER | SWP_NOSIZE);
		}
		return true;
		break;
	}
	case WM_SHOWWINDOW: {
		SetFocus(GetDlgItem(hWnd,g_focusset));
		break;
	}
	case WM_COMMAND: {
		switch(LOWORD(wParam)) {
			case IDOK: {
				if (IsDlgButtonChecked(hWnd,IDC_NOPROXY))
					ConnectData.proxytype=0;
				else if (IsDlgButtonChecked(hWnd,IDC_OTHERPROXY))
					ConnectData.proxytype=2;
				else
					ConnectData.proxytype=1;

				GetDlgItemText(hWnd,IDC_PROXYSERVER,ConnectData.proxyserver,countof(ConnectData.proxyserver)-1);
				GetDlgItemText(hWnd,IDC_PROXYUSERNAME,ConnectData.proxyuser,countof(ConnectData.proxyuser)-1);
				GetDlgItemText(hWnd,IDC_PROXYPASSWORD,ConnectData.proxypassword,countof(ConnectData.proxypassword)-1);

				TCHAR proxyentry[64];
				if (gProxyNr>1)
					_tcsprintf(proxyentry,TEXT("proxy%d"),gProxyNr);
				else
					_tcscpy(proxyentry,TEXT("proxy"));

				WritePrivateProfileString(proxyentry,TEXT("proxyserver"),ConnectData.proxyserver,gIniFileName);
				WritePrivateProfileString(proxyentry,TEXT("proxyuser"),ConnectData.proxyuser,gIniFileName);
				TCHAR buf[16];
				_itot(ConnectData.proxytype,buf,10);
				WritePrivateProfileString(proxyentry,TEXT("proxytype"),buf,gIniFileName);

				TCHAR szEncryptedPassword[256];
				if (!IsWindowVisible(GetDlgItem(hWnd,IDC_EDITPASS))) {  //button not visible
					if (ConnectData.proxypassword[0]==0) {
						WritePrivateProfileString(proxyentry,TEXT("proxypassword"),NULL,gIniFileName);
					} else if (CryptProc && IsDlgButtonChecked(hWnd,IDC_CRYPTPASS)) {
						TCHAR proxyentry2[64];
						_tcscpy(proxyentry2,proxyentry);
						_tcscat(proxyentry2,TEXT("$$pass"));
						BOOL ok=CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_SAVE_PASSWORD,proxyentry2,ConnectData.proxypassword,0)==FS_FILE_OK;
						WritePrivateProfileString(proxyentry,TEXT("proxypassword"),ok? TEXT("!") : NULL,gIniFileName);
						CryptCheckPass=true;
					} else {
						EncryptString(ConnectData.proxypassword, szEncryptedPassword, countof(szEncryptedPassword));
						WritePrivateProfileString(proxyentry,TEXT("proxypassword"),szEncryptedPassword,gIniFileName);
					}
				}

				EndDialog(hWnd, IDOK);
				return 1;
			}
			case IDCANCEL:
			{
				EndDialog(hWnd, IDCANCEL);
				return 1;
			}
			case IDC_IEPROXY:
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYSERVER),false);
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYUSERNAME),true);
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYPASSWORD),true);
				break;
			case IDC_OTHERPROXY:
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYSERVER),true);
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYUSERNAME),true);
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYPASSWORD),true);
				SetFocus(GetDlgItem(hWnd, IDC_PROXYSERVER));
				break;
			case IDC_NOPROXY:
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYSERVER),false);
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYUSERNAME),false);
				EnableWindow(GetDlgItem(hWnd,IDC_PROXYPASSWORD),false);
				break;
			case IDC_PROXYHELP: 
			{
				TCHAR szCaption[100]; LoadString(hinst, IDS_HELP_CAPTION, szCaption, countof(szCaption));
				TCHAR szBuffer[1024]; LoadString(hinst, IDS_HELP_PROXY, szBuffer, countof(szBuffer));
				MessageBox(hWnd, szBuffer, szCaption, MB_OK | MB_ICONINFORMATION);
				break;
			}
			case IDC_EDITPASS:
			{	
				BOOL doshow=true;
				int err;
				TCHAR proxyentry[64];
				if (gProxyNr>1)
					_tcsprintf(proxyentry,TEXT("proxy%d"),gProxyNr);
				else
					_tcscpy(proxyentry,TEXT("proxy"));
				_tcscat(proxyentry,TEXT("$$pass"));
				err=CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_LOAD_PASSWORD,proxyentry,ConnectData.proxypassword,countof(ConnectData.proxypassword)-1);
				if (err==FS_FILE_OK) {
					SetDlgItemText(hWnd,IDC_PROXYPASSWORD, ConnectData.proxypassword);
				} else if (err=FS_FILE_READERROR) {         // no password stored!
					SetDlgItemText(hWnd,IDC_PROXYPASSWORD, TEXT(""));
				} else {
					doshow=false;
				}
				if (doshow) {
					ShowWindow(GetDlgItem(hWnd,IDC_PROXYPASSWORD),SW_SHOW);
					ShowWindow(GetDlgItem(hWnd,IDC_CRYPTPASS),SW_SHOW);
					ShowWindow(GetDlgItem(hWnd,IDC_EDITPASS),SW_HIDE);
					if (gConnectResults->password[0]!=0)
						CheckDlgButton(hWnd,IDC_CRYPTPASS,BST_CHECKED);
				}
			}
		}
	}
	}
	return false;
}

void fillProxyCombobox(HWND hWnd,int defproxynr)
{
	SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_RESETCONTENT,0,0);
	TCHAR noproxy[100],ieproxy[100],addproxy[100],buf[256];
	LoadString(hinst, IDS_NO_PROXY, noproxy, countof(noproxy));
	LoadString(hinst, IDS_IE_PROXY, ieproxy, countof(ieproxy));
	LoadString(hinst, IDS_ADD_PROXY, addproxy, countof(addproxy));
	
	SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_ADDSTRING,0,(LPARAM)&noproxy);
	
	tConnectSettings connectData;
	int proxynr=1;
	while (true) {
		if (LoadProxySettingsFromNr(proxynr,&connectData)) {
			_tcsprintf(buf,TEXT("%d: "),proxynr);
			switch (connectData.proxytype) {
			case 0:
				_tcscat(buf,noproxy);
				break;
			case 1:
				_tcscat(buf,ieproxy);
				break;
			case 2:
				_tcsncat(buf,connectData.proxyserver,countof(buf)-1);
				break;
			}
			SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_ADDSTRING,0,(LPARAM)&buf);
		} else
			break;
		proxynr++;
	}
	SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_ADDSTRING,0,(LPARAM)&addproxy);
	if (defproxynr>=0 && defproxynr<=proxynr)
		SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_SETCURSEL,defproxynr,0);
}

BOOL DeleteLastProxy(int proxynrtodelete,TCHAR* ServerToSkip,TCHAR *AppendToList,int maxlen)
{
	if (proxynrtodelete<=1)
		return false;

	BOOL CanDelete=true;
	BOOL AlreadyAdded=false;
	TCHAR name[wdirtypemax];
	SERVERHANDLE hdl=FindFirstServer(name,sizeof(name)-1);
	while (hdl) {
		if (_tcsicmp(name,ServerToSkip)!=0) {
			int proxynr=GetPrivateProfileInt(name,TEXT("proxynr"),1,gIniFileName);
			if (proxynr==proxynrtodelete) {
				CanDelete=false;
				if (AlreadyAdded)
					_tcslcat(AppendToList,TEXT(","),maxlen);
				_tcslcat(AppendToList,name,maxlen);
				AlreadyAdded=true;
			}
		}
		hdl=FindNextServer(hdl,name,sizeof(name)-1);
	}
	if (CanDelete) {
		TCHAR proxyentry[64];
		_tcsprintf(proxyentry,TEXT("proxy%d"),proxynrtodelete);
		WritePrivateProfileString(proxyentry,NULL,NULL,gIniFileName);
	}
	return CanDelete;
}

// SR: 09.07.2005
myint1 CALLBACK ConnectDlgProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
	RECT rt1,rt2;
	int w,h,DlgWidth,DlgHeight,NewPosX,NewPosY;

	switch (Message) {
	case WM_INITDIALOG: {
		FillServerList(hWnd);
		SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_SETCURSEL,0,0);
		FillClientCertList(hWnd, gConnectResults);
		serverfieldchangedbyuser=false;
		if (_tcscmp(gDisplayName,s_quickconnect)!=0) {
			SetDlgItemText(hWnd,IDC_CONNECTTO,gConnectResults->server);
			if (gConnectResults->server[0])
				serverfieldchangedbyuser=true;

			SetDlgItemText(hWnd,IDC_USERNAME,gConnectResults->user);

			if (gConnectResults->SslConnect)
			{
				CheckDlgButton(hWnd,IDC_SECURE_SSL,BST_CHECKED);
				EnableWindow(GetDlgItem(hWnd,IDC_CBO_CC), TRUE);
			}
			else
				EnableWindow(GetDlgItem(hWnd,IDC_CBO_CC), FALSE);

			if (gConnectResults->interpreturlasutf8)
				CheckDlgButton(hWnd,IDC_UTF8_DIRS,BST_CHECKED);
			
			if (gConnectResults->use3stepuploadmethod)
				CheckDlgButton(hWnd,IDC_3STEP_UPLOAD,BST_CHECKED);

			if (gConnectResults->usemultistepuploadmethod)
				CheckDlgButton(hWnd,IDC_MULTISTEP,BST_CHECKED);
			else
				EnableWindow(GetDlgItem(hWnd,IDC_3STEP_UPLOAD),false);

			if (gConnectResults->deletebeforeupload)
				CheckDlgButton(hWnd,IDC_DELETE_BEFORE_UPLOAD,BST_CHECKED);

			if (gConnectResults->detailedlog)
				CheckDlgButton(hWnd,IDC_DETAILED_LOG,BST_CHECKED);

			if (gConnectResults->apacheDirWithSlash)
				CheckDlgButton(hWnd,IDC_APACHE_DIR_WITH_SLASH,BST_CHECKED);

			if (_tcscmp(gConnectResults->password,TEXT("\001"))==0 && CryptProc) {
				if (CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_LOAD_PASSWORD_NO_UI,gDisplayName,gConnectResults->password,countof(gConnectResults->password)-1)==FS_FILE_OK) {
					SetDlgItemText(hWnd,IDC_PASSWORD, gConnectResults->password);
					CheckDlgButton(hWnd,IDC_CRYPTPASS,BST_CHECKED);
				} else {
					ShowWindow(GetDlgItem(hWnd,IDC_PASSWORD),SW_HIDE);
					ShowWindow(GetDlgItem(hWnd,IDC_CRYPTPASS),SW_HIDE);
					ShowWindow(GetDlgItem(hWnd,IDC_EDITPASS),SW_SHOW);
				}
			} else {
				SetDlgItemText(hWnd,IDC_PASSWORD, gConnectResults->password);
				if (!CryptProc)
					EnableWindow(GetDlgItem(hWnd,IDC_CRYPTPASS),false);
				else if (gConnectResults->password[0]==0 && CryptCheckPass)
					CheckDlgButton(hWnd,IDC_CRYPTPASS,BST_CHECKED);
			}
			
			fillProxyCombobox(hWnd,gConnectResults->proxynr);
		} else
			fillProxyCombobox(hWnd,0);

		if (_tcscmp(gDisplayName,s_quickconnect)!=0) {
			if (gConnectResults->server[0]==0)
				g_focusset=IDC_CONNECTTO;
			else if (gConnectResults->user[0]==0)
				g_focusset=IDC_USERNAME;
			else
				g_focusset=IDC_PASSWORD;
		} else
			g_focusset=IDC_CONNECTTO;

		// trying to center the About dialog
		if (GetWindowRect(hWnd, &rt1) && GetWindowRect(GetParent(hWnd), &rt2)) {
			w=rt2.right-rt2.left;
			h=rt2.bottom-rt2.top;
			DlgWidth   = rt1.right - rt1.left;
			DlgHeight   = rt1.bottom - rt1.top ;
			NewPosX      =rt2.left + (w - DlgWidth)/2;
			NewPosY      =rt2.top + (h - DlgHeight)/2;
			SetWindowPos(hWnd, 0, NewPosX, NewPosY,
				0, 0, SWP_NOZORDER | SWP_NOSIZE);
		}

		// SR: 11.07.2005
		serverfieldchangedbyuser=false;

		return true;
		break;
	}
	case WM_SHOWWINDOW: {
		if (g_focusset)
			SetFocus(GetDlgItem(hWnd,g_focusset));
		break;
	}
	case WM_COMMAND: {
		switch(LOWORD(wParam)) {
			case IDOK: {
				GetDlgItemText(hWnd,IDC_CONNECTTO,gConnectResults->server,countof(gConnectResults->server)-1);
				GetDlgItemText(hWnd,IDC_USERNAME,gConnectResults->user,countof(gConnectResults->user)-1);
				GetDlgItemText(hWnd,IDC_PASSWORD,gConnectResults->password,countof(gConnectResults->password)-1);
				gConnectResults->SslConnect=IsDlgButtonChecked(hWnd,IDC_SECURE_SSL);
				if (!gConnectResults->SslConnect)
					if (_tcsnicmp(gConnectResults->server,TEXT("https://"),8)==0)
						gConnectResults->SslConnect=true;

				gConnectResults->interpreturlasutf8=IsDlgButtonChecked(hWnd,IDC_UTF8_DIRS);
				gConnectResults->use3stepuploadmethod=IsDlgButtonChecked(hWnd,IDC_3STEP_UPLOAD);
				gConnectResults->usemultistepuploadmethod=IsDlgButtonChecked(hWnd,IDC_MULTISTEP);
				gConnectResults->deletebeforeupload=IsDlgButtonChecked(hWnd,IDC_DELETE_BEFORE_UPLOAD);
				gConnectResults->detailedlog=IsDlgButtonChecked(hWnd,IDC_DETAILED_LOG);
				gConnectResults->apacheDirWithSlash=IsDlgButtonChecked(hWnd,IDC_APACHE_DIR_WITH_SLASH);

				gConnectResults->proxynr=SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCURSEL,0,0);
				int max=SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCOUNT,0,0)-1;
				if (gConnectResults->proxynr>=max)  // "add" item!
					gConnectResults->proxynr=0;

				LoadProxySettingsFromNr(gConnectResults->proxynr,gConnectResults);
				
				if (_tcscmp(gDisplayName,s_quickconnect)!=0) {
					WritePrivateProfileString(gDisplayName,TEXT("server"),gConnectResults->server,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("user"),gConnectResults->user,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("ssl"),gConnectResults->SslConnect ? TEXT("1") : NULL,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("utf8urls"),gConnectResults->interpreturlasutf8 ? TEXT("1") : NULL,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("3stepupload"),gConnectResults->use3stepuploadmethod ? TEXT("1") : NULL,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("multistepupload"),gConnectResults->usemultistepuploadmethod ? NULL : TEXT("0"),gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("deletebeforeupload"),gConnectResults->deletebeforeupload ? TEXT("1") : NULL,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("detailedlog"),gConnectResults->detailedlog ? TEXT("1") : NULL,gIniFileName);
					WritePrivateProfileString(gDisplayName,TEXT("apacheDirWithSlash"),gConnectResults->apacheDirWithSlash ? TEXT("1") : NULL,gIniFileName);

					TCHAR buf[16];
					_itot(gConnectResults->proxynr,buf,10);
					WritePrivateProfileString(gDisplayName,TEXT("proxynr"),buf,gIniFileName);

					TCHAR szEncryptedPassword[MAX_PATH]; 
					if (!IsWindowVisible(GetDlgItem(hWnd,IDC_EDITPASS))) {
						if (CryptProc && IsDlgButtonChecked(hWnd,IDC_CRYPTPASS) && gConnectResults->password[0]) {
							BOOL ok=CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_SAVE_PASSWORD,gDisplayName,gConnectResults->password,0)==FS_FILE_OK;
							WritePrivateProfileString(gDisplayName,TEXT("password"),ok? TEXT("!") : NULL,gIniFileName);
							CryptCheckPass=true;
						} else {
							EncryptString(gConnectResults->password, szEncryptedPassword, countof(szEncryptedPassword));
							WritePrivateProfileString(gDisplayName,TEXT("password"),szEncryptedPassword,gIniFileName);
						}
					}

					// save the client cert info...
					if (IsDlgButtonChecked(hWnd,IDC_SECURE_SSL))
					{
						int iSel = SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0);

						if (iSel > -1)
						{
							if (iSel == 0)
							{
								// first item selected -> empty item so remove the cert infos from ini
								WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_issuer"), NULL, gIniFileName);
								WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_serial"), NULL, gIniFileName);
							}
							else
							{
								CRYPT_INTEGER_BLOB* clbSerialB64 = reinterpret_cast<CRYPT_INTEGER_BLOB*>(SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETITEMDATA, (WPARAM) iSel, (LPARAM) 0));

								if (clbSerialB64 != NULL)
								{
									BYTE* pbSerial = (BYTE*) malloc(clbSerialB64->cbData + 1);
									TCHAR* pszIssuer = (TCHAR*) malloc(sizeof(TCHAR)*(SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETLBTEXTLEN, (WPARAM) iSel, (LPARAM) 0) + 1)); // + 1 due to null char

									if (pszIssuer)
									{
										if (SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETLBTEXT, (WPARAM) iSel, (LPARAM) pszIssuer) > 0)
											WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_issuer"), pszIssuer, gIniFileName);

										free(pszIssuer);
										pszIssuer = NULL;

										if (pbSerial)
										{
											memcpy(pbSerial, clbSerialB64->pbData, clbSerialB64->cbData);
											pbSerial[clbSerialB64->cbData] = 0;
#ifdef UNICODE
											WCHAR wbuf[MAX_PATH];
											MultiByteToWideChar(CP_ACP,0,(char*) pbSerial,-1,wbuf,countof(wbuf)-1);
											WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_serial"), wbuf, gIniFileName);
#else
											WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_serial"), (const char*) pbSerial, gIniFileName);
#endif
										}
									}

									if (pbSerial)
									{
										free(pbSerial);
										pbSerial = NULL;
									}
								}
							}
						}
					}
					else
					{
						// no item selected -> remove the cert infos from ini
						WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_issuer"), NULL, gIniFileName);
						WritePrivateProfileString(gDisplayName,TEXT("ssl_cert_serial"), NULL, gIniFileName);
					}
				}
				else
				{
					// get client cert info for the quick connection ...
					if (IsDlgButtonChecked(hWnd,IDC_SECURE_SSL))
					{
						int iSel = SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0);

						if (iSel > 0)
						{
							CRYPT_INTEGER_BLOB* clbSerialB64 = reinterpret_cast<CRYPT_INTEGER_BLOB*>(SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETITEMDATA, (WPARAM) iSel, (LPARAM) 0));

							if (clbSerialB64 != NULL)
							{
								BYTE* pbSerial = (BYTE*) malloc(clbSerialB64->cbData + 1);
								TCHAR* pszIssuer = (TCHAR*) malloc(sizeof(TCHAR)*(SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETLBTEXTLEN, (WPARAM) iSel, (LPARAM) 0) + 1)); // + 1 due to null char

								if (pszIssuer)
								{
									if (SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETLBTEXT, (WPARAM) iSel, (LPARAM) pszIssuer) > 0)
										_tcscpy(gConnectResults->SslCertIssuer, pszIssuer);

									free(pszIssuer);
									pszIssuer = NULL;

									if (pbSerial)
									{
										memcpy(pbSerial, clbSerialB64->pbData, clbSerialB64->cbData);
										pbSerial[clbSerialB64->cbData] = 0;

										strcpy(gConnectResults->SslCertSerial, (const char*) pbSerial);
									}
								}

								if (pbSerial)
								{
									free(pbSerial);
									pbSerial = NULL;
								}
							}
						}
					}
				}

				if (gConnectResults->SslConnect)
					gConnectResults->SslFlags=INTERNET_FLAG_SECURE | INTERNET_FLAG_RELOAD; // | INTERNET_FLAG_IGNORE_CERT_CN_INVALID;
				else
					gConnectResults->SslFlags=0;
				gConnectResults->customport=0;  // will be set later

				// free serial number structures associated with each client certificate combo item
				int iCount = SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETCOUNT, (WPARAM) 0, (LPARAM) 0);

				for (int i = 0; i < iCount; i++)
				{
					CRYPT_INTEGER_BLOB* clbSerialB64 = reinterpret_cast<CRYPT_INTEGER_BLOB*>(SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETITEMDATA, (WPARAM) i, (LPARAM) 0));

					if (clbSerialB64 != NULL)
					{
						delete clbSerialB64;
						clbSerialB64 = NULL;
					}
				}

				EndDialog(hWnd, IDOK);
				return true;
			}
			case IDCANCEL:
			{
				// free serial number structures associated with each client certificate combo item
				int iCount = SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETCOUNT, (WPARAM) 0, (LPARAM) 0);

				for (int i = 0; i < iCount; i++)
				{
					CRYPT_INTEGER_BLOB* clbSerialB64 = reinterpret_cast<CRYPT_INTEGER_BLOB*>(SendDlgItemMessage(hWnd, IDC_CBO_CC, CB_GETITEMDATA, (WPARAM) i, (LPARAM) 0));

					if (clbSerialB64 != NULL)
					{
						delete clbSerialB64;
						clbSerialB64 = NULL;
					}
				}

				EndDialog(hWnd, IDCANCEL);
				return true;
			}
			case IDC_EDITPASS:
			{	
				if (CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_LOAD_PASSWORD,gDisplayName,gConnectResults->password,countof(gConnectResults->password)-1)==FS_FILE_OK) {
				} else {
					gConnectResults->password[0]=0;
				}
				SetDlgItemText(hWnd,IDC_PASSWORD, gConnectResults->password);
				ShowWindow(GetDlgItem(hWnd,IDC_PASSWORD),SW_SHOW);
				ShowWindow(GetDlgItem(hWnd,IDC_CRYPTPASS),SW_SHOW);
				ShowWindow(GetDlgItem(hWnd,IDC_EDITPASS),SW_HIDE);
				if (gConnectResults->password[0]!=0)
					CheckDlgButton(hWnd,IDC_CRYPTPASS,BST_CHECKED);
				break;
			}
			case IDC_CONNECTTO:
				if (HIWORD(wParam)==EN_CHANGE) {
					serverfieldchangedbyuser=true;
				}
				break;
			case IDC_MULTISTEP:
				EnableWindow(GetDlgItem(hWnd,IDC_3STEP_UPLOAD),IsDlgButtonChecked(hWnd,IDC_MULTISTEP));
				break;
			case IDC_DEFAULTCOMBO: {
				if (HIWORD(wParam)==CBN_SELCHANGE) {
					char servertype[MAX_PATH];
					BOOL oldserverfieldchangedbyuser=serverfieldchangedbyuser;
					int id=SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_GETCURSEL,0,0);
					if (id!=CB_ERR) {
#ifdef UNICODE
						WCHAR wbuf[MAX_PATH];
						SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_GETLBTEXT,id,(LPARAM)&wbuf);
						WideCharToMultiByte(CP_ACP,0,wbuf,-1,servertype,countof(servertype)-1,NULL,NULL);
#else
						SendDlgItemMessage(hWnd,IDC_DEFAULTCOMBO,CB_GETLBTEXT,id,(LPARAM)&servertype);
#endif
						if (servertype[0]) {
							// multi-step is always the default
							LoadServerSettingsFromList(hWnd,servertype,!serverfieldchangedbyuser);
							// restore change flag
							serverfieldchangedbyuser=oldserverfieldchangedbyuser;
						}
					}
				}
				break;
			}
			case IDC_MULTISTEPHELP:
				TCHAR szCaption[100]; LoadString(hinst, IDS_HELP_CAPTION, szCaption, countof(szCaption));
				TCHAR szBuffer[1024]; LoadString(hinst, IDS_HELP_MULTISTEPUPLOAD, szBuffer, countof(szBuffer));
				MessageBox(hWnd, szBuffer, szCaption, MB_OK | MB_ICONINFORMATION);
				break;
			case IDC_3STEPHELP: 
			{
				// SR: 10.07.2005
				TCHAR szCaption[100]; LoadString(hinst, IDS_HELP_CAPTION, szCaption, countof(szCaption));
				TCHAR szBuffer[1024]; LoadString(hinst, IDS_HELP_THREESTEPUPLOAD, szBuffer, countof(szBuffer));
//				MessageBox(hWnd,"Normally the WebDAV plugin uses a two step upload method:\nFirst, a 1 byte file is sent to allow server authentication, and to avoid a lengthy big file upload which then fails with an 'access denied' error.\nIf this went OK, the actual file is sent.\n\nMicrosoft IIS requires a 3 step upload for NT LanMan authentication, though, so this option needs to be checked for IIS.","Help",MB_OK | MB_ICONINFORMATION);
				MessageBox(hWnd, szBuffer, szCaption, MB_OK | MB_ICONINFORMATION);
				break;
			}
			case IDC_UTF8HELP: 
			{
				// SR: 10.07.2005
				TCHAR szCaption[100]; LoadString(hinst, IDS_HELP_CAPTION, szCaption, countof(szCaption));
				TCHAR szBuffer[1024]; LoadString(hinst, IDS_HELP_UTF8, szBuffer, countof(szBuffer));
//				MessageBox(hWnd,"Some WebDAV servers expect accents and umlauts like  as plain text (ANSI), others as Unicode UTF-8.\nIf in doubt, try plain text first, and if the uploaded accents appear as garbage, use UTF-8.\n\nIf you have local access to the server, you may have a look at the created file names in both cases.","Help",MB_OK | MB_ICONINFORMATION);
				MessageBox(hWnd, szBuffer, szCaption, MB_OK | MB_ICONINFORMATION);
				break;
			}
			case IDC_DELUPLHELP: 
			{
				// SR: 10.07.2005
				TCHAR szCaption[100]; LoadString(hinst, IDS_HELP_CAPTION, szCaption, countof(szCaption));
				TCHAR szBuffer[1024]; LoadString(hinst, IDS_HELP_DELETEBEFOREUPLOAD, szBuffer, countof(szBuffer));
//				MessageBox(hWnd,"On some servers, upload fails when a file with the same name already exists. With this option, the remote file is deleted before the new file is uploaded. On other servers, this has the effect that the deleted file is sent to the server's recycle bin.","Help",MB_OK | MB_ICONINFORMATION);
				MessageBox(hWnd, szBuffer, szCaption, MB_OK | MB_ICONINFORMATION);
				break;
			}
			case IDC_SECURE_SSL:
			{
				BOOL bChecked = IsDlgButtonChecked(hWnd,IDC_SECURE_SSL);
				EnableWindow(GetDlgItem(hWnd,IDC_CBO_CC), bChecked);
				break;
			}
			case IDC_PROXYCOMBO:
				{
					int proxynr1=SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCURSEL,0,0);
					if (HIWORD(wParam)==CBN_SELCHANGE)
						if (proxynr1==SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCOUNT,0,0)-1)
							PostMessage(hWnd,WM_COMMAND,IDC_PROXYBUTTON,0);
				}
				break;
			case IDC_PROXYBUTTON:
			{
				int proxynr=SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCURSEL,0,0);
				if (proxynr>0) {
					gProxyNr=proxynr;
					if (IDOK==DialogBox(hinst,(LPCTSTR)MAKEINTRESOURCE(IDD_PROXY),GetActiveWindow(),ProxyDlgProc))
						fillProxyCombobox(hWnd,proxynr);
				}
				break;
			}
			case IDC_DELETELAST:
				int proxynr=SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCOUNT,0,0)-2;
				if (proxynr>=2) {    // proxy nr 1 cannot be deleted!
					TCHAR errorstr[1024];
					LoadString(hinst, IDS_ERROR_INUSE, errorstr, sizeof(errorstr));
					_tcslcat(errorstr,TEXT("\n"),sizeof(errorstr)-1);
					if (DeleteLastProxy(proxynr,gDisplayName,errorstr,sizeof(errorstr)-1)) {
						int proxynr=SendDlgItemMessage(hWnd,IDC_PROXYCOMBO,CB_GETCURSEL,0,0);
						fillProxyCombobox(hWnd,proxynr);
					} else {
						MessageBox(hWnd,errorstr,TEXT("SFTP"),MB_ICONSTOP);	
					}
				} else
					MessageBeep(MB_ICONSTOP);
				break;
		}
	}
	}
	return false;
}

BOOL isDigit(char ch) {
	return ch>='0' && ch<='9';
}

BOOL ContainsValidUtf8(char* utf8str);

BOOL ShowConnectDialog(pConnectSettings ConnectSettings,TCHAR* DisplayName,TCHAR* inifilename)
{
	gConnectResults=ConnectSettings;
	gDisplayName=DisplayName;
	gIniFileName=inifilename;
	BOOL QuickConnection=_tcscmp(gDisplayName,s_quickconnect)==0;
	BOOL QrConnection=_tcscmp(gDisplayName,s_qrcode)==0;
	if (QrConnection) {
		char scanned[256];
		WCHAR scanned16[256];
		scanned[0]=0;
		if (ScanQrCode(hinst, scanned,sizeof(scanned)-1)) {
			HWND maindlg=GetActiveWindow();
			LogProc(PluginNumber,MSGTYPE_DETAILS,TEXT("QR-Code received!"));
			if (ContainsValidUtf8(scanned)) {
				unsigned char* srcstart=(unsigned char*)scanned;
				WCHAR* trgstart=scanned16;
				ConvertUTF8toUTF16(&srcstart,srcstart+strlen(scanned)+1,
					(UTF16**)&trgstart,(UTF16*)scanned16+countof(scanned16)-1);
			} else {
				MultiByteToWideChar(CP_ACP,0,scanned,-1,scanned16,countof(scanned16)-1);
			}
			WideCharToMultiByte(CP_ACP,0,scanned16,-1,scanned,sizeof(scanned)-1,NULL,NULL);
#ifdef UNICODE
			LogProc(PluginNumber,MSGTYPE_DETAILS,scanned16);
#else
			LogProc(PluginNumber,MSGTYPE_DETAILS,scanned);
#endif
			int j;
			char* pj=strchr(scanned+7,'/');
			if (pj)
				j=(pj-scanned);
			else
				j=-1;
			if (strncmp(scanned,"http://",7)==0 && strlen(scanned)>10 && isDigit(scanned[7]) &&
				j>0 && j+4<strlen(scanned) &&
				(isDigit(scanned[j+1]) && isDigit(scanned[j+2]) && isDigit(scanned[j+3]) && isDigit(scanned[j+4]))) {
				pj=strchr(scanned,'\n');
				WCHAR* pw=wcschr(scanned16,'\n');
				if (pj) {
					pj[0]=0;
					pw[0]=0;
					pw++;
					WCHAR* pw2=wcschr(pw,'\n');
					if (pw2) {
						TCHAR errbuf[256];
						WCHAR ssid[80];
						pw2[0]=0;
						ssid[0]=0;
						wcsncat(ssid,pw,countof(ssid)-1);
						if (wcscmp(ssid,L"*")==0)
							wcscpy(ssid,L"Total_Commander");
						pw2++;
						int err=HasWlanNetworkAdapter();
						if (err==ERROR_WLAN_NOT_OPENED) {
							LoadString(hinst, IDS_WLAN_NO_ADAPTER, errbuf, countof(errbuf));
							MessageBox(maindlg,errbuf,TEXT("WebDAV"),MB_OK | MB_ICONSTOP);
							return false;
						} else if (err==ERROR_WLAN_NO_ADAPTERS) {
							LoadString(hinst, IDS_WLAN_DISABLED, errbuf, countof(errbuf));
							MessageBox(maindlg,errbuf,TEXT("WebDAV"),MB_OK | MB_ICONSTOP);
							return false;
						} else {
							LoadString(hinst, IDS_WLAN_DIFFERENT_NET, errbuf, countof(errbuf));
							if (MessageBox(maindlg,errbuf,TEXT("WebDAV"),MB_YESNO | MB_ICONQUESTION)==IDNO)
							return false;
							int err=ConnectToSpecificWlan(ssid,pw2);
							if (err!=0) {
								_tcsprintf(errbuf,TEXT("Connect error %d"),err);
								MessageBox(maindlg,errbuf,TEXT("WebDAV"),MB_OK | MB_ICONSTOP);
								return false;
							}
							gConnectResults->needDisconnectWlan=true;
							// fall through, return URL
						}
					}
				}
#ifdef UNICODE
				wcslcpy(gConnectResults->server,scanned16,countof(gConnectResults->server)-1);
#else 
				strlcpy(gConnectResults->server,scanned,countof(gConnectResults->server)-1);
#endif
				gConnectResults->interpreturlasutf8=true;
				gConnectResults->use3stepuploadmethod=false;
				gConnectResults->usemultistepuploadmethod=false;
				gConnectResults->deletebeforeupload=false;
				gConnectResults->detailedlog=false;
				gConnectResults->apacheDirWithSlash=true;
				return true;
			}
			if (strncmp(scanned,"http://",7)==0 || strncmp(scanned,"https://",8)==0) {
#ifdef UNICODE
				if (MessageBoxW(maindlg,scanned16,L"Code received",MB_OKCANCEL | MB_ICONQUESTION)==IDOK)
					ShellExecuteW(maindlg,NULL,scanned16,NULL,L"c:\\",SW_SHOW);
#else
				if (MessageBoxA(maindlg,scanned,"Code received",MB_OKCANCEL | MB_ICONQUESTION)==IDOK)
					ShellExecuteA(maindlg,NULL,scanned,NULL,"c:\\",SW_SHOW);
#endif
			} else {
#ifdef UNICODE
				int len=2*wcslen(scanned16)+2;
#else
				int len=strlen(scanned)+1;
#endif
				HGLOBAL clipdata=GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE, len + 1);
				if (!clipdata)
					return false;
				char* lock = (char*)GlobalLock(clipdata);
				if (!lock) {
					GlobalFree(clipdata);
					return false;
				}
				if (OpenClipboard(GetActiveWindow())) {
					EmptyClipboard();
#ifdef UNICODE
					wcslcpy((WCHAR*)lock,scanned16,len+1);
					((WCHAR*)lock)[len] = 0;
					GlobalUnlock(clipdata); 
					SetClipboardData(CF_UNICODETEXT,clipdata);
#else
					strlcpy(lock,scanned,len+1);
					lock[len] = 0;
					GlobalUnlock(clipdata); 
					SetClipboardData(CF_TEXT,clipdata);
#endif
					int cp=CodePageToCharset(GetACP());
					HGLOBAL hcp=GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE,4);
					lock=(char*)GlobalLock(hcp);
					*((int*)lock)=cp;
					GlobalUnlock(hcp);
					SetClipboardData(CF_LOCALE,hcp);
					CloseClipboard();
					MessageBoxA(maindlg,scanned,"Text copied to clipboard!",MB_OK | MB_ICONINFORMATION);
				} else
					GlobalFree(clipdata);
			}
			return false;

		} else
			return false;
	} if (!QuickConnection)
		LoadServerSettings(DisplayName,ConnectSettings);
	else
		ConnectSettings->dialogforconnection=false;
	if (ConnectSettings->dialogforconnection) {
		                                           // don't show dialog if:
		if (!QuickConnection &&                    // not using quick connection
			(ConnectSettings->user[0]==0 ||        // and
			ConnectSettings->password[0]) &&       // password saved
		(ConnectSettings->proxyuser[0]==0 ||       // no proxy auth required
		 ConnectSettings->proxypassword[0]))       //  or proxy pass saved
			return true;
		else {
			TCHAR title[256];
			if (ConnectSettings->proxyuser[0]!=0 &&       // no proxy auth required
				ConnectSettings->proxypassword[0]==0) {
				LoadString(hinst, IDS_PROXY_PASS_TITLE, title, countof(title));
				_tcsncat(title,ConnectSettings->proxyuser,countof(title));
				if (!RequestProc(PluginNumber,RT_PasswordFirewall,title,title,ConnectSettings->proxypassword,countof(ConnectSettings->proxypassword)-1))
					return false;
			}
			if (ConnectSettings->user[0]!=0 &&
				ConnectSettings->password[0]==0) {
				LoadString(hinst, IDS_PASS_TITLE, title, countof(title));
				_tcsncat(title,ConnectSettings->user,countof(title));
				if (!RequestProc(PluginNumber,RT_Password,title,title,ConnectSettings->password,countof(ConnectSettings->password)-1))
					return false;
			}
			return true;
		}
	} else
		return (IDOK==DialogBox(hinst,MAKEINTRESOURCE(IDD_WEBDAV),GetActiveWindow(),ConnectDlgProc));
}

BOOL WebDavConfigureServer(TCHAR* DisplayName,TCHAR* inifilename)
{
	tConnectSettings ConnectSettings;

	memset(&ConnectSettings,0,sizeof(tConnectSettings));
	ConnectSettings.dialogforconnection=false;
	return ShowConnectDialog(&ConnectSettings,DisplayName,inifilename);
}

void* WebDavConnectToServer(TCHAR* DisplayName,TCHAR* inifilename)
{
	tConnectSettings ConnectSettings;

	memset(&ConnectSettings,0,sizeof(tConnectSettings));
	ConnectSettings.dialogforconnection=true;
 	
	// Get connection settings here
	if (ShowConnectDialog(&ConnectSettings,DisplayName,inifilename)) {
		if (CryptProc && _tcscmp(ConnectSettings.password,TEXT("\001"))==0) {
			if (CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_LOAD_PASSWORD,gDisplayName,gConnectResults->password,countof(gConnectResults->password)-1)!=FS_FILE_OK) {
				MessageBox(GetActiveWindow(),TEXT("Failed to load password!"),TEXT("Error"),MB_ICONSTOP);
				return NULL;
			}
		}

		if (CryptProc && _tcscmp(ConnectSettings.proxypassword,TEXT("\001"))==0) {
			TCHAR proxyentry[64];
			if (ConnectSettings.proxynr>1)
				_tcsprintf(proxyentry,TEXT("proxy%d"),ConnectSettings.proxynr);
			else
				_tcscpy(proxyentry,TEXT("proxy"));
			_tcscat(proxyentry,TEXT("$$pass"));
			if (CryptProc(PluginNumber,CryptoNumber,FS_CRYPT_LOAD_PASSWORD,proxyentry,ConnectSettings.proxypassword,countof(ConnectSettings.proxypassword)-1)!=FS_FILE_OK) {
				MessageBox(GetActiveWindow(),TEXT("Failed to load proxy password!"),TEXT("Error"),MB_ICONSTOP);
				return NULL;
			}
		}

		ConnectSettings.bgConnMap=new BackgroundConnectionMap();
		InitializeCriticalSection(&ConnectSettings.connMapSection);

		// Clear proxy user and pass if proxy type is set to 0!
		if (ConnectSettings.proxytype==0) {
			ConnectSettings.proxyuser[0]=0;
			ConnectSettings.proxypassword[0]=0;
		}
		// split server name into server/path
		tcsReplaceBackslashBySlash(ConnectSettings.server);
		// Remove trailing http://
		if (_tcsnicmp(ConnectSettings.server,TEXT("http://"),7)==0)
			memmove(ConnectSettings.server,ConnectSettings.server+7,sizeof(TCHAR)*(_tcslen(ConnectSettings.server)-6));
		else if (_tcsnicmp(ConnectSettings.server,TEXT("https://"),8)==0)
			memmove(ConnectSettings.server,ConnectSettings.server+8,sizeof(TCHAR)*(_tcslen(ConnectSettings.server)-7));
		TCHAR* p=_tcschr(ConnectSettings.server,'/');
		if (p) {
			_tcslcpy(ConnectSettings.rootdir,p,countof(ConnectSettings.rootdir)-1);
			p[0]=0;
			// remove trailing backslash, also in case of root!
			p=_tcsrchr(ConnectSettings.rootdir,'/');
			if (p && p[1]==0)
				p[0]=0;
		} else
			ConnectSettings.rootdir[0]=0;
		// look for custom port
		p=_tcschr(ConnectSettings.server,':');
		if (p) {
			p[0]=0;
			p++;
			ConnectSettings.customport=_ttoi(p);
		} else if (ConnectSettings.SslConnect)
			ConnectSettings.customport=INTERNET_DEFAULT_HTTPS_PORT;
		if (ProgressProc(PluginNumber,DisplayName,TEXT("temp"),0))
			return NULL;
		if (WebDavConnect(&ConnectSettings)!=DAV_OK)
			return NULL;
		{
			TCHAR connbuf[MAX_PATH];
			_tcscpy(connbuf,TEXT("CONNECT \\"));
			_tcslcat(connbuf,DisplayName,countof(connbuf)-1);
			LogProc(PluginNumber,MSGTYPE_CONNECT,connbuf);
			pConnectSettings psettings=(pConnectSettings)malloc(sizeof(ConnectSettings));
			memcpy(psettings,&ConnectSettings,sizeof(ConnectSettings));
			return psettings;
		}
	}
	return NULL;
}

HINTERNET GetCachedConnection2(pConnectSettings ConnectSettings)
{
	HINTERNET net=NULL;
	int id=GetCurrentThreadId();
	BackgroundConnectionMap::iterator it = ConnectSettings->bgConnMap->find(id);
	if(it != ConnectSettings->bgConnMap->end())  // found matching thread!!!
	{
		net = it->second;
	}
	if (net==NULL) {
		// not found -> use foreground handle!
		net=ConnectSettings->ForegroundConnHandle;
	}
	return net;
}

HINTERNET GetCachedConnection(pConnectSettings ConnectSettings)
{
	HINTERNET net=NULL;
	EnterCriticalSection(&ConnectSettings->connMapSection);
	__try {
		net=GetCachedConnection2(ConnectSettings);
	}
	__finally {
		LeaveCriticalSection(&ConnectSettings->connMapSection);
	}
	// do not connect within the critical section!
	// this cannot be moved to the background, so no danger
	if (net==NULL) {  // we need another connection
		WebDavConnect(ConnectSettings);
		net=ConnectSettings->ForegroundConnHandle;
	}
	return net;
}

void AddNewForegroundConnection(pConnectSettings ConnectSettings,int id)
{
	// no critical section here, already in calling function
	BackgroundConnectionMap::iterator it = ConnectSettings->bgConnMap->find(id);
	if(it != ConnectSettings->bgConnMap->end())
	{
		HINTERNET net= it->second;
		if (net) {
			if (net==ConnectSettings->ForegroundConnHandle)
				return;
			InternetCloseHandle(net);
		}
		ConnectSettings->bgConnMap->erase(id);
    }
	HINTERNET hdl=ConnectSettings->ForegroundConnHandle;
	ConnectSettings->bgConnMap->insert(std::pair<int,HINTERNET>(id,hdl));
	ConnectSettings->ForegroundConnHandle=0;
}

void CloseBackgroundConnection(pConnectSettings ConnectSettings,int id)
{
	// no critical section here, already in calling function
	BackgroundConnectionMap::iterator it = ConnectSettings->bgConnMap->find(id);
	if(it != ConnectSettings->bgConnMap->end())
	{
		HINTERNET net= it->second;
		if (net)
			InternetCloseHandle(net);
		ConnectSettings->bgConnMap->erase(id);
    }
}

void WebDavStatusInfo(void* serverid,TCHAR* remotedir,int InfoStartEnd,int InfoOperation)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	EnterCriticalSection(&ConnectSettings->connMapSection);
	__try {
		int id=GetCurrentThreadId();
		if (InfoStartEnd==FS_STATUS_START) {
			if (ConnectSettings->ForegroundThreadId!=0 &&
				ConnectSettings->ForegroundThreadId!=id)
			{
				// A new foreground OP has started while a BG op is active!
				// Mark current OP as backgound
				AddNewForegroundConnection(ConnectSettings,ConnectSettings->ForegroundThreadId);
			}
			ConnectSettings->ForegroundThreadId=id;  // thread active!
		} else if (InfoStartEnd==FS_STATUS_END) {
			if (id==ConnectSettings->ForegroundThreadId) {  // end FG thread
				ConnectSettings->ForegroundThreadId=0;
			} else {
				CloseBackgroundConnection(ConnectSettings,id);
			}
		}
	}
	__finally {
		LeaveCriticalSection(&ConnectSettings->connMapSection);
	}
}

int WebDavCloseConnection(void* serverid)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;

	// delete temp file
	if (ConnectSettings->TempPathUniqueValue) {
		TCHAR buffer[MAX_PATH];
		TCHAR tempfilename[MAX_PATH];
		GetTempPath(MAX_PATH,buffer);
		GetTempFileName(buffer,TEXT("DAV"),ConnectSettings->TempPathUniqueValue,tempfilename);
		if (tempfilename[0]) {
			DeleteFile(tempfilename);
		}
		ConnectSettings->TempPathUniqueValue=0;
	}

	if (ConnectSettings->ForegroundConnHandle) {
		ShowStatus(TEXT("Disconnected"));
		InternetCloseHandle(ConnectSettings->ForegroundConnHandle);
		ConnectSettings->ForegroundConnHandle=NULL;
		numconnections--;
	}
	if (ConnectSettings->InetHandle) {
		InternetCloseHandle(ConnectSettings->InetHandle);
		ConnectSettings->InetHandle=NULL;
	}
	if (numconnections<=0) {
		InternetSetOption(0, 42, NULL, 0);
		// INTERNET_OPTION_END_BROWSER_SESSION 42
		// Flushes entries not in use from the password cache on the hard disk drive. Also resets the cache time used when the synchronization mode is once-per-session. No buffer is required for this option. This is used by InternetSetOption.
		WSACleanup();
		numconnections=0;
	}
	if (ConnectSettings->needDisconnectWlan) {
		DisconnectPreviouslyConnectedWlan();
		ConnectSettings->needDisconnectWlan=false;
	}
	return DAV_OK;
}

const TCHAR* skip_n_slashes(const TCHAR* p,int slashcount)
{
	while (slashcount>0 && p[0]) {
		if (p[0]=='/') {
			slashcount--;
			if (slashcount==0)
				return p+1;
		}
		p++;
	}
	if (p[0]=='/')
		p++;
	return p; // points to ending 0 if too many slashes
}

int getslashcount(TCHAR* p) // subdir like this //subdir
{
	int slashcount=0;
	while (p[0]) {
		if (p[0]=='/' && p[1]!=0)  // don't count trailing slash!
			slashcount++;
		p++;
	}
	return slashcount;	
}

int unhex(const char *s, int length)
{
	int c, i, value = 0;
	for(i = 0; s[i] != '\0' && i < length; i++) {
		c = s[i];
		if(c >= '0' && c <= '9') {
			value = (value << 4) | (c - '0');
		} else if(c >= 'a' && c <= 'z') {
			value = (value << 4) | (c - 'a' + 10);
		} else if(c >= 'A' && c <= 'Z') {
			value = (value << 4) | (c - 'A' + 10);
		}
	}
	return value;
}

char *strdup_url_decode(const char *string)
{
	int i, j, new_length = 0;
	char *new_string = NULL;
	new_length = strlen(string);
	new_string = (char *) malloc((new_length + 1) * sizeof(char));
	if(new_string == NULL) {
		return NULL;
	}
	for(i = 0, j = 0; string[i] != '\0'; i++) {
		if(string[i] == '%') {
			new_string[j++] = unhex(&string[i + 1], 2);
			i += 2;
		} else {
			new_string[j++] = string[i];
		}
	}
	new_string[j] = '\0';
	return new_string;
}

BOOL ContainsValidUtf8(char* utf8str)
{
	BOOL validdatafound=false;
	while (1) {
		while (utf8str[0]!=0 && ((unsigned char)utf8str[0])<128)
			utf8str++;
		if (utf8str[0]==0)
			break;
	    unsigned char ch=(unsigned char)utf8str[0];
		if (ch<0xC0)
			return false;   //Secondary character detected -> NOT UTF-8!
		int l=1;
		if (ch>=224) {
			l=2;
			if (ch>=240) {
				l=3;
				if (ch>=248) {
					l=4;
					if (ch>=252)
						l=5;
				}
			}
		}
		while (l>0 && utf8str[0]) {
			utf8str++;
			if ((utf8str[0] & 0xC0)!=0x80) return false;  //Not a secondary char!
			l--;
		}
		utf8str++;
		validdatafound=true;
	}
	return validdatafound;
}

void unicode_url_decode(WCHAR* outbuf,WCHAR* inbuf,int maxlen)
{
	int i, j;
	for(i = 0, j = 0; inbuf[i] != '\0'; i++) {
		if(inbuf[i] == '%') {
			char ansibuf[8];
			WCHAR wbuf[8];
			if (!inbuf[i+1] || !inbuf[i+2])  // do not read beyond end of string!
				break;
			ansibuf[0]=(char)inbuf[i + 1];
			ansibuf[1]=(char)inbuf[i + 2];
			ansibuf[2]=0;
			ansibuf[0]=unhex(ansibuf, 2);
			ansibuf[1]=0;
			MultiByteToWideChar(CP_ACP,0,ansibuf,-1,wbuf,countof(wbuf)-1);
			outbuf[j++]=wbuf[0];
			i += 2;
		} else {
			outbuf[j++] = inbuf[i];
		}
	}
	outbuf[j] = '\0';
}

int dav_readdir(DAV_OPENDIR_DATA *oddata)
{
	const TCHAR* p;
	BOOL retry;
	DAV_ACTIVELOCK *activelock = NULL;
	do {   // retry until we have valid data
		retry=false;
		if(oddata == NULL) 
		{
			return FALSE;
		}
		if(oddata->response_cursor == NULL)
		{
			return FALSE;
		}
		if(oddata->response_cursor->href == NULL)
		{
			return FALSE;
		}
		oddata->href = oddata->response_cursor->href;
		oddata->prop = dav_find_prop(oddata->response_cursor, 200, 200);
		oddata->response_cursor = oddata->response_cursor->next_response;

		// 4 cases:
		// 1: Force UTF-8: Convert plain text and %xy from UTF-8
		// 2: New: Body has UTF-8 header, %xy form valid UTF-8 code points -> convert both
		// 3: Body has UTF-8 header -> convert plain text but not %xy from UTF-8
		// 4. No UTF-8 at all -> convert Ansi -> UTF-16
#ifdef UNICODE
		if (oddata->bodyisutf8 || oddata->interpreturlasutf8) {
			BOOL codepointsasutf8=oddata->interpreturlasutf8;
			if (!codepointsasutf8) {
				char* utf8str=(char*)strchr(oddata->href,'%');
				if (utf8str) {
					utf8str=strdup_url_decode(oddata->href);
					if (ContainsValidUtf8(utf8str))
						codepointsasutf8=true;
					free(utf8str);
				}
			}
			if (codepointsasutf8) {  //
				// replace %ab%cd -> code points, then convert all from UTF-8 to UTF-16
				char* utf8str;
				utf8str=strdup_url_decode(oddata->href);
				unsigned char* srcstart=(unsigned char*)utf8str;
				WCHAR* trgstart=oddata->namebuf;
				ConvertUTF8toUTF16(&srcstart,(unsigned char*)utf8str+strlen(utf8str)+1,
					(UTF16**)&trgstart,(UTF16*)oddata->namebuf+countof(oddata->namebuf)-1);
				free(utf8str);
			} else {  // 2
				// convert from UTF-8 to UTF-16 first, then %xy as ANSI
				unsigned char* srcstart=(unsigned char*)oddata->href;
				WCHAR convbuf[1024];
				WCHAR* trgstart=convbuf;
				ConvertUTF8toUTF16(&srcstart,(unsigned char*)oddata->href+strlen(oddata->href)+1,
					(UTF16**)&trgstart,(UTF16*)convbuf+countof(convbuf)-1);
				unicode_url_decode(oddata->namebuf,convbuf,countof(oddata->namebuf)-1);
			}
		} else { //3
			char* utf8str=strdup_url_decode(oddata->href);
			MultiByteToWideChar(CP_ACP,0,utf8str,-1,oddata->namebuf,countof(oddata->namebuf)-1);
			free(utf8str);
		}
#else
		if (oddata->bodyisutf8 || oddata->interpreturlasutf8) {
			BOOL codepointsasutf8=oddata->interpreturlasutf8;
			if (!codepointsasutf8) {
				char* utf8str=(char*)strchr(oddata->href,'%');
				if (utf8str) {
					utf8str=strdup_url_decode(oddata->href);
					if (ContainsValidUtf8(utf8str))
						codepointsasutf8=true;
					free(utf8str);
				}
			}
			WCHAR utf16buf[1024];
			if (codepointsasutf8) {  //
				// replace %ab%cd -> code points, then convert all from UTF-8 to UTF-16
				char* utf8str=strdup_url_decode(oddata->href);
				unsigned char* srcstart=(unsigned char*)utf8str;
				WCHAR* trgstart=utf16buf;
				ConvertUTF8toUTF16(&srcstart,(unsigned char*)utf8str+strlen(utf8str)+1,
					(UTF16**)&trgstart,(UTF16*)utf16buf+countof(utf16buf)-1);
				WideCharToMultiByte(CP_ACP,0,utf16buf,-1,oddata->namebuf,sizeof(oddata->namebuf)-1,NULL,NULL);
				free(utf8str);
			} else {
				// convert from UTF-8 to UTF-16 first, then %xy as ANSI
				char abuf[1024];
				unsigned char* srcstart=(unsigned char*)oddata->href;
				WCHAR* trgstart=utf16buf;
				ConvertUTF8toUTF16(&srcstart,(unsigned char*)oddata->href+strlen(oddata->href)+1,
					(UTF16**)&trgstart,(UTF16*)utf16buf+countof(utf16buf)-1);
				WideCharToMultiByte(CP_ACP,0,utf16buf,-1,abuf,sizeof(abuf)-1,NULL,NULL);
				char* utf8str=strdup_url_decode(abuf);
				strlcpy(oddata->namebuf,utf8str,countof(oddata->namebuf)-1);
				free(utf8str);
			}
		} else
			strlcpy(oddata->namebuf,oddata->href,countof(oddata->namebuf)-1);
#endif
		if (oddata->namebuf[0]=='/') {   // dir relative to server
			p=oddata->namebuf+1;  // firstt char after initial slash
			if (_tcsncmp(oddata->namebuf,oddata->dirname,oddata->dirnamelen-1)==0) {
				if (_tcslen(oddata->namebuf)==oddata->dirnamelen-1)
					p=oddata->namebuf+oddata->dirnamelen-1;  // the dir without slash!
				else
					p=oddata->namebuf+oddata->dirnamelen;
			} else {
				p=skip_n_slashes(p,oddata->directory_slash_count);
				if (p[0]==0) {
					p=skip_n_slashes(oddata->namebuf+1,oddata->directory_slash_count-oddata->base_slash_count);
				}
			}
			if(p[0]==0)
			{
				retry=true;
			}
		} else {
			p=oddata->namebuf;
			// now skip the server name and if present also the port number:
			// http[s]://server.com[:80]/path_name/filename
			// first skip http or https
			if (_tcsnicmp(p,TEXT("https://"),8)==0)
				p+=8;
			else
				p+=7;
			while (p[0] && p[0]!='/') // skip the server
				p++;
			if (p[0]=='/')  // skip first slash after server name
				p++;
			p=skip_n_slashes(p,oddata->directory_slash_count); //skip path

			if(p[0]==0)  //it's the dir itself
			{
				retry=true;
			}
		}
	} while (retry);
	oddata->filename = p;

	if(oddata->prop != NULL)
	{
		oddata->size = oddata->prop->getcontentlength;
		oddata->cdate = oddata->prop->creationdate;
		oddata->mdate = oddata->prop->getlastmodified;
		oddata->type = oddata->prop->resourcetype;
		if((activelock = dav_find_activelock(oddata->prop, DAV_LOCKSCOPE_EXCLUSIVE, DAV_LOCKTYPE_WRITE)) != NULL)
		{
			oddata->lockowner = activelock->owner;
		}
		else
		{
			oddata->lockowner = NULL;
		}
	} else
		oddata->lockowner = NULL;
	return TRUE;
}

void dav_closedir(DAV_OPENDIR_DATA *oddata)
{
	if(oddata != NULL) 
	{
		dav_multistatus_destroy(&oddata->multistatus);
	}
}

int toooldcache=0;

BOOL WininetTooOld()
{
	if (toooldcache!=0) {
		return toooldcache==1;
	}

	DWORD thehandle;
	int infosize=GetFileVersionInfoSize(TEXT("wininet.dll"),&thehandle);
	if (infosize>0) {
		if (infosize<16384)
			infosize=16384;  // Workaround to problem with wrong buffer size
		LPVOID infobuf=(LPVOID)malloc(infosize);
		if (GetFileVersionInfo(TEXT("wininet.dll"),thehandle,infosize,infobuf)) {
			unsigned int thesize;
			int* p;
			TCHAR buf[8];
			buf[0]='\\';
			buf[1]=0;
			if (VerQueryValue(infobuf,buf,(void**)&p,&thesize)) {
				p=(int*)(((char*)p)+8);
				int verhigh=*p;
				verhigh=verhigh>>16;
				if (verhigh<=6) {
					toooldcache=1;
					return true;
				}
			}
		}
		free(infobuf);
	}
	return false;
	toooldcache=-1;
}

int GetStatusAndShowError(HINTERNET HttpHandle,BOOL detailedlog,BOOL needcheckchunkedresponse)
{
	TCHAR StatusCode[16];
	DWORD len;
	DWORD idx;
	BOOL winineterror=FALSE;

	// Debug: Show headers 
	{
		TCHAR buffer[8192];
		DWORD len=countof(buffer)-1;
		DWORD idx=0;
		if (HttpQueryInfo(HttpHandle,HTTP_QUERY_FLAG_REQUEST_HEADERS | HTTP_QUERY_RAW_HEADERS, buffer, &len, &idx)) {
			ShowStatus(buffer); // the request
			if (detailedlog) {
				TCHAR* p=buffer+_tcslen(buffer);
				TCHAR* p1=p+1;  // skip http line
				while (p[1]) {
					p[0]='\n';
					p=buffer+_tcslen(buffer);
				}
				ShowStatus(p1); // the additional headers
			}
		}

		if (detailedlog || needcheckchunkedresponse) {
			len=countof(buffer)-1;
			if (HttpQueryInfo(HttpHandle,HTTP_QUERY_RAW_HEADERS, buffer, &len, &idx)) {
				if (detailedlog) {
					ShowStatus(TEXT("******Received headers"));
					ShowStatus(buffer); // the request
				}
				TCHAR* p=buffer+_tcslen(buffer);
				TCHAR* p1=p+1;  // skip http line
				while (p[1]) {
					p[0]='\n';
					if (needcheckchunkedresponse) {
						if (_tcsnicmp(p+1,TEXT("Transfer-Encoding:"),18)==0) {
							if (_tcsstr(buffer,TEXT("chunked"))) {
								if (WininetTooOld()) {
									winineterror=TRUE;  // not used by anything else
								}
							}
						}
					}
				p=buffer+_tcslen(buffer);
				}
				if (detailedlog)
					ShowStatus(p1); // the additional headers
			}
		}
	}
	len=countof(StatusCode)-1;
	idx=0;

	if (!HttpQueryInfo(HttpHandle, HTTP_QUERY_STATUS_CODE, &StatusCode, &len, &idx))
		_tcscpy(StatusCode,TEXT("400"));
	TCHAR buffer[256];
	if (_tcsncmp(StatusCode,TEXT("2"),1)!=0) {
		_tcscpy(buffer,TEXT("Error: "));
	} else
		buffer[0]=0;
	{
		_tcscat(buffer,StatusCode);
		_tcscat(buffer,TEXT(" "));
		len=countof(buffer)-_tcslen(buffer);
		idx=0;
		if (HttpQueryInfo(HttpHandle, HTTP_QUERY_STATUS_TEXT, buffer+_tcslen(buffer), &len, &idx))
			ShowStatus(buffer);
	}

	int status=_ttoi(StatusCode);

	if (winineterror && (int)(status/100)==2)
		return -1;
	return status;
}

void SetupContextBuf(HINTERNET ConnHandle,CONTEXTBUF* cbuf)
{
	cbuf->lastpercent=0;
	cbuf->dwError=0;
	cbuf->hCreatedRequest=NULL;
	cbuf->hHandleCreatedEvent=CreateEvent(NULL, FALSE, FALSE, NULL);
	cbuf->hRequestCompleteEvent=CreateEvent(NULL, FALSE, FALSE, NULL);
	InternetSetStatusCallback(ConnHandle,(INTERNET_STATUS_CALLBACK)&InternetCallback);
}

void CleanupContextBuf(HINTERNET ConnHandle,CONTEXTBUF* cbuf)
{
	CloseHandle(cbuf->hHandleCreatedEvent);
	CloseHandle(cbuf->hRequestCompleteEvent);
	InternetSetStatusCallback(ConnHandle,(INTERNET_STATUS_CALLBACK)&DummyCallback);
}

HINTERNET WINAPI AsyncHttpOpenRequest(HINTERNET hConnect,LPCTSTR lpszVerb,LPCTSTR lpszObjectName,LPCTSTR lpszVersion,LPCTSTR lpszReferrer,LPCTSTR *lplpszAcceptTypes,DWORD dwFlags,CONTEXTBUF* cbuf)
{
	HANDLE events[2];
	HINTERNET openhdl;
	ResetEvent(cbuf->hHandleCreatedEvent);
	ResetEvent(cbuf->hRequestCompleteEvent);
	events[0]=cbuf->hHandleCreatedEvent;
	events[1]=cbuf->hRequestCompleteEvent;

	openhdl=HttpOpenRequest(hConnect,lpszVerb,lpszObjectName,lpszVersion,
		lpszReferrer,lplpszAcceptTypes,dwFlags,(DWORD)cbuf);
	if (openhdl==NULL) {
		if (GetLastError() != ERROR_IO_PENDING)
        {
            return NULL;
        }
		DWORD waitret;
		BOOL looprunning=true;
		while (looprunning) {
			MSG msg;
			waitret=MsgWaitForMultipleObjects(2,&events[0], false,100,QS_ALLEVENTS);
			switch (waitret){
			case WAIT_OBJECT_0: // request complete!
				looprunning=false;
				break;
			case WAIT_OBJECT_0+1: // handle created!
				openhdl=cbuf->hCreatedRequest;
				looprunning=false;
				break;
			case WAIT_OBJECT_0+2: // a message!
				while (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				break;
			case WAIT_TIMEOUT:
				break;
			}
			if (ProgressProc(PluginNumber,NULL,NULL,0)) {
				if (openhdl) {
					InternetCloseHandle(openhdl);
					openhdl=NULL;
					looprunning=false;
				}
			}
		}
	}
	return openhdl;
}

#define ASYNC_OK 0
#define ASYNC_FAILED 1
#define ASYNC_CANCELED_HANDLE_DELETED 2

int HandleRequestComplete(HINTERNET hRequest,CONTEXTBUF* cbuf)
{
	DWORD waitret;
	BOOL looprunning=true;
	BOOL handledeleted=false;
	BOOL ok=ASYNC_FAILED;
	DWORD LastTick=GetTickCount();
	DWORD StartTick=LastTick;
	int waitpercent=0;
	while (looprunning) {
		MSG msg;
		waitret=MsgWaitForMultipleObjects(1,&cbuf->hRequestCompleteEvent, false,100,QS_ALLEVENTS);
		switch (waitret){
		case WAIT_OBJECT_0: // request complete!
			if (cbuf->dwError) {
				ShowDetailedError(TEXT("HTTP error: "),cbuf->dwError);
			}
			ok=(cbuf->dwError==0) || (cbuf->dwError==ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION);
			looprunning=false;
			break;
		case WAIT_OBJECT_0+1: // a message!
			while (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			break;
		case WAIT_TIMEOUT:
			break;
		}
		if (cbuf->lastpercent==0) {
			if (GetTickCount()-LastTick>500) {
				waitpercent+=1;
				LastTick=GetTickCount();
			}
			if (waitpercent>=100)
				waitpercent=0;
		} else {
			waitpercent=0;
			LastTick=GetTickCount();  // new: no reaction for 2 seconds _during_ transfer!
		}
		if (LastTick>StartTick+2000)
			if (ProgressProc(PluginNumber,NULL,NULL,cbuf->lastpercent+waitpercent)) {
				if (!handledeleted) {
					InternetSetStatusCallback(hRequest,(INTERNET_STATUS_CALLBACK)&DummyCallback);
					InternetCloseHandle(hRequest);
				}
				handledeleted=true;
				ok=false;
				looprunning=false;
			}
	}
	if (ok)
		return ASYNC_OK;
	else if (!handledeleted)
		return ASYNC_FAILED;
	else
		return ASYNC_CANCELED_HANDLE_DELETED;
}

int AsyncHttpSendRequest(HINTERNET hRequest,LPCTSTR lpszHeaders,DWORD dwHeadersLength,LPVOID lpOptional,DWORD dwOptionalLength,CONTEXTBUF* cbuf)
{
	INTERNET_BUFFERS bufin;

	memset(&bufin,0,sizeof(bufin));
	bufin.dwStructSize=sizeof(bufin);
	bufin.dwHeadersLength=dwHeadersLength;
	bufin.dwHeadersTotal=dwHeadersLength;
	bufin.lpcszHeader=lpszHeaders;
	bufin.dwBufferLength=dwOptionalLength;
	bufin.dwBufferTotal=dwOptionalLength;
	bufin.lpvBuffer=lpOptional;

	ResetEvent(cbuf->hRequestCompleteEvent);
	cbuf->dwError=0;
	BOOL ok=HttpSendRequest(hRequest,lpszHeaders,dwHeadersLength,lpOptional,dwOptionalLength);
	if (ok || GetLastError()!=ERROR_IO_PENDING) {  // it wasn't async, or failed
		cbuf->dwError=GetLastError();
		return ok ? ASYNC_OK : ASYNC_FAILED;
	}
	return HandleRequestComplete(hRequest,cbuf);
}

BOOL AsyncHttpSendRequestEx (HINTERNET hRequest,LPINTERNET_BUFFERS lpBuffersIn,LPINTERNET_BUFFERS lpBuffersOut,DWORD dwFlags,CONTEXTBUF* cbuf)
{
	ResetEvent(cbuf->hRequestCompleteEvent);
	cbuf->dwError=0;

	BOOL ok=HttpSendRequestEx(hRequest,lpBuffersIn,lpBuffersOut,dwFlags | HSR_ASYNC,(DWORD)cbuf);
	
	if (ok || GetLastError()!=ERROR_IO_PENDING) {  // it wasn't async, or failed
		cbuf->dwError=GetLastError();
		return ok ? ASYNC_OK : ASYNC_FAILED;
	}
	return HandleRequestComplete(hRequest,cbuf);
}

int AsyncHttpEndRequest(HINTERNET hRequest,LPINTERNET_BUFFERS lpBuffersOut,DWORD dwFlags,CONTEXTBUF* cbuf)
{
	ResetEvent(cbuf->hRequestCompleteEvent);

	cbuf->dwError=0;
	BOOL ok=HttpEndRequest(hRequest,lpBuffersOut,dwFlags,(DWORD)cbuf);
	if (ok || GetLastError()!=ERROR_IO_PENDING) {  // it wasn't async, or failed
		cbuf->dwError=GetLastError();
		return ok ? ASYNC_OK : ASYNC_FAILED;
	}
	return HandleRequestComplete(hRequest,cbuf);
}

int AsyncInternetReadFile(IN HINTERNET hFile, IN LPVOID lpBuffer, IN DWORD dwNumberOfBytesToRead, OUT LPDWORD lpdwNumberOfBytesRead,CONTEXTBUF* cbuf)
{
	ResetEvent(cbuf->hRequestCompleteEvent);
	INTERNET_BUFFERSA InetBuff;
	memset(&InetBuff, 0, sizeof(InetBuff));
	InetBuff.dwStructSize = sizeof(InetBuff);
	InetBuff.lpvBuffer = lpBuffer;
	InetBuff.dwBufferLength = dwNumberOfBytesToRead;
	
	cbuf->dwError=0;
	BOOL ok=InternetReadFileExA(hFile,&InetBuff,IRF_ASYNC,(DWORD)cbuf);
	if (ok || GetLastError()!=ERROR_IO_PENDING) {  // it wasn't async, or failed
		if (ok)
			*lpdwNumberOfBytesRead=InetBuff.dwBufferLength;
		else
			*lpdwNumberOfBytesRead=0;
		cbuf->dwError=GetLastError();
		return ok ? ASYNC_OK : ASYNC_FAILED;
	}
	int ret=HandleRequestComplete(hFile,cbuf);
	if (ret==ASYNC_OK)
		*lpdwNumberOfBytesRead=InetBuff.dwBufferLength;
	else
		*lpdwNumberOfBytesRead=0;
	return ret;
}

int AsyncInternetWriteFile(HINTERNET hFile,LPCVOID lpBuffer,DWORD dwNumberOfBytesToWrite,LPDWORD lpdwNumberOfBytesWritten,CONTEXTBUF* cbuf)
{
	ResetEvent(cbuf->hRequestCompleteEvent);
	BOOL ok=InternetWriteFile(hFile,lpBuffer,dwNumberOfBytesToWrite,lpdwNumberOfBytesWritten);
	cbuf->dwError=0;
	if (ok || GetLastError()!=ERROR_IO_PENDING) {  // it wasn't async, or failed
		if (ok)
			*lpdwNumberOfBytesWritten=dwNumberOfBytesToWrite;
		else
			*lpdwNumberOfBytesWritten=0;
		cbuf->dwError=GetLastError();
		return ok ? ASYNC_OK : ASYNC_FAILED;
	}
	int ret=HandleRequestComplete(hFile,cbuf);
	if (ret==ASYNC_OK)
		*lpdwNumberOfBytesWritten=dwNumberOfBytesToWrite;
	else
		*lpdwNumberOfBytesWritten=0;
	return ret;
}

BOOL CALLBACK EnumThreadWndProc(HWND hwnd,LPARAM lParam)
{
	HWND popwnd=GetLastActivePopup(hwnd);  // find window with popup
	if (popwnd!=hwnd) {
		*(HWND*)lParam=popwnd;
		return false;
	} else
		return true;
}

BOOL CALLBACK EnumThreadWndProc2(HWND hwnd,LPARAM lParam)
{
	*(HWND*)lParam=hwnd;
	return false;
}

#define BODY_UTF8 1

int GetHeaderEncoding(char* header) // look for: Content-Type:*utf-8
{
	strlwr(header);
	char* p=strstr(header,"content-type:");
	if (p) {
		p+=13;
		if (strstr(p,"utf-8"))
			return BODY_UTF8;
	}
	return 0;
}

int GetBodyEncoding(char* body)
{
	char* p=strstr(body,"encoding=");
	if (p) {
		p+=9;
		while (p[0]=='"' || p[0]=='\'' || p[0]==' ' || p[0]=='\r' || p[0]=='\n' || p[0]=='\t')
			p++;
		if (strnicmp(p,"utf-8",5)==0)
			return BODY_UTF8;
	}
	return 0;
}

void appendproxyauthinfo(TCHAR* headers,TCHAR* user,TCHAR* pass,int maxlen)
{
	if (user[0]) {
		char buf1[MAX_PATH],buf2[MAX_PATH];
#ifdef UNICODE
		WideCharToMultiByte(CP_ACP,0,user,-1,buf1,sizeof(buf1)-1,NULL,NULL);
#else
		strlcpy(buf1,user,MAX_PATH-2);
#endif
		strcat(buf1,":");
#ifdef UNICODE
		WideCharToMultiByte(CP_ACP,0,pass,-1,buf1+strlen(buf1),sizeof(buf1)-strlen(buf1)-1,NULL,NULL);
#else
		strlcat(buf1,pass,MAX_PATH-2);
#endif
		MimeEncode(buf1,buf2,sizeof(buf2)-1);
		strcpy(buf1,"Proxy-Authorization: Basic ");
		strlcat(buf1,buf2,sizeof(buf1)-1);
		strlcat(buf1,"\r\n",sizeof(buf1)-1);
#ifdef UNICODE
		MultiByteToWideChar(CP_ACP,0,buf1,-1,headers+wcslen(headers),maxlen-wcslen(headers));
#else
		strlcat(headers,buf1,maxlen);
#endif
	}
}


void setproxyauthinfo(HINTERNET ConnHandle,TCHAR* proxyuser,TCHAR* proxypassword)
{
	if (proxyuser[0]) {
		InternetSetOption(ConnHandle, INTERNET_OPTION_PROXY_USERNAME,
			proxyuser, _tcslen(proxyuser)+1);
	}
	if (proxypassword[0]) {
		InternetSetOption(ConnHandle, INTERNET_OPTION_PROXY_PASSWORD,
			proxypassword, _tcslen(proxypassword)+1);
	}
}

#ifndef ERROR_INTERNET_SEC_CERT_ERRORS
#define ERROR_INTERNET_SEC_CERT_ERRORS 12055
#define ERROR_INTERNET_SEC_CERT_NO_REV 12056
#define ERROR_INTERNET_SEC_CERT_REV_FAILED 12057
#endif

int WebDavFindFirstFile(void* serverid,TCHAR* remotedir,void** davdataptr)
{
	HTTP_MEMORY_STORAGE *dirstorage;
	TCHAR dirname[4*MAX_PATH];
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	BOOL repeatrequest=ConnectSettings->SslConnect || ConnectSettings->proxyuser[0];
	int redirectCount=0;   // avoid infinite loop when redirecting

	ShowStatus(TEXT("================="));
    _tcscpy(dirname,TEXT("Get dir: "));
	TCHAR* p2=dirname+_tcslen(dirname);
    _tcslcat(dirname,remotedir,countof(dirname)-1);
	TCHAR* p3=dirname+_tcslen(dirname)-1;
	if (p3>p2 && (p3[0]=='/' || p3[0]=='\\'))
		p3[0]=0;
    ShowStatus(dirname);

httprepeatrequestlabel:
	http_create_memory_storage(&dirstorage);

	BOOL bodyisutf8=false;

	_tcslcpy(dirname,remotedir,countof(dirname)-1);
	if (NULL==tcsFormValidUrl(dirname,countof(dirname)-1,ConnectSettings->interpreturlasutf8)) {
		ShowStatus(TEXT("Invalid Unicode path name!"));
		return DAV_FAILED;
	}
	if (_tcslen(dirname)>1) {
		TCHAR* p=dirname+_tcslen(dirname)-1;
		if (ConnectSettings->appendslash) {
			if (p[0]!='/')            // ADD trailing slash!
				_tcslcat(dirname,TEXT("/"),countof(dirname)-1);
		} else {
			if (p[0]=='/')            // REMOVE trailing slash!
				p[0]=0;
		}
	}

	if (dirstorage) {
		HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
		CONTEXTBUF cbuf;
		SetupContextBuf(ConnHandle,&cbuf);
		bodyisutf8=false;

		HINTERNET HttpHandle;
		int status=400;

		/*char buffer[8192];
		HANDLE tempfile=CreateFile(TEXT("c:\\temp\\testdav.txt"),GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
			OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
		if (tempfile!=INVALID_HANDLE_VALUE) {
			DWORD read_count;
			http_storage_seek(dirstorage, 0);
			while (ReadFile(tempfile,&buffer,sizeof(buffer),&read_count,NULL) && read_count>0) {
				http_storage_write(dirstorage,buffer, read_count);
			}
			CloseHandle(tempfile);
			http_storage_seek(dirstorage, 0);
			status=200;
		}
		else*/
		{

			setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);

			HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("PROPFIND"),dirname,TEXT("HTTP/1.1"),NULL,NULL,
				INTERNET_FLAG_KEEP_CONNECTION | INTERNET_FLAG_NO_CACHE_WRITE | ConnectSettings->SslFlags,&cbuf);
			if (!HttpHandle)
				ShowDetailedError(TEXT("HttpOpenRequest error: "),GetLastError());
			else {
				TCHAR optionalheaders[512];
	/*			char xmlbodypadded[256];
				strcpy(xmlbodypadded,propfindxmlbody);
				int l=strlen(xmlbodypadded);  // due to an error in wininet, the length must be >150!
				while (l<160) {
					strcat(xmlbodypadded,"\r\n");
					l+=2;
				}
				wsprintf(optionalheaders,"Depth: 1\r\nContent-type: text/xml; charset=\"utf-8\"\r\n Content-Length: %d\r\n",strlen(xmlbodypadded));
	*/			_tcscpy(optionalheaders,TEXT("Depth: 1\r\nContent-type: text/xml; charset=\"utf-8\"\r\n"));
				// we append it here again, otherwise we may get an error on first connect!
				appendproxyauthinfo(optionalheaders,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(optionalheaders)-1);
				// Note: The Software AG webDAV server at
				// http://tamino.demozone.softwareag.com/taminowebdavserver/yourstore
				// doesn't seem to like ANY xml body :(
				int ok=ASYNC_FAILED;
				int retrycount=0;

				//SetSSLCert(serverid, HttpHandle);

				do {
					ok=AsyncHttpSendRequest(HttpHandle,optionalheaders,_tcslen(optionalheaders),NULL,0/*xmlbodypadded,strlen(xmlbodypadded)*/,&cbuf);
					if (ok==ASYNC_CANCELED_HANDLE_DELETED) {
						repeatrequest=false;
					} else if (ok==ASYNC_FAILED) {
						//char buf[255];
						//sprintf(buf,"Error code %d",cbuf.dwError);
						//MessageBox(0,buf,"test",0);

						if (cbuf.dwError==ERROR_INTERNET_INVALID_CA ||
							cbuf.dwError==ERROR_INTERNET_INCORRECT_PASSWORD ||
							cbuf.dwError==ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_CN_INVALID ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_DATE_INVALID ||
							cbuf.dwError==ERROR_INTERNET_RETRY_DIALOG ||
							cbuf.dwError==ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_ERRORS ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_NO_REV ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_REV_FAILED ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_REVOKED ||
							cbuf.dwError==ERROR_INTERNET_SECURITY_CHANNEL_ERROR)
							{
							MessageBeep(MB_ICONQUESTION);
							HWND wnd=GetActiveWindow();
							if (wnd==NULL || GetWindowThreadProcessId(wnd,NULL)!=GetCurrentThreadId()) {
								wnd=NULL;
								EnumThreadWindows(GetCurrentThreadId(),EnumThreadWndProc,(LPARAM)&wnd);
								if (wnd==NULL)
									EnumThreadWindows(GetCurrentThreadId(),EnumThreadWndProc2,(LPARAM)&wnd);
							}
							if (ERROR_CANCELLED==InternetErrorDlg(wnd,HttpHandle,cbuf.dwError,
								FLAGS_ERROR_UI_FILTER_FOR_ERRORS |
								 FLAGS_ERROR_UI_FLAGS_GENERATE_DATA |
								 FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS,NULL))
								break;
							if (cbuf.dwError==ERROR_INTERNET_SEC_CERT_REV_FAILED ||
								cbuf.dwError==ERROR_INTERNET_SEC_CERT_NO_REV) {  // not handled automatically
								int newflag;
								unsigned long sz;
								sz=sizeof(newflag);
								InternetQueryOption(HttpHandle,INTERNET_OPTION_SECURITY_FLAGS,&newflag,&sz);
								//sprintf(buf,"Flags: %d",newflag);
								//MessageBox(0,buf,"test",0);
								newflag|=SECURITY_FLAG_IGNORE_REVOCATION; // | SECURITY_FLAG_IGNORE_UNKNOWN_CA;
								InternetSetOption(HttpHandle,INTERNET_OPTION_SECURITY_FLAGS,&newflag,sizeof(newflag));
							}
						}
						else if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED)
						{
							SetSSLCert(serverid, HttpHandle);
						}
						else
						{
							ShowDetailedError(TEXT("HttpSendRequest failed: "),cbuf.dwError);
							break;
						}
					}
				} while (ok==ASYNC_FAILED && ++retrycount<5);
				if (ok==ASYNC_OK) {
					char buffer[8192];
					DWORD bytesread;
					do {
						ok=AsyncInternetReadFile(HttpHandle,&buffer,sizeof(buffer),&bytesread,&cbuf);
						if (bytesread>0) {
							http_storage_write(dirstorage,buffer, bytesread);
						}
					} while (ok==ASYNC_OK && bytesread>0);
					status=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
					if ((int)status/100==2) {
						repeatrequest=false;
					}
					if ((status==301 || status==302) && redirectCount<3) {  // redirect!
						redirectCount++;
						TCHAR buffer[4*MAX_PATH];
						DWORD len=sizeof(buffer)-1;
						DWORD idx=0;
						if (HttpQueryInfo(HttpHandle,HTTP_QUERY_LOCATION, buffer, &len, &idx)) {
							TCHAR* p=buffer;
							if (p[0]) {
								if (_tcsnicmp(p,TEXT("http://"),7)==0 ||
									_tcsnicmp(p,TEXT("https://"),8)==0)
									p=_tcschr(p+8,'/');  // get subdir only
								if (p) {
									_tcslcpy(dirname,p,countof(dirname)-1);
									TCHAR* pend=dirname+_tcslen(dirname)-1;
									if (pend[0]=='/')
										ConnectSettings->appendslash=true;
									repeatrequest=true;
								}
							}
						}
					} else if (!ConnectSettings->interpreturlasutf8) {
						// get encoding of header or buffer, but only if we do not interpret UTF8 afterwards!
						char buffer[2048];
						DWORD len=sizeof(buffer)-1;
						DWORD idx=0;
						if (HttpQueryInfo(HttpHandle,HTTP_QUERY_RAW_HEADERS, buffer, &len, &idx)) {
							// look for Content-Type: text/xml; charset="utf-8"
							// or better: Content-Type:*utf-8
							// the header lines are 0-terminated, finished with double 0
							if (buffer[0]) {
								char* p=buffer;
								while (p[0]) {
									bodyisutf8=GetHeaderEncoding(p)!=0;
									if (bodyisutf8)
										break;
									p+=strlen(p)+1;
								}
							}
						}
					}
				}
				if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
					InternetCloseHandle(HttpHandle);
			}
		}
		CleanupContextBuf(ConnHandle,&cbuf);

	  	DAV_OPENDIR_DATA *oddata=(DAV_OPENDIR_DATA*)malloc(sizeof(DAV_OPENDIR_DATA));
		DAV_RESPONSE *response_cursor = NULL;
		DAV_PROP *prop = NULL;
		int error = HT_OK;
		oddata->interpreturlasutf8=ConnectSettings->interpreturlasutf8;

		if(dirstorage->content_size>0 && int(status/100)==2)
		{
			// We only need to decode UTF8 before % conversion if we do NOT decode UTF8 AFTER conversion
			if (!oddata->interpreturlasutf8) {  // get encoding of header or buffer
				int read_count;
				char buffer[2048];

				if (!bodyisutf8) {
					http_storage_seek(dirstorage, 0);
					if (http_storage_read(dirstorage, buffer, 2047, &read_count) == HT_OK) {
						buffer[read_count]=0;
						bodyisutf8=GetBodyEncoding(buffer)!=0;
					}
					http_storage_seek(dirstorage, 0);
				}
			}
			if (ConnectSettings->detailedlog &&
				ConnHandle==ConnectSettings->ForegroundConnHandle) {
				int read_count;
				char buffer[8192];
				TCHAR tempdir[MAX_PATH];
				TCHAR tempfilename[3*MAX_PATH];
				GetTempPath(260,tempdir);
				ConnectSettings->TempPathUniqueValue=GetTempFileName(tempdir,TEXT("DAV"),ConnectSettings->TempPathUniqueValue,tempfilename);
				if (tempfilename[0]) {
					HANDLE tempfile=CreateFile(tempfilename,GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
						CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
					if (tempfile) {
						DWORD write_count;
						http_storage_seek(dirstorage, 0);
						while (http_storage_read(dirstorage, buffer, 8192, &read_count) == HT_OK && read_count) {
							WriteFile(tempfile,&buffer,read_count,&write_count,NULL);
						}
						CloseHandle(tempfile);
						http_storage_seek(dirstorage, 0);
					}
				}
			}

			/* // Code to test dav listing from user
			HANDLE tempfile=CreateFile(L"c:\\temp\\davtest.tmp",GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
			if (tempfile) {
				http_create_memory_storage(&dirstorage);
				DWORD read_count;
				char buffer[8192];
				while (ReadFile(tempfile,buffer,8192,&read_count,NULL) && read_count>0) {
					http_storage_write(dirstorage,buffer, read_count);
				}
				CloseHandle(tempfile);
				http_storage_seek(dirstorage, 0);
			}
			*/

			error = dav_create_multistatus_from_storage(&oddata->multistatus, (http_storage*)dirstorage,bodyisutf8);
			oddata->bodyisutf8=bodyisutf8;
			http_storage_destroy(&dirstorage);
			if (error) {
				free(oddata);
				return DAV_FAILED;
			}
			if(oddata->multistatus != NULL)
			{
				oddata->response_cursor = oddata->multistatus->first_response;
				for(response_cursor = oddata->multistatus->first_response; response_cursor != NULL; response_cursor = response_cursor->next_response)
				{
					if((prop = dav_find_prop(response_cursor, 200, 200)) != NULL)
					{
//						dav_scan_locktoken_into_database(hoststr(connection), response_cursor->href, prop);
					}
				}
			}
			oddata->directory_slash_count=getslashcount(dirname);
			oddata->base_slash_count=ConnectSettings->baseslashcount;
			// Unencoded directory name!
			_tcslcpy(oddata->dirname,remotedir,countof(oddata->dirname)-1);
			tcsReplaceBackslashBySlash(oddata->dirname);
			tcslcatforwardslash(oddata->dirname,countof(oddata->dirname)-1);
			oddata->dirnamelen=_tcslen(oddata->dirname);

			*davdataptr=oddata;
			return DAV_OK;
		} else
			http_storage_destroy(&dirstorage);
		free(oddata);
	}
	if (repeatrequest) {
		repeatrequest=false;
		goto httprepeatrequestlabel;
	}
	return DAV_FAILED;
}

BOOL WebDavFindNextFile(void* serverid,void* davdataptr,WIN32_FIND_DATA *FindData,DAV_OPENDIR_DATA **oddatafound)
{
	DAV_OPENDIR_DATA *oddata=(DAV_OPENDIR_DATA*)davdataptr;
	if (!oddata)
		return DAV_FAILED;
	if (dav_readdir(oddata)) {
		if (oddatafound)
			*oddatafound=oddata;
		memset(FindData,0,sizeof(WIN32_FIND_DATA));
		FindData->dwFileAttributes=0;
		_tcslcpy(FindData->cFileName,oddata->filename,countof(FindData->cFileName)-1);
		TCHAR* p=_tcsrchr(FindData->cFileName,'/');
		if (oddata->type==DAV_RESOURCETYPE_COLLECTION) {
			FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
			if (p && p[1]==0)
				p[0]=0;
		} else if (p) {
			if (p[1]==0) {   // trailing slash?
				p[0]=0;
				if (oddata->prop==NULL || oddata->prop->getcontenttype==NULL ||
					strstr(oddata->prop->getcontenttype,"directory")!=NULL)  // handle server which appends slash to file name(!)
					FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
			}
		}
		if (oddata->lockowner!=NULL && oddata->lockowner[0]!=0)
			FindData->dwFileAttributes=FILE_ATTRIBUTE_READONLY;

		FindData->cAlternateFileName[0]=0;
		FindData->ftCreationTime=oddata->cdate;
		FindData->ftLastAccessTime.dwHighDateTime=0;
		FindData->ftLastAccessTime.dwLowDateTime=0;
		FindData->nFileSizeHigh=(DWORD)(oddata->size >> 32);
		FindData->nFileSizeLow=(DWORD)(oddata->size) & 0xFFFFFFFF;

		FindData->ftLastWriteTime=oddata->mdate;
		if (oddata->mdate.dwHighDateTime==0 && oddata->mdate.dwLowDateTime==0) {
            FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
            FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
        }
		return DAV_OK;
	} else
		return DAV_FAILED;
}

int WebDavFindClose(void* serverid,void* davdataptr)
{
	if (davdataptr) {
		DAV_OPENDIR_DATA *oddata=(DAV_OPENDIR_DATA*)davdataptr;
		dav_closedir(oddata);
		free(oddata);
		davdataptr=NULL;
	}
	return DAV_OK;
}

#define propertiesxmlbody "\r\n<?xml version=\"1.0\" encoding=\"utf-8\" ?><A:propfind xmlns:A='DAV'><A:prop><A:getcontentlength/><A:getlastmodified/><A:owner/><A:group/><A:permissions/></A:prop></A:propfind>"

int WebDavGetSingleFileProperties(void* serverid,TCHAR* remotedir,void** davdataptr)
{
	HTTP_MEMORY_STORAGE *dirstorage;
	TCHAR dirname[3*MAX_PATH];
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	BOOL repeatrequest=ConnectSettings->SslConnect || ConnectSettings->proxyuser[0];

	ShowStatus(TEXT("================="));
    _tcscpy(dirname,TEXT("File info: "));
    _tcslcat(dirname,remotedir,countof(dirname)-1);
    ShowStatus(dirname);

httprepeatrequestlabel:
	http_create_memory_storage(&dirstorage);

	BOOL bodyisutf8=false;

	_tcslcpy(dirname,remotedir,countof(dirname)-1);
	if (NULL==tcsFormValidUrl(dirname,countof(dirname)-1,ConnectSettings->interpreturlasutf8)) {
		ShowStatus(TEXT("Invalid Unicode path name!"));
		return DAV_FAILED;
	}
	/*if (_tcslen(dirname)>1) {
		TCHAR* p=dirname+_tcslen(dirname)-1;
		if (p[0]!='/')            // ADD trailing slash!
			_tcslcat(dirname,TEXT("/"),countof(dirname)-1);
	}*/

	if (dirstorage) {
		HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
		CONTEXTBUF cbuf;
		SetupContextBuf(ConnHandle,&cbuf);
		bodyisutf8=false;

		HINTERNET HttpHandle;
		int status=400;

		{
			setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);

			HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("PROPFIND"),dirname,TEXT("HTTP/1.1"),NULL,NULL,
				INTERNET_FLAG_KEEP_CONNECTION | INTERNET_FLAG_NO_CACHE_WRITE | ConnectSettings->SslFlags,&cbuf);
			if (!HttpHandle)
				ShowDetailedError(TEXT("HttpOpenRequest error: "),GetLastError());
			else {
				TCHAR optionalheaders[512];
	/*			char xmlbodypadded[256];
				strcpy(xmlbodypadded,propertiesxmlbody);
				int l=strlen(xmlbodypadded);  // due to an error in wininet, the length must be >150!
				while (l<160) {
					strcat(xmlbodypadded,"\r\n");
					l+=2;
				}
				wsprintf(optionalheaders,TEXT("Depth: 0\r\nContent-type: text/xml; charset=\"utf-8\"\r\n Content-Length: %d\r\n"),strlen(xmlbodypadded));*/
				_tcscpy(optionalheaders,TEXT("Depth: 0\r\nContent-type: text/xml; charset=\"utf-8\"\r\n"));
				// we append it here again, otherwise we may get an error on first connect!
				appendproxyauthinfo(optionalheaders,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(optionalheaders)-1);
				// Note: The Software AG webDAV server at
				// http://tamino.demozone.softwareag.com/taminowebdavserver/yourstore
				// doesn't seem to like ANY xml body :(
				int ok=ASYNC_FAILED;
				int retrycount=0;

				do {
					ok=AsyncHttpSendRequest(HttpHandle,optionalheaders,_tcslen(optionalheaders),NULL,0/*xmlbodypadded,strlen(xmlbodypadded)*/,&cbuf);
					if (ok==ASYNC_CANCELED_HANDLE_DELETED) {
						repeatrequest=false;
					} else if (ok==ASYNC_FAILED) {
						if (cbuf.dwError==ERROR_INTERNET_INVALID_CA ||
							cbuf.dwError==ERROR_INTERNET_INCORRECT_PASSWORD ||
							cbuf.dwError==ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_CN_INVALID ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_DATE_INVALID ||
							cbuf.dwError==ERROR_INTERNET_RETRY_DIALOG ||
							cbuf.dwError==ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_ERRORS ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_NO_REV ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_REV_FAILED ||
							cbuf.dwError==ERROR_INTERNET_SEC_CERT_REVOKED ||
							cbuf.dwError==ERROR_INTERNET_SECURITY_CHANNEL_ERROR)
							{
							MessageBeep(MB_ICONQUESTION);
							HWND wnd=GetActiveWindow();
							if (wnd==NULL || GetWindowThreadProcessId(wnd,NULL)!=GetCurrentThreadId()) {
								wnd=NULL;
								EnumThreadWindows(GetCurrentThreadId(),EnumThreadWndProc,(LPARAM)&wnd);
								if (wnd==NULL)
									EnumThreadWindows(GetCurrentThreadId(),EnumThreadWndProc2,(LPARAM)&wnd);
							}
							if (ERROR_CANCELLED==InternetErrorDlg(wnd,HttpHandle,cbuf.dwError,
								FLAGS_ERROR_UI_FILTER_FOR_ERRORS |
								 FLAGS_ERROR_UI_FLAGS_GENERATE_DATA |
								 FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS,NULL))
								break;
							if (cbuf.dwError==ERROR_INTERNET_SEC_CERT_REV_FAILED ||
								cbuf.dwError==ERROR_INTERNET_SEC_CERT_NO_REV) {  // not handled automatically
								int newflag;
								unsigned long sz;
								sz=sizeof(newflag);
								InternetQueryOption(HttpHandle,INTERNET_OPTION_SECURITY_FLAGS,&newflag,&sz);
								newflag|=SECURITY_FLAG_IGNORE_REVOCATION; // | SECURITY_FLAG_IGNORE_UNKNOWN_CA;
								InternetSetOption(HttpHandle,INTERNET_OPTION_SECURITY_FLAGS,&newflag,sizeof(newflag));
							}
						}
						else if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED)
						{
							SetSSLCert(serverid, HttpHandle);
						}
						else
						{
							ShowDetailedError(TEXT("HttpSendRequest failed: "),cbuf.dwError);
							break;
						}
					}
				} while (ok==ASYNC_FAILED && ++retrycount<5);
				if (ok==ASYNC_OK) {
					char buffer[8192];
					DWORD bytesread;
					do {
						ok=AsyncInternetReadFile(HttpHandle,&buffer,sizeof(buffer),&bytesread,&cbuf);
						if (bytesread>0) {
							http_storage_write(dirstorage,buffer, bytesread);
						}
					} while (ok==ASYNC_OK && bytesread>0);
					status=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
					if ((int)status/100==2) {
						repeatrequest=false;
					}
					if (!ConnectSettings->interpreturlasutf8) {
						// get encoding of header or buffer, but only if we do not interpret UTF8 afterwards!
						char buffer[2048];
						DWORD len=sizeof(buffer)-1;
						DWORD idx=0;
						if (HttpQueryInfo(HttpHandle,HTTP_QUERY_RAW_HEADERS, buffer, &len, &idx)) {
							// look for Content-Type: text/xml; charset="utf-8"
							// or better: Content-Type:*utf-8
							// the header lines are 0-terminated, finished with double 0
							if (buffer[0]) {
								char* p=buffer;
								while (p[0]) {
									bodyisutf8=GetHeaderEncoding(p)!=0;
									if (bodyisutf8)
										break;
									p+=strlen(p)+1;
								}
							}
						}
					}
				}
				if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
					InternetCloseHandle(HttpHandle);
			}
		}
		CleanupContextBuf(ConnHandle,&cbuf);

	  	DAV_OPENDIR_DATA *oddata=(DAV_OPENDIR_DATA*)malloc(sizeof(DAV_OPENDIR_DATA));
		DAV_RESPONSE *response_cursor = NULL;
		DAV_PROP *prop = NULL;
		int error = HT_OK;
		oddata->interpreturlasutf8=ConnectSettings->interpreturlasutf8;

		if(dirstorage->content_size>0 && int(status/100)==2)
		{
			// We only need to decode UTF8 before % conversion if we do NOT decode UTF8 AFTER conversion
			if (!oddata->interpreturlasutf8) {  // get encoding of header or buffer
				int read_count;
				char buffer[2048];

				if (!bodyisutf8) {
					http_storage_seek(dirstorage, 0);
					if (http_storage_read(dirstorage, buffer, 2047, &read_count) == HT_OK) {
						buffer[read_count]=0;
						bodyisutf8=GetBodyEncoding(buffer)!=0;
					}
					http_storage_seek(dirstorage, 0);
				}
			}
			if (ConnectSettings->detailedlog) {
				int read_count;
				char buffer[8192];
				TCHAR tempdir[MAX_PATH];
				TCHAR tempfilename[3*MAX_PATH];
				GetTempPath(260,tempdir);
				ConnectSettings->TempPathUniqueValue=GetTempFileName(tempdir,TEXT("DAV"),ConnectSettings->TempPathUniqueValue,tempfilename);
				if (tempfilename[0]) {
					HANDLE tempfile=CreateFile(tempfilename,GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
						CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
					if (tempfile) {
						DWORD write_count;
						http_storage_seek(dirstorage, 0);
						while (http_storage_read(dirstorage, buffer, 8192, &read_count) == HT_OK && read_count) {
							WriteFile(tempfile,&buffer,read_count,&write_count,NULL);
						}
						CloseHandle(tempfile);
						http_storage_seek(dirstorage, 0);
					}
				}
			}
			// loadlog
			/*
			{
				DWORD read_count;
				char buffer[8192];
				TCHAR tempfilename[3*MAX_PATH];
				_tcscpy(tempfilename,TEXT("c:\\temp\\DAVTEST.TXT"));
				HANDLE tempfile=CreateFile(tempfilename,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
						OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
				if (tempfile) {
					http_storage_destroy(&dirstorage);
					http_create_memory_storage(&dirstorage);
					while (ReadFile(tempfile,buffer,sizeof(buffer),&read_count,NULL) && read_count>0) {
						http_storage_write(dirstorage,buffer, read_count);
					}
					CloseHandle(tempfile);
					http_storage_seek(dirstorage, 0);
				}

			}
			*/
  
			error = dav_create_multistatus_from_storage(&oddata->multistatus, (http_storage*)dirstorage,bodyisutf8);
			oddata->bodyisutf8=bodyisutf8;
			http_storage_destroy(&dirstorage);
			if (error) {
				free(oddata);
				return DAV_FAILED;
			}
			if(oddata->multistatus != NULL)
			{
				oddata->response_cursor = oddata->multistatus->first_response;
				for(response_cursor = oddata->multistatus->first_response; response_cursor != NULL; response_cursor = response_cursor->next_response)
				{
					if((prop = dav_find_prop(response_cursor, 200, 200)) != NULL)
					{
//						dav_scan_locktoken_into_database(hoststr(connection), response_cursor->href, prop);
					}
				}
			}
			oddata->directory_slash_count=getslashcount(dirname)-1; // important, to get data of this item itself!
			oddata->base_slash_count=ConnectSettings->baseslashcount;

			*davdataptr=oddata;
			return DAV_OK;
		} else
			http_storage_destroy(&dirstorage);
		free(oddata);
	}
	if (repeatrequest) {
		repeatrequest=false;
		goto httprepeatrequestlabel;
	}
	return DAV_FAILED;
}

TCHAR* ConvertValueToTChar(BOOL u8,const char* inbuf,TCHAR* outbuf,int maxlen,TCHAR* defvalue)
{
	_tcscpy(outbuf,defvalue);
#ifdef UNICODE
	if (inbuf) {
		if (u8) {
			unsigned char* srcstart=(unsigned char*)inbuf;
			WCHAR* trgstart=outbuf;
			ConvertUTF8toUTF16(&srcstart,(unsigned char*)inbuf+strlen(inbuf)+1,
				(UTF16**)&outbuf,(UTF16*)outbuf+maxlen);
		} else { //3
			MultiByteToWideChar(CP_ACP,0,inbuf,-1,outbuf,maxlen);
		}
		return outbuf;
	}
#else
	if (inbuf) {
		WCHAR utf16buf[1024];
		unsigned char* srcstart=(unsigned char*)inbuf;
		WCHAR* trgstart=utf16buf;
		if (u8) {
			ConvertUTF8toUTF16(&srcstart,(unsigned char*)inbuf+strlen(inbuf)+1,
				&trgstart,((UTF16*)trgstart)+countof(utf16buf)-1);
			WideCharToMultiByte(CP_ACP,0,utf16buf,-1,outbuf,maxlen,NULL,NULL);
		} else
			strlcpy(outbuf,inbuf,maxlen);
		return outbuf;
	}
#endif
	return NULL;
}

WIN32_FIND_DATA* PropertiesFindData;
DAV_OPENDIR_DATA *PropertiesOddata;


myint1 CALLBACK PropertiesDlgProc(HWND hWnd,unsigned int Message,WPARAM wParam,LPARAM lParam)
{
	RECT rt1,rt2;
	int w,h,DlgWidth,DlgHeight,NewPosX,NewPosY;
	char buf[256];

	switch (Message) {
	case WM_INITDIALOG: {
		SetDlgItemText(hWnd,IDC_PROP_NAME,PropertiesFindData->cFileName);
		__int64 sz=((__int64)(PropertiesFindData->nFileSizeHigh))<<32 | PropertiesFindData->nFileSizeLow;
		_i64toa(sz,buf,10);
		strcat(buf," b");
		sz/=1024;
		if (sz>1024) {
			sz/=1024;
			strcat(buf," (");
			_i64toa(sz,buf+strlen(buf),10);
			strcat(buf," M)");
		} else if (sz>0) {
			strcat(buf," (");
			_i64toa(sz,buf+strlen(buf),10);
			strcat(buf," k)");
		}
		SetDlgItemTextA(hWnd,IDC_PROP_SIZE,buf);

		SYSTEMTIME tdt={0};
		FILETIME lft;
		FileTimeToLocalFileTime(&PropertiesFindData->ftLastWriteTime,&lft);
		FileTimeToSystemTime(&lft,&tdt);
		sprintf(buf,"%d-%02d-%02d %02d:%02d:%02d (local)",tdt.wYear,tdt.wMonth,tdt.wDay,tdt.wHour,tdt.wMinute,tdt.wSecond);
		SetDlgItemTextA(hWnd,IDC_PROP_MODIFIED,buf);

		FileTimeToLocalFileTime(&PropertiesFindData->ftCreationTime,&lft);
		FileTimeToSystemTime(&lft,&tdt);
		sprintf(buf,"%d-%02d-%02d %02d:%02d:%02d (local)",tdt.wYear,tdt.wMonth,tdt.wDay,tdt.wHour,tdt.wMinute,tdt.wSecond);
		SetDlgItemTextA(hWnd,IDC_PROP_CREATED,buf);

		bool u8=PropertiesOddata->bodyisutf8 || PropertiesOddata->interpreturlasutf8;
		TCHAR outbuf[1024];
		ConvertValueToTChar(u8,PropertiesOddata->lockowner,outbuf,countof(outbuf)-1,TEXT("-"));
		SetDlgItemText(hWnd,IDC_LOCKED_BY,outbuf);

		if (PropertiesOddata->prop) {
			ConvertValueToTChar(u8,PropertiesOddata->prop->owner,outbuf,countof(outbuf)-1,TEXT("-"));
			SetDlgItemText(hWnd,IDC_PROP_OWNER,outbuf);
			ConvertValueToTChar(u8,PropertiesOddata->prop->group,outbuf,countof(outbuf)-1,TEXT("-"));
			SetDlgItemText(hWnd,IDC_PROP_GROUP,outbuf);
		}

		// trying to center the About dialog
		if (GetWindowRect(hWnd, &rt1) && GetWindowRect(GetParent(hWnd), &rt2)) {
			w=rt2.right-rt2.left;
			h=rt2.bottom-rt2.top;
			DlgWidth   = rt1.right - rt1.left;
			DlgHeight   = rt1.bottom - rt1.top ;
			NewPosX      =rt2.left + (w - DlgWidth)/2;
			NewPosY      =rt2.top + (h - DlgHeight)/2;
			SetWindowPos(hWnd, 0, NewPosX, NewPosY,
				0, 0, SWP_NOZORDER | SWP_NOSIZE);
		}
		return 1;
	}
	case WM_COMMAND: {
		switch(LOWORD(wParam)) {
			case IDOK:
			case IDCANCEL:
				EndDialog(hWnd, IDOK);
				return 1;
		}
	}
	}
	return 0;
}


void ShowDavPropertiesDialog(WIN32_FIND_DATA* FindData,DAV_OPENDIR_DATA *oddatafound)
{
	PropertiesFindData=FindData;
	PropertiesOddata=oddatafound;
	DialogBox(hinst,MAKEINTRESOURCE(IDD_PROPERTIES),GetActiveWindow(),PropertiesDlgProc);	
}

int WebDavCreateDirectory(void* serverid,TCHAR* Path)
{
	TCHAR msgbuf[3*MAX_PATH];
	ShowStatus(TEXT("================="));
 	_tcscpy(msgbuf,TEXT("Create dir: "));
	_tcslcat(msgbuf,Path,countof(msgbuf)-1);
	ShowStatus(msgbuf);
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;

	int retval=DAV_FAILED;

	TCHAR thename[3*MAX_PATH];
	_tcslcpy(thename,Path,countof(thename)-1);
	if (NULL==tcsFormValidUrl(thename,countof(thename)-1,ConnectSettings->interpreturlasutf8)) {
		ShowStatus(TEXT("Invalid Unicode name!"));
		return DAV_FAILED;
	}
	if (ConnectSettings->apacheDirWithSlash) {
		TCHAR* p=thename+_tcslen(thename)-1;
		if (p[0]!='/')            // ADD trailing slash!
			_tcslcat(thename,TEXT("/"),countof(thename)-1);
	}

	HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
	CONTEXTBUF cbuf;
	SetupContextBuf(ConnHandle,&cbuf);

	setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);
	HINTERNET HttpHandle;
	HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("MKCOL"),thename,TEXT("HTTP/1.1"),NULL,NULL,
		INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_KEEP_CONNECTION | ConnectSettings->SslFlags,&cbuf);
	if (HttpHandle) {
		TCHAR optionalheaders[512];
		TCHAR* phdr;
		int hdrsz;
		if (ConnectSettings->proxyuser[0]) {
			optionalheaders[0]=0;
			appendproxyauthinfo(optionalheaders,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(optionalheaders)-1);
			phdr=optionalheaders;
			hdrsz=_tcslen(optionalheaders);
		} else {
			phdr=NULL;
			hdrsz=0;
		}

		BOOL bCertTried = FALSE;
retry:		
		int ok=AsyncHttpSendRequest(HttpHandle, phdr, hdrsz, NULL, 0,&cbuf);

		if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
		{
			SetSSLCert(serverid, HttpHandle);
			bCertTried = TRUE;
			goto retry;
		}

		if (ok==ASYNC_OK) {
			int StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
			if ((int)(StatusCode/10)==20)
				retval=DAV_OK;

			if (StatusCode!=204 && StatusCode!=304) { //204= no body
				char buffer[64];
				DWORD dwSize;
				do	{ // clear reply
					ok=AsyncInternetReadFile (HttpHandle, &buffer, countof(buffer)-1, &dwSize,&cbuf);
				} while (dwSize != 0);
			}
		}
		if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
			InternetCloseHandle(HttpHandle);

	}
	CleanupContextBuf(ConnHandle,&cbuf);
	return retval;
}

int WebDavRenameMoveFile(void* serverid,TCHAR* OldName,TCHAR* NewName,BOOL Move, BOOL Overwrite, BOOL isdir)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	BOOL retry;   // for redirects
	int retrycount;
	int retval=DAV_FAILED;
	TCHAR* operation=TEXT("COPY");
	if (Move)
		operation=TEXT("MOVE");

	BOOL TargetWithRelativePath=ConnectSettings->RelativePathUrl;
	BOOL RetryWithRelativePath=false;
	int StatusOnFirstTry=0;
	HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
	do {
		RetryWithRelativePath=false;
		ShowStatus(TEXT("================="));
		TCHAR msgbuf[3*MAX_PATH];
		_tcscpy(msgbuf,operation);
		_tcslcat(msgbuf,TEXT(": "),countof(msgbuf)-1);
		_tcslcat(msgbuf,OldName,countof(msgbuf)-1);
		_tcslcat(msgbuf,TEXT("->"),countof(msgbuf)-1);
		_tcslcat(msgbuf,NewName,countof(msgbuf)-1);
		ShowStatus(msgbuf);

		TCHAR optionalheaders[1024];
		int hdrsz;

		if (!TargetWithRelativePath) {
			_tcscpy(optionalheaders,TEXT("Destination: http"));
			if (ConnectSettings->SslConnect)
				_tcscat(optionalheaders,TEXT("s"));    //https!
			TCHAR thename[3*MAX_PATH];
			_tcslcpy(thename,NewName,countof(thename)-1);
			if (isdir && ConnectSettings->apacheDirWithSlash)
				tcslcatforwardslash(thename,countof(thename)-1);
			if (ConnectSettings->customport &&
				((ConnectSettings->SslConnect && ConnectSettings->customport!=443) ||
				 (!ConnectSettings->SslConnect && ConnectSettings->customport!=80)))
				_tcsprintf(optionalheaders+_tcslen(optionalheaders),TEXT("://%s:%d%s\r\n"),ConnectSettings->server,ConnectSettings->customport,thename);
			else
				_tcsprintf(optionalheaders+_tcslen(optionalheaders),TEXT("://%s%s\r\n"),ConnectSettings->server,thename);
		} else { 	// Change: pass path relative to server root
			_tcscpy(optionalheaders,TEXT("Destination: "));
			_tcslcat(optionalheaders,NewName,countof(optionalheaders)-3);
			if (isdir && ConnectSettings->apacheDirWithSlash)
				tcslcatforwardslash(optionalheaders,countof(optionalheaders)-3);
			_tcslcat(optionalheaders,TEXT("\r\n"),countof(optionalheaders)-1);
		}

		if (NULL==tcsFormValidUrl(optionalheaders+13,countof(optionalheaders)-14,ConnectSettings->interpreturlasutf8)) {
			ShowStatus(TEXT("Invalid source Unicode name!"));
			return DAV_FAILED;
		}
		if (!Overwrite)
			_tcscat(optionalheaders,TEXT("Overwrite: F\r\n"));
		appendproxyauthinfo(optionalheaders,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(optionalheaders)-1);
		hdrsz=_tcslen(optionalheaders);
		setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);

		TCHAR thename[3*MAX_PATH];
		_tcslcpy(thename,OldName,countof(thename)-1);
		if (NULL==tcsFormValidUrl(thename,countof(thename)-1,ConnectSettings->interpreturlasutf8)) {
			ShowStatus(TEXT("Invalid target Unicode name!"));
			return DAV_FAILED;
		}
		if (isdir && ConnectSettings->apacheDirWithSlash)
			tcslcatforwardslash(thename,countof(thename)-1);

		HINTERNET HttpHandle;
		CONTEXTBUF cbuf;
		SetupContextBuf(ConnHandle,&cbuf);
		retrycount=10;
		do {
			retry=false;
			HttpHandle=AsyncHttpOpenRequest(ConnHandle,operation,thename,TEXT("HTTP/1.1"),
				NULL,NULL,
				INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_KEEP_CONNECTION | ConnectSettings->SslFlags,&cbuf);
			if (HttpHandle) {
				int ok=AsyncHttpSendRequest(HttpHandle, optionalheaders, hdrsz, NULL, 0, &cbuf);

				if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED)
				{
					SetSSLCert(serverid, HttpHandle);
					retrycount--;
					continue;
				}

				if (ok==ASYNC_OK) {
					int StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
					if ((int)(StatusCode/10)==20) {
						retval=DAV_OK;
						if (RetryWithRelativePath)
							ConnectSettings->RelativePathUrl=true;
					}
					else if (!Overwrite && StatusCode==412)
						retval=DAV_EXISTS;
					
					if (StatusCode!=204 && StatusCode!=304) { //204= no body
						char buffer[64];
						DWORD dwSize;
						do	{ // clear reply
							ok=AsyncInternetReadFile (HttpHandle, &buffer, sizeof(buffer), &dwSize,&cbuf);
						} while (ok==ASYNC_OK && dwSize != 0);
					}
					// fix to some Apache versions
					if (StatusCode==301 || StatusCode==302) {  // moved permanently or temporarily!
						TCHAR thename2[3*MAX_PATH];
						DWORD len=countof(thename2)-1;
						DWORD idx=0;
						if (HttpQueryInfo(HttpHandle, HTTP_QUERY_LOCATION, thename2, &len, &idx)) {
							TCHAR* p=_tcschr(thename2+8,'/');
							if (p) {
								_tcscpy(thename,p);
								ShowStatus(TEXT("Redirecting to new URL:"));
								ShowStatus(thename);
								retry=true;
							}
						}				
					} else if (StatusOnFirstTry==0)
						StatusOnFirstTry=StatusCode;
					// Note: Barracudadrive returns error 502 "Bad Gateway!"
					if ((StatusCode>=400 && StatusCode<=499 || StatusCode==502) && StatusCode!=412 /* target exists */) {
						if (!ConnectSettings->RelativePathUrl && !TargetWithRelativePath) {
							TargetWithRelativePath=true;
							RetryWithRelativePath=true;
							retry=false;
						} else if (TargetWithRelativePath && StatusOnFirstTry==412)
							StatusCode=412;
					}
				}
				if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
					InternetCloseHandle(HttpHandle);

			}
		} while (retry && retrycount-->0);
		CleanupContextBuf(ConnHandle,&cbuf);
	} while (RetryWithRelativePath);
	return retval;
}

#define DATABUFSIZE 32768

int WebDavDownloadFile(void* serverid,TCHAR* RemoteName,TCHAR* LocalName,BOOL alwaysoverwrite,
					   _int64 filesize,FILETIME *ft,BOOL Resume)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	_int64 sizeloaded=0;

	TCHAR msgbuf[3*MAX_PATH];
	HANDLE houtfile;

	ShowStatus(TEXT("================="));
	_tcscpy(msgbuf,TEXT("File receive: "));
	_tcslcat(msgbuf,RemoteName,countof(msgbuf)-1);
	ShowStatus(msgbuf);

	TCHAR thename[3*MAX_PATH];
	_tcslcpy(thename,RemoteName,countof(thename)-1);
	if (NULL==tcsFormValidUrl(thename,countof(thename)-1,ConnectSettings->interpreturlasutf8)) {
		ShowStatus(TEXT("Invalid Unicode name!"));
		return DAV_FAILED;
	}

	if (Resume) {
		houtfile=CreateFileT(LocalName,GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
			OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
		if (houtfile!=INVALID_HANDLE_VALUE) {
			DWORD szh;
			sizeloaded=GetFileSize(houtfile,&szh);
			sizeloaded|=((_int64)szh)<<32;
			SetFilePointer(houtfile,0,NULL,SEEK_END);

			if (filesize<=sizeloaded) {  // local file is larger!
				CloseHandle(houtfile);
				return filesize==sizeloaded ? DAV_OK : DAV_WRITEFAILED;
			}
		}
	} else {
		houtfile=CreateFileT(LocalName,GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
			alwaysoverwrite ? CREATE_ALWAYS : CREATE_NEW,
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	}
	if (houtfile==INVALID_HANDLE_VALUE) {
		int err=GetLastError();
		switch (err) {
		case ERROR_ACCESS_DENIED:return DAV_EXISTS;
		case ERROR_SHARING_VIOLATION:return DAV_EXISTS;
		default:return DAV_WRITEFAILED;
		}
	}
	int retval=DAV_READFAILED;
	BOOL connectOK=false;

	HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
	HINTERNET HttpHandle;
	CONTEXTBUF cbuf;
	SetupContextBuf(ConnHandle,&cbuf);

	setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);

	HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("GET"),thename,TEXT("HTTP/1.0"),NULL,NULL,
		INTERNET_FLAG_KEEP_CONNECTION | INTERNET_FLAG_NO_CACHE_WRITE | ConnectSettings->SslFlags,&cbuf);
	if (HttpHandle) {
		TCHAR optionalheaders[1024],nrbuf1[64],nrbuf2[64];
		TCHAR* phdr;
		int hdrsz;
		if (sizeloaded || ConnectSettings->proxyuser[0]) {
			if (sizeloaded) {
				_tcscpy(optionalheaders,TEXT("Range:bytes="));
#ifdef UNICODE
				_i64tow(sizeloaded,nrbuf1,10);
				_i64tow(filesize-1,nrbuf2,10);  // fixed: must be 1 less than size!
#else
				_i64toa(sizeloaded,nrbuf1,10);
				_i64toa(filesize-1,nrbuf2,10);
#endif
				_tcslcat(optionalheaders,nrbuf1,countof(optionalheaders)-1);
				_tcslcat(optionalheaders,TEXT("-"),countof(optionalheaders)-1);
				_tcslcat(optionalheaders,nrbuf2,countof(optionalheaders)-1);
				_tcslcat(optionalheaders,TEXT("\r\n"),countof(optionalheaders)-1);
				  // bug in gmx media center: bytes=1000- returns entire file!
			} else
				optionalheaders[0]=0;
			appendproxyauthinfo(optionalheaders,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(optionalheaders)-1);
			phdr=optionalheaders;
			hdrsz=_tcslen(optionalheaders);
		} else {
			phdr=NULL;
			hdrsz=0;
		}
		
		BOOL bCertTried = FALSE;
retry:		
		int ok=AsyncHttpSendRequest(HttpHandle,phdr,hdrsz,NULL,0,&cbuf);

		if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
		{
			SetSSLCert(serverid, HttpHandle);
			bCertTried = TRUE;
			goto retry;
		}

		if (ok==ASYNC_OK) {
			char* pbuffer=NULL;
			DWORD bytesread,byteswritten;

			pbuffer=(char*)malloc(DATABUFSIZE);
			if (pbuffer) {
				retval=DAV_OK;
				// Make sure we don't get an error document back!!!
				int StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,true);

				if (StatusCode==-1) {
					TCHAR errbuf[1024];
					LoadString(hinst, IDS_WININET_BUG_CHUNKED, errbuf, countof(errbuf));

					// tried with larger buffer than file size, failed too!
					RequestProc(PluginNumber,RT_MsgOK,TEXT("Error!"),errbuf,NULL,0);
					retval=DAV_READFAILED;
				} if (sizeloaded && StatusCode!=206) {
					LogProc(PluginNumber,MSGTYPE_DETAILS,TEXT("Server does not support resume!"));
					retval=DAV_READFAILED;
				} else if ((int)(StatusCode/100)!=2) {  // error -> get error message
					do	{
						ok=AsyncInternetReadFile (HttpHandle, pbuffer, DATABUFSIZE, &bytesread,&cbuf);
					} while (ok==ASYNC_OK && bytesread != 0);
					retval=DAV_READFAILED;
				} else {   // all OK -> get data!
					connectOK=true;
					do {
						cbuf.lastpercent=GetPercent(sizeloaded,filesize);
						ok=AsyncInternetReadFile(HttpHandle,pbuffer,DATABUFSIZE,&bytesread,&cbuf);
						if (ok==ASYNC_OK && bytesread>0) {
							if (!WriteFile(houtfile,pbuffer,bytesread,&byteswritten,NULL)) {
								retval=DAV_WRITEFAILED;
								break;
							}
							sizeloaded+=byteswritten;
							if (UpdatePercentBar(GetPercent(sizeloaded,filesize))) {
								retval=DAV_ABORT;
								break;
							}
						}
					} while (ok==ASYNC_OK && bytesread>0);
				}
				free(pbuffer);
			}
		}
		if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
			InternetCloseHandle(HttpHandle);

	}
	CleanupContextBuf(ConnHandle,&cbuf);
	SetFileTime(houtfile,NULL,NULL,ft);
	CloseHandle(houtfile);
	if (!connectOK && sizeloaded==0)
		DeleteFile(LocalName);

	return retval;
}

void WebDavSetOverwriteFlag()
{
}

typedef struct {
	HINTERNET HttpHandle;
} threaddata,*threaddataptr;

DWORD WINAPI AbortThreadProc(LPVOID lpParameter)
{
	threaddataptr tdp=(threaddataptr)lpParameter;
	HINTERNET hdl;

	Sleep(100);
	if (tdp->HttpHandle) {  // maybe HttpEndRequest was successful?
		hdl=tdp->HttpHandle;
		tdp->HttpHandle=NULL;

		InternetCloseHandle(hdl);
		DWORD starttime=GetTickCount();
		do {
			MSG msg;
			while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) 
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} while (GetCurrentTime()-starttime<5000);
	}
	return 0;
}

BOOL WebDavDeleteBeforeUpload(void* serverid)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	return ConnectSettings->deletebeforeupload;
}

int WebDavUploadFile(void* serverid,TCHAR* LocalName,TCHAR* RemoteName,DWORD resumeat)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	int retval;
	FILETIME lastwritetime;
	TCHAR msgbuf[3*MAX_PATH];
	ShowStatus(TEXT("================="));
	_tcscpy(msgbuf,TEXT("File send: "));
	_tcslcat(msgbuf,RemoteName,countof(msgbuf)-1);
	ShowStatus(msgbuf);
	retval=DAV_WRITEFAILED;
	lastwritetime.dwHighDateTime=-1;
	lastwritetime.dwLowDateTime=-1;
	char timestamp[128];
	TCHAR thename[3*MAX_PATH];
	timestamp[0]=0;
	_tcslcpy(thename,RemoteName,countof(thename)-1);
	if (NULL==tcsFormValidUrl(thename,countof(thename)-1,ConnectSettings->interpreturlasutf8)) {
		ShowStatus(TEXT("Invalid Unicode name!"));
		return DAV_WRITEFAILED;
	}

	// Note: HTTP PUT does NOT currently support Content-Range!
	if (resumeat)
		return DAV_WRITEFAILED;

	HANDLE houtfile=CreateFileT(LocalName,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);

	if (houtfile!=INVALID_HANDLE_VALUE) {
		DWORD szh;
		_int64 sizesent=0;
		_int64 filesize=GetFileSize(houtfile,&szh);
		GetFileTime(houtfile,NULL,NULL,&lastwritetime);
		filesize|=((_int64)szh)<<32;

		HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
		HINTERNET HttpHandle;
		HCERTSTORE hCertStore = NULL;
		CONTEXTBUF cbuf;
		SetupContextBuf(ConnHandle,&cbuf);
		setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);

		HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("PUT"),thename,TEXT("HTTP/1.1"),NULL,NULL,
			INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_KEEP_CONNECTION | ConnectSettings->SslFlags,&cbuf);
		if (HttpHandle) {
			INTERNET_BUFFERS BufferIn;
			int StatusCode;
			int ok;
			char buffer[8192];
			DWORD dwSize;
			TCHAR additionalheader[512];
			_TCHAR* pext=_tcsrchr(thename,'.');

			char ext[128];
			if (pext) {
#ifdef UNICODE
				WideCharToMultiByte(CP_ACP,0,pext+1,-1,ext,countof(ext)-1,NULL,NULL);
#else
				strlcpy(ext,pext+1,countof(ext)-1);
#endif
			} else
				strcpy(ext,"no extension");
			_tcscpy(additionalheader,TEXT("Content-type: "));
			switch (GetMimeTypeFromMap(ext,buffer,256)) {
			case 1:
#ifdef UNICODE
				WCHAR wbuf[MAX_PATH];
				MultiByteToWideChar(CP_ACP,0,buffer,-1,additionalheader+_tcslen(additionalheader),countof(additionalheader)-1-_tcslen(additionalheader));
#else
				strlcat(additionalheader,buffer,countof(additionalheader)-1);
#endif
				_tcslcat(additionalheader,_T("\r\n"),countof(additionalheader)-1);
				break;
			case 0:
				_tcslcat(additionalheader,TEXT("application/octet-stream\r\n"),countof(additionalheader)-1);
			}
			appendproxyauthinfo(additionalheader,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(additionalheader)-1);
			HttpAddRequestHeaders(HttpHandle,
				additionalheader,
				-1,HTTP_ADDREQ_FLAG_ADD | HTTP_ADDREQ_FLAG_REPLACE);

			if (ConnectSettings->usemultistepuploadmethod) {
				// First step: Upload 1 byte file -> causes authentication start!
				// 0 bytes or HttpSendRequest do NOT work!
				ShowStatus(TEXT("First upload step: Send 1 byte file for authentication"));

				strcpy(buffer,"1");			
				
				BOOL bCertTried = FALSE;
retry:		
				ok=AsyncHttpSendRequest(HttpHandle, NULL, 0, buffer, strlen(buffer),&cbuf);

				if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
				{
					SetSSLCert(serverid, HttpHandle);
					bCertTried = TRUE;
					goto retry;
				}

				StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
				if (StatusCode!=204 && StatusCode!=304) { //204= no body
					do	{
						char buffer2[64];
						ok=AsyncInternetReadFile (HttpHandle, buffer2, sizeof(buffer2), &dwSize,&cbuf);
					} while (ok==ASYNC_OK && dwSize != 0);
				}
			} else
				StatusCode=400;
			if (!((StatusCode>=403 && StatusCode<=406) || StatusCode>=408 || (StatusCode/100)==5)) { // check that it isn't forbidden

				// Second step: Upload 2 byte file -> causes authentication!
				// 0 bytes or HttpSendRequestEx do NOT work!
				if (ConnectSettings->usemultistepuploadmethod && ConnectSettings->use3stepuploadmethod) {
					ShowStatus(TEXT("Second upload step:  Send 2 byte file for authentication"));

					strcpy(buffer,"12");
					memset(&BufferIn,0,sizeof(BufferIn));
					BufferIn.dwStructSize=sizeof(BufferIn);
					BufferIn.dwBufferTotal=strlen(buffer);

					// Important: Replace content length header!
					wsprintf(additionalheader,TEXT("Content-Length: %d\r\n"),strlen(buffer));
					appendproxyauthinfo(additionalheader,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(additionalheader)-1);

					HttpAddRequestHeaders(HttpHandle,additionalheader,-1,HTTP_ADDREQ_FLAG_ADD | HTTP_ADDREQ_FLAG_REPLACE);

					BOOL bCertTried = FALSE;
retry1:		
					ok=AsyncHttpSendRequestEx(HttpHandle, &BufferIn, 0, HSR_INITIATE, &cbuf);

					if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
					{
						SetSSLCert(serverid, HttpHandle);
						bCertTried = TRUE;
						goto retry1;
					}

					if (ok==ASYNC_OK) {
						DWORD byteswritten,dwSize;
						ok=AsyncInternetWriteFile(HttpHandle,&buffer,strlen(buffer),&byteswritten,&cbuf);
						if (ok==ASYNC_OK)
							ok=AsyncHttpEndRequest(HttpHandle, 0, 0, &cbuf);
						if (ok==ASYNC_OK) {
							StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
							if (StatusCode!=204 && StatusCode!=304) { //204= no body
								do	{ // clear reply
									ok=AsyncInternetReadFile (HttpHandle, &buffer, sizeof(buffer), &dwSize,&cbuf);
								} while (ok==ASYNC_OK && dwSize != 0);
							}
						}
					}
				}
				// Third step: now send the actual file!
				ShowStatus(TEXT("Last upload step: Send actual file"));

				memset(&BufferIn,0,sizeof(BufferIn));
				BufferIn.dwStructSize=sizeof(BufferIn);
				BufferIn.dwBufferTotal=(DWORD)filesize;
				_tcscpy(additionalheader,TEXT("Content-Length: "));
				_i64tot(filesize,additionalheader+_tcslen(additionalheader),10);
				_tcscat(additionalheader,TEXT("\r\n"));
				if (!CreateHtmlDateString(&lastwritetime,timestamp))
					timestamp[0]=0;
				if (timestamp[0]) {
					_tcscat(additionalheader,TEXT("X-Last-Modified: "));
#ifdef UNICODE
					int L=wcslen(additionalheader);
					MultiByteToWideChar(CP_ACP,0,timestamp,-1,additionalheader+L,countof(additionalheader)-L-1);
#else
					_tcscat(additionalheader,timestamp);
#endif
					_tcscat(additionalheader,TEXT("\r\n"));
				}
				appendproxyauthinfo(additionalheader,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(additionalheader)-1);

				HttpAddRequestHeaders(HttpHandle,additionalheader,-1,HTTP_ADDREQ_FLAG_ADD | HTTP_ADDREQ_FLAG_REPLACE);

				HANDLE hAbortThread=NULL;

				BOOL bCertTried = FALSE;
retry2:
				if (filesize>0xFFFFFFFF)
					ok=AsyncHttpSendRequestEx(HttpHandle, NULL, 0, HSR_INITIATE, &cbuf); // don't overwrite the Content-Length header!
				else
					ok=AsyncHttpSendRequestEx(HttpHandle, &BufferIn, 0, HSR_INITIATE, &cbuf);

				if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
				{
					SetSSLCert(serverid, HttpHandle);
					bCertTried = TRUE;
					goto retry2;
				}

				if (ok==ASYNC_OK) {
					DWORD bytesread,byteswritten;
					do {
						if (ReadFile(houtfile,&buffer,sizeof(buffer),&bytesread,NULL) && bytesread>0) {
							cbuf.lastpercent=GetPercent(sizesent,filesize);
							ok=AsyncInternetWriteFile(HttpHandle,&buffer,bytesread,&byteswritten,&cbuf);
							sizesent+=byteswritten;
							if (UpdatePercentBar(GetPercent(sizesent,filesize)) && !hAbortThread) {
								retval=DAV_ABORT;
								//break - in separate thread!;

								DWORD pThreadId;
								threaddata td;
								td.HttpHandle=HttpHandle;

								hAbortThread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&AbortThreadProc,
									&td,0,&pThreadId);
								Sleep(1000);
							}
						}
					} while (ok==ASYNC_OK && bytesread>0);

					if (hAbortThread)
						CloseHandle(hAbortThread);

					if (1) { //ok==ASYNC_OK && retval!=DAV_ABORT) {
						ok=AsyncHttpEndRequest(HttpHandle, 0, 0, &cbuf);
						if (ok==ASYNC_OK) {
							StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
							if ((int)(StatusCode/10)==20)
								retval=DAV_OK;
							if (StatusCode!=204 && StatusCode!=304) { //204= no body
								DWORD dwSize;
								do	{
									char buffer2[64];
									ok=AsyncInternetReadFile (HttpHandle, &buffer2, sizeof(buffer2), &dwSize,&cbuf);
								} while (ok==ASYNC_OK && dwSize != 0);
							}
						}
					}
				}
			}
			if (HttpHandle && ok!=ASYNC_CANCELED_HANDLE_DELETED)
				InternetCloseHandle(HttpHandle);
			if (ok==ASYNC_OK && lastwritetime.dwHighDateTime!=-1 && ConnectSettings->propPatchAllowed && timestamp[0]) {
				// Set timestamp!
				HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("PROPPATCH"),thename,TEXT("HTTP/1.1"),NULL,NULL,
					INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_KEEP_CONNECTION | ConnectSettings->SslFlags,&cbuf);
				if (HttpHandle) {
					strlcpy(buffer,"<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:Z=\"urn:schemas-microsoft-com:\"><D:set><D:prop><D:getlastmodified>",sizeof(buffer)-1);
					strlcat(buffer,timestamp,sizeof(buffer)-1);
					strlcat(buffer,"</D:getlastmodified><Z:Win32LastModifiedTime>",sizeof(buffer)-1);
					strlcat(buffer,timestamp,sizeof(buffer)-1);
					strlcat(buffer,"</Z:Win32LastModifiedTime></D:prop></D:set></D:propertyupdate>",sizeof(buffer)-1);
					memset(&BufferIn,0,sizeof(BufferIn));
					BufferIn.dwStructSize=sizeof(BufferIn);
					BufferIn.dwBufferTotal=strlen(buffer);
					// Important: Replace content length header!
					wsprintf(additionalheader,TEXT("Content-Type: text/xml; charset=\"utf-8\"\r\nContent-Length: %d\r\n"),strlen(buffer));
					appendproxyauthinfo(additionalheader,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(additionalheader)-1);
					HttpAddRequestHeaders(HttpHandle,additionalheader,-1,HTTP_ADDREQ_FLAG_ADD | HTTP_ADDREQ_FLAG_REPLACE);
					BOOL bCertTried = FALSE;
					int ok2;
					BOOL retrying=TRUE;
					while (retrying) {
						retrying=FALSE;
						ok2=AsyncHttpSendRequestEx(HttpHandle, &BufferIn, 0, HSR_INITIATE, &cbuf);
						if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
						{
							SetSSLCert(serverid, HttpHandle);
							bCertTried = TRUE;
							retrying=TRUE;
						}
					}
					if (ok2==ASYNC_OK) {
						DWORD byteswritten,dwSize;
						ok2=AsyncInternetWriteFile(HttpHandle,&buffer,strlen(buffer),&byteswritten,&cbuf);
						if (ok2==ASYNC_OK)
							ok2=AsyncHttpEndRequest(HttpHandle, 0, 0, &cbuf);
						if (ok2==ASYNC_OK) {
							StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
							if (StatusCode!=204 && StatusCode!=304) { //204= no body
								do	{ // clear reply
									ok2=AsyncInternetReadFile (HttpHandle, &buffer, sizeof(buffer), &dwSize,&cbuf);
								} while (ok2==ASYNC_OK && dwSize != 0);
							}
							if (StatusCode==501) // unsupported
								ConnectSettings->propPatchAllowed=false;
						}
					}
					if (HttpHandle && ok!=ASYNC_CANCELED_HANDLE_DELETED)
						InternetCloseHandle(HttpHandle);
				}
			}
		}
		CleanupContextBuf(ConnHandle,&cbuf);
		CloseHandle(houtfile);
	} else
		retval=DAV_READFAILED;
	return retval;
}

int WebDavDeleteFile(void* serverid,TCHAR* RemoteName,BOOL isdir)
{
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	TCHAR msgbuf[3*MAX_PATH];
	BOOL retry;   // for redirects
	int retrycount;
	ShowStatus(TEXT("================="));
 	_tcscpy(msgbuf,TEXT("File delete: "));
	_tcslcat(msgbuf,RemoteName,countof(msgbuf)-1);
	ShowStatus(msgbuf);

	TCHAR thename[3*MAX_PATH];

	_tcslcpy(thename,RemoteName,countof(thename)-1);
	if (NULL==tcsFormValidUrl(thename,countof(thename)-1,ConnectSettings->interpreturlasutf8)) {
		ShowStatus(TEXT("Invalid Unicode name!"));
		return DAV_WRITEFAILED;
	}
	if (isdir && ConnectSettings->apacheDirWithSlash)
		tcslcatforwardslash(thename,countof(thename)-1);

	HINTERNET ConnHandle=GetCachedConnection(ConnectSettings);
	int retval=DAV_FAILED;
	CONTEXTBUF cbuf;
	SetupContextBuf(ConnHandle,&cbuf);
	HINTERNET HttpHandle;
	setproxyauthinfo(ConnHandle,ConnectSettings->proxyuser,ConnectSettings->proxypassword);
	retrycount=10;
	do {
		retry=false;
		HttpHandle=AsyncHttpOpenRequest(ConnHandle,TEXT("DELETE"),thename,TEXT("HTTP/1.1"),NULL,NULL,
			INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_KEEP_CONNECTION | ConnectSettings->SslFlags,&cbuf);
		if (HttpHandle) {
			TCHAR optionalheaders[512];
			TCHAR* phdr;
			int hdrsz;
			if (ConnectSettings->proxyuser[0]) {
				optionalheaders[0]=0;
				appendproxyauthinfo(optionalheaders,ConnectSettings->proxyuser,ConnectSettings->proxypassword,countof(optionalheaders)-1);
				phdr=optionalheaders;
				hdrsz=_tcslen(optionalheaders);
			} else {
				phdr=NULL;
				hdrsz=0;
			}
			
			BOOL bCertTried = FALSE;
retry:
			int ok=AsyncHttpSendRequest(HttpHandle, phdr, hdrsz, NULL, 0,&cbuf);

			if (cbuf.dwError == ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED && !bCertTried)
			{
				SetSSLCert(serverid, HttpHandle);
				bCertTried = TRUE;
				goto retry;
			}

			if (ok==ASYNC_OK) {
				int StatusCode=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog,false);
				if ((int)(StatusCode/10)==20)
					retval=DAV_OK;
				if (StatusCode!=204 && StatusCode!=304) { //204= no body
					char buffer[64];
					DWORD dwSize;
					do    { // clear reply
						ok=AsyncInternetReadFile(HttpHandle, &buffer, sizeof(buffer), &dwSize,&cbuf);
					} while (ok==ASYNC_OK && dwSize != 0);
				}
				// fix to some Apache versions
				if (StatusCode==301 || StatusCode==302) {  // moved permanently or temporarily!
					TCHAR thename2[3*MAX_PATH];
					DWORD len=countof(thename2)-1;
					DWORD idx=0;
					if (HttpQueryInfo(HttpHandle, HTTP_QUERY_LOCATION, thename2, &len, &idx)) {
						TCHAR* p=_tcschr(thename2+8,'/');
						if (p) {
							_tcscpy(thename,p);
							ShowStatus(TEXT("Redirecting to new URL:"));
							ShowStatus(thename);
							retry=true;
						}
					}				
				}
			}
			if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
				InternetCloseHandle(HttpHandle);

		}
	} while (retry && retrycount-->0);
	CleanupContextBuf(ConnHandle,&cbuf);
	return retval;
}

int WebDavSetAttr(void* serverid,TCHAR* RemoteName,int NewAttr)
{
	ShowStatus(TEXT("Set file attributes not implemented, sorry"));
	return FS_FILE_NOTSUPPORTED;
}

/*
          rfc1123-date = wkday "," SP date1 SP time SP "GMT"
          date1        = 2DIGIT SP month SP 4DIGIT
                         ; day month year (e.g., 02 Jun 1982)

          time         = 2DIGIT ":" 2DIGIT ":" 2DIGIT
                         ; 00:00:00 - 23:59:59

          wkday        = "Mon" | "Tue" | "Wed"
                       | "Thu" | "Fri" | "Sat" | "Sun"

          month        = "Jan" | "Feb" | "Mar" | "Apr"
                       | "May" | "Jun" | "Jul" | "Aug"
                       | "Sep" | "Oct" | "Nov" | "Dec"
*/

int WebDavSetDateTime(void* serverid,TCHAR* RemoteName,FILETIME *LastWriteTime)
{
	ShowStatus(TEXT("Set Date/Time not implemented, sorry"));
	return FS_FILE_NOTSUPPORTED;
	
/*	pConnectSettings ConnectSettings=(pConnectSettings)serverid;
	char thename[MAX_PATH];
	strlcpy(thename,RemoteName,sizeof(thename)-1);
	FormValidUrl(thename,sizeof(thename)-1,ConnectSettings->interpreturlasutf8);

	int status=400;
	HINTERNET HttpHandle;
	CONTEXTBUF cbuf;
	SetupContextBuf(ConnHandle,&cbuf);

	HttpHandle=AsyncHttpOpenRequest(ConnectSettings->ConnHandle,"PROPPATCH",thename,"HTTP/1.1",NULL,NULL,
		INTERNET_FLAG_KEEP_CONNECTION | ConnectSettings->SslFlags,&cbuf);
	if (HttpHandle) {
		char xmlbodypadded[256],optionalheaders[256];
		strcpy(xmlbodypadded,datesetxmlbody);
		int l=strlen(xmlbodypadded);  // due to an error in wininet, the length must be >150!
		while (l<160) {
			strcat(xmlbodypadded,"\r\n");
			l+=2;
		}
		wsprintf(optionalheaders,"Content-type: text/xml; charset=\"utf-8\"\r\nContent-Length: %d\r\n",strlen(xmlbodypadded));

		int ok=AsyncHttpSendRequest(HttpHandle,optionalheaders,strlen(optionalheaders),xmlbodypadded,strlen(xmlbodypadded),&cbuf);
		if (ok==ASYNC_OK) {
			status=GetStatusAndShowError(HttpHandle,ConnectSettings->detailedlog);
			if (status!=204 && status!=304) { //204= no body
				char buffer[8192];
				DWORD bytesread;
				do {
					ok=AsyncInternetReadFile(HttpHandle,&buffer,sizeof(buffer),&bytesread,&cbuf);
				} while (ok==ASYNC_OK && bytesread>0);
			}
		}
		if (ok!=ASYNC_CANCELED_HANDLE_DELETED)
			InternetCloseHandle(HttpHandle);

	}
	CleanupContextBuf(ConnHandle,&cbuf);
	return int(status/100)==2 ? FS_FILE_OK : FS_FILE_NOTSUPPORTED;
	*/
}

//*******************************************************************************

// catches callbacks coming too late!
void __stdcall DummyCallback(HINTERNET hInternet,DWORD dwContext,DWORD dwInternetStatus,LPVOID lpStatusInfo,DWORD dwStatusInfoLen)
{
	MessageBeep(0);
}

void __stdcall InternetCallback(HINTERNET hInternet,DWORD dwContext,DWORD dwInternetStatus,LPVOID lpStatusInfo,DWORD dwStatusInfoLen)
{
	INTERNET_ASYNC_RESULT *pRes = (INTERNET_ASYNC_RESULT *)lpStatusInfo;
	CONTEXTBUF* cbuf=(CONTEXTBUF*)dwContext;

	switch(dwInternetStatus) {
		case INTERNET_STATUS_HANDLE_CREATED:
		{
			cbuf->hCreatedRequest = (HINTERNET)pRes->dwResult;
			cbuf->dwError=pRes->dwError;
			SetEvent(cbuf->hHandleCreatedEvent);
			break;
		}
		case INTERNET_STATUS_REQUEST_COMPLETE:
		{
			cbuf->dwError=pRes->dwError;
			SetEvent(cbuf->hRequestCompleteEvent);
			break;
		}
	}
}

void SetSSLCert(void* serverid, HINTERNET hRequest)
{
	//MessageBox(GetActiveWindow(),TEXT("Test 1"),TEXT("Call to SetSSLCert!"),0);
	pConnectSettings ConnectSettings=(pConnectSettings)serverid;

	if (ConnectSettings->SslCertIssuer[0]==0)
		return;


	if (ConnectSettings->SslConnect &&
		_tcslen(ConnectSettings->SslCertIssuer) > 0 &&
		strlen(ConnectSettings->SslCertSerial) > 0)
	{
		// client certificate was configured. So find the cert in the store and use it for this connection
		if (!SslCertStore)
			SslCertStore = CertOpenSystemStore(NULL, SSL_CLIENT_CERTIFICATE_STORE);

		if (SslCertStore)
		{
			// CertGetNameString here leads to unresolved external symbol although the required h file and lib 
			// is included... Therefore use LoadLibrary/GetProcAddress
			HMODULE hCryptDll = LoadLibrary(TEXT("Crypt32.dll"));

			if (hCryptDll)
			{
				typedef DWORD (WINAPI* pfnCertGetNameString)(PCCERT_CONTEXT pCertContext, DWORD dwType, DWORD dwFlags,
															 void *pvTypePara, TCHAR* pszNameString, DWORD cchNameString);
#ifdef UNICODE
				pfnCertGetNameString pfnCertGetNameStringProc = reinterpret_cast<pfnCertGetNameString>(GetProcAddress(hCryptDll, "CertGetNameStringW"));
#else
				pfnCertGetNameString pfnCertGetNameStringProc = reinterpret_cast<pfnCertGetNameString>(GetProcAddress(hCryptDll, "CertGetNameStringA"));
#endif
				if (pfnCertGetNameStringProc != NULL)
				{
					PCCERT_CONTEXT   pCertContext = NULL;
					TCHAR szNameString[MAX_PATH + 1] = TEXT("");


					while ((pCertContext = CertEnumCertificatesInStore(SslCertStore, pCertContext)))
					{
						DWORD dwRet = pfnCertGetNameStringProc(pCertContext, CERT_NAME_SIMPLE_DISPLAY_TYPE,
															   CERT_NAME_DISABLE_IE4_UTF8_FLAG,
															   NULL, szNameString, MAX_PATH);
						
						if (dwRet)
						{
							PCERT_INFO pCertInfo = pCertContext->pCertInfo;

							if (pCertInfo != NULL)
							{
								// Get the serial number in order to search for the cert when connecting...
								CRYPT_INTEGER_BLOB clbSerial = pCertInfo->SerialNumber;

								unsigned int iOut = 0;
								unsigned char* szB64 = base64_encode((const char*) clbSerial.pbData, clbSerial.cbData, &iOut);

								if (szB64 != NULL)
								{
									if (iOut > 0)
									{
										if (_tcsicmp(ConnectSettings->SslCertIssuer, szNameString) == 0)
										{
											if (strnicmp(ConnectSettings->SslCertSerial, (const char*) szB64, iOut) == 0)
											{
												free(szB64);
												szB64 = NULL;

												if (InternetSetOption(hRequest, INTERNET_OPTION_CLIENT_CERT_CONTEXT,
													                  (void*) pCertContext, sizeof(CERT_CONTEXT)))
												{
													// show the cert info...
													TCHAR connbuf[MAX_PATH];
													_tcsprintf(connbuf,TEXT("Re-Sending request using client certificate: %s"), ConnectSettings->SslCertIssuer);
													LogProc(PluginNumber,MSGTYPE_DETAILS,connbuf);
												}
												else
													ShowDetailedError(TEXT("InternetSetOption failed using client certificate: "),GetLastError());

												CertFreeCertificateContext(pCertContext);

												break;
											}
										}
									}
									
									free(szB64);
									szB64 = NULL;
								}
							}
						}
					}
				}

				FreeLibrary(hCryptDll);
			}
		}
	}
}

int MimeMapLoaded=0;
std::map<std::string,std::string> MimeMap;

void AddSingleExtMimePair(char* ext,char* mime)
{
	MimeMap.insert(std::pair<std::string,std::string>(ext,mime));
}

bool AddSingleMimeType(char* pstart)
{
	char* p1=pstart;
	while (p1[0]) {
		if (p1[0]==9)
			p1[0]=' ';
		p1++;
	}
	p1=strchr(pstart,' ');
	if (!p1)
		return false;
	p1[0]=0;
	p1++;
	while (p1[0]==' ')
		p1++;
	// multiple extensions, separated by a space:
	bool endreached=p1[0]==0;
	while (!endreached) {
		char* p2=p1;
		while (p2[0]!=' ' && p2[0]!=0)
			p2++;
		if (p2[0]==0)
			endreached=true;
		else
			p2[0]=0;
		strlwr(p1);
		AddSingleExtMimePair(p1,pstart);
		while (p2[0]==' ')
			p2++;
		p1=p2+1;
	}
	return true;
}

bool LoadMimeTypes()
{
	if (MimeMapLoaded)
		return MimeMapLoaded==1;

	MimeMapLoaded=-1;
	TCHAR modulename[MAX_PATH];
	modulename[0]=0;
	GetModuleFileName(hinst,modulename,countof(modulename)-11);
	if (modulename[0]==0)
		return false;
	TCHAR* p=_tcsrchr(modulename,'\\');
	if (!p)
		return false;
	p++;
	_tcscpy(p,_T("mime.types"));
	HANDLE tempfile=CreateFile(modulename,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	if (tempfile!=INVALID_HANDLE_VALUE) {
		MimeMapLoaded=1;
		DWORD read;
		DWORD size=GetFileSize(tempfile,NULL)+1;
		char* mimebuf=(char*)malloc(size);
		if (ReadFile(tempfile,mimebuf,size-1,&read,NULL) && read>0) {
			mimebuf[read]=0;
			char* pstart=mimebuf;
			bool endreached=false;
			while (pstart[0]==0x0D || pstart[0]==0x0A)
				pstart++;
			while (pstart[0]) {
				char* pend=strchr(pstart,0xA);
				char* pend2=strchr(pstart,0xD);
				if (pend==NULL || (pend2!=NULL && pend2<pend))
					pend=pend2;
				if (pend==NULL) {
					pend=pstart+strlen(pstart);
					endreached=true;
				}
				pend[0]=0;
				while (pstart[0]==' ' || pstart[0]==9)
					pstart++;
				if (pstart[0]!='#')
					AddSingleMimeType(pstart);
				pstart=pend+1;
				while (pstart[0]==0x0D || pstart[0]==0x0A)
					pstart++;
				if (endreached)
					break;
			}
			free(mimebuf);
		}
		CloseHandle(tempfile);
		return true;
	}
	return false;
}


int GetMimeTypeFromMap(char* ext,char* mime,int maxlen) {
	if (!LoadMimeTypes())
		return -1;    // no file -> don't append MIME type

	char lwrext[128];
	strlcpy(lwrext,ext,countof(lwrext)-1);
	strlwr(lwrext);
	std::map<std::string,std::string>::iterator it = MimeMap.find(lwrext);
	if(it != MimeMap.end())
	{
		strlcpy(mime,it->second.c_str(),maxlen);
		return 1;
	}
	mime[0]=0;
	return 0;
}

