// some code from:
// http://www.rohitab.com/discuss/topic/34389-directshow-webcam-capture-class-c/

#include <windows.h>
#include "SimpleWebCam.h"

#define BITS_PER_PIXEL 24

const GUID FAR IID_ISampleGrabberCB={
	0x0579154A,0x2B53,0x4994,0xB0,0xD0,0xE7,0x73,0x14,0x8E,0xFF,0x85};
const GUID FAR CLSID_CaptureGraphBuilder2={
	0xBF87B6E1,0x8C27,0x11d0,0xB3,0xF0,0x00,0xAA,0x00,0x37,0x61,0xC5};
const GUID FAR IID_ICaptureGraphBuilder2={
	0x93E5A4E0,0x2D50,0x11d2,0xAB,0xFA,0x00,0xA0,0xC9,0xC6,0xE3,0x8D};
const GUID FAR CLSID_NullRenderer={
	0xC1F400A4,0x3F08,0x11d3,0x9F,0x0B,0x00,0x60,0x08,0x03,0x9E,0x37};
const GUID FAR IID_ISampleGrabber={
	0x6B652FFF,0x11FE,0x4fce,0x92,0xAD,0x02,0x66,0xB5,0xD7,0xC7,0x8F};
const GUID FAR CLSID_SampleGrabber={
	0xC1F400A0,0x3F08,0x11d3,0x9F,0x0B,0x00,0x60,0x08,0x03,0x9E,0x37};
const GUID FAR IID_ICreateDevEnum={
	0x29840822,0x5B84,0x11D0,0xBD,0x3B,0x00,0xA0,0xC9,0x11,0xCE,0x86};
const GUID FAR IID_IFilterGraph2={
	0x36b73882,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60};
const GUID FAR IID_IBaseFilter={
	0x56a86895,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70};
const GUID FAR IID_IMediaControl={
	0x56a868b1,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70};
const GUID FAR CLSID_VideoInputDeviceCategory={
	0x860BB310,0x5D01,0x11d0,0xBD,0x3B,0x00,0xA0,0xC9,0x11,0xCE,0x86};
const GUID FAR CLSID_SystemDeviceEnum={
	0x62BE5D10,0x60EB,0x11d0,0xBD,0x3B,0x00,0xA0,0xC9,0x11,0xCE,0x86};
const GUID FAR PIN_CATEGORY_CAPTURE={
	0xfb6c4281,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba};
const GUID FAR PIN_CATEGORY_PREVIEW={
	0xfb6c4282,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba};
const GUID FAR FORMAT_VideoInfo={
	0x05589f80,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a};
const GUID FAR MEDIASUBTYPE_RGB24={
	0xe436eb7d,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70};
const GUID FAR MEDIATYPE_Video={
	0x73646976,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71};
const GUID FAR CLSID_FilterGraph={
	0xe436ebb3,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70};

SimpleWebCam::SimpleWebCam()
{
	CoInitialize(NULL);
	devicecount=0;
	friendlyname[0]=0;
	filtername[0]=0;
	index=-1;
	sourcefilter=0;
	samplegrabberfilter=0;
	nullrenderer=0;
	callbackhandler=new CallbackHandler(this);
	isRunning=false;
	graph=NULL;
	for (int i=0;i<MAX_CAMERAS;i++) {
		devicenames[i]=NULL;
		monikers[i]=NULL;
	}
	GetDeviceList();
}

SimpleWebCam::~SimpleWebCam()
{
	for (int i=0;i<devicecount;i++) {
		if (monikers[i]!=NULL)
			monikers[i]->Release();
		monikers[i]=NULL;
		if (devicenames[i]!=NULL)
			free(devicenames[i]);
		devicenames[i]=NULL;
	}
}

int SimpleWebCam::GetDeviceCount()
{
	return devicecount;
}

HRESULT SimpleWebCam::GetDeviceList()
{
	VARIANT name;
	ICreateDevEnum*		dev_enum;
	IEnumMoniker*		enum_moniker;
	IMoniker*			moniker;
	IPropertyBag*		pbag;

	HRESULT	hr = CoCreateInstance(CLSID_SystemDeviceEnum,NULL,CLSCTX_INPROC_SERVER,IID_ICreateDevEnum,(void**) &dev_enum);
	if (hr < 0) return hr;

	hr = dev_enum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory,&enum_moniker,NULL);
	if (hr < 0) return hr;
	if (hr == S_FALSE) return hr; //no devices found

	devicecount=0;
	while (enum_moniker->Next(1, &moniker,0) == S_OK && devicecount<MAX_CAMERAS)
	{
		hr = moniker->BindToStorage(0, 0, IID_IPropertyBag, (void**) &pbag);
		if (hr >= 0)
		{
			VariantInit(&name);
			//get the description
			hr = pbag->Read(L"Description", &name, 0);
			if (hr < 0) hr = pbag->Read(L"FriendlyName", &name, 0);
			if (hr >= 0)
			{
				monikers[devicecount]=moniker;
				int L=wcslen(name.bstrVal);
				devicenames[devicecount]=(WCHAR*)malloc(100);
				devicenames[devicecount][0]=0;
				wcsncat(devicenames[devicecount],name.bstrVal,L+1);
			}
			VariantClear(&name);
			pbag->Release();
			devicecount++;
		}
	}
	return S_OK;
}

#define COUNTOF(x) (sizeof(x)/sizeof(x[0]))

void SimpleWebCam::CloseCamera()
{
	if (graph==NULL)
		return;
	if (isRunning)
		Stop();
	sourcefilter->Release();
	sourcefilter=NULL;
	samplegrabberfilter->Release();
	samplegrabberfilter=NULL;
	nullrenderer->Release();
	nullrenderer=NULL;
	control->Release();
	control=NULL;
	capture->Release();
	capture=NULL;
	graph->Release();
	graph=NULL;
	index=-1;
}

HRESULT SimpleWebCam::OpenCamera(int newindex)
{
	if (newindex<0 || newindex>=devicecount || newindex==index)
		return E_FAIL;
	if (graph!=NULL)
		CloseCamera();
	index=newindex;
	
	//create the FilterGraph
	HRESULT hr = CoCreateInstance(CLSID_FilterGraph,NULL,CLSCTX_INPROC_SERVER,IID_IFilterGraph2,(void**) &graph);
	if (hr < 0) return hr; 
	//create the CaptureGraphBuilder
	hr = CoCreateInstance(CLSID_CaptureGraphBuilder2,NULL,CLSCTX_INPROC_SERVER,IID_ICaptureGraphBuilder2,(void**) &capture);
	if (hr < 0) return hr;
	//get the controller for the graph
	hr = graph->QueryInterface(IID_IMediaControl, (void**) &control);
	if (hr < 0) return hr;
	capture->SetFiltergraph(graph);

	WCHAR* filtername=devicenames[index];

	//add a filter for the device
	hr = graph->AddSourceFilterForMoniker(monikers[index], 0, filtername, &sourcefilter);
	if (hr!=S_OK && hr!=VFW_S_DUPLICATE_NAME) return hr;

	//create a samplegrabber filter for the device
	hr = CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER,IID_IBaseFilter,(void**)&samplegrabberfilter);
	if (hr < 0) return hr;

	//set mediatype on the samplegrabber
	hr = samplegrabberfilter->QueryInterface(IID_ISampleGrabber, (void**)&samplegrabber);
	if (hr != S_OK) return hr;

	WCHAR filtername2[80];
	wcsncpy(filtername2, L"SG ",COUNTOF(filtername2)-1);
	wcsncat(filtername2, filtername,COUNTOF(filtername2)-4);
	graph->AddFilter(samplegrabberfilter, filtername2);

	//set the media type
	AM_MEDIA_TYPE mt;
	memset(&mt, 0, sizeof(AM_MEDIA_TYPE));
	mt.majortype	= MEDIATYPE_Video;
	mt.subtype		= MEDIASUBTYPE_RGB24; 
	mt.formattype   = FORMAT_VideoInfo;
	// setting the above to 32 bits fails consecutive Select for some reason
	// and only sends one single callback (flush from previous one ???)
	// must be deeper problem. 24 bpp seems to work fine for now.
	
	hr = samplegrabber->SetMediaType(&mt);
	if (hr != S_OK) return hr;
				
	//add the callback to the samplegrabber
	hr = samplegrabber->SetCallback(callbackhandler,0);
	if (hr != S_OK) return hr;

	//set the null renderer
	hr = CoCreateInstance(CLSID_NullRenderer,NULL,CLSCTX_INPROC_SERVER,IID_IBaseFilter,(void**) &nullrenderer);
	if (hr < 0) return hr; 

	wcsncpy(filtername2, L"NR ",COUNTOF(filtername2)-1);
	wcsncat(filtername2+3, filtername,COUNTOF(filtername2)-4);
	graph->AddFilter(nullrenderer, filtername2);
	//set the render path
	#ifdef SHOW_DEBUG_RENDERER
	hr = capture->RenderStream(&PIN_CATEGORY_PREVIEW, &MEDIATYPE_Video, sourcefilter, samplegrabberfilter, NULL);
	#else
	hr = capture->RenderStream(&PIN_CATEGORY_PREVIEW, &MEDIATYPE_Video, sourcefilter, samplegrabberfilter, nullrenderer);
	#endif
	if (hr < 0) return hr; 

	//if the stream is started, start capturing immediatly
	LONGLONG start=0, stop=MAXLONGLONG;
	hr = capture->ControlStream(&PIN_CATEGORY_CAPTURE, &MEDIATYPE_Video, sourcefilter, &start, &stop, 1,2);
	if (hr < 0) return hr;
				
	// look up the media type:
	width = 0;
	height = 0;
	AM_MEDIA_TYPE* info = new AM_MEDIA_TYPE();
	hr = samplegrabber->GetConnectedMediaType(info);				
	if ( hr == S_OK ) {
		if (info->formattype == FORMAT_VideoInfo) {
			const VIDEOINFOHEADER * vi = reinterpret_cast<VIDEOINFOHEADER*>( info->pbFormat );
			width = vi->bmiHeader.biWidth;
			height = vi->bmiHeader.biHeight;
		}
		CoTaskMemFree( info->pbFormat );					
	}
	free(info);
	control->Run();
	return S_OK;
}

int SimpleWebCam::GetIndex()
{
	return index;
}

int SimpleWebCam::GetWidth()
{
	return width;
}

int SimpleWebCam::GetHeight()
{
	return height;
}

const WCHAR* SimpleWebCam::GetName(int newindex)
{
	if (newindex==-1 && index>=0)
		return devicenames[index];
	if (newindex>=0 && newindex<MAX_CAMERAS)
		return devicenames[newindex];
	else
		return NULL;
}

void SimpleWebCam::SetCallback(WebCamCallback callback)
{
	callbackhandler->SetCallback(callback);
}

HRESULT SimpleWebCam::Start()
{
	HRESULT hr;
	if (nullrenderer==NULL)
		return E_FAIL;

	hr = nullrenderer->Run(0);
	if (hr < 0) return hr;

	hr = samplegrabberfilter->Run(0);
	if (hr < 0) return hr;

	hr = sourcefilter->Run(0);
	if (hr < 0) return hr;

	isRunning=true;
	return 0;
}

HRESULT SimpleWebCam::Stop()
{
	HRESULT hr;

	hr = sourcefilter->Stop();
	if (hr < 0) return hr;

	hr = samplegrabberfilter->Stop();
	if (hr < 0) return hr;

	hr = nullrenderer->Stop();
	if (hr < 0) return hr;

	isRunning=false;
	return 0;
}

CallbackHandler::CallbackHandler(SimpleWebCam* vd)
{
	callback = 0;
	parent = vd;
}

CallbackHandler::~CallbackHandler()
{
}

void CallbackHandler::SetCallback(WebCamCallback cb)
{
	callback = cb;
}

HRESULT CallbackHandler::SampleCB(double time, IMediaSample *sample)
{
	HRESULT hr;
	char* buffer;

	hr = sample->GetPointer((BYTE**)&buffer);
	if (hr != S_OK) return S_OK;

	if (callback) callback(buffer, sample->GetActualDataLength(),
		parent->GetWidth(),parent->GetHeight(),BITS_PER_PIXEL);
	return S_OK;
}

HRESULT CallbackHandler::BufferCB(double time, BYTE *buffer, long len)
{
	return S_OK;
}

HRESULT CallbackHandler::QueryInterface(const IID &iid, LPVOID *ppv)
{
	if( iid == IID_ISampleGrabberCB || iid == IID_IUnknown )
	{
		*ppv = (void *) static_cast<ISampleGrabberCB*>( this );
		return S_OK;
	}
	return E_NOINTERFACE;
}

ULONG CallbackHandler::AddRef()
{
	return 1;
}

ULONG CallbackHandler::Release()
{
	return 2;
}

BOOL HasWebCams()
{
	ICreateDevEnum*		dev_enum;
	IEnumMoniker*		enum_moniker;
	IMoniker*			moniker;

	HRESULT	hr = CoCreateInstance(CLSID_SystemDeviceEnum,NULL,CLSCTX_INPROC_SERVER,IID_ICreateDevEnum,(void**) &dev_enum);
	if (hr < 0) return FALSE;

	hr = dev_enum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory,&enum_moniker,NULL);
	if (hr < 0) return FALSE;
	if (hr == S_FALSE) return FALSE; //no devices found

	if(enum_moniker->Next(1, &moniker,0) == S_OK)
	{
		return TRUE;
	}
	return FALSE;
}
