unit users;

interface

uses Classes;

type TUser = class
public
   Name  : String;
   uid   : Integer;
end;

type TUserList = class
public
   constructor Create;
   destructor Destroy; override;

   procedure ParsePasswd(FileName : String);
   function GetName(uid : Integer) : String;
   function GetUID(Name : String) : Integer;

   procedure ParseGroup(FileName : String);
   function GetGroup(gid : Integer) : String;
   function GetGID(Group : String) : Integer;
private
   users  : TList;
   groups : TList;

   function Token(var S : String) : String;

end;

implementation

uses SysUtils;

constructor TUserList.Create;
begin
   Users := TList.Create;
   Groups := TList.Create;
end;

destructor TUserList.Destroy;
var
   i : Integer;
begin
   for i := 0 to Users.Count - 1 do
   begin
      TUser(Users[i]).Free;
   end;
   Users.Free;

   for i := 0 to Groups.Count - 1 do
   begin
      TUser(Groups[i]).Free;
   end;
   Groups.Free;
end;

function TUserList.Token(var S : String) : String;
var
   p : Integer;
begin
   p := Pos(':', S);
   if p <> 0 then
   begin
      Result := Copy(S, 1, p - 1);
      Delete(S, 1, p);
   end;
end;

procedure TUserList.ParsePasswd(FileName : String);
var
   Passwd   : TStringList;
   i        : Integer;
   Line     : String;
   Name     : String;
   uid      : Integer;
   NewUser  : TUser;

begin
   Passwd := TStringList.Create;
   try
      Passwd.LoadFromFile(FileName);
      for i := 0 to Passwd.Count - 1 do
      begin
         Line := Passwd[i];
         Name := Token(Line);//Copy(Line, 1, p - 1);
         Token(Line); // password
         uid := StrToInt(Token(Line));
         NewUser := TUser.Create;
         NewUser.Name   := Name;
         NewUSer.UID    := Uid;
         Users.Add(NewUser);
      end;
   finally
      Passwd.Free;
   end;
end;

function TUserList.GetName(uid : Integer) : String;
var
   i     : Integer;
   Found : Boolean;
begin
   Found := False;
   for i := 0 to Users.Count - 1 do
   begin
      if TUser(Users[i]).UID = UID then
      begin
         Result := TUser(Users[i]).Name;
         Found  := True;
         break;
      end
   end;
   if not Found then
   begin
      Result := IntToStr(uid);
   end;
end;

function TUserList.GetUID(Name : String) : Integer;
var
   i : Integer;
begin
   Result := -1;
   for i := 0 to Users.Count - 1 do
   begin
      if AnsiCompareStr(TUser(Users[i]).Name, Name) = 0 then
      begin
         Result := TUser(Users[i]).UID;
         break;
      end
   end;
end;

procedure TUserList.ParseGroup(FileName : String);
var
   Passwd   : TStringList;
   i        : Integer;
   Line     : String;
   Name     : String;
   uid      : Integer;
   NewUser  : TUser;

begin
   Passwd := TStringList.Create;
   try
      Passwd.LoadFromFile(FileName);
      for i := 0 to Passwd.Count - 1 do
      begin
         Line := Passwd[i];
         Name := Token(Line);//Copy(Line, 1, p - 1);
         Token(Line); // password
         uid := StrToInt(Token(Line));
         NewUser := TUser.Create;
         NewUser.Name   := Name;
         NewUSer.UID    := Uid;
         Groups.Add(NewUser);
      end;
   finally
      Passwd.Free;
   end;
end;

function TUserList.GetGroup(gid : Integer) : String;
var
   i     : Integer;
   Found : Boolean;
begin
   Found := False;
   for i := 0 to Groups.Count - 1 do
   begin
      if TUser(Groups[i]).UID = GID then
      begin
         Result := TUser(Groups[i]).Name;
         Found := True;
         break;
      end;
   end;
   if not Found then
   begin
      Result := IntToStr(gid);
   end;
end;

function TUserList.GetGID(Group : String) : Integer;
var
   i : Integer;
begin
   Result := -1;
   for i := 0 to Groups.Count - 1 do
   begin
      if AnsiCompareStr(TUser(Groups[i]).Name, Group) = 0 then
      begin
         Result := TUser(Groups[i]).UID;
         break;
      end
   end;
end;

end.
