unit reiser;

interface

uses windows,sysutils;

const reiserdll='rfsdll.dll';

type tfileiteminfostruct=record
       filename:pchar;
       size_lo:integer;
       size_hi:integer;
       atime:integer;   { time of last access }
       mtime:integer;	  { time file was last modified  }
       ctime:integer;	  { time inode (stat data) was last changed (except changes to sd_atime and sd_mtime) }
       mode:integer;	  { file type, permissions }
     end;
     pfileiteminfostruct=^tfileiteminfostruct;

type tReiserReadDirList=function(iDrive,iOffsetLow,iOffsetHigh:integer;dirname:pchar):pfileiteminfostruct; stdcall;
     tReiserFreeDirList=procedure(fis:pfileiteminfostruct); stdcall;
     tReiserGetFile=function (iDrive,iOffsetLow,iOffsetHigh:integer;dirname,localfile:pchar):bool; stdcall;
     tReiserGetFileW=function (iDrive,iOffsetLow,iOffsetHigh:integer;dirname:pchar;localfile:pwidechar):bool; stdcall;

var ReiserReadDirList:tReiserReadDirList=nil;
    ReiserFreeDirList:tReiserFreeDirList=nil;
    ReiserGetFile:tReiserGetFile=nil;
    ReiserGetFileW:tReiserGetFileW=nil;

implementation

var lib:thandle;
    exename:array[0..MAX_PATH-1] of char;
    p:pchar;

initialization
  GetModuleFileName(hinstance,exename,sizeof(exename)-1);
  p:=strrscan(exename,'\');
  if p<>nil then inc(p)
            else p:=exename;
   strcopy(p,reiserdll);
  SetErrormode($8001);
  lib:=LoadLibrary(exename);
  if lib<>0 then begin
    ReiserReadDirList:=GetProcAddress(lib,'ReiserReadDirList');
    ReiserFreeDirList:=GetProcAddress(lib,'ReiserFreeDirList');
    ReiserGetFile:=GetProcAddress(lib,'ReiserGetFile');
    ReiserGetFileW:=GetProcAddress(lib,'ReiserGetFileW');
  end;
finalization
  if lib<>0 then
    FreeLibrary(lib);
end.

