unit plugpropdlg;

interface

uses messages,windows,inode,sysutils,time,ex2;

{$r dlgs}

procedure ShowFileProperties(handle:thandle;INode:TINode;filename:pchar);

implementation

var br:hbrush;
    fnt:hfont;
    fileptr:pchar;
    thenode:tinode;

function DlgProc(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): integer; stdcall;
var w,h,i:integer;
    rect:trect;
    Resolved:string;
begin
  DlgProc:=1;
  case Message of
    wm_InitDialog:begin
      getwindowrect(Dialog,rect);
      w:=rect.right-rect.left;
      h:=rect.bottom-rect.top;
      movewindow(Dialog,(getsystemmetrics(sm_cxscreen)-w) div 2,
                        (getsystemmetrics(sm_cyscreen)-h) div 2,
                        w,h,true);

      br:=createsolidbrush(getsyscolor(color_btnface));
      fnt:=createfont(-12,0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
        CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH,'MS Sans Serif');
      for i:=101 to 115 do begin
        if i<>114 then senddlgitemmessage(Dialog,i,EM_SETREADONLY,1,0);
        senddlgitemmessage(Dialog,i,wm_setfont,fnt,0);
      end;
      setdlgitemtext(Dialog,101,fileptr);
      setdlgitemtext(Dialog,102,pchar(IntToStr(thenode.INodeNo)));
      setdlgitemtext(Dialog,103,pchar(thenode.ModeString));
      setdlgitemtext(Dialog,104,pchar(IntToStr(thenode.info.i_uid)));
      setdlgitemtext(Dialog,105,pchar(IntToStr(thenode.info.i_gid)));
      setdlgitemtext(Dialog,106,pchar(FloatToStr(thenode.GetSize.QuadPart)));
      setdlgitemtext(Dialog,107,pchar(Time.CTime(thenode.info.i_atime)));
      setdlgitemtext(Dialog,108,pchar(Time.CTime(thenode.info.i_ctime)));
      setdlgitemtext(Dialog,109,pchar(Time.CTime(thenode.info.i_mtime)));
      setdlgitemtext(Dialog,110,pchar(Time.CTime(thenode.info.i_dtime)));
      setdlgitemtext(Dialog,111,pchar(IntToStr(thenode.info.i_links_count)));
      setdlgitemtext(Dialog,112,pchar(IntToStr(thenode.info.i_blocks)));
      setdlgitemtext(Dialog,113,pchar(IntToStr(thenode.info.i_flags)));

      if ((thenode.Info.i_mode and S_IFMT) = S_IFLNK) then
      begin
         if thenode.ResolveLink(Resolved)=0 then begin
           setdlgitemtext(Dialog,114,'link target');
           setdlgitemtext(Dialog,115,pchar(Resolved));
         end;
      end
      else if (thenode.Info.i_mode and S_IFMT) = S_IFBLK then
      begin
         setdlgitemtext(Dialog,115,'block device');
      end
      else if (thenode.Info.i_mode and S_IFMT) = S_IFCHR then
      begin
         setdlgitemtext(Dialog,115,'character device');
      end
      else if ((thenode.Info.i_mode and S_IFMT) = S_IFIFO) then
         setdlgitemtext(Dialog,115,'fifo')
      else if ((thenode.Info.i_mode and S_IFMT) = S_IFDIR) then
         setdlgitemtext(Dialog,115,'directory')
      else if ((thenode.Info.i_mode and S_IFDIR) = S_IFREG) then
         setdlgitemtext(Dialog,115,'file');
      exit
    end;
    wm_ctlcolor:begin
      if hiword(lparam)<>ctlcolor_listbox then begin
        DlgProc:=br;
        SetBkColor(wparam,getsyscolor(color_btnface));
        SetTextColor(wparam,getsyscolor(color_btntext));
      end;
      exit
    end;
    wm_command:case wparam of
      1:begin        {OK}
        deleteobject(br);
        deleteobject(fnt);
        EndDialog(Dialog, id_ok);
        Exit;
      end;
    end;
  end;
  DlgProc:=0;
end;


procedure ShowFileProperties;
begin
  thenode:=inode;
  fileptr:=filename;
  dialogbox(hinstance,'PROPDLG',handle,@dlgproc);
end;

end.
