unit cunicode;

interface

uses windows,sysutils;

const wdirtypemax=1024;
      longnameprefixmax=6;

function usys:boolean;
function walcopy(outname:pchar;inname:pwidechar;maxlen:integer):pchar;
function awlcopy(outname:pwidechar;inname:pchar;maxlen:integer):pwidechar;
function wafilenamecopy(outname:pchar;inname:pwidechar):pchar;
function awfilenamecopy(outname:pwidechar;inname:pchar):pwidechar;
function wcslen(wp:pwidechar):integer;
function MakeExtraLongNameW(outbuf:pwidechar;inbuf:pwidechar;maxlen:integer):boolean;
function DeleteFileT(lpFileName:pwidechar):boolean;
function CreateFileT(lpFileName:pwidechar;dwDesiredAccess,dwShareMode:DWORD;
  lpSecurityAttributes:PSECURITYATTRIBUTES;dwCreationDisposition,dwFlagsAndAttributes:DWORD;hTemplateFile:tHANDLE):tHANDLE;
function testfiletypeT(thename:pwidechar):integer;

implementation

function usys:boolean;
begin
  result:=Win32Platform=VER_PLATFORM_WIN32_NT;
end;

function walcopy(outname:pchar;inname:pwidechar;maxlen:integer):pchar;
begin
  if inname<>nil then begin
    WideCharToMultiByte(CP_ACP,0,inname,-1,outname,maxlen,nil,nil);
    outname[maxlen]:=#0;
    result:=outname
  end else
    result:=nil;
end;

function awlcopy(outname:pwidechar;inname:pchar;maxlen:integer):pwidechar;
begin
  if inname<>nil then begin
    MultiByteToWideChar(CP_ACP,0,inname,-1,outname,maxlen);
    outname[maxlen]:=#0;
    result:=outname;
  end else
    result:=nil;
end;

function wstrscan(wp:pwidechar;ch:widechar):pwidechar;
begin
  result:=wp;
  while (result[0]<>#0) do begin
    if result[0]=ch then exit;
    inc(result);
  end;
  {Not found}
  result:=nil;
end;

function wafilenamecopy(outname:pchar;inname:pwidechar):pchar;
begin
  result:=walcopy(outname,inname,wdirtypemax-1);
end;

function awfilenamecopy(outname:pwidechar;inname:pchar):pwidechar;
begin
  result:=awlcopy(outname,inname,wdirtypemax-1);
end;

function wcslen(wp:pwidechar):integer;
begin
  if wp=nil then result:=0
  else begin
    result:=0;
    while wp[result]<>#0 do
      inc(result);
  end;
end;

procedure wcslcpy(wto,wfrom:pwidechar;maxchars:integer);
var l:integer;
begin
  l:=2*wcslen(wfrom)+2;
  if l>2*maxchars then begin
    move(wfrom[0],wto[0],2*maxchars);
    wto[maxchars]:=#0;
  end else
    move(wfrom[0],wto[0],l);
end;

function wstrend(wp:pwidechar):pwidechar;
begin
  result:=wp+wcslen(wp);
end;

procedure wcslcat(wto,wfrom:pwidechar;maxchars:integer);
begin
  wcslcpy(wstrend(wto),wfrom,maxchars-wcslen(wto));
end;

function MakeExtraLongNameW(outbuf:pwidechar;inbuf:pwidechar;maxlen:integer):boolean;
begin
  if (wcslen(inbuf)>259) then begin
    if (inbuf[0]='\') and (inbuf[1]='\') then begin   // UNC-Path! Use \\?\UNC\server\share\subdir\name.ext
      wcslcpy(outbuf,'\\?\UNC',maxlen);
      wcslcat(outbuf,inbuf+1,maxlen);
    end else begin
      wcslcpy(outbuf,'\\?\',maxlen);
      wcslcat(outbuf,inbuf,maxlen);
    end;
  end else
    wcslcpy(outbuf,inbuf,maxlen);
  result:=wcslen(inbuf)+4<=maxlen;
end;

function DeleteFileT(lpFileName:pwidechar):boolean;
var wbuf:array[0..wdirtypemax+longnameprefixmax-1] of widechar;
    buf:array[0..MAX_PATH-1] of char;
begin
  if usys then begin
    if MakeExtraLongNameW(wbuf,lpFileName,wdirtypemax-1+longnameprefixmax) then
       result:=DeleteFileW(wbuf)
    else
       result:=false;
  end else
    result:=DeleteFile(wafilenamecopy(buf,lpFileName));
end;

function CreateFileT(lpFileName:pwidechar;dwDesiredAccess,dwShareMode:DWORD;
  lpSecurityAttributes:PSECURITYATTRIBUTES;dwCreationDisposition,dwFlagsAndAttributes:DWORD;hTemplateFile:tHANDLE):tHANDLE;
var wbuf:array[0..wdirtypemax+longnameprefixmax-1] of widechar;
    buf:array[0..MAX_PATH-1] of char;
begin
  if usys then begin
    if MakeExtraLongNameW(wbuf,lpFileName,wdirtypemax-1+longnameprefixmax) then
      result:=CreateFileW(wbuf,dwDesiredAccess,dwShareMode,
				lpSecurityAttributes,dwCreationDisposition,
				dwFlagsAndAttributes,hTemplateFile)
    else
      result:=INVALID_HANDLE_VALUE;
  end else
    result:=CreateFile(wafilenamecopy(buf,lpFileName),dwDesiredAccess,dwShareMode,
			lpSecurityAttributes,dwCreationDisposition,
			dwFlagsAndAttributes,hTemplateFile);
end;

function WHasUNCPrefix(ps:pwidechar):boolean;
begin
  result:=(ps[0]='\') and (ps[1]='\') and (ps[2]<>'\');
end;

function WisUncServer(ps:pwidechar):boolean; {Teste auf Format \\Server\ }
var p:pwidechar;
begin
  result:=false;
  if WHasUNCPrefix(ps) then begin {UNC!}
    p:=ps+2;
    if p[0]='\' then inc(p); {Eigene Shellextension hat \\\ bei einigen Foldern!}
    p:=WStrScan(p,'\');
    result:=(p=nil) or (p[1]=#0);
  end;
end;

function WIsDriveRoot(ps:pwidechar):boolean; {Teste auf Format c:\ }
begin
  result:=(ps[3]=#0) and (ps[1]=':') and (ps[2]='\');
end;

function WIsUncRoot(ps:pwidechar):boolean; {Teste auf Format  \\Server\Share\  oder c:\ }
var p:pwidechar;
begin
  result:=false;
  if WHasUNCPrefix(ps) then begin {UNC!}
    p:=WStrScan(ps+2,'\');
    if (p<>nil) and (p[1]<>#0) then begin
      p:=WStrScan(p+1,'\');
      result:=(p=nil) or (p[1]=#0);
    end;
  end else
    result:=WIsDriveRoot(ps);
end;

procedure cutlastbackslash(st:pchar);
var p:pchar;
begin
  p:=AnsiPrev(st,strend(st));
  if (st[0]<>#0) and (p[0]='\') then p[0]:=#0;
end;

function testfiletypeT(thename:pwidechar):integer;{0=not found, 1=file, 2=dir}
var s:twin32finddataW;
    s2:TWin32FindData;
    thename1:array[0..wdirtypemax+longnameprefixmax] of widechar;
    thename2:array[0..wdirtypemax] of char;
    p:pwidechar;
    handle:thandle;
    useddefaultchar:bool;
begin
  result:=0;
  if thename<>nil then begin
    WideCharToMultiByte(CP_ACP,WC_COMPOSITECHECK,thename,-1,thename2,
      sizeof(thename2)-1,nil,@useddefaultchar);
    if ((strlen(thename2)=3) and (thename2[1]=':') and (thename2[2]='\')) then begin
      {$I-} chdir(strpas(thename2));{$I+}
      if ioresult=0 then result:=2; {A dir}
    end else begin
      if usys then begin
        MakeExtraLongNameW(thename1,thename,wdirtypemax+longnameprefixmax);
        p:=CharPrevW(thename1,wstrend(thename1));
        if (thename1[0]<>#0) and (p[0]='\') then p[0]:=#0;
        if wisuncserver(thename1) then          { \\server }
          result:=0
        else if wisuncroot(thename1) then       { \\server\share }
          result:=2
        else begin
          handle:=FindFirstFileW(thename1,s);
          if handle<>invalid_handle_value then begin
            if s.dwFileAttributes and fadirectory=0 then result:=1 else
            if s.dwFileAttributes and favolumeid=0 then result:=2;
            windows.FindClose(handle);
          end;
        end;  
      end else begin
        if not useddefaultchar then begin   {Sonst wird ? als Wildcard benutzt!}
          cutlastbackslash(thename2);
          handle:=FindFirstFile(thename2,s2);
          if handle<>invalid_handle_value then begin
            if s2.dwFileAttributes and fadirectory=0 then result:=1 else
            if s2.dwFileAttributes and favolumeid=0 then result:=2;
            windows.FindClose(handle);
          end;
        end;
      end;
    end;
  end;
end;


end.
