
{
  Work with codepages
  (c) 1999 by Alexander Trunov, (2:5069/10), (jnc@mail.ru)
  
  *** Modified by keYer, (13.02.2003), (keyer7@mail.ru)
}

unit CodePages;

interface

const
  cpWin = 0;
  cpKoi = 1;
  cpDos = 2;
  
  function Win2Dos(const s : string ) : string;
  function Dos2Win(const s : string ) : string;
  function Win2Koi(const s : string ) : string;
  function Koi2Win(const s : string ) : string;
  function Koi2Dos(const s : string ) : string;
  function Dos2Koi(const s : string ) : string;
  function DetermineCodepage(const s : string ) : byte;

implementation

type
  TConvertChars = array[#128..#255] of char;
  
const
  DosSet = [#128..#175] + [#224..#239];
  KoiSet = ['','','','','','','',
            '','','','','','','',
            '','','','','','','',
            '','','','','','','',
            '','','',''];
  WinSet = ['','','','','','',
            '','','','','','',
            '','','','','','',
            '','','','','','',
            '','','','','','',
            '', '', ''];
  Win2KoiChars: TConvertChars = (
#128,#129,#130,#131,#132,#133,#134,#135,#136,#137,#060,#139,#140,#141,#142,#143,
#144,#145,#146,#147,#148,#169,#150,#151,#152,#153,#154,#062,#176,#157,#183,#159,
#160,#246,#247,#074,#164,#231,#166,#167,#179,#169,#180,#060,#172,#173,#174,#183,
#156,#177,#073,#105,#199,#181,#182,#158,#163,#191,#164,#062,#106,#189,#190,#167,
#225,#226,#247,#231,#228,#229,#246,#250,#233,#234,#235,#236,#237,#238,#239,#240,
#242,#243,#244,#245,#230,#232,#227,#254,#251,#253,#154,#249,#248,#252,#224,#241,
#193,#194,#215,#199,#196,#197,#214,#218,#201,#202,#203,#204,#205,#206,#207,#208,
#210,#211,#212,#213,#198,#200,#195,#222,#219,#221,#223,#217,#216,#220,#192,#209);
  Koi2WinChars: TConvertChars = (
#128,#129,#130,#131,#132,#133,#134,#135,#136,#137,#138,#139,#140,#141,#142,#143,
#144,#145,#146,#147,#148,#149,#150,#151,#152,#153,#218,#155,#176,#157,#183,#159,
#160,#161,#162,#184,#186,#165,#166,#191,#168,#169,#170,#171,#172,#173,#174,#175,
#156,#177,#178,#168,#170,#181,#182,#175,#184,#185,#186,#187,#188,#189,#190,#185,
#254,#224,#225,#246,#228,#229,#244,#227,#245,#232,#233,#234,#235,#236,#237,#238,
#239,#255,#240,#241,#242,#243,#230,#226,#252,#251,#231,#248,#253,#249,#247,#250,
#222,#192,#193,#214,#196,#197,#212,#195,#213,#200,#201,#202,#203,#204,#205,#206,
#207,#223,#208,#209,#210,#211,#198,#194,#220,#219,#199,#216,#221,#217,#215,#218);
  Win2DosChars: TConvertChars = (
#128,#129,#130,#131,#132,#133,#134,#135,#136,#137,#138,#139,#140,#141,#142,#143,
#144,#145,#146,#147,#148,#149,#150,#151,#152,#153,#154,#155,#156,#157,#158,#159,
#160,#161,#162,#163,#164,#165,#166,#167,#168,#169,#170,#34, #172,#173,#174,#175,
#176,#177,#178,#179,#180,#181,#182,#183,#184,#252,#186,#34, #188,#189,#190,#191,
#128,#129,#130,#131,#132,#133,#134,#135,#136,#137,#138,#139,#140,#141,#142,#143,
#144,#145,#146,#147,#148,#149,#150,#151,#152,#153,#154,#155,#156,#157,#158,#159,
#160,#161,#162,#163,#164,#165,#166,#167,#168,#169,#170,#171,#172,#173,#174,#175,
#224,#225,#226,#227,#228,#229,#230,#231,#232,#233,#234,#235,#236,#237,#238,#239);
  Dos2WinChars: TConvertChars = (
#192,#193,#194,#195,#196,#197,#198,#199,#200,#201,#202,#203,#204,#205,#206,#207,
#208,#209,#210,#211,#212,#213,#214,#215,#216,#217,#218,#219,#220,#221,#222,#223,
#224,#225,#226,#227,#228,#229,#230,#231,#232,#233,#234,#235,#236,#237,#238,#239,
#32, #32, #32, #166,#166,#166,#166,#43, #43, #166,#166,#43, #43, #43, #43, #43,
#43, #45, #45, #43, #45, #43, #166,#166,#43, #43, #45, #45, #166,#45, #43, #45,
#45, #45, #45, #43, #43, #43, #43, #43, #43, #43, #43, #95, #95, #95, #95, #95,
#240,#241,#242,#243,#244,#245,#246,#247,#248,#249,#250,#251,#252,#253,#254,#255,
#168,#184,#170,#186,#175,#191,#161,#162,#176,#183,#183,#95, #185,#164,#95, #95);

function Win2Dos(const s : string ) : string;
var
  i : longint;
begin
  Result := s;
  for i := 1 to length(Result) do
    if Result[i] > #127 then Result[i] := Win2DosChars[Result[i]];
end;

function Dos2Win(const s : string ) : string;
var
  i : longint;
begin
  Result := s;
  for i := 1 to length(s) do
    if Result[i] > #127 then Result[i] := Dos2WinChars[Result[i]];
end;

function Win2Koi(const s : string ) : string;
var
  i : longint;
begin
  Result := s;
  for i := 1 to length(Result) do
    if Result[i] > #127 then Result[i] := Win2KoiChars[Result[i]];
end;

function Koi2Win(const s : string ) : string;
var
  i : longint;
begin
  Result := s;
  for i := 1 to length(Result) do
    if Result[i] > #127 then Result[i] := Koi2WinChars[Result[i]];
end;

function Koi2Dos(const s : string ) : string;
var
  i : longint;
begin
  Result := s;
  for i := 1 to length(Result) do
    if Result[i] > #127 then Result[i] := Win2DosChars[Koi2WinChars[Result[i]]];
end;

function Dos2Koi(const s : string ) : string;
var
  i : longint;
begin
  Result := s;
  for i := 1 to length(Result) do
    if Result[i] > #127 then Result[i] := Win2KoiChars[Dos2WinChars[Result[i]]];
end;

function DetermineCodepage(const s : string ) : byte;
var
  WinCount,
  DosCount,
  KoiCount,
  i : Integer;
begin
  WinCount := 0;
  DosCount := 0;
  KoiCount := 0;
  for i := 1 to Length(s) do
  begin
    if s[i] in DosSet then Inc(DosCount);
    if s[i] in WinSet then Inc(WinCount);
    if s[i] in KoiSet then Inc(KoiCount);
  end;
  Result := cpDos;
  if KoiCount > DosCount then
  begin
    Result := cpKoi;
    if WinCount > KoiCount then Result := cpWin;
  end
  else
  begin
    if WinCount >= DosCount then Result := cpWin;
  end;
end;

end.
