// rfsdll.cpp : Defines the entry point for the DLL application.
//
#include "time.h"
#include "rfsdll.h"
#include "precomp.h"
#include "reiserfs.h"

HINSTANCE hinst;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			hinst=(HINSTANCE)hModule;
			break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}


int comparefunc2(const void *elem1, const void *elem2 )
{
    return strcmp( (*((ReiserFsFileInfo**)elem1))->m_strName, (*((ReiserFsFileInfo**)elem2))->m_strName );
}

pfileiteminfostruct __stdcall ReiserReadDirList(int iDrive,int iOffsetLow,int iOffsetHigh,char* dirname)
{
    ReiserFsPartition partition;

	if (partition.OpenAtOffset(iDrive,iOffsetLow,iOffsetHigh))
    {
        if( !dirname )
            dirname = "/";

        PList directory;

        if( partition.ListDir(&directory,dirname) )
        {
            // create array of pointers 
            ReiserFsFileInfo** array = new ReiserFsFileInfo*[directory.m_lCount];
            if( array )
            {
                int index = 0;
                ENUMERATE( &directory, ReiserFsFileInfo, pFile )
                    array[index++] = pFile;

                size_t sc = (size_t) (directory.m_lCount - 2);
                if( sc > 1 )
                    qsort( &(array[2]), sc, sizeof(ReiserFsFileInfo*), comparefunc2 );

				pfileiteminfostruct fis;
				fis=(pfileiteminfostruct)malloc(sizeof(fileiteminfostruct)*(directory.m_lCount-1));

				fis[0].size_lo=directory.m_lCount-2;

                for( index = 2; index < directory.m_lCount; index++ )
                {
                    ReiserFsFileInfo* pFile = array[index];

					fis[index-1].atime=pFile->m_stat.sd_mtime;
					fis[index-1].ctime=pFile->m_stat.sd_ctime;
					fis[index-1].mode=pFile->m_stat.sd_mode;
					fis[index-1].mtime=pFile->m_stat.sd_mtime;
					fis[index-1].size_lo=(unsigned int)pFile->m_stat.sd_size & 0x0FFFFFFFF;
					fis[index-1].size_hi=(int)(pFile->m_stat.sd_size >> 32);
					fis[index-1].filename=(char*)malloc(strlen(pFile->m_strName)+1);
					strcpy(fis[index-1].filename,pFile->m_strName);
				}
				fis[0].atime=1;
				fis[0].ctime=2;
				fis[0].mtime=3;
				fis[0].mode=4;
				return fis;
            }
        }
	}
	return NULL;

}

bool __stdcall ReiserGetFile(int iDrive,int iOffsetLow,int iOffsetHigh,char* dirname,char* localfile)
{
    ReiserFsPartition partition;

	if (partition.OpenAtOffset(iDrive,iOffsetLow,iOffsetHigh))
    {
        if( !dirname || !localfile )
        {
            printf("ERROR, must specify both dirname and localfile\n" );
        }
        else
        {
            printf("about to copy %s -> %s...", dirname, localfile );
            if( partition.GetFileAW(dirname,localfile,NULL,FALSE) )
            {
                printf("done.\n");
				return TRUE;
            }
            else
            {
                printf("failed\n");
				return FALSE;
            }
        }
    }
	return FALSE;
}

bool __stdcall ReiserGetFileW(int iDrive,int iOffsetLow,int iOffsetHigh,char* dirname,WCHAR* localfile)
{
    ReiserFsPartition partition;

	if (partition.OpenAtOffset(iDrive,iOffsetLow,iOffsetHigh))
    {
        if( !dirname || !localfile )
        {
            printf("ERROR, must specify both dirname and localfile\n" );
        }
        else
        {
            printf("about to copy %s -> %s...", dirname, localfile );
            if( partition.GetFileAW(dirname,NULL,localfile,FALSE) )
            {
                printf("done.\n");
				return TRUE;
            }
            else
            {
                printf("failed\n");
				return FALSE;
            }
        }
    }
	return FALSE;
}

void __stdcall ReiserFreeDirList(pfileiteminfostruct fis)
{
	int cnt=(int)fis[0].size_lo;	
	for(int index = 1; index <= cnt; index++ )
		free(fis[index].filename);
	free(fis);
}
