# View Helper - BasePath

## Introduction

While most *URL*s generated by the framework have the base *URL* prepended automatically, developers
will need to prepend the base *URL* to their own *URL*s (usually inside an href attribute) in order
for paths to resources to be correct.

If you're running on ZF2's MVC base, `basePath()` will point to the `public` folder of the
application's root.

## Basic Usage

Usage of the `basePath()` helper is straightforward:

```php
/*
 * The following assume that the base URL of the page/application is "/mypage".
 */

/*
 * Prints:
 * <base href="/mypage/" />
 */
<base href="<?php echo $this->basePath(); ?>" />

/*
 * Prints:
 * <link rel="stylesheet" type="text/css" href="/mypage/css/base.css" />
 */
<link rel="stylesheet" type="text/css"
     href="<?php echo $this->basePath('css/base.css'); ?>" />
```

> ## Note
For simplicity's sake, we strip out the entry *PHP* file (e.g., "`index.php`") from the base *URL* .
However, in some situations this may cause a problem. If one occurs, use
`$this-plugin('basePath')-setBasePath()` to manually set the base path.
