import RPi.GPIO as GPIO
import time
import smtplib
import email.mime.multipart
from email.mime.text import MIMEText

GPIO.setmode(GPIO.BCM)
GPIO.setup(21, GPIO.IN, pull_up_down = GPIO.PUD_UP)

def send_email(message):
    gmail_user = 'YOUR-GMAIL-ACCOUNT-NAME@gmail.com'
    gmail_password = 'YOUR-GMAIL-ACCOUNT-PASSWORD'

    try:
        msg = email.mime.multipart.MIMEMultipart()
        msg['to'] = 'Your Name<YOUR-EMAIL-ADDRESS@DOMAIN.COM>'
        msg['from'] = 'Your Gmail<YOUR-GMAIL-ACCOUNT-NAME@gmail.com>'
        msg['subject'] = 'Water Sensor Alert'
        msg.add_header('reply-to', 'YOUR-GMAIL-ACCOUNT-NAME@gmail.com')
        msg.attach(MIMEText(message, 'plain'))
        session = smtplib.SMTP('smtp.gmail.com', 587)
        session.starttls()
        session.login(gmail_user, gmail_password)
        message = msg.as_string()
        session.sendmail('YOUR-GMAIL-ACCOUNT-NAME@gmail.com', 
        'YOUR-EMAIL-ADDRESS@DOMAIN.COM', message)
        session.quit()
        print('Email sent.')
    except:
        print('Email failed to send.')

alert_trigger = False

while True:
    if GPIO.input(21):
        if alert_trigger != True:
            send_email("No water detected.")
            alert_trigger = True
    else:
        if alert_trigger != False:
            send_email("Water detected.")
            alert_trigger = False
    time.sleep(1)