import asyncio
import asyncpraw

async def main():

    reddit = asyncpraw.Reddit(client_id="APP_CLIENT_ID_GOES_HERE",
            client_secret="APP_CLIENT_SECRET_GOES_HERE",
            password="REDDIT_USER_PASSWORD_GOES_HERE",
            user_agent="RedditBot",
            username="REDDIT_USERNAME_GOES_HERE")

    async for mysubreddit in reddit.user.subreddits(limit=None): #(1)
        current = mysubreddit.display_name
        print('Subreddit: ' + current) #(2)
        subreddit = await reddit.subreddit(current)  
        async for submission in subreddit.new(limit=20): #(3)
                print(submission.title)

    await reddit.close()

if __name__ == "__main__":
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())