import asyncpraw
from discord import Embed
from discord.ext import commands

BOT_TOKEN = "BOT_TOKEN_GOES_HERE"

reddit = asyncpraw.Reddit(client_id="APP_CLIENT_ID_GOES_HERE",
            client_secret="APP_CLIENT_SECRET_GOES_HERE",
            password="REDDIT_USER_PASSWORD_GOES_HERE",
            user_agent="RedditBot",
            username="REDDIT_USERNAME_GOES_HERE")

bot = commands.Bot('!') #(1)

@bot.command(name='list', aliases=['l'], \
help='List new posts in subscribed reddits.') #(2)
async def reddlist(ctx):
    async for mysubreddit in reddit.user.subreddits(limit=None):
        current = mysubreddit.display_name
        await ctx.send('Checking ' + current + '...')
        subreddit = await reddit.subreddit(current)
        async for submission in subreddit.new(limit=20):
                embed = Embed(title=submission.title, url=submission.url)
                await ctx.send(embed=embed)

@bot.command(name='hide', aliases=['h'], \
help='Hide new posts in subscribed reddits.')
@commands.has_role('Announcements')
async def reddlist(ctx):
    async for mysubreddit in reddit.user.subreddits(limit=None):
        subreddit = await reddit.subreddit(mysubreddit.display_name)
        async for submission in subreddit.new(limit=20):
                await submission.hide()     
                await ctx.send('Hidden: ' + submission.title)

@bot.command(name='clear', aliases=['c', 'delete', 'd'],  #(3)
             help='Clear up to 100 messages at a time in the \
             current channel.')
async def clear(ctx):
    await ctx.channel.purge(limit=100)
    await ctx.send('Messages deleted.', delete_after=4)


@bot.event #(4)
async def on_command_error(ctx, error):
    if isinstance(error, commands.errors.CommandNotFound):
        await ctx.send("I don't understand that command.")    

bot.run(BOT_TOKEN)