import feedparser
from bs4 import BeautifulSoup
from gtts import gTTS
from mutagen.mp3 import MP3
from mutagen.easyid3 import EasyID3
from mutagen.id3 import ID3, APIC, error
import os
from pathlib import Path
from pathlib import Path
import platform
import sqlite3
import shutil
import time
import smtplib
import email.mime.multipart
from email.mime.text import MIMEText

URLS = ['https://forum.devtalk.com/latest.rss',
        'https://feeds.npr.org/1001/rss.xml',
        'https://projects-raspberry.com/news-updates/raspberry-pi-news/feed/',        
        ]

def send_email(message):
    gmail_user = 'YOUR-GMAIL-ACCOUNT-NAME@gmail.com'
    gmail_password = 'YOUR-GMAIL-ACCOUNT-PASSWORD'

    try:
        msg = email.mime.multipart.MIMEMultipart()
        msg['to'] = 'Your Name<YOUR-EMAIL-ADDRESS@DOMAIN.COM>'
        msg['from'] = 'Your Gmail<YOUR-GMAIL-ACCOUNT-NAME@gmail.com>'
        msg['subject'] = 'New PiSpeak Content Available'
        msg.add_header('reply-to', 'YOUR-GMAIL-ACCOUNT-NAME@gmail.com')
        msg.attach(MIMEText(message, 'plain'))
        session = smtplib.SMTP('smtp.gmail.com', 587)
        session.starttls()
        session.login(gmail_user, gmail_password)
        message = msg.as_string()
        session.sendmail('YOUR-GMAIL-ACCOUNT-NAME@gmail.com', 
        'YOUR-EMAIL-ADDRESS@DOMAIN.COM', message)
        session.quit()
        print('Email sent.')
    except:
        print('Email failed to send.')

if os.path.exists('feeddata.db'):
    read_articles = True
else:
    read_articles = False
    print("feeddata.db database doesn't exist, creating new database file.")
    conn = sqlite3.connect('feeddata.db')
    c = conn.cursor()

    c.execute('''CREATE TABLE NewsFeeds (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        title TEXT,
        link TEXT
        );''') 

    conn.commit()
    conn.close() 

conn = sqlite3.connect('feeddata.db')
c = conn.cursor()

storycount = 0
storycollection = 'The following new articles have been compiled for you:\n\n'
tobeconverted = ''

for url in URLS:
    feed = feedparser.parse(url)

    for entry in feed["entries"]:
        title = entry.get("title")
        link = entry.get("link")
        description = BeautifulSoup(entry.get("description"), "lxml").text

        c.execute("SELECT link FROM NewsFeeds WHERE link=?", [link])
        link_exists = c.fetchone()
        if link_exists:
            # Record already exists in the database
            pass
        else:
            newdata = (title, link)
            c.execute("INSERT INTO NewsFeeds (title, link) VALUES (?,?)",\
             newdata)
            storycount = storycount + 1
            storycollection = storycollection + title + '\n' + link + '\n\n'
            tobeconverted = tobeconverted + '\n' + title + '\n' + description

if tobeconverted != '':
    tobeconverted = tobeconverted + ' End of playback.'
    output = gTTS(text=tobeconverted, lang='en', tld='com', slow=False)
    output.save('output.mp3')

    os.system('ffmpeg -i output.mp3 -filter:a "atempo=2.0" -vn -y faster.mp3')
    os.remove('output.mp3')

    mp3_file = EasyID3('faster.mp3')

    mp3_file["title"] = "Sample Title"
    mp3_file["artist"] = "Content Creator"
    mp3_file["album"] = "PiSpeak Project"
    mp3_file.save()

    mp3_file = MP3('faster.mp3', ID3=ID3)
    mp3_file.tags.add(APIC(mime='image/jpeg',type=3,desc=u'PiSpeak Project',
                    data=open('home.jpg','rb').read()))
    mp3_file.save()

    # Add the time stamp and article count in final MP3 filename
    current_seconds = time.time()
    current_time = time.localtime(current_seconds)
    current_directory = os.getcwd()

    newsMP3name = 'NEWS - %d-%d-%d at %d-%d - %s articles.mp3' % (
    current_time.tm_year, current_time.tm_mon, current_time.tm_mday,  
    current_time.tm_hour, current_time.tm_min, storycount)

    # Rename faster.mp3 to the one with more details in the final filename
    os.rename('faster.mp3', newsMP3name)

    # Move the final MP3 file to the GoogleDrive directory
    homedirectory = str(Path.home())
    if platform.system() == 'Windows':
        syncfolder = '\\GoogleDrive\\'
    else:
        syncfolder = '/GoogleDrive/'
    mp3destination = homedirectory + syncfolder + newsMP3name
    shutil.move(newsMP3name, mp3destination)

    message_body = storycollection + '\n\nready to be retrieved in '\
                                   + newsMP3name
    send_email(message_body) 

conn.commit()
conn.close()