import feedparser
import os
import sqlite3 # (1)

CHANNELS = ['UCMb3lp0IfG6EXVngmYg77ng', 'UCS0hb_kOzL4aY0o6Diwj-Qg', 
            'UC-ptWR16ITQyYOglXyQmpzw', 'UCJquYOG5EL82sKTfH9aMA9Q']

if os.path.exists('videodata.db'): # (2)
    download_files = True
else:
    download_files = False
    print("videodata.db doesn't exist, creating new database file.")
    conn = sqlite3.connect('videodata.db') # (3)
    c = conn.cursor()

    c.execute('''CREATE TABLE YouTubeFeeds (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        video_id TEXT,
        video_title TEXT,
        video_author TEXT,
        video_published TEXT
        );''') # (4)

    conn.commit() # (5)
    conn.close() 

conn = sqlite3.connect('videodata.db')
c = conn.cursor()

for channel_id in CHANNELS:
    parsed = feedparser.parse(
'https://www.youtube.com/feeds/videos.xml?channel_id=' + channel_id)
    for entry in parsed.entries: # (6)
        video_url = entry.link 
        video_id = entry.yt_videoid
        video_title = entry.title
        video_author = entry.author
        video_published = entry.published
        c.execute("SELECT video_id FROM YouTubeFeeds WHERE video_id=?", [video_id]) # (7)
        id_exists = c.fetchone()
        if id_exists:
            # Record already extists in the database
            pass
        else:
            videodata = (video_id, video_title, video_author, video_published)
            c.execute("INSERT INTO YouTubeFeeds (video_id, video_title, \
                 video_author, video_published) VALUES (?,?,?,?)", videodata) # (8)

conn.commit()
conn.close()