from bs4 import BeautifulSoup # (1)
import feedparser 

URLS = ['https://forum.devtalk.com/latest.rss', # (2)
        'https://feeds.npr.org/1001/rss.xml',
        'https://projects-raspberry.com/news-updates/raspberry-pi-news/feed/',        
        ]

for url in URLS: # (3)
    feed = feedparser.parse(url)

    for entry in feed["entries"]: # (4)
        title = entry.get("title")
        link = entry.get("link")
        description = BeautifulSoup(entry.get("description"), "lxml").text # (5)
        print(title + '\n' + link + '\n' + description + '\n\n') # (6)
