import smbus #(1)
import time

DEVICE_BUS = 1 #(2)
DEVICE_ADDR = 0x17

TEMP_REG = 0x01
LIGHT_REG_L = 0x02
LIGHT_REG_H = 0x03
STATUS_REG = 0x04
ON_BOARD_TEMP_REG = 0x05
ON_BOARD_HUMIDITY_REG = 0x06
ON_BOARD_SENSOR_ERROR = 0x07
BMP280_TEMP_REG = 0x08
BMP280_PRESSURE_REG_L = 0x09
BMP280_PRESSURE_REG_M = 0x0A
BMP280_PRESSURE_REG_H = 0x0B
BMP280_STATUS = 0x0C
MOTION_DETECT = 0x0D

bus = smbus.SMBus(DEVICE_BUS)

while True: #(3)
    aReceiveBuf = []

    aReceiveBuf.append(0x00)

    for i in range(TEMP_REG,MOTION_DETECT + 1):
        aReceiveBuf.append(bus.read_byte_data(DEVICE_ADDR, i))

    if aReceiveBuf[STATUS_REG] & 0x01 : #(4)
        print('The external temperature sensor range was exceeded. \
        No value reported.')
    elif aReceiveBuf[STATUS_REG] & 0x02 :
        print('The external temperature sensor is disconnected.')
    else :
        external_celsius = aReceiveBuf[TEMP_REG]
        external_fahrenheit = (external_celsius * 9/5) + \
         32 #(5)
        print('The current external sensor temperature = ' 
        + str(external_celsius) + ' C / ' + \ 
        str(external_fahrenheit) + ' F\n')

    onboard_celsius = aReceiveBuf[ON_BOARD_TEMP_REG] #(6)
    onboard_fahrenheit = (onboard_celsius * 9/5) + 32

    print('The current onboard sensor temperature = ' 
    + str(onboard_celsius) + ' C / ' + str(onboard_fahrenheit) + ' F') #(7)

    if aReceiveBuf[ON_BOARD_SENSOR_ERROR] != 0 :
        print('The current onboard temperature and \
        humidity sensor data is unavailable.')

    time.sleep(1)