import smbus

DEVICE_BUS = 1
DEVICE_ADDR = 0x17

# Register the SensorHub on-board sensors
TEMP_REG = 0x01
LIGHT_REG_L = 0x02
LIGHT_REG_H = 0x03
STATUS_REG = 0x04
ON_BOARD_TEMP_REG = 0x05
ON_BOARD_HUMIDITY_REG = 0x06
ON_BOARD_SENSOR_ERROR = 0x07
BMP280_TEMP_REG = 0x08
BMP280_PRESSURE_REG_L = 0x09
BMP280_PRESSURE_REG_M = 0x0A
BMP280_PRESSURE_REG_H = 0x0B
BMP280_STATUS = 0x0C
MOTION_DETECT = 0x0D

bus = smbus.SMBus(DEVICE_BUS)

aReceiveBuf = []

aReceiveBuf.append(0x00)

for i in range(TEMP_REG,MOTION_DETECT + 1):
    aReceiveBuf.append(bus.read_byte_data(DEVICE_ADDR, i))

if aReceiveBuf[STATUS_REG] & 0x01 :
    print('The external temperature sensor range was exceeded. No value reported.')
elif aReceiveBuf[STATUS_REG] & 0x02 :
    print('The external temperature sensor is disconnected.')
else :
    external_celsius = aReceiveBuf[TEMP_REG]
    external_fahrenheit = (external_celsius * 9/5) + 32
    print('The current external sensor temperature = ' + str(external_celsius) + ' C / ' + str(external_fahrenheit) + ' F')

if aReceiveBuf[STATUS_REG] & 0x04 :
    print('The onboard light sensor is overloaded.')
elif aReceiveBuf[STATUS_REG] & 0x08 :
    print('The onboard light sensor is not responding.')
else :
    print('The current onboard light sensor brightness = %d Lux' % (aReceiveBuf[LIGHT_REG_H] << 8 | aReceiveBuf[LIGHT_REG_L]))

onboard_celsius = aReceiveBuf[ON_BOARD_TEMP_REG]
onboard_fahrenheit = (onboard_celsius * 9/5) + 32

print('The current onboard sensor temperature = ' + str(onboard_celsius) + ' C / ' + str(onboard_fahrenheit) + ' F')
print('The current onboard sensor humidity = %d %%' % aReceiveBuf[ON_BOARD_HUMIDITY_REG])

if aReceiveBuf[ON_BOARD_SENSOR_ERROR] != 0 :
    print('The current onboard temperature and humidity sensor data is unavailable.')

if aReceiveBuf[BMP280_STATUS] == 0 :
    print('The current barometer temperature = %d Celsius' % aReceiveBuf[BMP280_TEMP_REG])
    print('The current barometer pressure = %d pascal' % (aReceiveBuf[BMP280_PRESSURE_REG_L] | aReceiveBuf[BMP280_PRESSURE_REG_M] << 8 | aReceiveBuf[BMP280_PRESSURE_REG_H] << 16))
else :
    print('The onboard barometer is not working correctly.')

if aReceiveBuf[MOTION_DETECT] == 1 :
    print('Movement was detected within the last 5 seconds.')
else:
    print('No recent movement was detected.')
