import smbus
import time

DEVICE_BUS = 1
DEVICE_ADDR = 0x17

TEMP_REG = 0x01
LIGHT_REG_L = 0x02
LIGHT_REG_H = 0x03
STATUS_REG = 0x04
ON_BOARD_TEMP_REG = 0x05
ON_BOARD_HUMIDITY_REG = 0x06
ON_BOARD_SENSOR_ERROR = 0x07
BMP280_TEMP_REG = 0x08
BMP280_PRESSURE_REG_L = 0x09
BMP280_PRESSURE_REG_M = 0x0A
BMP280_PRESSURE_REG_H = 0x0B
BMP280_STATUS = 0x0C
MOTION_DETECT = 0x0D

bus = smbus.SMBus(DEVICE_BUS)

while True:
    aReceiveBuf = []

    aReceiveBuf.append(0x00)

    for i in range(TEMP_REG,MOTION_DETECT + 1):
        aReceiveBuf.append(bus.read_byte_data(DEVICE_ADDR, i))

    lux = (aReceiveBuf[LIGHT_REG_H] << 8 | aReceiveBuf[LIGHT_REG_L])

    if aReceiveBuf[STATUS_REG] & 0x04 :
        print('The onboard light sensor is overloaded.')
    elif aReceiveBuf[STATUS_REG] & 0x08 :
        print('The onboard light sensor is not responding.')
    else :
        print('The current onboard light sensor brightness = %d lux.' % lux)

    time.sleep(1)
