package com.java.basics;

// Class to demonstrate the Char Array to String Java example!
public class CharArrayToStringExample {

	public static void main(String[] args) {

		// Initializing a sample character array.
		char[] charArray = { 'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '!' };

		// Approach #1- Using the String object to pass "char array" into the constructor.
		String strObject = new String(charArray);
		System.out.println(strObject);

		System.out.println("\n");

		// Approach #2 - Using the "valueOf()" or "copyValueOf()" method.
		String strValueOf = String.valueOf(charArray);				// String.copyValueOf(charArray);
		System.out.println(strValueOf);

		System.out.println("\n");

		// Approach #3 - Using the StringBuilder object.
		// We'll perform iteration on char array and append it to the StringBuilder and call "toString()" method
		// to print the value.
		StringBuilder builder = new StringBuilder();
		for(char c : charArray)
			builder.append(c);

		System.out.println(builder.toString());
	}
}