package com.javacodegeeks.examples.stack;

import java.util.Stack;

public class PostfixExpEvaluator {
    public static void main(String[] args) {
        char postfix[] = {'4', '5', '6', '*', '+', ')'};
        evaluatePostFixExpression(postfix);
    }

    private static void evaluatePostFixExpression(char postfix[]) {
        int A, B;
        Stack<Integer> s = new Stack<>();

        for (int i = 0; postfix[i] != ')'; i++) {
            char ch = postfix[i];
            if (Character.isDigit(ch)) {
                s.push(ch - '0');
            } else if (isOperator(ch)) {
                A = s.pop();
                B = s.pop();
                int val = calculateValue(A, B, ch);
                s.push(val);
            }
        }
        System.out.println("Result of expression evaluation: " + s.pop());
    }

    private static int calculateValue(int a, int b, char ch) {
        int val = 0;
        switch (ch) {
            case '*':
                val = b * a;
                break;
            case '/':
                val = b / a;
                break;
            case '+':
                val = b + a;
                break;
            case '-':
                val = b - a;
                break;
        }
        return val;
    }

    private static boolean isOperator(char ch) {
        return ch == '+' || ch == '-' || ch == '*' || ch == '/';
    }
}
