public class CatchMultipleExceptionsWithCustomException {
    public static void main(String[] args) {
        // We demonstrate with a short password
        try {
            CatchMultipleExceptionsWithCustomException.checkPass("pass");
        } catch (NoPassException e) {
            e.printStackTrace();
        } catch (ShortPassException e) {
            e.printStackTrace();
        } finally {
            System.out.println("Finally block is always executed");
        }

        // We demonstrate with no password
        try {
            CatchMultipleExceptionsWithCustomException.checkPass(null);
        } catch (NoPassException e) {
            e.printStackTrace();
        } catch (ShortPassException e) {
            e.printStackTrace();
        } finally {
            System.out.println("Finally block is always executed");
        }

        // We demonstrate with valid password
        try {
            CatchMultipleExceptionsWithCustomException.checkPass("123456");
            System.out.println("Password check : OK");
        } catch (NoPassException e) {
            e.printStackTrace();
        } catch (ShortPassException e) {
            e.printStackTrace();
        } finally {
            System.out.println("Finally block is always executed");
        }
    }
    // Our business method that check password validity and throws NoPassException and ShortPassException
    public static void checkPass(String pass) throws NoPassException, ShortPassException {
        int minPassLength = 5;
        if (pass == null)
            throw new NoPassException("No pass provided");
        if (pass.length() < minPassLength)
            throw new ShortPassException("The password provided is too short");
    }
}


