import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class FxColorExample6 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void start(Stage stage)
	{
		// Set the Property of the Points
		String colorValue = "radial-gradient(focus-angle 45deg, focus-distance 50%, " +
				"center 50% 50%, radius 50%, white 0%, black 100%)";
		// Create the Radial Gradient
		RadialGradient gradient = RadialGradient.valueOf(colorValue);
		// Create the Circle
		Circle circle = new Circle(150, 150, 150);
		circle.setFill(gradient);

		// Create the VBox
		VBox root = new VBox();
		// Add the details to the VBox
		root.getChildren().add(circle);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title
		stage.setTitle("Defining radial Color Gradients");
		// Show the Stage
		stage.show();

	}
}
