import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxColorExample5 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void start(Stage stage)
	{
		// Create the Stop Points of the First Rectangle
		Stop[] stop1 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		// Create the Linear Gradient of the First Circle
		RadialGradient gradient1 = new RadialGradient(0, 0, 0.5, 0.5, 0.5, true, CycleMethod.NO_CYCLE, stop1);
		// Create the first Circle
		Circle circle1 = new Circle(50, 50, 50);
		// Fill the first Circle
		circle1.setFill(gradient1);

		// Same procedure with all other Objects
		Stop[] stop2 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		RadialGradient gradient2 = new RadialGradient(0, 0, 0.5, 0.5, 0.2, true, CycleMethod.NO_CYCLE, stop2);
		Circle circle2 = new Circle(50, 50, 50);
		circle2.setFill(gradient2);

		Stop[] stop3 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		RadialGradient gradient3 = new RadialGradient(0, 0, 0.5, 0.5, 0.2, true, CycleMethod.REPEAT, stop3);
		Circle circle3 = new Circle(50, 50, 50);
		circle3.setFill(gradient3);

		Stop[] stop4 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		RadialGradient gradient4 = new RadialGradient(60, 0.2, 0.5, 0.5, 0.2, true, CycleMethod.REPEAT, stop4);
		Circle circle4 = new Circle(50, 50, 50);
		circle4.setFill(gradient4);

		Stop[] stop5 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		RadialGradient gradient5 = new RadialGradient(0, 0, 0.5, 0.5, 0.5, true, CycleMethod.REPEAT, stop5);
		Rectangle rectangle1 = new Rectangle(200, 100);
		rectangle1.setFill(gradient5);

		Stop[] stop6 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		RadialGradient gradient6 = new RadialGradient(0, 0, 100, 50, 50, false, CycleMethod.REPEAT, stop6);
		Rectangle rectangle2 = new Rectangle(200, 100);
		rectangle2.setFill(gradient6);

		Stop[] stop7 = new Stop[]{new Stop(0, Color.WHITE),
				new Stop(0.40, Color.GRAY),
				new Stop(0.60, Color.TAN),
				new Stop(1, Color.BLACK)};

		RadialGradient gradient7 = new RadialGradient(-30, 1.0, 0.5, 0.5, 0.5, true, CycleMethod.REPEAT, stop7);
		Circle circle5 = new Circle(50, 50, 50);
		circle5.setFill(gradient7);

		// Create the VBoxes
		VBox vbox1 = new VBox(circle1, circle2, circle3, circle4);
		VBox vbox2 = new VBox(rectangle1, rectangle2, circle5);

		// Create the HBox
		HBox root = new HBox();
		// Add the details to the HBox
		root.getChildren().addAll(vbox1, vbox2);

		// Set the Style-properties of the HBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title
		stage.setTitle("A Radial Gradient Example");
		// Show the Stage
		stage.show();

	}
}
