import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.paint.LinearGradient;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxColorExample4 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void start(Stage stage)
	{
		// Set the Property of the Points
		String value = "from 0px 0px to 100px 0px, repeat, white 0%, black 100%";
		// Create the Linear Gradient
		LinearGradient gradient = LinearGradient.valueOf(value);
		// Create the Rectangle
		Rectangle rectangle = new Rectangle(300, 100);
		rectangle.setFill(gradient);

		// Create the VBox
		VBox root = new VBox();
		// Add the details to the VBox
		root.getChildren().add(rectangle);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title
		stage.setTitle("Defining linear Color Gradients");
		// Show the Stage
		stage.show();

	}
}
