import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxColorExample3 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void start(Stage stage)
	{
		// Create the Stop Points of the First Rectangle
		Stop[] stop1 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		// Create the Linear Gradient of the First Rectangle
		LinearGradient gradient1 = new LinearGradient(0, 0, 1, 0, true, CycleMethod.NO_CYCLE, stop1);
		// Create the first Rectangle
		Rectangle rectangle1 = new Rectangle(300, 50);
		// Fill the first Rectangle
		rectangle1.setFill(gradient1);

		// Same procedure with all other Objects
		Stop[] stop2 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		LinearGradient gradient2 = new LinearGradient(0, 0, 0.5, 0, true, CycleMethod.NO_CYCLE, stop2);
		Rectangle rectangle2 = new Rectangle(300, 50);
		rectangle2.setFill(gradient2);

		Stop[] stop3 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		LinearGradient gradient3 = new LinearGradient(0, 0, 0.5, 0, true, CycleMethod.REFLECT, stop3);
		Rectangle rectangle3 = new Rectangle(300, 50);
		rectangle3.setFill(gradient3);

		Stop[] stop4 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		LinearGradient gradient4 = new LinearGradient(0, 0, 0.1, 0, true, CycleMethod.REFLECT, stop4);
		Rectangle rectangle4 = new Rectangle(300, 50);
		rectangle4.setFill(gradient4);

		Stop[] stop5 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		LinearGradient gradient5 = new LinearGradient(0, 0, 0.5, 0, true, CycleMethod.REPEAT, stop5);
		Rectangle rectangle5 = new Rectangle(300, 50);
		rectangle5.setFill(gradient5);

		Stop[] stop6 = new Stop[]{new Stop(0, Color.RED),
				new Stop(0.25, Color.GREEN),
				new Stop(0.50, Color.BLUE),
				new Stop(0.75, Color.ORANGE),
				new Stop(1, Color.YELLOW)};

		LinearGradient gradient6 = new LinearGradient(0, 0, 1, 0, true, CycleMethod.NO_CYCLE, stop6);
		Rectangle rectangle6 = new Rectangle(300, 50);
		rectangle6.setFill(gradient6);

		Stop[] stop7 = new Stop[]{new Stop(0, Color.WHITE), new Stop(1, Color.BLACK)};
		LinearGradient gradient7 = new LinearGradient(0, 0, 0.1, 0.1, true, CycleMethod.REPEAT, stop7);
		Rectangle rectangle7 = new Rectangle(300, 50);
		rectangle7.setFill(gradient7);

		// Create the VBox
		VBox root = new VBox();
		// Add the details to the VBox
		root.getChildren().addAll(rectangle1, rectangle2, rectangle3,
			rectangle4, rectangle5, rectangle6, rectangle7);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title
		stage.setTitle("A Linear Gradient Example");
		// Show the Stage
		stage.show();
	}
}
