import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxColorExample2 extends Application
{
	private Image image;

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void init()
	{
		// Create an Image object
		String file = "file:///C:/Workspaces/Workspace_Entrepreneur/JavaFXProjects/src/FXColor/javafx-logo.png";
		image = new Image(file);
	}

	public void start(Stage stage)
	{
		// Create an anchor rectangle at (0, 0) that is 25% wide and 25% tall
		// relative to the rectangle to be filled
		ImagePattern pattern1 = new ImagePattern(image, 0, 0, 0.25, 0.25, true);
		Rectangle rectangle1 = new Rectangle(300, 100);
		rectangle1.setFill(pattern1);

		// Create an anchor rectangle at (0, 0) that is 50% wide and 50% tall
		// relative to the rectangle to be filled
		ImagePattern pattern2 = new ImagePattern(image, 0, 0, 0.5, 0.5, true);
		Rectangle rectangle2 = new Rectangle(300, 100);
		rectangle2.setFill(pattern2);

		// Using absolute bounds for the anchor rectangle
		ImagePattern pattern3 = new ImagePattern(image, 40, 15, 20, 20, false);
		Rectangle rectangle3 = new Rectangle(300, 100);
		rectangle3.setFill(pattern3);

		// Create a Circle
		ImagePattern pattern4 = new ImagePattern(image, 0, 0, 0.1, 0.1, true);
		Circle circle = new Circle(100, 100, 50);
		circle.setFill(pattern4);

		// Create the VBox
		VBox root = new VBox();
		// Add the details to the VBox
		root.getChildren().addAll(rectangle1, rectangle2, rectangle3, circle);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title
		stage.setTitle("An Image Patterns Example");
		// Show the Stage
		stage.show();
	}
}
